/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "common.h"
#include "helpers.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>


void* mem_alloc (size_t size, short zero_it) {
  void* retval;

  retval=mem_realloc(NULL,size);
  if (zero_it) {
    memset(retval,0,size);
  }
  return retval;
}

void* mem_realloc (void* oldpointer, size_t size) {
  void* retval;
    
  if ((retval=realloc(oldpointer,size))==NULL && size>0) {
    errexit("Memory allocation failure");
  }
  return retval;
}

char* str_dup (const char* input) {
  return strn_dup(input,strlen(input));
}

char* strn_dup (const char* input, size_t insize) {
  void* retval;

  retval=mem_alloc(insize+1,1);
  strncpy(retval,input,insize);
  return retval;
}

char* strn_printf (int length, char* input,...) {
  char* storage;
  va_list ap;
    
  va_start(ap,input);
  storage=strn_vprintf(length,input,&ap);
  va_end(ap);
  return storage;
}

char* strn_vprintf (int length, char* input, va_list* ap) {
  char* storage;
    
  if (input==NULL) {
    return NULL;
  }
  storage=NULL;
  if (length<=0) {
    length=vsnprintf(NULL,0,input,*ap);
  }
  if (length==-1) {
    //glibc2.0 and earlier
    length=0;
    do {
      if (storage!=NULL) {
	free(storage);
      }
      length+=BUFSIZ;
      storage=mem_alloc(length,0);
    } while ((vsnprintf(storage,length,input,*ap))==-1);
    length=strlen(storage);
  } else if (length>0) {
    //glib2.1 and later (C99)
    storage=mem_alloc(length+1,1);
    vsnprintf(storage,length+1,input,*ap);
  } else {
    return str_dup("");
  }
  return storage;
}
