/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "common.h"
#include "../config.h"
#include <stdio.h>

void help(char *me){
  printf("This is a program written by Hendrik Sattler (post@hendrik-sattler.de).\n");
  printf("This program is licenced with the GPL.\n");
  printf("Use at your own risk!\n");
  printf("You need a phone made by Siemens to get an useful result.\n\n");
  printf("Syntax: %s [options] [operation [slot[sms options]]] [file1 file2 ...]\n",me);
  printf("\nOptions:\n");
  printf(" --device <device>         -d  specify another than the compiled in device\n");
  printf(" --baud <baudrate>         -b  specify another than the compiled in baudrate\n");
  printf(" --out <file>              -o  specify a file when getting ('-' for stdout)\n");
  printf("                               when using slot \"all\" this gets expanded\n");
  printf(" --pipe <program>          -p  specify a pipe to use\n");
  printf(" --pin <pin>                   use this pin if one is needed\n");
  printf(" --quiet                   -q  decreases verbosity by 1 (min verbosity: -1)\n");
  printf(" --verbose                 -v  increases verbosity by 1 (max verbosity: +1)\n");
  printf(" --reset                       try this if the phone does not respond after an\n");
  printf("                               user-interrupted file transfer\n");
  printf(" --help                    -h  print this message\n");
  printf(" --version                     print the version number\n");
  printf("\nOperation:\n");
  printf(" --remove                  -r  removes an entry from the phone\n");
  printf(" --send                    -s  sends a file to the phone\n");
  printf(" --get                     -g  get an entry and save it to a file\n");
  printf(" --info                    -i  collect information\n");
  printf(" --set-time                    synchronize time on phone\n");
  printf(" --set-smsc                    set the SMSC number (requires \"-n\")\n");
  printf("\nSlot (<slot#> is either a number or \"all\"):\n");
  printf(" --bitmap[=<slot#>]        -B  select bitmap slot number\n");
  printf(" --midi[=<slot#>]          -M  select midi slot number\n");
  printf(" --vcal[=<slot#>]          -C  select calendar slot number\n");
  printf(" --vcard[=<slot#>]         -F  select address book slot number\n");
  printf(" --pbook[=]<phonebook>     -P  select phonebook\n");
  printf(" --sms[=<slot#>|=<status>] -S  select short-message\n");
  printf("\nSMS options:\n");
  printf(" --number <number>         -n  specify number to send SMS to (sending only)\n");
  printf(" --text <text>             -t  specify content of SMS (sending only)\n");
  printf(" --unicode                     use UCS-2 (unicode) as charset (sending only)\n");
  printf(" --direct                      send/receive without storing in the phone\n");
  printf(" --smsmem                      select a specific sms memory\n");
  printf(" --srr                         request a status report from the SMSC\n");
  printf(" --flash                       make the sms appear directly (if supported by\n");
  printf("                               the receiving entity)\n");
  printf("\nSee README file for more detailed information.\n");	
  printf("Version: ");version();
}

void version () {
  printf("%s\n",PACKAGE_VERSION);
}
