/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "../config.h"

/*
 * Now lets select a charset that is supported by local iconv
 * and matches the local wchar_t implementation
 */
#ifdef HAVE_LIBICONV
# ifdef ICONV_HAS_WCHAR_T
#  define INTERNAL_CHARSET "WCHAR_T"
# else
#  if SIZEOF_WCHAR_T==2
#   ifdef WORDS_BIGENDIAN
#    define INTERNAL_CHARSET "UCS-2BE"
#   else
#    define INTERNAL_CHARSET "UCS-2LE"
#   endif
#  else
#   ifdef WORDS_BIGENDIAN
#    define INTERNAL_CHARSET "UCS-4BE"
#   else
#    define INTERNAL_CHARSET "UCS-4LE"
#   endif
#  endif
# endif
#else
# define INTERNAL_CHARSET "WCHAR_T"
#endif

/*
 * this should replace the functionality of nl_langinfo
 * but only as far as needed by our program and only for fixed values
 *
 * This is pretty dumb but easy way to try it, I hope it works alright
 */
#ifdef NO_NL_LANGINFO
// This specifies the date output format
# define D_T_FMT "%a %b %e %H:%M:%S %Y"
/* This specifies the conversion charset for input/output
 * ANSI_X3.4-1968 is the ASCII charset and actually the worst case
 * but should always works (anybody knows a better charset for CygWin?)
 */
# define CODESET "ANSI_X3.4-1968"
  char* nl_langinfo (char* type);
#else
# include <langinfo.h>
#endif

#include <termios.h>
#ifdef NO_CFMAKERAW
# undef cfmakeraw
  int cfmakeraw(struct termios *termios_p);
#endif

#ifdef HAVE_WCHAR_H
# include <wchar.h>
#else
# include <stddef.h>
#endif
#ifdef NO_WCSLEN
 size_t wcslen(const wchar_t *wcs);
#endif
