.TH scmxx 1 2002-05-10 SCMxx
.SH ИМЯ
scmxx \- осуществляет обмен данными с вашим мобильным телефоном Siemens
.SH СИНТАКСИС
.B scmxx 
[--device \fIустройство\fP] [--baud \fIскорость_передачи\fP] \\
.br
[--quiet] [--verbose] \\
.br
--reset | --help | --version | --info | --set-time |
.br
--set-smsc --number \fIномер\fP
.PP
.B scmxx 
[--device \fIустройство\fP] [--baud \fIскорость_передачи\fP] \\
.br
[--out \fIфайл\fP] [--pipe \fIканал\fP] [--pin \fIPIN-код\fP] \\
.br
[--quiet] [--verbose] \\
.br
--remove | --send | --get \\
.br
--bitmap[=\fIслот#\fP] | --midi[=\fIслот#\fP] | --vcal[=\fIслот#\fP] |
 --vcard[=\fIслот#\fP] | --pbook=\fIтел_книга\fP \\
.br
[файл1 [файл2 [...]]]
.PP 
.B scmxx 
[--device \fIустройство\fP] [--baud \fIскорость_передачи\fP] \\
.br
[--out \fIфайл\fP] [--pipe \fIканал\fP] [--pin \fIPIN-код\fP] \\
.br
[--quiet] [--verbose] \\
.br
--remove |& --get |& --send \\
.br
 --sms[=\fIслот#\fP|=\fIстатус\fP] [--text \fIтекст\fP] [--number \fIномер\fP] 
[--direct] [--flash] [--srr] [--unicode] [--smsmem=\fIтип_памяти\fP]\\
.br
[файл1 [файл2 [...]]]
.SH ОПИСАНИЕ
SCMxx может копировать файлы в мобильный телефон Siemens и обратно, а также
удалять сохраненные файлы. Файлы могут быть прочитаны из конкретного файла или
получены через стандартный ввод и сохранены в конкретном файле или переданы на
стандартный вывод. SMS могут быть также напрямую переданы или приняты без
сохранения в мобильном телефоне. SCMxx была протестирована с несколькими
мобильными телефонами, произведенными Siemens (только S25 и поздние).

Выводимый текст (телефонная книга и сообщения) зависит от таблицы символов
текущей локализации. Вводимый аналогично. Такое преимущество у локализации, но
есть и недостаток, что все остальные символы должны вводиться через
последовательность вида \\XXXX, где X - шестнадцатиричный символ (например,
\\20ac для знака Euro). Это 16битное представление значения unicode.  Символ
новой строки может быть введен, используя общее представление \\n, а символ '\\'
должен быть экранирован сам собой. В bash в результате необходимо вводить
строку подобно "\\\\".

.SH ОПЦИИ
.TP 20
.B --device (-d)
определить отличное от вкомпилированного имя устройства. Опция перекрывает
переменную окружения SCMXX_TTY и вскомпилированное значение. Для системы linux
может быть, к примеру, /dev/ttyS0 для последовательного соединения и
/dev/ircomm0 для соединения по инфракрасному порту.
.P
.TP 20
.B --baud (-b)
определить скорость устройства. Подходящие значения зависят от системы, но
могут быть 9600, 19200, 38400, 57600 или 115200. Значение по умолчанию 19200.
Телефоны S25 и *35i работают только при скорости 19200, все поздние модели
также работают при полной скорости последовательного канала. Соединения по 
инфракрасному порту могут содержать исключения из этих правил (зависит от
реализации порта). Опция перекрывает значение переменной окружения
SCMXX_BAUD и вкомпилированное значение.
.P
.TP 20
.B --out (-o)
определить используемый файл. При получении с параметром "all" к каждому файлу
присоединяется номер слота, точка и тип файла (SMS состовляет исключение). При
отправке или удалении, опция не будет использоваться, но в качестве параметра
должны быть указаны корректные файлы.  Стандартный ввод и вывод должны быть
однозначно выбраны через дефис ("-"), программа ничего не выводит (кроме
получения непрочитанных SMS).  Ничего не добавляется к "-", когда идет
получение группы файлов.
.P
.TP 20
.B --pipe (-p)
определить канал к другой программе. При получении данных с параметром "all",
каждый файл будет передан по каналу к этим программам сам собой (исключая
записи телефонных книг).
.P
.TP 20
.B --quiet (-q)
уменьшить степень подробности вывода на 1 (минимальное значение: -1)
.P
.TP 20
.B --pin
использовать этот pin, если необходимо
.P
.TP 20
.B --verbose (-v)
увеличить степень подробности вывода на 1 (максимальное значение: +1)
.P
.TP 20
.B --reset
попытаться сбросить телефон, и он снова станет доступен. Это может понадобится
в случае, если телефон не отвечает больше по последовательному интерфейсу,
особенно при прерванной перед этим пользователем передачи файла.
Произойдет просто слепая передача некоторых символов.
.P
.TP 20
.B --help (-h)
вывести текст помощи
.P
.TP 20
.B --version
вывести номер версии
.P
.TP 20
.B --remove (-r)
удалить запись в телефоне. "Слот" выбирается либо числом, либо ключевым словом
"all". Когда опция определена с опциями --sms и --get, будет произведено
получение и удаление. Когда опция определена с опцией --sms, может быть получен
также статус сообщений. Статус может принимать следующие значения:
"непрочитанные", "прочитанные", "неотправленные" и "отправленные".
.P
.TP 20
.B --get (-g)
получить запись и сохранить ее в файл. "Слот" выбирается либо числом, либо
ключевым словом "all". Когда опция определена с опцией --sms, может быть
получен также статус сообщений. Статус может принимать следующие
значения: "непрочитанные", "прочитанные", "неотправленные" и "отправленные".
.P
.TP 20
.B --send (-s)
отправить файл в телефон. "Слот" является числом. Без параметра будет
произведена попытка поиска первого свободного слота (возможно, что это займет
длительный промежуток времени). Когда определены слот и группа файлов
для загрузки, то данный слот является начальной точкой для поиска пустых
слотов. Групповая перезапись, запись в непустые слоты не поддерживается.
Если опция определена с --sms, то это также может определять статус.
Статус может принимать следующие значения: "непрочитанные", "прочитанные",
"неотправленные", "отправленные", но только два последних в данный момент
работают правильно (и необходимо использовать -direct, иначе сообщение
только скопируется).
.P
.TP 20
.B --info (-i)
собрать информацию о телефоне
.P
.TP 20
.B --set-time
синхронизировать время в телефоне. Рекомендуется использовать инструменты
типа ntpdate перед синхронизацией.
.P
.TP 20
.B --set-smsc
установить номер SMS-центра (требует опцию --number)
.P
.TP 20
.B --bitmap (-B)
выбрать номер слота для картинки (.bmp)
.P
.TP 20
.B --midi (-M)
выбрать номер слота для мелодии вызова (.mid)
.P
.TP 20
.B --vcal (-C)
выбрать номер слота для календаря (.vcs)
.P
.TP 20
.B --vcard (-F)
выбрать номер слота для визитки (.vcf) (не поддерживается в *35i или S25).
.P
.TP 20
.B --pbook (-P)
выбрать телефонную книгу, смотрите вывод --info, чтобы узнать доступные
телефонные книги.
.P
.TP 20
.B --sms (-S)
выбрать режим службы коротких сообщений
.P
.TP 20
.B --text (-t)
определить содержание текста SMS (только в режиме отправки). Заметьте,
что длина ограничена 160 GSM символами, минус 1 на каждый используемый символ,
который нуждается в 14-битном кодировании. Программа откажет в отправке,
если текст слишком длинный. Поддержка multipart-SMS появиться в более поздней
версии.
.P
.TP 20
.B --number (-n)
определить номер для отправки SMS (только в режиме отправки). Заметьте, что
номер может иметь вначале '+' для международных номеров. Он ограничен 20
цифрами (без '+'), которых действительно достаточно.
.P
.TP 20
.B --direct
отправить/получить сообщение без сохранения его в памяти телефона. Это не
выполняется по умолчанию, так как вы будете несомненно заняты сообщением, при
отправке. При непосредственном получении, SMS, тип которого не соответствует
DELIVER, все еще сохраняется в памяти телефона (scmxx не может пока что
декодировать такие сообщения).
.P
.TP 20
.B --unicode
переслать сообщение и ипользовать UCS-2 (16бит unicode) как таблицу символов.
Эта опция ограничит длину сообщения до 70 символов. Если опция не определена,
то будет использовано кодирование символов 7бит GSM с максимальным ограничением
в 160 символов. Необязательно применять эту опцию для декодирования сообщений,
написанных в кодировке unicode.
.P
.TP 20
.B --smsmem
выбрать память sms для последующего доступа. Номер слота может варьироваться
в зависимости от выбранного типа памяти. Смотрите вывод --info для
поддерживаемых типов памяти. Телефонами *35i и S25 поддерживается только "SM",
*45 могут также поддерживать "ME" и "MT". Последнее содержит "ME" + "SM".
"MT" является значеним по умолчанию для телефонов, поддерживающих это.
Для всех остальных телефонов, значение по умолчанию соответствует "SM".
.P
.TP 20
.B --flash
установить Class0 в поле схемы кодирования данных, что обычно интерпретируется
как "немедленное отображение". Не все принимающие аппараты дают право делать
это. Заметьте, что очередное sms обычно перезаписывает предыдущее
сообщение без вопросов такого типа! Использование опции не рекомендуется.
.P
.TP 20
.B --srr
установить StatusReportRequest бит в поле pdutype из sms pdu. Это зависит от
SMSC, если это принимать во внимание. С некоторыми центрами сообщений это
потребует дополнительных затрат!
.SH ИСПОЛЬЗОВАНИЕ
.TP
Отправить файл картинки в телефон как картинку:
.br
scmxx --send --bitmap=0 myfile.bmp
.br
ИЛИ
.br
scmxx -sB0 myfile.bmp
.br
ИЛИ
.br
cat myfile.bmp | scmxx -sB -
.TP
Получить картинку из телефона и сохранить ее в новом файле:
.br
scmxx --get --bitmap=0 --out=myfile.bmp
.br
ИЛИ
.br
scmxx -gB0 -o myfile.bmp
.br
ИЛИ
.br
scmxx -gB0 >myfile.bmp

.SH ЗАМЕЧАНИЯ
Здесь описывается дополнительный параметр --ignore-serial-bits. Используйте
его только тогда, когда вообще нет ответа от телефона. Он очищает все биты
последовательного порта вместо чтения их из устройства. Это может помочь,
хотя и нет уверенности, что такое поведение не вызвано плохим кабелем или
неверными настройками порта.
.P
Другой параметр --device-timeout=<секунды> предназначен для случая, когда
телефону когда-либо потребуется больше времени на ответ, чем определенные
по умолчанию 10 секунд. Действительно, это было более чем достаточно, но
кто знает. Минимальное значение равно 1.

.SH ПЕРЕМЕННЫЕ ОКРУЖЕНИЯ
.P
.TP 20
.B SCMXX_TTY
смотрите описание опции --device
.P
.TP 20
.B SCMXX_BAUD
смотрите описание опции --baud
.SH АВТОР
Hendrik Sattler <post@hendrik-sattler.de>.
Перевод выполнен Andy Shevchenko <andy@smile.org.ua> и Irina
Yeresko <mecec@yandex.ru>

