#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "prescheme.h"
#include <string.h>
#include <stdlib.h>
#include "scheme48vm.h"
#include "scheme48heap.h"
#include "scheme48write-barrier.h"
#include "bibop/bibop.h"

struct image_location {
  long new_descriptor;
  long next;
};
struct table {
  long *keys;
  struct image_location **values;
  long count;
  long size;
};
struct bibop_areas {
  long *small;
  long small_index;
  long *large;
  long large_index;
  long *weaks;
  long weaks_index;
};
static struct image_location *table_ref(struct table*, long);
static long image_alloc(long, long);
static void write_descriptor(long);
static void table_setB(struct table*, long, struct image_location*);
static char resumer_recordP(long);
static long trace_image_value(long);
long s48_max_heap_size(void);
void s48_set_max_heap_sizeB(long);
long s48_min_heap_size(void);
char * s48_get_new_small_start_addr(void);
void s48_set_new_small_start_addrB(char *);
char * s48_get_new_large_start_addr(void);
void s48_set_new_large_start_addrB(char *);
char * s48_get_new_weaks_start_addr(void);
void s48_set_new_weaks_start_addrB(char *);
void s48_initialization_completeB(void);
long s48_startup_procedure(void);
long s48_initial_symbols(void);
long s48_initial_imported_bindings(void);
long s48_initial_exported_bindings(void);
long s48_resumer_records(void);
void s48_initializing_gc_root(void);
void s48_set_image_valuesB(long, long, long, long, long);
void s48_trace_continuation_contentsB(char *, char *, long);
long s48_allocate_stob(long, long);
void s48_trace_continuation(char *, long);
long s48_read_image(char*, long);
long s48_write_image(long, long, FILE *);
static long Smax_heap_sizeS;
static long Smin_heap_sizeS;
static char * Snew_small_start_addrS;
static char * Snew_large_start_addrS;
static char * Snew_weaks_start_addrS;
static char * *Spure_areasS;
static char * *Simpure_areasS;
static long *Spure_sizesS;
static long *Simpure_sizesS;
static long SstatusS;
static char SeofPS;
static long Sstartup_procedureS;
static long SsymbolsS;
static long Simported_bindingsS;
static long Sexported_bindingsS;
static long Sresumer_recordsS;
static char * Simg_start_addrS;
static char * Simg_end_addrS;
static long Simg_heap_sizeS;
static char * Ssmall_img_start_addrS;
static char * Ssmall_img_hp_addrS;
static char * Ssmall_img_end_addrS;
static long Ssmall_img_heap_sizeS;
static char * Slarge_img_start_addrS;
static char * Slarge_img_hp_addrS;
static char * Slarge_img_end_addrS;
static long Slarge_img_heap_sizeS;
static char * Sweaks_img_start_addrS;
static char * Sweaks_img_hp_addrS;
static char * Sweaks_img_end_addrS;
static long Sweaks_img_heap_sizeS;
static char * Sheap_image_pointerS;
static char * Ssymbol_addressS;
static long Sheap_object_remaining_cellsS;
static char * Sheap_object_pointerS;
static struct table *Sstob_tableS;
static long SoffsetS;
static char * Sarea_startS;
static char SinitializingPS;
static long SstatusS;
static FILE * Simage_portS;
static char * Simage_bufferS;
static char * Simage_buffer_pointerS;
static long small_image_start_address;
static char * Ssmall_image_beginS;
static char * Ssmall_image_hpS;
static char * Ssmall_image_endS;
static char * Slarge_image_beginS;
static char * Slarge_image_hpS;
static char * Slarge_image_endS;
static char * Sweaks_image_beginS;
static char * Sweaks_image_hpS;
static char * Sweaks_image_endS;
static struct bibop_areas *Sbibop_areasS;
static char Straced_last_stobPS;
static long Sstob_table_obj_nrS;
static struct table *Sstob_tableS;
static long Sfirst_stobS;
static struct image_location *Slast_stobS;
static long Sresumer_countS;
static long Sresumer_recordsS;
static long Sundumpable_recordsS;
static long Sundumpable_countS;

static struct image_location *table_ref(struct table *table_0X, long key_1X)
{
  long arg0K0;
  long next_5X;
  long i_4X;
  long *keys_3X;
  long size_2X;
 {  if ((0 < (table_0X->size))) {
    size_2X = table_0X->size;
    keys_3X = table_0X->keys;
    arg0K0 = ((key_1X ^ ((((key_1X)<<1)) ^ (((key_1X)>>10)))) & (-1 + size_2X));
    goto L3700;}
  else {
    return (NULL);}}
 L3700: {
  i_4X = arg0K0;
  next_5X = *(keys_3X + i_4X);
  if ((key_1X == next_5X)) {
    return (*((table_0X->values) + i_4X));}
  else {
    if ((0 == next_5X)) {
      if ((i_4X == (table_0X->size))) {
        arg0K0 = 0;
        goto L3700;}
      else {
        return (NULL);}}
    else {
      arg0K0 = (1 + i_4X);
      goto L3700;}}}
}
static long image_alloc(long type_size_6X, long length_in_a_units_7X)
{
  char * arg1K0;
  char * data_addr_9X;
  char * image_hp_8X;
 {  if ((0 == type_size_6X)) {
    arg1K0 = (Ssmall_image_hpS);
    goto L4286;}
  else {
    if ((1 == type_size_6X)) {
      arg1K0 = (Slarge_image_hpS);
      goto L4286;}
    else {
      if ((2 == type_size_6X)) {
        arg1K0 = (Sweaks_image_hpS);
        goto L4286;}
      else {
        ps_error("invalid area tag", 0);
        arg1K0 = (Sweaks_image_hpS);
        goto L4286;}}}}
 L4286: {
  image_hp_8X = arg1K0;
  data_addr_9X = image_hp_8X + 4;
  if ((0 == type_size_6X)) {
    Ssmall_image_hpS = (data_addr_9X + length_in_a_units_7X);
    goto L4305;}
  else {
    if ((1 == type_size_6X)) {
      Slarge_image_hpS = (data_addr_9X + length_in_a_units_7X);
      goto L4305;}
    else {
      if ((2 == type_size_6X)) {
        Sweaks_image_hpS = (data_addr_9X + length_in_a_units_7X);
        goto L4305;}
      else {
        goto L4305;}}}}
 L4305: {
  return (3 + (((long) data_addr_9X)));}
}
static void write_descriptor(long descriptor_10X)
{
  long have_11X;
 {  *((long *) (Simage_buffer_pointerS)) = (long) (descriptor_10X);
  Simage_buffer_pointerS = ((Simage_buffer_pointerS) + 4);
  if ((4096 == ((Simage_buffer_pointerS) - (Simage_bufferS)))) {
    have_11X = (Simage_buffer_pointerS) - (Simage_bufferS);
    if ((0 < have_11X)) {
      if (((SstatusS) == NO_ERRORS)) {
        SstatusS = (ps_write_block((Simage_portS), ((char *) (Simage_bufferS)), have_11X));
        goto L7341;}
      else {
        goto L7341;}}
    else {
      return;}}
  else {
    return;}}
 L7341: {
  Simage_buffer_pointerS = (Simage_bufferS);
  return;}
}
static void table_setB(struct table *table_12X, long key_13X, struct image_location *value_14X)
{
  long arg0K0;
  long i_30X;
  struct image_location *value_29X;
  long key_28X;
  long i_27X;
  long i_26X;
  struct image_location **new_values_25X;
  long *new_keys_24X;
  long new_size_23X;
  struct image_location **old_values_22X;
  long v_21X;
  long old_size_20X;
  long *old_keys_19X;
  long next_18X;
  long i_17X;
  long *keys_16X;
  long size_15X;
 {  if ((0 < (table_12X->size))) {
    size_15X = table_12X->size;
    keys_16X = table_12X->keys;
    arg0K0 = ((key_13X ^ ((((key_13X)<<1)) ^ (((key_13X)>>10)))) & (-1 + size_15X));
    goto L7836;}
  else {
    return;}}
 L7836: {
  i_17X = arg0K0;
  next_18X = *(keys_16X + i_17X);
  if ((key_13X == next_18X)) {
    *((table_12X->values) + i_17X) = value_14X;
    return;}
  else {
    if ((0 == next_18X)) {
      if ((i_17X == (table_12X->size))) {
        arg0K0 = 0;
        goto L7836;}
      else {
        *((table_12X->keys) + i_17X) = key_13X;
        *((table_12X->values) + i_17X) = value_14X;
        table_12X->count = (1 + (table_12X->count));
        if (((table_12X->count) == ((table_12X->size) / 3))) {
          old_keys_19X = table_12X->keys;
          old_size_20X = table_12X->size;
          v_21X = table_12X->size;
          old_values_22X = table_12X->values;
          new_size_23X = ((v_21X)<<1);
          new_keys_24X = (long*)malloc(sizeof(long) * (1 + new_size_23X));
          new_values_25X = (struct image_location**)malloc(sizeof(struct image_location*) * new_size_23X);
          if ((NULL == new_keys_24X)) {
            goto L5259;}
          else {
            if ((NULL == new_values_25X)) {
              goto L5259;}
            else {
              table_12X->keys = new_keys_24X;
              table_12X->values = new_values_25X;
              table_12X->size = new_size_23X;
              table_12X->count = 0;
              arg0K0 = 0;
              goto L5412;}}}
        else {
          return;}}}
    else {
      arg0K0 = (1 + i_17X);
      goto L7836;}}}
 L5259: {
  if ((NULL == new_keys_24X)) {
    goto L5267;}
  else {
    free(new_keys_24X);
    goto L5267;}}
 L5412: {
  i_26X = arg0K0;
  if ((i_26X < (1 + new_size_23X))) {
    *(new_keys_24X + i_26X) = 0;
    arg0K0 = (1 + i_26X);
    goto L5412;}
  else {
    arg0K0 = 0;
    goto L5290;}}
 L5267: {
  if ((NULL == new_values_25X)) {
    goto L5275;}
  else {
    free(new_values_25X);
    goto L5275;}}
 L5290: {
  i_27X = arg0K0;
  if ((i_27X == old_size_20X)) {
    free(old_keys_19X);
    free(old_values_22X);
    return;}
  else {
    key_28X = *(old_keys_19X + i_27X);
    if ((0 == key_28X)) {
      goto L5306;}
    else {
      value_29X = *(old_values_22X + i_27X);
      arg0K0 = ((key_28X ^ ((((key_28X)<<1)) ^ (((key_28X)>>10)))) & (-1 + new_size_23X));
      goto L5434;}}}
 L5275: {
  table_12X->size = 0;
  return;}
 L5306: {
  arg0K0 = (1 + i_27X);
  goto L5290;}
 L5434: {
  i_30X = arg0K0;
  if ((0 == (*(new_keys_24X + i_30X)))) {
    if ((i_30X == new_size_23X)) {
      arg0K0 = 0;
      goto L5434;}
    else {
      *(new_keys_24X + i_30X) = key_28X;
      *(new_values_25X + i_30X) = value_29X;
      goto L5306;}}
  else {
    arg0K0 = (1 + i_30X);
    goto L5434;}}
}
static char resumer_recordP(long stob_31X)
{
  long type_32X;
 {  if ((3 == (3 & stob_31X))) {
    if ((9 == (31 & ((((*((long *) ((((char *) (-3 + stob_31X))) + -4))))>>2))))) {
      type_32X = *((long *) (((char *) (-3 + stob_31X))));
      if ((3 == (3 & type_32X))) {
        if ((9 == (31 & ((((*((long *) ((((char *) (-3 + type_32X))) + -4))))>>2))))) {
          return (3 == (3 & (*((long *) ((((char *) (-3 + type_32X))) + 4)))));}
        else {
          return 0;}}
      else {
        return 0;}}
    else {
      return 0;}}
  else {
    return 0;}}
}
static long trace_image_value(long thing_33X)
{
  struct image_location *arg2K0;
  struct image_location *arg2K1;
  long arg0K0;
  long merged_arg0K0;

  int gc_recordP_return_tag;
  char gc_recordP0_return_value;
  long x_34X;
  long header_57X;
  long type_size_56X;
  char v_55X;
  long x_54X;
  struct image_location *new_53X;
  long new_descriptor_52X;
  struct image_location *new_51X;
  struct image_location *image_location_50X;
  long new_descriptor_49X;
  long v_48X;
  long h_47X;
  long stob_46X;
  struct image_location *image_location_45X;
  long new_alias_44X;
  char * addr_43X;
  long x_42X;
  long i_41X;
  long len_40X;
  long vector_39X;
  char v_38X;
  long type_37X;
  char v_36X;
  struct image_location *have_35X;
 {  if ((3 == (3 & thing_33X))) {
    have_35X = table_ref((Sstob_tableS), thing_33X);
    if ((NULL == have_35X)) {
      merged_arg0K0 = thing_33X;
      gc_recordP_return_tag = 0;
      goto gc_recordP;
     gc_recordP_return_0:
      v_36X = gc_recordP0_return_value;
      if (v_36X) {
        type_37X = *((long *) (((char *) (-3 + thing_33X))));
        merged_arg0K0 = type_37X;
        gc_recordP_return_tag = 1;
        goto gc_recordP;
       gc_recordP_return_1:
        v_38X = gc_recordP0_return_value;
        if (v_38X) {
          if ((1 == (*((long *) ((((char *) (-3 + type_37X))) + 4))))) {
            if (((Sundumpable_countS) < ((((3 + ((long)(((unsigned long)(*((long *) ((((char *) (-3 + (Sundumpable_recordsS)))) + -4))))>>8))))>>2)))) {
              vector_39X = Sundumpable_recordsS;
              len_40X = (((3 + ((long)(((unsigned long)(*((long *) ((((char *) (-3 + vector_39X))) + -4))))>>8))))>>2);
              arg0K0 = 0;
              goto L12274;}
            else {
              goto L15605;}}
          else {
            arg0K0 = thing_33X;
            goto L13071;}}
        else {
          arg0K0 = thing_33X;
          goto L13071;}}
      else {
        arg0K0 = thing_33X;
        goto L13071;}}
    else {
      return (have_35X->new_descriptor);}}
  else {
    return thing_33X;}}
 L12274: {
  i_41X = arg0K0;
  if ((i_41X == len_40X)) {
    x_42X = Sundumpable_recordsS;
    addr_43X = (((char *) (-3 + x_42X))) + ((((Sundumpable_countS))<<2));S48_WRITE_BARRIER(x_42X, addr_43X, thing_33X);
    *((long *) addr_43X) = (long) (thing_33X);
    Sundumpable_countS = (1 + (Sundumpable_countS));
    goto L15605;}
  else {
    if (((*((long *) ((((char *) (-3 + vector_39X))) + (((i_41X)<<2))))) == thing_33X)) {
      goto L15605;}
    else {
      arg0K0 = (1 + i_41X);
      goto L12274;}}}
 L15605: {
  new_alias_44X = trace_image_value((*((long *) ((((char *) (-3 + thing_33X))) + 4))));
  image_location_45X = (struct image_location*)malloc(sizeof(struct image_location));
  if ((NULL == image_location_45X)) {
    arg2K0 = image_location_45X;
    goto L15609;}
  else {
    image_location_45X->new_descriptor = new_alias_44X;
    image_location_45X->next = 0;
    arg2K0 = image_location_45X;
    goto L15609;}}
 L13071: {
  stob_46X = arg0K0;
  h_47X = *((long *) ((((char *) (-3 + stob_46X))) + -4));
  v_48X = s48_area_type_size(stob_46X);
  new_descriptor_49X = image_alloc(v_48X, (-4 & (3 + ((long)(((unsigned long)h_47X)>>8)))));
  image_location_50X = (struct image_location*)malloc(sizeof(struct image_location));
  if ((NULL == image_location_50X)) {
    arg0K0 = new_descriptor_49X;
    arg2K1 = image_location_50X;
    goto L13075;}
  else {
    image_location_50X->new_descriptor = new_descriptor_49X;
    image_location_50X->next = 0;
    arg0K0 = new_descriptor_49X;
    arg2K1 = image_location_50X;
    goto L13075;}}
 L15609: {
  new_51X = arg2K0;
  if ((NULL == new_51X)) {
    (Sstob_tableS)->size = 0;
    return new_alias_44X;}
  else {table_setB((Sstob_tableS), thing_33X, new_51X);
    return new_alias_44X;}}
 L13075: {
  new_descriptor_52X = arg0K0;
  new_53X = arg2K1;
  if ((NULL == new_53X)) {
    (Sstob_tableS)->size = 0;
    return new_descriptor_52X;}
  else {
    x_54X = Sfirst_stobS;
    if ((1 == x_54X)) {
      Sfirst_stobS = stob_46X;
      goto L13096;}
    else {
      (Slast_stobS)->next = stob_46X;
      goto L13096;}}}
 L13096: {
  Slast_stobS = new_53X;
  new_53X->next = 1;table_setB((Sstob_tableS), stob_46X, new_53X);
  v_55X = resumer_recordP(stob_46X);
  if (v_55X) {
    Sresumer_countS = (1 + (Sresumer_countS));
    goto L13112;}
  else {
    goto L13112;}}
 L13112: {
  Sstob_table_obj_nrS = (1 + (Sstob_table_obj_nrS));
  type_size_56X = s48_area_type_size(stob_46X);
  if ((0 == type_size_56X)) {
    if ((Straced_last_stobPS)) {
      *(((Sbibop_areasS)->small) + ((Sbibop_areasS)->small_index)) = 1;
      (Sbibop_areasS)->small_index = (1 + ((Sbibop_areasS)->small_index));
      goto L4409;}
    else {
      goto L4409;}}
  else {
    if ((1 == type_size_56X)) {
      if ((Straced_last_stobPS)) {
        *(((Sbibop_areasS)->large) + ((Sbibop_areasS)->large_index)) = 1;
        (Sbibop_areasS)->large_index = (1 + ((Sbibop_areasS)->large_index));
        goto L4425;}
      else {
        goto L4425;}}
    else {
      if ((2 == type_size_56X)) {
        if ((Straced_last_stobPS)) {
          *(((Sbibop_areasS)->weaks) + ((Sbibop_areasS)->weaks_index)) = 1;
          (Sbibop_areasS)->weaks_index = (1 + ((Sbibop_areasS)->weaks_index));
          goto L4441;}
        else {
          goto L4441;}}
      else {
        ps_error("Unexpected area type size!", 0);
        return new_descriptor_52X;}}}}
 L4409: {
  *(((Sbibop_areasS)->small) + ((Sbibop_areasS)->small_index)) = stob_46X;
  (Sbibop_areasS)->small_index = (1 + ((Sbibop_areasS)->small_index));
  return new_descriptor_52X;}
 L4425: {
  *(((Sbibop_areasS)->large) + ((Sbibop_areasS)->large_index)) = stob_46X;
  (Sbibop_areasS)->large_index = (1 + ((Sbibop_areasS)->large_index));
  return new_descriptor_52X;}
 L4441: {
  *(((Sbibop_areasS)->weaks) + ((Sbibop_areasS)->weaks_index)) = stob_46X;
  (Sbibop_areasS)->weaks_index = (1 + ((Sbibop_areasS)->weaks_index));
  return new_descriptor_52X;}
 gc_recordP: {
  x_34X = merged_arg0K0;{
  if ((3 == (3 & x_34X))) {
    header_57X = *((long *) ((((char *) (-3 + x_34X))) + -4));
    if ((3 == (3 & header_57X))) {
      if ((3 == (3 & header_57X))) {
        gc_recordP0_return_value = (9 == (31 & ((((*((long *) ((((char *) (-3 + header_57X))) + -4))))>>2))));
        goto gc_recordP_return;}
      else {
        gc_recordP0_return_value = 0;
        goto gc_recordP_return;}}
    else {
      if ((3 == (3 & x_34X))) {
        gc_recordP0_return_value = (9 == (31 & ((((*((long *) ((((char *) (-3 + x_34X))) + -4))))>>2))));
        goto gc_recordP_return;}
      else {
        gc_recordP0_return_value = 0;
        goto gc_recordP_return;}}}
  else {
    gc_recordP0_return_value = 0;
    goto gc_recordP_return;}}
 gc_recordP_return:
  switch (gc_recordP_return_tag) {
  case 0: goto gc_recordP_return_0;
  default: goto gc_recordP_return_1;
  }}

}
long s48_max_heap_size(void)
{

 {  return (Smax_heap_sizeS);}
}
void s48_set_max_heap_sizeB(long size_58X)
{

 {  Smax_heap_sizeS = size_58X;
  return;}
}
long s48_min_heap_size(void)
{

 {  return (Smin_heap_sizeS);}
}
char * s48_get_new_small_start_addr(void)
{

 {  return (Snew_small_start_addrS);}
}
void s48_set_new_small_start_addrB(char * addr_59X)
{

 {  Snew_small_start_addrS = addr_59X;
  return;}
}
char * s48_get_new_large_start_addr(void)
{

 {  return (Snew_large_start_addrS);}
}
void s48_set_new_large_start_addrB(char * addr_60X)
{

 {  Snew_large_start_addrS = addr_60X;
  return;}
}
char * s48_get_new_weaks_start_addr(void)
{

 {  return (Snew_weaks_start_addrS);}
}
void s48_set_new_weaks_start_addrB(char * addr_61X)
{

 {  Snew_weaks_start_addrS = addr_61X;
  return;}
}
void s48_initialization_completeB(void)
{

 {  SinitializingPS = 0;
  return;}
}
long s48_startup_procedure(void)
{

 {  return (Sstartup_procedureS);}
}
long s48_initial_symbols(void)
{

 {  return (SsymbolsS);}
}
long s48_initial_imported_bindings(void)
{

 {  return (Simported_bindingsS);}
}
long s48_initial_exported_bindings(void)
{

 {  return (Sexported_bindingsS);}
}
long s48_resumer_records(void)
{

 {  return (Sresumer_recordsS);}
}
void s48_initializing_gc_root(void)
{
  long expr_66X;
  long expr_65X;
  long expr_64X;
  long expr_63X;
  long expr_62X;
 {  if ((SinitializingPS)) {
    expr_62X = s48_trace_value((Sstartup_procedureS));
    Sstartup_procedureS = expr_62X;
    expr_63X = s48_trace_value((SsymbolsS));
    SsymbolsS = expr_63X;
    expr_64X = s48_trace_value((Simported_bindingsS));
    Simported_bindingsS = expr_64X;
    expr_65X = s48_trace_value((Sexported_bindingsS));
    Sexported_bindingsS = expr_65X;
    expr_66X = s48_trace_value((Sresumer_recordsS));
    Sresumer_recordsS = expr_66X;
    return;}
  else {
    return;}}
}
void s48_set_image_valuesB(long startup_proc_67X, long symbols_68X, long imports_69X, long exports_70X, long records_71X)
{

 {  Sstartup_procedureS = startup_proc_67X;
  SsymbolsS = symbols_68X;
  Simported_bindingsS = imports_69X;
  Sexported_bindingsS = exports_70X;
  Sresumer_recordsS = records_71X;
  return;}
}
void s48_trace_continuation_contentsB(char * contents_pointer_72X, char * code_pointer_73X, long mask_size_74X)
{
  char * arg1K0;
  char * arg1K1;
  long arg0K0;
  long x2_80X;
  char * ptr_79X;
  long mask_78X;
  char * trace_ptr_77X;
  char * mask_ptr_76X;
  char * mask_pointer_75X;
 {  mask_pointer_75X = code_pointer_73X + -7;
  arg1K0 = (mask_pointer_75X + (0 - mask_size_74X));
  arg1K1 = contents_pointer_72X;
  goto L3117;}
 L3117: {
  mask_ptr_76X = arg1K0;
  trace_ptr_77X = arg1K1;
  if ((mask_ptr_76X == mask_pointer_75X)) {
    return;}
  else {
    arg0K0 = (*((unsigned char *) mask_ptr_76X));
    arg1K1 = trace_ptr_77X;
    goto L3125;}}
 L3125: {
  mask_78X = arg0K0;
  ptr_79X = arg1K1;
  if ((0 == mask_78X)) {
    arg1K0 = (mask_ptr_76X + 1);
    arg1K1 = (trace_ptr_77X + 32);
    goto L3117;}
  else {
    if ((1 == (1 & mask_78X))) {
      x2_80X = s48_trace_value((*((long *) ptr_79X)));
      *((long *) ptr_79X) = (long) (x2_80X);
      goto L3143;}
    else {
      goto L3143;}}}
 L3143: {
  arg0K0 = (((mask_78X)>>1));
  arg1K1 = (ptr_79X + 4);
  goto L3125;}
}
long s48_allocate_stob(long type_81X, long size_82X)
{
  long arg0K0;
  char * arg1K0;
  char * thing_88X;
  char * v_87X;
  char * v_86X;
  long needed_85X;
  long length_in_bytes_84X;
  char tracedP_83X;
 {  tracedP_83X = type_81X < 16;
  if (tracedP_83X) {
    arg0K0 = (((size_82X)<<2));
    goto L4186;}
  else {
    arg0K0 = size_82X;
    goto L4186;}}
 L4186: {
  length_in_bytes_84X = arg0K0;
  needed_85X = 4 + length_in_bytes_84X;
  if (tracedP_83X) {
    v_86X = s48_allocate_tracedAgc(needed_85X);
    arg1K0 = v_86X;
    goto L4202;}
  else {
    v_87X = s48_allocate_untracedAgc(needed_85X);
    arg1K0 = v_87X;
    goto L4202;}}
 L4202: {
  thing_88X = arg1K0;
  if ((thing_88X == NULL)) {
    ps_error("insufficient heap space for external allocation", 0);
    goto L4214;}
  else {
    goto L4214;}}
 L4214: {
  *((long *) thing_88X) = (long) ((2 + (((((((length_in_bytes_84X)<<6)) + type_81X))<<2))));
  return (3 + (((long) (thing_88X + 4))));}
}
void s48_trace_continuation(char * contents_pointer_89X, long size_90X)
{
  char * data_pointer_93X;
  long mask_size_92X;
  char * code_pointer_91X;
 {  code_pointer_91X = (((char *) (-3 + (*((long *) (contents_pointer_89X + 4)))))) + ((((*((long *) contents_pointer_89X)))>>2));
  mask_size_92X = *((unsigned char *) (code_pointer_91X + -3));
  if ((0 == mask_size_92X)) {s48_trace_locationsB(contents_pointer_89X, (contents_pointer_89X + size_90X));
    return;}
  else {
    data_pointer_93X = contents_pointer_89X + 12;s48_trace_locationsB(contents_pointer_89X, data_pointer_93X);s48_trace_continuation_contentsB(data_pointer_93X, code_pointer_91X, mask_size_92X);
    return;}}
}
long s48_read_image(char *image_filename_94X, long max_heap_size_95X)
{
  struct image_location *arg2K0;
  struct table *arg5K0;
  char *arg4K1;
  char arg3K1;
  char arg3K0;
  char * arg1K0;
  long arg0K2;
  long arg0K1;
  long arg0K0;
  struct table *merged_arg5K1;
  FILE * merged_arg6K2;
  long merged_arg0K2;
  long merged_arg0K0;
  long merged_arg0K1;
  char * merged_arg1K2;
  char * merged_arg1K1;
  char * merged_arg1K0;

  int really_read_image_area_return_tag;
  long really_read_image_area0_return_value;
  int read_image_area_return_tag;
  long read_image_area0_return_value;
  int reverse_byte_orderB_return_tag;
  int relocate_image_return_tag;
  int relocate_binding_table_two_spaceB_return_tag;
  int relocate_binding_table_bibopB_return_tag;
  int relocateD0_return_tag;
  long relocateD00_return_value;
  int old_Gnew_addr_return_tag;
  char * old_Gnew_addr0_return_value;
  int parse_reachable_objects_return_tag;
  long parse_reachable_objects0_return_value;
  int relocateD1_return_tag;
  long relocateD10_return_value;
  char * new_start_addr_96X;
  long img_heap_size_97X;
  FILE * port_98X;
  char * new_start_addr_99X;
  long img_heap_size_100X;
  FILE * port_101X;
  char * start_102X;
  char * end_103X;
  long delta_104X;
  char * start_105X;
  char * end_106X;
  long table_107X;
  long delta_108X;
  long table_109X;
  struct table *stob_table_110X;
  long address_111X;
  char * addr_112X;
  long format_113X;
  char * from_addr_114X;
  char * to_addr_115X;
  long image_format_116X;
  long address_117X;
  long status_503X;
  long status_502X;
  char *string_501X;
  char okayP_500X;
  long status_499X;
  char eofP_498X;
  long got_497X;
  long need_496X;
  long status_495X;
  long status_494X;
  char *string_493X;
  char okayP_492X;
  long status_491X;
  char eofP_490X;
  long got_489X;
  long need_488X;
  char * next_487X;
  long value_486X;
  long byte_a_485X;
  char * addr_b_484X;
  char * addr_a_483X;
  long j_482X;
  long i_481X;
  char * ptr_480X;
  long d_479X;
  long descriptor_478X;
  char * ptr_477X;
  char * addr_476X;
  long val_475X;
  long next_474X;
  long next_473X;
  long link_472X;
  long entry_471X;
  char * addr_470X;
  long value_469X;
  long bucket_468X;
  long bucket_467X;
  long link_466X;
  long i_465X;
  char * addr_464X;
  long val_463X;
  long next_462X;
  long next_461X;
  long link_460X;
  long entry_459X;
  char * addr_458X;
  long value_457X;
  long bucket_456X;
  long bucket_455X;
  long link_454X;
  long i_453X;
  struct image_location *image_location_452X;
  long v_451X;
  char * address_450X;
  char * y_449X;
  char * y_448X;
  char * v_447X;
  char * y_446X;
  char * index_445X;
  long v_444X;
  long v_443X;
  char * v_442X;
  long v_441X;
  char * new_address_440X;
  struct image_location *image_location_439X;
  long v_438X;
  struct image_location *val_437X;
  struct image_location *image_location_436X;
  long v_435X;
  char * v_434X;
  long v_433X;
  struct image_location *val_432X;
  struct image_location *val_431X;
  struct image_location *image_location_430X;
  char * new_address_429X;
  struct image_location *v_428X;
  long v_427X;
  char * address_426X;
  struct image_location *val_425X;
  struct image_location *image_location_424X;
  char * new_address_423X;
  struct image_location *image_location_422X;
  char * new_address_421X;
  long size_in_cells_420X;
  struct image_location *v_419X;
  long v_418X;
  struct image_location *image_location_417X;
  char * new_address_416X;
  long size_in_bytes_415X;
  long size_in_cells_414X;
  long header_cell_413X;
  char * x1_412X;
  char * current_addr_411X;
  struct image_location *v_410X;
  long v_409X;
  char * current_addr_408X;
  long size_in_cells_407X;
  long cell_406X;
  char * x1_405X;
  char * current_addr_404X;
  struct image_location *image_location_403X;
  long v_402X;
  char * address_401X;
  char * addr_400X;
  long val_399X;
  long next_398X;
  long next_397X;
  struct image_location *image_location_396X;
  long v_395X;
  char * addr_394X;
  long val_393X;
  long link_392X;
  long entry_391X;
  char * address_390X;
  long cell_389X;
  long size_388X;
  char * address_387X;
  long i_386X;
  long next_385X;
  long next_384X;
  char * addr_383X;
  long value_382X;
  long cell_381X;
  long resumer_records_380X;
  long expr_379X;
  struct image_location **values_378X;
  long *keys_377X;
  struct table *table_376X;
  long link_375X;
  long entry_374X;
  long bucket_373X;
  long bucket_372X;
  long expr_371X;
  long v_370X;
  char * pointer_369X;
  long size_368X;
  long cell_367X;
  char * addr_366X;
  long tab_365X;
  char * addr_364X;
  long value_363X;
  long link_362X;
  long i_361X;
  long expr_360X;
  long v_359X;
  char * pointer_358X;
  long size_357X;
  long cell_356X;
  char * addr_355X;
  long tab_354X;
  long v_353X;
  long bucket_352X;
  long bucket_351X;
  struct table *stob_table_350X;
  long table_349X;
  long expr_348X;
  long v_347X;
  char * pointer_346X;
  long size_345X;
  long cell_344X;
  char * addr_343X;
  long tab_342X;
  long v_341X;
  long link_340X;
  long i_339X;
  long v_338X;
  char * pointer_337X;
  long size_336X;
  long cell_335X;
  char * addr_334X;
  long tab_333X;
  long v_332X;
  struct image_location *image_location_331X;
  long v_330X;
  long table_329X;
  long expr_328X;
  char * address_327X;
  long descriptor_326X;
  long expr_325X;
  long status_324X;
  char eofP_323X;
  long descriptor_322X;
  long expr_321X;
  long status_320X;
  long status_319X;
  long status_318X;
  char * v_317X;
  char * v_316X;
  long expr_315X;
  long status_314X;
  long status_313X;
  char eofP_312X;
  char ch_311X;
  long we_310X;
  long cells_309X;
  long descriptor_308X;
  long expr_307X;
  long status_306X;
  long status_305X;
  long status_304X;
  long status_303X;
  long status_302X;
  long status_301X;
  char eofP_300X;
  char v_299X;
  long expr_298X;
  long status_297X;
  char *string_296X;
  char okayP_295X;
  long expr_294X;
  long status_293X;
  char eofP_292X;
  long thing_291X;
  long status_290X;
  long wh_289X;
  long cells_288X;
  long descriptor_287X;
  long expr_286X;
  long status_285X;
  long expr_284X;
  long expr_283X;
  long expr_282X;
  long status_281X;
  char eofP_280X;
  long got_279X;
  long need_278X;
  struct table *v_277X;
  long status_276X;
  char eofP_275X;
  long thing_274X;
  long status_273X;
  long expr_272X;
  long status_271X;
  char eofP_270X;
  long thing_269X;
  long status_268X;
  long le_267X;
  long cells_266X;
  long status_265X;
  long status_264X;
  long status_263X;
  long expr_262X;
  long descriptor_261X;
  struct table *table_260X;
  long i_259X;
  long status_258X;
  char eofP_257X;
  long thing_256X;
  long status_255X;
  long expr_254X;
  long status_253X;
  char eofP_252X;
  long thing_251X;
  long status_250X;
  long lh_249X;
  long cells_248X;
  long status_247X;
  long status_246X;
  long status_245X;
  long status_244X;
  long status_243X;
  long status_242X;
  long status_241X;
  long *keys_240X;
  char * v_239X;
  long status_238X;
  char eofP_237X;
  long thing_236X;
  long status_235X;
  long expr_234X;
  long status_233X;
  char eofP_232X;
  long thing_231X;
  long status_230X;
  long se_229X;
  long cells_228X;
  long v_227X;
  long byte_a_226X;
  char * addr_b_225X;
  char * addr_a_224X;
  long j_223X;
  long i_222X;
  long status_221X;
  long status_220X;
  long status_219X;
  long status_218X;
  long status_217X;
  long status_216X;
  char eofP_215X;
  char v_214X;
  long expr_213X;
  long expr_212X;
  long expr_211X;
  char * weaks_new_hp_210X;
  long weaks_delta_209X;
  char * large_new_hp_208X;
  long large_delta_207X;
  char * small_new_hp_206X;
  long small_delta_205X;
  long v_204X;
  char reverse_byte_orderP_203X;
  long status_202X;
  char eofP_201X;
  long thing_200X;
  long status_199X;
  long expr_198X;
  long status_197X;
  char eofP_196X;
  long thing_195X;
  long status_194X;
  long sh_193X;
  long cells_192X;
  long cells_191X;
  long status_190X;
  long status_189X;
  char eofP_188X;
  long thing_187X;
  long status_186X;
  long status_185X;
  char eofP_184X;
  long thing_183X;
  long status_182X;
  long sb_181X;
  long cells_180X;
  long status_179X;
  char eofP_178X;
  long thing_177X;
  long status_176X;
  long cells_175X;
  long status_174X;
  char eofP_173X;
  long got_172X;
  char * new_addr_171X;
  long image_size_170X;
  long format_169X;
  long status_168X;
  long status_167X;
  long status_166X;
  long status_165X;
  long status_164X;
  long status_163X;
  char eofP_162X;
  long thing_161X;
  long status_160X;
  long status_159X;
  char eofP_158X;
  long thing_157X;
  long status_156X;
  long status_155X;
  long status_154X;
  long status_153X;
  long status_152X;
  long status_151X;
  long old_bytes_per_cell_150X;
  long status_149X;
  char eofP_148X;
  char thing_147X;
  long status_146X;
  char eofP_145X;
  long thing_144X;
  long status_143X;
  long format_142X;
  long status_141X;
  char eofP_140X;
  long status_139X;
  char eofP_138X;
  char ch_137X;
  long i_136X;
  long status_135X;
  char eofP_134X;
  long n_133X;
  long status_132X;
  char same_versionP_131X;
  long status_130X;
  char eofP_129X;
  long status_128X;
  char eofP_127X;
  char ch_126X;
  long status_125X;
  long status_124X;
  char eofP_123X;
  char ch_122X;
  long status_121X;
  long status_120X;
  long status_119X;
  FILE * port_118X;
 {  SstatusS = NO_ERRORS;
  SeofPS = 0;
  port_118X = ps_open_input_file(image_filename_94X, &status_119X);
  if ((status_119X == NO_ERRORS)) {
    status_120X = SstatusS;
    if ((status_120X == NO_ERRORS)) {
      if ((SeofPS)) {
        goto L7941;}
      else {
        goto L9464;}}
    else {
      goto L7941;}}
  else {
    ps_write_string("Can't open heap image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    ps_write_string((ps_error_string(status_119X)), (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    return -1;}}
 L7941: {
  status_121X = SstatusS;
  if ((status_121X == NO_ERRORS)) {
    if ((SeofPS)) {
      goto L7992;}
    else {
      goto L9384;}}
  else {
    goto L7992;}}
 L9464: {
  PS_READ_CHAR(port_118X, ch_122X, eofP_123X, status_124X)
  if (eofP_123X) {
    arg3K0 = eofP_123X;
    arg0K1 = status_124X;
    goto L7915;}
  else {
    if ((status_124X == NO_ERRORS)) {
      if ((12 == ch_122X)) {
        arg3K0 = 0;
        arg0K1 = status_124X;
        goto L7915;}
      else {
        goto L9464;}}
    else {
      arg3K0 = eofP_123X;
      arg0K1 = status_124X;
      goto L7915;}}}
 L7992: {
  status_125X = SstatusS;
  if ((status_125X == NO_ERRORS)) {
    if ((SeofPS)) {
      arg3K0 = 0;
      goto L8043;}
    else {
      arg0K0 = 0;
      goto L9318;}}
  else {
    arg3K0 = 0;
    goto L8043;}}
 L9384: {
  PS_READ_CHAR(port_118X, ch_126X, eofP_127X, status_128X)
  if (eofP_127X) {
    arg3K0 = eofP_127X;
    arg0K1 = status_128X;
    goto L7966;}
  else {
    if ((status_128X == NO_ERRORS)) {
      if ((10 == ch_126X)) {
        arg3K0 = 0;
        arg0K1 = status_128X;
        goto L7966;}
      else {
        goto L9384;}}
    else {
      arg3K0 = eofP_127X;
      arg0K1 = status_128X;
      goto L7966;}}}
 L7915: {
  eofP_129X = arg3K0;
  status_130X = arg0K1;
  if (eofP_129X) {
    SeofPS = 1;
    goto L7941;}
  else {
    if ((status_130X == NO_ERRORS)) {
      goto L7941;}
    else {
      SeofPS = 1;
      if (((SstatusS) == NO_ERRORS)) {
        SstatusS = status_130X;
        goto L7941;}
      else {
        goto L7941;}}}}
 L8043: {
  same_versionP_131X = arg3K0;
  status_132X = SstatusS;
  if ((status_132X == NO_ERRORS)) {
    if ((SeofPS)) {
      arg0K0 = -1;
      goto L8096;}
    else {
      PS_READ_INTEGER(port_118X, n_133X, eofP_134X, status_135X)
      if (eofP_134X) {
        SeofPS = 1;
        arg0K0 = -1;
        goto L8096;}
      else {
        if ((status_135X == NO_ERRORS)) {
          arg0K0 = n_133X;
          goto L8096;}
        else {
          SeofPS = 1;
          if (((SstatusS) == NO_ERRORS)) {
            SstatusS = status_135X;
            arg0K0 = -1;
            goto L8096;}
          else {
            arg0K0 = -1;
            goto L8096;}}}}}
  else {
    arg0K0 = -1;
    goto L8096;}}
 L9318: {
  i_136X = arg0K0;
  PS_READ_CHAR(port_118X, ch_137X, eofP_138X, status_139X)
  if (eofP_138X) {
    arg3K0 = 0;
    arg3K1 = eofP_138X;
    arg0K2 = status_139X;
    goto L8017;}
  else {
    if ((status_139X == NO_ERRORS)) {
      if ((i_136X == (strlen((char *) "Vanilla 34")))) {
        arg3K0 = (10 == ch_137X);
        arg3K1 = 0;
        arg0K2 = status_139X;
        goto L8017;}
      else {
        if ((ch_137X == (*("Vanilla 34" + i_136X)))) {
          arg0K0 = (1 + i_136X);
          goto L9318;}
        else {
          arg3K0 = 0;
          arg3K1 = 0;
          arg0K2 = status_139X;
          goto L8017;}}}
    else {
      arg3K0 = 0;
      arg3K1 = eofP_138X;
      arg0K2 = status_139X;
      goto L8017;}}}
 L7966: {
  eofP_140X = arg3K0;
  status_141X = arg0K1;
  if (eofP_140X) {
    SeofPS = 1;
    goto L7992;}
  else {
    if ((status_141X == NO_ERRORS)) {
      goto L7992;}
    else {
      SeofPS = 1;
      if (((SstatusS) == NO_ERRORS)) {
        SstatusS = status_141X;
        goto L7992;}
      else {
        goto L7992;}}}}
 L8096: {
  format_142X = arg0K0;
  status_143X = SstatusS;
  if ((status_143X == NO_ERRORS)) {
    if ((SeofPS)) {
      arg0K0 = -1;
      goto L8149;}
    else {
      PS_READ_INTEGER(port_118X, thing_144X, eofP_145X, status_146X)
      if (eofP_145X) {
        SeofPS = 1;
        arg0K0 = -1;
        goto L8149;}
      else {
        if ((status_146X == NO_ERRORS)) {
          arg0K0 = thing_144X;
          goto L8149;}
        else {
          SeofPS = 1;
          if (((SstatusS) == NO_ERRORS)) {
            SstatusS = status_146X;
            arg0K0 = -1;
            goto L8149;}
          else {
            arg0K0 = -1;
            goto L8149;}}}}}
  else {
    arg0K0 = -1;
    goto L8149;}}
 L8017: {
  thing_147X = arg3K0;
  eofP_148X = arg3K1;
  status_149X = arg0K2;
  if (eofP_148X) {
    SeofPS = 1;
    arg3K0 = 0;
    goto L8043;}
  else {
    if ((status_149X == NO_ERRORS)) {
      arg3K0 = thing_147X;
      goto L8043;}
    else {
      SeofPS = 1;
      if (((SstatusS) == NO_ERRORS)) {
        SstatusS = status_149X;
        arg3K0 = 0;
        goto L8043;}
      else {
        arg3K0 = 0;
        goto L8043;}}}}
 L8149: {
  old_bytes_per_cell_150X = arg0K0;
  if (((SstatusS) == NO_ERRORS)) {
    if ((SeofPS)) {
      SstatusS = EDOM;
      ps_write_string("Premature EOF when reading image file", (stderr));
      { long ignoreXX;
      PS_WRITE_CHAR(10, (stderr), ignoreXX) }
      status_151X = SstatusS;
      if ((status_151X == NO_ERRORS)) {
        goto L8597;}
      else {
        ps_write_string((ps_error_string((SstatusS))), (stderr));
        { long ignoreXX;
        PS_WRITE_CHAR(10, (stderr), ignoreXX) }
        goto L8597;}}
    else {
      if (same_versionP_131X) {
        if ((0 == format_142X)) {
          goto L8661;}
        else {
          if ((1 == format_142X)) {
            goto L8661;}
          else {
            ps_write_string("Unknown image format", (stderr));
            { long ignoreXX;
            PS_WRITE_CHAR(10, (stderr), ignoreXX) }
            status_152X = SstatusS;
            if ((status_152X == NO_ERRORS)) {
              goto L8672;}
            else {
              ps_write_string((ps_error_string((SstatusS))), (stderr));
              { long ignoreXX;
              PS_WRITE_CHAR(10, (stderr), ignoreXX) }
              goto L8672;}}}}
      else {
        ps_write_string("Format of image is incompatible with this version of system", (stderr));
        { long ignoreXX;
        PS_WRITE_CHAR(10, (stderr), ignoreXX) }
        status_153X = SstatusS;
        if ((status_153X == NO_ERRORS)) {
          goto L8631;}
        else {
          ps_write_string((ps_error_string((SstatusS))), (stderr));
          { long ignoreXX;
          PS_WRITE_CHAR(10, (stderr), ignoreXX) }
          goto L8631;}}}}
  else {
    ps_write_string("Error reading from image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    status_154X = SstatusS;
    if ((status_154X == NO_ERRORS)) {
      goto L8562;}
    else {
      ps_write_string((ps_error_string((SstatusS))), (stderr));
      { long ignoreXX;
      PS_WRITE_CHAR(10, (stderr), ignoreXX) }
      goto L8562;}}}
 L8597: {
  status_155X = ps_close(port_118X);
  if ((status_155X == NO_ERRORS)) {
    arg0K0 = -1;
    arg0K1 = format_142X;
    goto L15092;}
  else {
    ps_write_string("Error closing image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    arg0K0 = -1;
    arg0K1 = format_142X;
    goto L15092;}}
 L8661: {
  if ((4 == old_bytes_per_cell_150X)) {
    if ((0 == format_142X)) {
      status_156X = SstatusS;
      if ((status_156X == NO_ERRORS)) {
        if ((SeofPS)) {
          arg0K0 = -1;
          goto L5743;}
        else {
          PS_READ_INTEGER(port_118X, thing_157X, eofP_158X, status_159X)
          if (eofP_158X) {
            SeofPS = 1;
            arg0K0 = -1;
            goto L5743;}
          else {
            if ((status_159X == NO_ERRORS)) {
              arg0K0 = thing_157X;
              goto L5743;}
            else {
              SeofPS = 1;
              if (((SstatusS) == NO_ERRORS)) {
                SstatusS = status_159X;
                arg0K0 = -1;
                goto L5743;}
              else {
                arg0K0 = -1;
                goto L5743;}}}}}
      else {
        arg0K0 = -1;
        goto L5743;}}
    else {
      if ((1 == format_142X)) {
        status_160X = SstatusS;
        if ((status_160X == NO_ERRORS)) {
          if ((SeofPS)) {
            arg0K0 = -1;
            goto L5861;}
          else {
            PS_READ_INTEGER(port_118X, thing_161X, eofP_162X, status_163X)
            if (eofP_162X) {
              SeofPS = 1;
              arg0K0 = -1;
              goto L5861;}
            else {
              if ((status_163X == NO_ERRORS)) {
                arg0K0 = thing_161X;
                goto L5861;}
              else {
                SeofPS = 1;
                if (((SstatusS) == NO_ERRORS)) {
                  SstatusS = status_163X;
                  arg0K0 = -1;
                  goto L5861;}
                else {
                  arg0K0 = -1;
                  goto L5861;}}}}}
        else {
          arg0K0 = -1;
          goto L5861;}}
      else {
        ps_error("check-all-data!: Unknown image format (this can't happen)", 0);
        goto L8191;}}}
  else {
    ps_write_string("Incompatible bytes-per-cell in image", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    status_164X = SstatusS;
    if ((status_164X == NO_ERRORS)) {
      goto L8706;}
    else {
      ps_write_string((ps_error_string((SstatusS))), (stderr));
      { long ignoreXX;
      PS_WRITE_CHAR(10, (stderr), ignoreXX) }
      goto L8706;}}}
 L8672: {
  status_165X = ps_close(port_118X);
  if ((status_165X == NO_ERRORS)) {
    arg0K0 = -1;
    arg0K1 = format_142X;
    goto L15092;}
  else {
    ps_write_string("Error closing image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    arg0K0 = -1;
    arg0K1 = format_142X;
    goto L15092;}}
 L8631: {
  status_166X = ps_close(port_118X);
  if ((status_166X == NO_ERRORS)) {
    arg0K0 = -1;
    arg0K1 = format_142X;
    goto L15092;}
  else {
    ps_write_string("Error closing image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    arg0K0 = -1;
    arg0K1 = format_142X;
    goto L15092;}}
 L8562: {
  status_167X = ps_close(port_118X);
  if ((status_167X == NO_ERRORS)) {
    arg0K0 = -1;
    arg0K1 = format_142X;
    goto L15092;}
  else {
    ps_write_string("Error closing image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    arg0K0 = -1;
    arg0K1 = format_142X;
    goto L15092;}}
 L15092: {
  status_168X = arg0K0;
  format_169X = arg0K1;
  if ((0 == status_168X)) {
    if (((SstatusS) == NO_ERRORS)) {
      image_size_170X = Simg_heap_sizeS;
      Smax_heap_sizeS = max_heap_size_95X;
      Smin_heap_sizeS = (((image_size_170X)<<2));s48_initialize_bibop_heap();
      Spure_areasS = ((char **)malloc(sizeof(char *) * 0));
      Simpure_areasS = (Spure_areasS);
      Spure_sizesS = ((long*)malloc(sizeof(long) * 0));
      Simpure_sizesS = (Spure_sizesS);s48_initialize_image_areas(((Ssmall_img_end_addrS) - (Ssmall_img_start_addrS)), ((Ssmall_img_hp_addrS) - (Ssmall_img_start_addrS)), ((Slarge_img_end_addrS) - (Slarge_img_start_addrS)), ((Slarge_img_hp_addrS) - (Slarge_img_start_addrS)), ((Sweaks_img_end_addrS) - (Sweaks_img_start_addrS)), ((Sweaks_img_hp_addrS) - (Sweaks_img_start_addrS)));s48_check_heap_sizeB();
      if (((SstatusS) == NO_ERRORS)) {
        new_addr_171X = (char *)malloc(4);
        got_172X = ps_read_block(port_118X, ((char *) new_addr_171X), 4, &eofP_173X, &status_174X);
        if ((status_174X == NO_ERRORS)) {
          if (eofP_173X) {
            goto L5566;}
          else {
            if ((got_172X < 4)) {
              goto L5566;}
            else {
              goto L5518;}}}
        else {
          SstatusS = status_174X;
          goto L5566;}}
      else {
        return -1;}}
    else {
      return -1;}}
  else {
    return -1;}}
 L5743: {
  cells_175X = arg0K0;
  Simg_start_addrS = (((char *) (((cells_175X)<<2))));
  status_176X = SstatusS;
  if ((status_176X == NO_ERRORS)) {
    if ((SeofPS)) {
      arg0K0 = -1;
      goto L5798;}
    else {
      PS_READ_INTEGER(port_118X, thing_177X, eofP_178X, status_179X)
      if (eofP_178X) {
        SeofPS = 1;
        arg0K0 = -1;
        goto L5798;}
      else {
        if ((status_179X == NO_ERRORS)) {
          arg0K0 = thing_177X;
          goto L5798;}
        else {
          SeofPS = 1;
          if (((SstatusS) == NO_ERRORS)) {
            SstatusS = status_179X;
            arg0K0 = -1;
            goto L5798;}
          else {
            arg0K0 = -1;
            goto L5798;}}}}}
  else {
    arg0K0 = -1;
    goto L5798;}}
 L5861: {
  cells_180X = arg0K0;
  sb_181X = ((cells_180X)<<2);
  status_182X = SstatusS;
  if ((status_182X == NO_ERRORS)) {
    if ((SeofPS)) {
      arg0K0 = -1;
      goto L5916;}
    else {
      PS_READ_INTEGER(port_118X, thing_183X, eofP_184X, status_185X)
      if (eofP_184X) {
        SeofPS = 1;
        arg0K0 = -1;
        goto L5916;}
      else {
        if ((status_185X == NO_ERRORS)) {
          arg0K0 = thing_183X;
          goto L5916;}
        else {
          SeofPS = 1;
          if (((SstatusS) == NO_ERRORS)) {
            SstatusS = status_185X;
            arg0K0 = -1;
            goto L5916;}
          else {
            arg0K0 = -1;
            goto L5916;}}}}}
  else {
    arg0K0 = -1;
    goto L5916;}}
 L8191: {
  status_186X = SstatusS;
  if ((status_186X == NO_ERRORS)) {
    if ((SeofPS)) {
      arg0K0 = -1;
      goto L8242;}
    else {
      PS_READ_INTEGER(port_118X, thing_187X, eofP_188X, status_189X)
      if (eofP_188X) {
        SeofPS = 1;
        arg0K0 = -1;
        goto L8242;}
      else {
        if ((status_189X == NO_ERRORS)) {
          arg0K0 = thing_187X;
          goto L8242;}
        else {
          SeofPS = 1;
          if (((SstatusS) == NO_ERRORS)) {
            SstatusS = status_189X;
            arg0K0 = -1;
            goto L8242;}
          else {
            arg0K0 = -1;
            goto L8242;}}}}}
  else {
    arg0K0 = -1;
    goto L8242;}}
 L8706: {
  status_190X = ps_close(port_118X);
  if ((status_190X == NO_ERRORS)) {
    arg0K0 = -1;
    arg0K1 = format_142X;
    goto L15092;}
  else {
    ps_write_string("Error closing image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    arg0K0 = -1;
    arg0K1 = format_142X;
    goto L15092;}}
 L5566: {
  ps_error("byte order check failed", 0);
  goto L5518;}
 L5518: {
  if ((1 == (*((long *) new_addr_171X)))) {
    free(new_addr_171X);
    arg3K0 = 0;
    goto L15155;}
  else {
    arg0K0 = 0;
    arg0K1 = 3;
    goto L5579;}}
 L5798: {
  cells_191X = arg0K0;
  Simg_end_addrS = (((char *) (((cells_191X)<<2))));
  Simg_heap_sizeS = ((((3 + ((Simg_end_addrS) - (Simg_start_addrS))))>>2));
  goto L8191;}
 L5916: {
  cells_192X = arg0K0;
  sh_193X = ((cells_192X)<<2);
  status_194X = SstatusS;
  if ((status_194X == NO_ERRORS)) {
    if ((SeofPS)) {
      arg0K0 = -1;
      goto L5971;}
    else {
      PS_READ_INTEGER(port_118X, thing_195X, eofP_196X, status_197X)
      if (eofP_196X) {
        SeofPS = 1;
        arg0K0 = -1;
        goto L5971;}
      else {
        if ((status_197X == NO_ERRORS)) {
          arg0K0 = thing_195X;
          goto L5971;}
        else {
          SeofPS = 1;
          if (((SstatusS) == NO_ERRORS)) {
            SstatusS = status_197X;
            arg0K0 = -1;
            goto L5971;}
          else {
            arg0K0 = -1;
            goto L5971;}}}}}
  else {
    arg0K0 = -1;
    goto L5971;}}
 L8242: {
  expr_198X = arg0K0;
  SsymbolsS = expr_198X;
  status_199X = SstatusS;
  if ((status_199X == NO_ERRORS)) {
    if ((SeofPS)) {
      arg0K0 = -1;
      goto L8295;}
    else {
      PS_READ_INTEGER(port_118X, thing_200X, eofP_201X, status_202X)
      if (eofP_201X) {
        SeofPS = 1;
        arg0K0 = -1;
        goto L8295;}
      else {
        if ((status_202X == NO_ERRORS)) {
          arg0K0 = thing_200X;
          goto L8295;}
        else {
          SeofPS = 1;
          if (((SstatusS) == NO_ERRORS)) {
            SstatusS = status_202X;
            arg0K0 = -1;
            goto L8295;}
          else {
            arg0K0 = -1;
            goto L8295;}}}}}
  else {
    arg0K0 = -1;
    goto L8295;}}
 L15155: {
  reverse_byte_orderP_203X = arg3K0;
  if ((0 == format_169X)) {
    Sheap_image_pointerS = NULL;
    Ssymbol_addressS = NULL;
    v_204X = SsymbolsS;
    if ((1 == v_204X)) {
      arg1K0 = (Simg_end_addrS);
      goto L7677;}
    else {
      arg1K0 = ((((char *) (-3 + (SsymbolsS)))) + -4);
      goto L7677;}}
  else {
    if ((1 == format_169X)) {
      small_delta_205X = (Snew_small_start_addrS) - (Ssmall_img_start_addrS);
      small_new_hp_206X = (Ssmall_img_hp_addrS) + small_delta_205X;
      large_delta_207X = (Snew_large_start_addrS) - (Slarge_img_start_addrS);
      large_new_hp_208X = (Slarge_img_hp_addrS) + large_delta_207X;
      weaks_delta_209X = (Snew_weaks_start_addrS) - (Sweaks_img_start_addrS);
      weaks_new_hp_210X = (Sweaks_img_hp_addrS) + weaks_delta_209X;
      merged_arg1K0 = (Snew_weaks_start_addrS);
      merged_arg0K1 = (Sweaks_img_heap_sizeS);
      merged_arg6K2 = port_118X;
      read_image_area_return_tag = 0;
      goto read_image_area;
     read_image_area_return_0:
      expr_211X = read_image_area0_return_value;
      if ((0 == expr_211X)) {
        if (((SstatusS) == NO_ERRORS)) {
          merged_arg1K0 = (Snew_large_start_addrS);
          merged_arg0K1 = (Slarge_img_heap_sizeS);
          merged_arg6K2 = port_118X;
          read_image_area_return_tag = 1;
          goto read_image_area;
         read_image_area_return_1:
          expr_212X = read_image_area0_return_value;
          if ((0 == expr_212X)) {
            if (((SstatusS) == NO_ERRORS)) {
              merged_arg1K0 = (Snew_small_start_addrS);
              merged_arg0K1 = (Ssmall_img_heap_sizeS);
              merged_arg6K2 = port_118X;
              read_image_area_return_tag = 2;
              goto read_image_area;
             read_image_area_return_2:
              expr_213X = read_image_area0_return_value;
              if ((0 == expr_213X)) {
                if (((SstatusS) == NO_ERRORS)) {
                  PS_READ_CHAR(port_118X, v_214X, eofP_215X, status_216X)
                  if ((status_216X == NO_ERRORS)) {
                    if (eofP_215X) {
                      status_217X = ps_close(port_118X);
                      if ((status_217X == NO_ERRORS)) {
                        if (reverse_byte_orderP_203X) {
                          merged_arg1K0 = (Snew_small_start_addrS);
                          merged_arg1K1 = small_new_hp_206X;
                          reverse_byte_orderB_return_tag = 0;
                          goto reverse_byte_orderB;
                         reverse_byte_orderB_return_0:
                          merged_arg1K0 = (Snew_large_start_addrS);
                          merged_arg1K1 = large_new_hp_208X;
                          reverse_byte_orderB_return_tag = 1;
                          goto reverse_byte_orderB;
                         reverse_byte_orderB_return_1:
                          merged_arg1K0 = (Snew_weaks_start_addrS);
                          merged_arg1K1 = weaks_new_hp_210X;
                          reverse_byte_orderB_return_tag = 2;
                          goto reverse_byte_orderB;
                         reverse_byte_orderB_return_2:
                          goto L13871;}
                        else {
                          goto L13871;}}
                      else {
                        ps_write_string("Error closing image file", (stderr));
                        { long ignoreXX;
                        PS_WRITE_CHAR(10, (stderr), ignoreXX) }
                        status_218X = SstatusS;
                        if ((status_218X == NO_ERRORS)) {
                          goto L14180;}
                        else {
                          ps_write_string((ps_error_string((SstatusS))), (stderr));
                          { long ignoreXX;
                          PS_WRITE_CHAR(10, (stderr), ignoreXX) }
                          goto L14180;}}}
                    else {
                      ps_write_string("Image file has extraneous data after image", (stderr));
                      { long ignoreXX;
                      PS_WRITE_CHAR(10, (stderr), ignoreXX) }
                      status_219X = SstatusS;
                      if ((status_219X == NO_ERRORS)) {
                        goto L14148;}
                      else {
                        ps_write_string((ps_error_string((SstatusS))), (stderr));
                        { long ignoreXX;
                        PS_WRITE_CHAR(10, (stderr), ignoreXX) }
                        goto L14148;}}}
                  else {
                    ps_write_string("Error reading from image file", (stderr));
                    { long ignoreXX;
                    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
                    status_220X = SstatusS;
                    if ((status_220X == NO_ERRORS)) {
                      goto L14116;}
                    else {
                      ps_write_string((ps_error_string((SstatusS))), (stderr));
                      { long ignoreXX;
                      PS_WRITE_CHAR(10, (stderr), ignoreXX) }
                      goto L14116;}}}
                else {
                  goto L13830;}}
              else {
                goto L13830;}}
            else {
              goto L13824;}}
          else {
            goto L13824;}}
        else {
          goto L13818;}}
      else {
        goto L13818;}}
    else {
      ps_write_string("invalid image format", (stderr));
      { long ignoreXX;
      PS_WRITE_CHAR(10, (stderr), ignoreXX) }
      status_221X = SstatusS;
      if ((status_221X == NO_ERRORS)) {
        goto L15042;}
      else {
        ps_write_string((ps_error_string((SstatusS))), (stderr));
        { long ignoreXX;
        PS_WRITE_CHAR(10, (stderr), ignoreXX) }
        goto L15042;}}}}
 L5579: {
  i_222X = arg0K0;
  j_223X = arg0K1;
  if ((i_222X < j_223X)) {
    addr_a_224X = new_addr_171X + i_222X;
    addr_b_225X = new_addr_171X + j_223X;
    byte_a_226X = *((unsigned char *) addr_a_224X);
    *((unsigned char *) addr_a_224X) = (unsigned char) ((*((unsigned char *) addr_b_225X)));
    *((unsigned char *) addr_b_225X) = (unsigned char) (byte_a_226X);
    arg0K0 = (1 + i_222X);
    arg0K1 = (-1 + j_223X);
    goto L5579;}
  else {
    v_227X = *((long *) new_addr_171X);
    if ((1 == v_227X)) {
      goto L5538;}
    else {
      ps_error("Unable to correct byte order", 0);
      goto L5538;}}}
 L5971: {
  cells_228X = arg0K0;
  se_229X = ((cells_228X)<<2);
  status_230X = SstatusS;
  if ((status_230X == NO_ERRORS)) {
    if ((SeofPS)) {
      arg0K0 = -1;
      goto L6028;}
    else {
      PS_READ_INTEGER(port_118X, thing_231X, eofP_232X, status_233X)
      if (eofP_232X) {
        SeofPS = 1;
        arg0K0 = -1;
        goto L6028;}
      else {
        if ((status_233X == NO_ERRORS)) {
          arg0K0 = thing_231X;
          goto L6028;}
        else {
          SeofPS = 1;
          if (((SstatusS) == NO_ERRORS)) {
            SstatusS = status_233X;
            arg0K0 = -1;
            goto L6028;}
          else {
            arg0K0 = -1;
            goto L6028;}}}}}
  else {
    arg0K0 = -1;
    goto L6028;}}
 L8295: {
  expr_234X = arg0K0;
  Simported_bindingsS = expr_234X;
  status_235X = SstatusS;
  if ((status_235X == NO_ERRORS)) {
    if ((SeofPS)) {
      arg0K0 = -1;
      goto L8348;}
    else {
      PS_READ_INTEGER(port_118X, thing_236X, eofP_237X, status_238X)
      if (eofP_237X) {
        SeofPS = 1;
        arg0K0 = -1;
        goto L8348;}
      else {
        if ((status_238X == NO_ERRORS)) {
          arg0K0 = thing_236X;
          goto L8348;}
        else {
          SeofPS = 1;
          if (((SstatusS) == NO_ERRORS)) {
            SstatusS = status_238X;
            arg0K0 = -1;
            goto L8348;}
          else {
            arg0K0 = -1;
            goto L8348;}}}}}
  else {
    arg0K0 = -1;
    goto L8348;}}
 L7677: {
  v_239X = arg1K0;
  Ssymbol_addressS = v_239X;
  Sheap_object_remaining_cellsS = 0;
  Sheap_object_pointerS = NULL;
  keys_240X = (long*)malloc(sizeof(long) * 4097);
  arg0K0 = 0;
  goto L7700;}
 L13871: {
  if ((small_delta_205X == large_delta_207X)) {
    if ((large_delta_207X == weaks_delta_209X)) {
      goto L13887;}
    else {
      goto L14200;}}
  else {
    goto L14200;}}
 L14180: {
  status_241X = ps_close(port_118X);
  if ((status_241X == NO_ERRORS)) {
    arg0K0 = -1;
    goto L15157;}
  else {
    ps_write_string("Error closing image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    arg0K0 = -1;
    goto L15157;}}
 L14148: {
  status_242X = ps_close(port_118X);
  if ((status_242X == NO_ERRORS)) {
    arg0K0 = -1;
    goto L15157;}
  else {
    ps_write_string("Error closing image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    arg0K0 = -1;
    goto L15157;}}
 L14116: {
  status_243X = ps_close(port_118X);
  if ((status_243X == NO_ERRORS)) {
    arg0K0 = -1;
    goto L15157;}
  else {
    ps_write_string("Error closing image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    arg0K0 = -1;
    goto L15157;}}
 L13830: {
  ps_write_string("error reading small area from image", (stderr));
  { long ignoreXX;
  PS_WRITE_CHAR(10, (stderr), ignoreXX) }
  status_244X = SstatusS;
  if ((status_244X == NO_ERRORS)) {
    goto L14084;}
  else {
    ps_write_string((ps_error_string((SstatusS))), (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    goto L14084;}}
 L13824: {
  ps_write_string("error reading large area from image", (stderr));
  { long ignoreXX;
  PS_WRITE_CHAR(10, (stderr), ignoreXX) }
  status_245X = SstatusS;
  if ((status_245X == NO_ERRORS)) {
    goto L14045;}
  else {
    ps_write_string((ps_error_string((SstatusS))), (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    goto L14045;}}
 L13818: {
  ps_write_string("error reading weaks area from image", (stderr));
  { long ignoreXX;
  PS_WRITE_CHAR(10, (stderr), ignoreXX) }
  status_246X = SstatusS;
  if ((status_246X == NO_ERRORS)) {
    goto L14006;}
  else {
    ps_write_string((ps_error_string((SstatusS))), (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    goto L14006;}}
 L15042: {
  status_247X = ps_close(port_118X);
  if ((status_247X == NO_ERRORS)) {
    arg0K0 = -1;
    goto L15157;}
  else {
    ps_write_string("Error closing image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    arg0K0 = -1;
    goto L15157;}}
 L5538: {
  free(new_addr_171X);
  arg3K0 = 1;
  goto L15155;}
 L6028: {
  cells_248X = arg0K0;
  lh_249X = ((cells_248X)<<2);
  status_250X = SstatusS;
  if ((status_250X == NO_ERRORS)) {
    if ((SeofPS)) {
      arg0K0 = -1;
      goto L6083;}
    else {
      PS_READ_INTEGER(port_118X, thing_251X, eofP_252X, status_253X)
      if (eofP_252X) {
        SeofPS = 1;
        arg0K0 = -1;
        goto L6083;}
      else {
        if ((status_253X == NO_ERRORS)) {
          arg0K0 = thing_251X;
          goto L6083;}
        else {
          SeofPS = 1;
          if (((SstatusS) == NO_ERRORS)) {
            SstatusS = status_253X;
            arg0K0 = -1;
            goto L6083;}
          else {
            arg0K0 = -1;
            goto L6083;}}}}}
  else {
    arg0K0 = -1;
    goto L6083;}}
 L8348: {
  expr_254X = arg0K0;
  Sexported_bindingsS = expr_254X;
  status_255X = SstatusS;
  if ((status_255X == NO_ERRORS)) {
    if ((SeofPS)) {
      arg0K0 = -1;
      goto L8401;}
    else {
      PS_READ_INTEGER(port_118X, thing_256X, eofP_257X, status_258X)
      if (eofP_257X) {
        SeofPS = 1;
        arg0K0 = -1;
        goto L8401;}
      else {
        if ((status_258X == NO_ERRORS)) {
          arg0K0 = thing_256X;
          goto L8401;}
        else {
          SeofPS = 1;
          if (((SstatusS) == NO_ERRORS)) {
            SstatusS = status_258X;
            arg0K0 = -1;
            goto L8401;}
          else {
            arg0K0 = -1;
            goto L8401;}}}}}
  else {
    arg0K0 = -1;
    goto L8401;}}
 L7700: {
  i_259X = arg0K0;
  if ((i_259X < 4097)) {
    *(keys_240X + i_259X) = 0;
    arg0K0 = (1 + i_259X);
    goto L7700;}
  else {
    table_260X = (struct table*)malloc(sizeof(struct table));
    if ((NULL == table_260X)) {
      arg5K0 = table_260X;
      goto L7688;}
    else {
      table_260X->keys = keys_240X;
      table_260X->values = ((struct image_location**)malloc(sizeof(struct image_location*) * 4096));
      table_260X->count = 0;
      table_260X->size = 4096;
      arg5K0 = table_260X;
      goto L7688;}}}
 L13887: {
  if ((0 == small_delta_205X)) {
    goto L13941;}
  else {
    descriptor_261X = Sstartup_procedureS;
    if ((3 == (3 & descriptor_261X))) {
      arg0K0 = (3 + (((long) ((((char *) (-3 + descriptor_261X))) + small_delta_205X))));
      goto L13896;}
    else {
      arg0K0 = descriptor_261X;
      goto L13896;}}}
 L14200: {
  ps_error("Bug: Cannot load image, because the deltas of all parts aren't equal. Notify the authors.", 0);
  goto L13887;}
 L15157: {
  expr_262X = arg0K0;
  if ((0 == expr_262X)) {
    if (((SstatusS) == NO_ERRORS)) {
      return 0;}
    else {
      return -1;}}
  else {
    return -1;}}
 L14084: {
  status_263X = ps_close(port_118X);
  if ((status_263X == NO_ERRORS)) {
    arg0K0 = -1;
    goto L15157;}
  else {
    ps_write_string("Error closing image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    arg0K0 = -1;
    goto L15157;}}
 L14045: {
  status_264X = ps_close(port_118X);
  if ((status_264X == NO_ERRORS)) {
    arg0K0 = -1;
    goto L15157;}
  else {
    ps_write_string("Error closing image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    arg0K0 = -1;
    goto L15157;}}
 L14006: {
  status_265X = ps_close(port_118X);
  if ((status_265X == NO_ERRORS)) {
    arg0K0 = -1;
    goto L15157;}
  else {
    ps_write_string("Error closing image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    arg0K0 = -1;
    goto L15157;}}
 L6083: {
  cells_266X = arg0K0;
  le_267X = ((cells_266X)<<2);
  status_268X = SstatusS;
  if ((status_268X == NO_ERRORS)) {
    if ((SeofPS)) {
      arg0K0 = -1;
      goto L6140;}
    else {
      PS_READ_INTEGER(port_118X, thing_269X, eofP_270X, status_271X)
      if (eofP_270X) {
        SeofPS = 1;
        arg0K0 = -1;
        goto L6140;}
      else {
        if ((status_271X == NO_ERRORS)) {
          arg0K0 = thing_269X;
          goto L6140;}
        else {
          SeofPS = 1;
          if (((SstatusS) == NO_ERRORS)) {
            SstatusS = status_271X;
            arg0K0 = -1;
            goto L6140;}
          else {
            arg0K0 = -1;
            goto L6140;}}}}}
  else {
    arg0K0 = -1;
    goto L6140;}}
 L8401: {
  expr_272X = arg0K0;
  Sresumer_recordsS = expr_272X;
  status_273X = SstatusS;
  if ((status_273X == NO_ERRORS)) {
    if ((SeofPS)) {
      arg0K0 = -1;
      goto L8454;}
    else {
      PS_READ_INTEGER(port_118X, thing_274X, eofP_275X, status_276X)
      if (eofP_275X) {
        SeofPS = 1;
        arg0K0 = -1;
        goto L8454;}
      else {
        if ((status_276X == NO_ERRORS)) {
          arg0K0 = thing_274X;
          goto L8454;}
        else {
          SeofPS = 1;
          if (((SstatusS) == NO_ERRORS)) {
            SstatusS = status_276X;
            arg0K0 = -1;
            goto L8454;}
          else {
            arg0K0 = -1;
            goto L8454;}}}}}
  else {
    arg0K0 = -1;
    goto L8454;}}
 L7688: {
  v_277X = arg5K0;
  Sstob_tableS = v_277X;
  Sheap_image_pointerS = ((char *)malloc(((((Simg_heap_sizeS))<<2))));
  if ((0 == format_169X)) {
    need_278X = (((Simg_heap_sizeS))<<2);
    got_279X = ps_read_block(port_118X, ((char *) (Sheap_image_pointerS)), need_278X, &eofP_280X, &status_281X);
    if ((status_281X == NO_ERRORS)) {
      if (eofP_280X) {
        arg3K0 = 0;
        arg4K1 = "Premature EOF when reading image file";
        goto L9851;}
      else {
        if ((got_279X < need_278X)) {
          arg3K0 = 0;
          arg4K1 = "Read returned too few bytes";
          goto L9851;}
        else {
          arg3K0 = 1;
          arg4K1 = "";
          goto L9851;}}}
    else {
      SstatusS = status_281X;
      arg3K0 = 0;
      arg4K1 = "Error reading from image file";
      goto L9851;}}
  else {
    if ((1 == format_169X)) {
      merged_arg1K0 = (Snew_weaks_start_addrS);
      merged_arg0K1 = (Sweaks_img_heap_sizeS);
      merged_arg6K2 = port_118X;
      really_read_image_area_return_tag = 0;
      goto really_read_image_area;
     really_read_image_area_return_0:
      expr_282X = really_read_image_area0_return_value;
      if ((0 == expr_282X)) {
        if (((SstatusS) == NO_ERRORS)) {
          merged_arg1K0 = (Snew_large_start_addrS);
          merged_arg0K1 = (Slarge_img_heap_sizeS);
          merged_arg6K2 = port_118X;
          really_read_image_area_return_tag = 1;
          goto really_read_image_area;
         really_read_image_area_return_1:
          expr_283X = really_read_image_area0_return_value;
          if ((0 == expr_283X)) {
            if (((SstatusS) == NO_ERRORS)) {
              merged_arg1K0 = (Snew_small_start_addrS);
              merged_arg0K1 = (Ssmall_img_heap_sizeS);
              merged_arg6K2 = port_118X;
              really_read_image_area_return_tag = 2;
              goto really_read_image_area;
             really_read_image_area_return_2:
              expr_284X = really_read_image_area0_return_value;
              if ((0 == expr_284X)) {
                if (((SstatusS) == NO_ERRORS)) {
                  arg0K0 = 0;
                  goto L9884;}
                else {
                  arg0K0 = -1;
                  goto L9884;}}
              else {
                arg0K0 = -1;
                goto L9884;}}
            else {
              arg0K0 = -1;
              goto L9884;}}
          else {
            arg0K0 = -1;
            goto L9884;}}
        else {
          arg0K0 = -1;
          goto L9884;}}
      else {
        arg0K0 = -1;
        goto L9884;}}
    else {
      ps_write_string("this can't happen: invalid image format", (stderr));
      { long ignoreXX;
      PS_WRITE_CHAR(10, (stderr), ignoreXX) }
      status_285X = SstatusS;
      if ((status_285X == NO_ERRORS)) {
        goto L10254;}
      else {
        ps_write_string((ps_error_string((SstatusS))), (stderr));
        { long ignoreXX;
        PS_WRITE_CHAR(10, (stderr), ignoreXX) }
        goto L10254;}}}}
 L13941: {
  if ((0 == large_delta_207X)) {
    goto L13953;}
  else {
    merged_arg0K0 = large_delta_207X;
    merged_arg1K1 = (Snew_large_start_addrS);
    merged_arg1K2 = large_new_hp_208X;
    relocate_image_return_tag = 0;
    goto relocate_image;
   relocate_image_return_0:
    goto L13953;}}
 L13896: {
  expr_286X = arg0K0;
  Sstartup_procedureS = expr_286X;
  descriptor_287X = SsymbolsS;
  if ((3 == (3 & descriptor_287X))) {
    arg0K0 = (3 + (((long) ((((char *) (-3 + descriptor_287X))) + small_delta_205X))));
    goto L13902;}
  else {
    arg0K0 = descriptor_287X;
    goto L13902;}}
 L6140: {
  cells_288X = arg0K0;
  wh_289X = ((cells_288X)<<2);
  status_290X = SstatusS;
  if ((status_290X == NO_ERRORS)) {
    if ((SeofPS)) {
      arg0K0 = -1;
      goto L6195;}
    else {
      PS_READ_INTEGER(port_118X, thing_291X, eofP_292X, status_293X)
      if (eofP_292X) {
        SeofPS = 1;
        arg0K0 = -1;
        goto L6195;}
      else {
        if ((status_293X == NO_ERRORS)) {
          arg0K0 = thing_291X;
          goto L6195;}
        else {
          SeofPS = 1;
          if (((SstatusS) == NO_ERRORS)) {
            SstatusS = status_293X;
            arg0K0 = -1;
            goto L6195;}
          else {
            arg0K0 = -1;
            goto L6195;}}}}}
  else {
    arg0K0 = -1;
    goto L6195;}}
 L8454: {
  expr_294X = arg0K0;
  Sstartup_procedureS = expr_294X;
  if (((SstatusS) == NO_ERRORS)) {
    if ((SeofPS)) {
      arg0K0 = 0;
      arg0K1 = format_142X;
      goto L15092;}
    else {
      goto L8793;}}
  else {
    arg0K0 = 0;
    arg0K1 = format_142X;
    goto L15092;}}
 L9851: {
  okayP_295X = arg3K0;
  string_296X = arg4K1;
  if (okayP_295X) {
    arg0K0 = 0;
    goto L9884;}
  else {
    ps_write_string(string_296X, (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    status_297X = SstatusS;
    if ((status_297X == NO_ERRORS)) {
      goto L10119;}
    else {
      ps_write_string((ps_error_string((SstatusS))), (stderr));
      { long ignoreXX;
      PS_WRITE_CHAR(10, (stderr), ignoreXX) }
      goto L10119;}}}
 L9884: {
  expr_298X = arg0K0;
  if ((0 == expr_298X)) {
    if (((SstatusS) == NO_ERRORS)) {
      PS_READ_CHAR(port_118X, v_299X, eofP_300X, status_301X)
      if ((status_301X == NO_ERRORS)) {
        if (eofP_300X) {
          status_302X = ps_close(port_118X);
          if ((status_302X == NO_ERRORS)) {
            arg0K0 = 0;
            goto L14938;}
          else {
            ps_write_string("Error closing image file", (stderr));
            { long ignoreXX;
            PS_WRITE_CHAR(10, (stderr), ignoreXX) }
            status_303X = SstatusS;
            if ((status_303X == NO_ERRORS)) {
              goto L10002;}
            else {
              ps_write_string((ps_error_string((SstatusS))), (stderr));
              { long ignoreXX;
              PS_WRITE_CHAR(10, (stderr), ignoreXX) }
              goto L10002;}}}
        else {
          ps_write_string("Image file has extraneous data after image", (stderr));
          { long ignoreXX;
          PS_WRITE_CHAR(10, (stderr), ignoreXX) }
          status_304X = SstatusS;
          if ((status_304X == NO_ERRORS)) {
            goto L9970;}
          else {
            ps_write_string((ps_error_string((SstatusS))), (stderr));
            { long ignoreXX;
            PS_WRITE_CHAR(10, (stderr), ignoreXX) }
            goto L9970;}}}
      else {
        ps_write_string("Error reading from image file", (stderr));
        { long ignoreXX;
        PS_WRITE_CHAR(10, (stderr), ignoreXX) }
        status_305X = SstatusS;
        if ((status_305X == NO_ERRORS)) {
          goto L9938;}
        else {
          ps_write_string((ps_error_string((SstatusS))), (stderr));
          { long ignoreXX;
          PS_WRITE_CHAR(10, (stderr), ignoreXX) }
          goto L9938;}}}
    else {
      arg0K0 = -1;
      goto L14938;}}
  else {
    arg0K0 = -1;
    goto L14938;}}
 L10254: {
  status_306X = ps_close(port_118X);
  if ((status_306X == NO_ERRORS)) {
    arg0K0 = -1;
    goto L9884;}
  else {
    ps_write_string("Error closing image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    arg0K0 = -1;
    goto L9884;}}
 L13953: {
  if ((0 == weaks_delta_209X)) {
    arg0K0 = 0;
    goto L15157;}
  else {
    merged_arg0K0 = weaks_delta_209X;
    merged_arg1K1 = (Snew_weaks_start_addrS);
    merged_arg1K2 = weaks_new_hp_210X;
    relocate_image_return_tag = 1;
    goto relocate_image;
   relocate_image_return_1:
    arg0K0 = 0;
    goto L15157;}}
 L13902: {
  expr_307X = arg0K0;
  SsymbolsS = expr_307X;
  descriptor_308X = Simported_bindingsS;
  if ((3 == (3 & descriptor_308X))) {
    arg0K0 = (3 + (((long) ((((char *) (-3 + descriptor_308X))) + small_delta_205X))));
    goto L13908;}
  else {
    arg0K0 = descriptor_308X;
    goto L13908;}}
 L6195: {
  cells_309X = arg0K0;
  we_310X = ((cells_309X)<<2);
  Ssmall_img_start_addrS = (((char *) sb_181X));
  Ssmall_img_hp_addrS = (((char *) sh_193X));
  Ssmall_img_end_addrS = (((char *) se_229X));
  Slarge_img_start_addrS = (((char *) se_229X));
  Slarge_img_hp_addrS = (((char *) lh_249X));
  Slarge_img_end_addrS = (((char *) le_267X));
  Sweaks_img_start_addrS = (((char *) le_267X));
  Sweaks_img_hp_addrS = (((char *) wh_289X));
  Sweaks_img_end_addrS = (((char *) we_310X));
  Ssmall_img_heap_sizeS = ((((sh_193X - sb_181X))>>2));
  Slarge_img_heap_sizeS = ((((lh_249X - se_229X))>>2));
  Sweaks_img_heap_sizeS = ((((wh_289X - le_267X))>>2));
  Simg_start_addrS = (((char *) le_267X));
  Simg_end_addrS = (((char *) sh_193X));
  Simg_heap_sizeS = ((((((se_229X - sb_181X))>>2)) + ((((le_267X - se_229X))>>2))) + ((((we_310X - le_267X))>>2)));
  goto L8191;}
 L8793: {
  PS_READ_CHAR(port_118X, ch_311X, eofP_312X, status_313X)
  if (eofP_312X) {
    arg3K0 = eofP_312X;
    arg0K1 = status_313X;
    goto L8481;}
  else {
    if ((status_313X == NO_ERRORS)) {
      if ((12 == ch_311X)) {
        arg3K0 = 0;
        arg0K1 = status_313X;
        goto L8481;}
      else {
        goto L8793;}}
    else {
      arg3K0 = eofP_312X;
      arg0K1 = status_313X;
      goto L8481;}}}
 L10119: {
  status_314X = ps_close(port_118X);
  if ((status_314X == NO_ERRORS)) {
    arg0K0 = -1;
    goto L9884;}
  else {
    ps_write_string("Error closing image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    arg0K0 = -1;
    goto L9884;}}
 L14938: {
  expr_315X = arg0K0;
  if ((0 == expr_315X)) {
    if (((SstatusS) == NO_ERRORS)) {
      if (reverse_byte_orderP_203X) {
        merged_arg1K0 = (Simg_start_addrS);
        merged_arg0K1 = format_169X;
        old_Gnew_addr_return_tag = 0;
        goto old_Gnew_addr;
       old_Gnew_addr_return_0:
        v_316X = old_Gnew_addr0_return_value;
        merged_arg1K0 = (Simg_end_addrS);
        merged_arg0K1 = format_169X;
        old_Gnew_addr_return_tag = 1;
        goto old_Gnew_addr;
       old_Gnew_addr_return_1:
        v_317X = old_Gnew_addr0_return_value;
        merged_arg1K0 = v_316X;
        merged_arg1K1 = v_317X;
        reverse_byte_orderB_return_tag = 3;
        goto reverse_byte_orderB;
       reverse_byte_orderB_return_3:
        goto L14950;}
      else {
        goto L14950;}}
    else {
      arg0K0 = -1;
      goto L15157;}}
  else {
    arg0K0 = -1;
    goto L15157;}}
 L10002: {
  status_318X = ps_close(port_118X);
  if ((status_318X == NO_ERRORS)) {
    arg0K0 = -1;
    goto L14938;}
  else {
    ps_write_string("Error closing image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    arg0K0 = -1;
    goto L14938;}}
 L9970: {
  status_319X = ps_close(port_118X);
  if ((status_319X == NO_ERRORS)) {
    arg0K0 = -1;
    goto L14938;}
  else {
    ps_write_string("Error closing image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    arg0K0 = -1;
    goto L14938;}}
 L9938: {
  status_320X = ps_close(port_118X);
  if ((status_320X == NO_ERRORS)) {
    arg0K0 = -1;
    goto L14938;}
  else {
    ps_write_string("Error closing image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    arg0K0 = -1;
    goto L14938;}}
 L13908: {
  expr_321X = arg0K0;
  Simported_bindingsS = expr_321X;
  descriptor_322X = Sexported_bindingsS;
  if ((3 == (3 & descriptor_322X))) {
    arg0K0 = (3 + (((long) ((((char *) (-3 + descriptor_322X))) + small_delta_205X))));
    goto L13914;}
  else {
    arg0K0 = descriptor_322X;
    goto L13914;}}
 L8481: {
  eofP_323X = arg3K0;
  status_324X = arg0K1;
  if (eofP_323X) {
    SeofPS = 1;
    arg0K0 = 0;
    arg0K1 = format_142X;
    goto L15092;}
  else {
    if ((status_324X == NO_ERRORS)) {
      arg0K0 = 0;
      arg0K1 = format_142X;
      goto L15092;}
    else {
      SeofPS = 1;
      if (((SstatusS) == NO_ERRORS)) {
        SstatusS = status_324X;
        arg0K0 = 0;
        arg0K1 = format_142X;
        goto L15092;}
      else {
        arg0K0 = 0;
        arg0K1 = format_142X;
        goto L15092;}}}}
 L14950: {
  if ((0 == format_169X)) {
    merged_arg1K0 = (Simg_start_addrS);
    merged_arg1K1 = (Ssymbol_addressS);
    merged_arg0K2 = format_169X;
    parse_reachable_objects_return_tag = 0;
    goto parse_reachable_objects;
   parse_reachable_objects_return_0:
    goto L14952;}
  else {
    if ((1 == format_169X)) {
      merged_arg1K0 = (Ssmall_img_start_addrS);
      merged_arg1K1 = (Ssymbol_addressS);
      merged_arg0K2 = format_169X;
      parse_reachable_objects_return_tag = 1;
      goto parse_reachable_objects;
     parse_reachable_objects_return_1:
      merged_arg1K0 = (Slarge_img_start_addrS);
      merged_arg1K1 = ((Slarge_img_start_addrS) + ((((Slarge_img_heap_sizeS))<<2)));
      merged_arg0K2 = format_169X;
      parse_reachable_objects_return_tag = 2;
      goto parse_reachable_objects;
     parse_reachable_objects_return_2:
      merged_arg1K0 = (Sweaks_img_start_addrS);
      merged_arg1K1 = ((Sweaks_img_start_addrS) + ((((Sweaks_img_heap_sizeS))<<2)));
      merged_arg0K2 = format_169X;
      parse_reachable_objects_return_tag = 3;
      goto parse_reachable_objects;
     parse_reachable_objects_return_3:
      goto L14952;}
    else {
      ps_error("allocate+parse+copy-objects!: Unknown image format", 0);
      goto L14952;}}}
 L13914: {
  expr_325X = arg0K0;
  Sexported_bindingsS = expr_325X;
  descriptor_326X = Sresumer_recordsS;
  if ((3 == (3 & descriptor_326X))) {
    arg0K0 = (3 + (((long) ((((char *) (-3 + descriptor_326X))) + small_delta_205X))));
    goto L13920;}
  else {
    arg0K0 = descriptor_326X;
    goto L13920;}}
 L14952: {
  address_327X = (((char *) (-3 + (Sstartup_procedureS)))) + -4;
  if ((0 == (((long) address_327X)))) {
    arg0K0 = -1;
    goto L14607;}
  else {
    arg0K0 = (((long) address_327X));
    goto L14607;}}
 L13920: {
  expr_328X = arg0K0;
  Sresumer_recordsS = expr_328X;
  table_329X = SsymbolsS;
  if ((3 == (3 & table_329X))) {
    if ((2 == (31 & ((((*((long *) ((((char *) (-3 + table_329X))) + -4))))>>2))))) {
      arg0K0 = 0;
      goto L12618;}
    else {
      goto L13926;}}
  else {
    goto L13926;}}
 L14607: {
  v_330X = arg0K0;
  image_location_331X = table_ref((Sstob_tableS), v_330X);
  Sstartup_procedureS = (3 + (((long) ((((char *) (image_location_331X->new_descriptor))) + 4))));
  v_332X = SsymbolsS;
  if ((1 == v_332X)) {
    goto L14537;}
  else {
    tab_333X = SsymbolsS;
    merged_arg1K0 = ((((char *) (-3 + tab_333X))) + -4);
    merged_arg0K1 = format_169X;
    old_Gnew_addr_return_tag = 2;
    goto old_Gnew_addr;
   old_Gnew_addr_return_2:
    addr_334X = old_Gnew_addr0_return_value;
    cell_335X = *((long *) addr_334X);
    if ((2 == (3 & cell_335X))) {
      size_336X = (((3 + ((long)(((unsigned long)cell_335X)>>8))))>>2);
      pointer_337X = s48_allocate_tracedAgc((4 + (((size_336X)<<2))));
      memmove((void *)pointer_337X, (void *)addr_334X,(4 + (((size_336X)<<2))));
      arg0K0 = (3 + (((long) (pointer_337X + 4))));
      goto L14528;}
    else {
      ps_error("read-tables! no header", 0);
      arg0K0 = v_338X;
      goto L14528;}}}
 L12618: {
  i_339X = arg0K0;
  if ((1024 == i_339X)) {
    goto L13926;}
  else {
    link_340X = *((long *) ((((char *) (-3 + table_329X))) + (((i_339X)<<2))));
    if ((0 == (3 & link_340X))) {
      arg0K0 = (3 + (-4 & link_340X));
      goto L12624;}
    else {
      arg0K0 = link_340X;
      goto L12624;}}}
 L13926: {
  merged_arg0K0 = (Simported_bindingsS);
  merged_arg0K1 = small_delta_205X;
  relocate_binding_table_two_spaceB_return_tag = 0;
  goto relocate_binding_table_two_spaceB;
 relocate_binding_table_two_spaceB_return_0:
  merged_arg0K0 = (Sexported_bindingsS);
  merged_arg0K1 = small_delta_205X;
  relocate_binding_table_two_spaceB_return_tag = 1;
  goto relocate_binding_table_two_spaceB;
 relocate_binding_table_two_spaceB_return_1:
  merged_arg0K0 = small_delta_205X;
  merged_arg1K1 = (Snew_small_start_addrS);
  merged_arg1K2 = small_new_hp_206X;
  relocate_image_return_tag = 2;
  goto relocate_image;
 relocate_image_return_2:
  goto L13941;}
 L14537: {
  v_341X = Simported_bindingsS;
  if ((1 == v_341X)) {
    goto L14557;}
  else {
    tab_342X = Simported_bindingsS;
    merged_arg1K0 = ((((char *) (-3 + tab_342X))) + -4);
    merged_arg0K1 = format_169X;
    old_Gnew_addr_return_tag = 3;
    goto old_Gnew_addr;
   old_Gnew_addr_return_3:
    addr_343X = old_Gnew_addr0_return_value;
    cell_344X = *((long *) addr_343X);
    if ((2 == (3 & cell_344X))) {
      size_345X = (((3 + ((long)(((unsigned long)cell_344X)>>8))))>>2);
      pointer_346X = s48_allocate_tracedAgc((4 + (((size_345X)<<2))));
      memmove((void *)pointer_346X, (void *)addr_343X,(4 + (((size_345X)<<2))));
      arg0K0 = (3 + (((long) (pointer_346X + 4))));
      goto L14548;}
    else {
      ps_error("read-tables! no header", 0);
      arg0K0 = v_347X;
      goto L14548;}}}
 L14528: {
  expr_348X = arg0K0;
  SsymbolsS = expr_348X;
  table_349X = SsymbolsS;
  stob_table_350X = Sstob_tableS;
  if ((3 == (3 & table_349X))) {
    if ((2 == (31 & ((((*((long *) ((((char *) (-3 + table_349X))) + -4))))>>2))))) {
      arg0K0 = 0;
      goto L12832;}
    else {
      goto L14537;}}
  else {
    goto L14537;}}
 L12624: {
  bucket_351X = arg0K0;
  if ((1 == bucket_351X)) {
    goto L12620;}
  else {
    bucket_352X = bucket_351X + small_delta_205X;
    if ((3 == (3 & bucket_352X))) {
      arg0K0 = (-4 & bucket_352X);
      goto L12629;}
    else {
      arg0K0 = bucket_352X;
      goto L12629;}}}
 L14557: {
  v_353X = Sexported_bindingsS;
  if ((1 == v_353X)) {
    goto L14577;}
  else {
    tab_354X = Sexported_bindingsS;
    merged_arg1K0 = ((((char *) (-3 + tab_354X))) + -4);
    merged_arg0K1 = format_169X;
    old_Gnew_addr_return_tag = 4;
    goto old_Gnew_addr;
   old_Gnew_addr_return_4:
    addr_355X = old_Gnew_addr0_return_value;
    cell_356X = *((long *) addr_355X);
    if ((2 == (3 & cell_356X))) {
      size_357X = (((3 + ((long)(((unsigned long)cell_356X)>>8))))>>2);
      pointer_358X = s48_allocate_tracedAgc((4 + (((size_357X)<<2))));
      memmove((void *)pointer_358X, (void *)addr_355X,(4 + (((size_357X)<<2))));
      arg0K0 = (3 + (((long) (pointer_358X + 4))));
      goto L14568;}
    else {
      ps_error("read-tables! no header", 0);
      arg0K0 = v_359X;
      goto L14568;}}}
 L14548: {
  expr_360X = arg0K0;
  Simported_bindingsS = expr_360X;
  merged_arg0K0 = (Simported_bindingsS);
  merged_arg5K1 = (Sstob_tableS);
  relocate_binding_table_bibopB_return_tag = 0;
  goto relocate_binding_table_bibopB;
 relocate_binding_table_bibopB_return_0:
  goto L14557;}
 L12832: {
  i_361X = arg0K0;
  if ((1024 == i_361X)) {
    goto L14537;}
  else {
    link_362X = *((long *) ((((char *) (-3 + table_349X))) + (((i_361X)<<2))));
    if ((0 == (3 & link_362X))) {
      arg0K0 = (3 + (-4 & link_362X));
      goto L12838;}
    else {
      arg0K0 = link_362X;
      goto L12838;}}}
 L12620: {
  arg0K0 = (1 + i_339X);
  goto L12618;}
 L12629: {
  value_363X = arg0K0;
  addr_364X = (((char *) (-3 + table_329X))) + (((i_339X)<<2));S48_WRITE_BARRIER(table_329X, addr_364X, value_363X);
  *((long *) addr_364X) = (long) (value_363X);
  arg0K0 = bucket_352X;
  goto L12640;}
 L14577: {
  if ((1 == (Sresumer_recordsS))) {
    goto L14954;}
  else {
    tab_365X = Sresumer_recordsS;
    merged_arg1K0 = ((((char *) (-3 + tab_365X))) + -4);
    merged_arg0K1 = format_169X;
    old_Gnew_addr_return_tag = 5;
    goto old_Gnew_addr;
   old_Gnew_addr_return_5:
    addr_366X = old_Gnew_addr0_return_value;
    cell_367X = *((long *) addr_366X);
    if ((2 == (3 & cell_367X))) {
      size_368X = (((3 + ((long)(((unsigned long)cell_367X)>>8))))>>2);
      pointer_369X = s48_allocate_tracedAgc((4 + (((size_368X)<<2))));
      memmove((void *)pointer_369X, (void *)addr_366X,(4 + (((size_368X)<<2))));
      arg0K0 = (3 + (((long) (pointer_369X + 4))));
      goto L14588;}
    else {
      ps_error("read-tables! no header", 0);
      arg0K0 = v_370X;
      goto L14588;}}}
 L14568: {
  expr_371X = arg0K0;
  Sexported_bindingsS = expr_371X;
  merged_arg0K0 = (Sexported_bindingsS);
  merged_arg5K1 = (Sstob_tableS);
  relocate_binding_table_bibopB_return_tag = 1;
  goto relocate_binding_table_bibopB;
 relocate_binding_table_bibopB_return_1:
  goto L14577;}
 L12838: {
  bucket_372X = arg0K0;
  if ((1 == bucket_372X)) {
    goto L12834;}
  else {
    merged_arg0K0 = bucket_372X;
    relocateD1_return_tag = 0;
    goto relocateD1;
   relocateD1_return_0:
    bucket_373X = relocateD10_return_value;
    if ((3 == (3 & bucket_373X))) {
      arg0K0 = (-4 & bucket_373X);
      goto L12843;}
    else {
      arg0K0 = bucket_373X;
      goto L12843;}}}
 L12640: {
  entry_374X = arg0K0;
  link_375X = *((long *) ((((char *) (-3 + entry_374X))) + 4));
  if ((0 == (3 & link_375X))) {
    arg0K0 = (3 + (-4 & link_375X));
    goto L12644;}
  else {
    arg0K0 = link_375X;
    goto L12644;}}
 L14954: {
  table_376X = Sstob_tableS;
  keys_377X = table_376X->keys;
  values_378X = table_376X->values;
  arg0K0 = 0;
  goto L3651;}
 L14588: {
  expr_379X = arg0K0;
  Sresumer_recordsS = expr_379X;
  resumer_records_380X = Sresumer_recordsS;
  cell_381X = *((long *) ((((char *) (-3 + resumer_records_380X))) + -4));
  if ((2 == (3 & cell_381X))) {
    arg1K0 = (((char *) (-3 + resumer_records_380X)));
    arg0K1 = ((((3 + ((long)(((unsigned long)cell_381X)>>8))))>>2));
    goto L10407;}
  else {
    ps_error("relocate-resumer-record! - no header", 0);
    goto L14954;}}
 L12834: {
  arg0K0 = (1 + i_361X);
  goto L12832;}
 L12843: {
  value_382X = arg0K0;
  addr_383X = (((char *) (-3 + table_349X))) + (((i_361X)<<2));S48_WRITE_BARRIER(table_349X, addr_383X, value_382X);
  *((long *) addr_383X) = (long) (value_382X);
  arg0K0 = bucket_373X;
  goto L12854;}
 L12644: {
  next_384X = arg0K0;
  if ((1 == next_384X)) {
    goto L12620;}
  else {
    next_385X = next_384X + small_delta_205X;
    if ((3 == (3 & next_385X))) {
      arg0K0 = (-4 & next_385X);
      goto L12649;}
    else {
      arg0K0 = next_385X;
      goto L12649;}}}
 L3651: {
  i_386X = arg0K0;
  if ((i_386X == (table_376X->size))) {
    free(keys_377X);
    free(values_378X);
    free(table_376X);
    free((Sheap_image_pointerS));
    arg0K0 = 0;
    goto L15157;}
  else {
    if ((0 == (*(keys_377X + i_386X)))) {
      goto L3653;}
    else {
      free((*(values_378X + i_386X)));
      goto L3653;}}}
 L10407: {
  address_387X = arg1K0;
  size_388X = arg0K1;
  if ((0 == size_388X)) {
    goto L14954;}
  else {
    cell_389X = *((long *) address_387X);
    if ((3 == (3 & cell_389X))) {
      address_390X = (((char *) (-3 + cell_389X))) + -4;
      if ((0 == (((long) address_390X)))) {
        arg0K0 = -1;
        goto L10472;}
      else {
        arg0K0 = (((long) address_390X));
        goto L10472;}}
    else {
      ps_error("Could this happen?", 0);
      goto L14954;}}}
 L12854: {
  entry_391X = arg0K0;
  link_392X = *((long *) ((((char *) (-3 + entry_391X))) + 4));
  if ((0 == (3 & link_392X))) {
    arg0K0 = (3 + (-4 & link_392X));
    goto L12858;}
  else {
    arg0K0 = link_392X;
    goto L12858;}}
 L12649: {
  val_393X = arg0K0;
  addr_394X = (((char *) (-3 + entry_374X))) + 4;S48_WRITE_BARRIER(entry_374X, addr_394X, val_393X);
  *((long *) addr_394X) = (long) (val_393X);
  arg0K0 = next_385X;
  goto L12640;}
 L3653: {
  arg0K0 = (1 + i_386X);
  goto L3651;}
 L10472: {
  v_395X = arg0K0;
  image_location_396X = table_ref((Sstob_tableS), v_395X);
  *((long *) address_387X) = (long) ((3 + (((long) ((((char *) (image_location_396X->new_descriptor))) + 4)))));
  arg1K0 = (address_387X + 4);
  arg0K1 = (-1 + size_388X);
  goto L10407;}
 L12858: {
  next_397X = arg0K0;
  if ((1 == next_397X)) {
    goto L12834;}
  else {
    merged_arg0K0 = next_397X;
    relocateD1_return_tag = 1;
    goto relocateD1;
   relocateD1_return_1:
    next_398X = relocateD10_return_value;
    if ((3 == (3 & next_398X))) {
      arg0K0 = (-4 & next_398X);
      goto L12863;}
    else {
      arg0K0 = next_398X;
      goto L12863;}}}
 L12863: {
  val_399X = arg0K0;
  addr_400X = (((char *) (-3 + entry_391X))) + 4;S48_WRITE_BARRIER(entry_391X, addr_400X, val_399X);
  *((long *) addr_400X) = (long) (val_399X);
  arg0K0 = next_398X;
  goto L12854;}
 relocateD1: {
  address_117X = merged_arg0K0;{
  address_401X = (((char *) (-3 + address_117X))) + -4;
  if ((0 == (((long) address_401X)))) {
    arg0K0 = -1;
    goto L12802;}
  else {
    arg0K0 = (((long) address_401X));
    goto L12802;}}
 L12802: {
  v_402X = arg0K0;
  image_location_403X = table_ref(stob_table_350X, v_402X);
  relocateD10_return_value = (3 + (((long) ((((char *) (image_location_403X->new_descriptor))) + 4))));
  goto relocateD1_return;}
 relocateD1_return:
  switch (relocateD1_return_tag) {
  case 0: goto relocateD1_return_0;
  default: goto relocateD1_return_1;
  }}

 parse_reachable_objects: {
  from_addr_114X = merged_arg1K0;
  to_addr_115X = merged_arg1K1;
  image_format_116X = merged_arg0K2;{
  arg1K0 = from_addr_114X;
  goto L13245;}
 L13245: {
  current_addr_404X = arg1K0;
  if ((current_addr_404X == to_addr_115X)) {
    parse_reachable_objects0_return_value = 0;
    goto parse_reachable_objects_return;}
  else {
    merged_arg1K0 = current_addr_404X;
    merged_arg0K1 = image_format_116X;
    old_Gnew_addr_return_tag = 6;
    goto old_Gnew_addr;
   old_Gnew_addr_return_6:
    x1_405X = old_Gnew_addr0_return_value;
    cell_406X = *((long *) x1_405X);
    if ((2 == (3 & cell_406X))) {
      size_in_cells_407X = (((3 + ((long)(((unsigned long)cell_406X)>>8))))>>2);
      if ((0 == (Sheap_object_remaining_cellsS))) {
        goto L13270;}
      else {
        ps_error("Encountered an header within an d-vector.", 0);
        goto L13270;}}
    else {
      if ((3 == (3 & cell_406X))) {
        current_addr_408X = (((char *) (-3 + cell_406X))) + -4;
        if ((0 == (((long) current_addr_408X)))) {
          arg0K0 = -1;
          goto L13472;}
        else {
          arg0K0 = (((long) current_addr_408X));
          goto L13472;}}
      else {
        *((long *) (Sheap_object_pointerS)) = (long) (cell_406X);
        Sheap_object_remaining_cellsS = (-1 + (Sheap_object_remaining_cellsS));
        Sheap_object_pointerS = ((Sheap_object_pointerS) + 4);
        goto L13327;}}}}
 L13270: {
  if ((2 == (3 & cell_406X))) {
    if (((31 & (((cell_406X)>>2))) < 16)) {
      goto L13286;}
    else {
      if ((0 == (((long) current_addr_404X)))) {
        arg0K0 = -1;
        goto L13358;}
      else {
        arg0K0 = (((long) current_addr_404X));
        goto L13358;}}}
  else {
    goto L13286;}}
 L13472: {
  v_409X = arg0K0;
  v_410X = table_ref((Sstob_tableS), v_409X);
  if ((NULL == v_410X)) {
    current_addr_411X = (((char *) (-3 + cell_406X))) + -4;
    merged_arg1K0 = current_addr_411X;
    merged_arg0K1 = image_format_116X;
    old_Gnew_addr_return_tag = 7;
    goto old_Gnew_addr;
   old_Gnew_addr_return_7:
    x1_412X = old_Gnew_addr0_return_value;
    header_cell_413X = *((long *) x1_412X);
    size_in_cells_414X = 1 + ((((3 + ((long)(((unsigned long)header_cell_413X)>>8))))>>2));
    size_in_bytes_415X = ((size_in_cells_414X)<<2);
    if ((2 == (3 & header_cell_413X))) {
      if (((31 & (((header_cell_413X)>>2))) < 16)) {
        goto L12051;}
      else {
        new_address_416X = s48_allocate_tracedAgc((((size_in_cells_414X)<<2)));
        image_location_417X = (struct image_location*)malloc(sizeof(struct image_location));
        if ((NULL == image_location_417X)) {
          arg2K0 = image_location_417X;
          goto L12110;}
        else {
          image_location_417X->new_descriptor = (((long) new_address_416X));
          image_location_417X->next = 0;
          arg2K0 = image_location_417X;
          goto L12110;}}}
    else {
      goto L12051;}}
  else {
    goto L13318;}}
 L13327: {
  arg1K0 = (current_addr_404X + 4);
  goto L13245;}
 L13286: {
  if ((0 == (((long) current_addr_404X)))) {
    arg0K0 = -1;
    goto L13405;}
  else {
    arg0K0 = (((long) current_addr_404X));
    goto L13405;}}
 L13358: {
  v_418X = arg0K0;
  v_419X = table_ref((Sstob_tableS), v_418X);
  if ((NULL == v_419X)) {
    size_in_cells_420X = 1 + size_in_cells_407X;
    new_address_421X = s48_allocate_tracedAgc((((size_in_cells_420X)<<2)));
    image_location_422X = (struct image_location*)malloc(sizeof(struct image_location));
    if ((NULL == image_location_422X)) {
      arg2K0 = image_location_422X;
      goto L13376;}
    else {
      image_location_422X->new_descriptor = (((long) new_address_421X));
      image_location_422X->next = 0;
      arg2K0 = image_location_422X;
      goto L13376;}}
  else {
    goto L13283;}}
 L12051: {
  new_address_423X = s48_allocate_tracedAgc(size_in_bytes_415X);
  image_location_424X = (struct image_location*)malloc(sizeof(struct image_location));
  if ((NULL == image_location_424X)) {
    arg2K0 = image_location_424X;
    goto L12138;}
  else {
    image_location_424X->new_descriptor = (((long) new_address_423X));
    image_location_424X->next = 0;
    arg2K0 = image_location_424X;
    goto L12138;}}
 L12110: {
  val_425X = arg2K0;
  if ((0 == (((long) current_addr_411X)))) {
    arg0K0 = -1;
    goto L12112;}
  else {
    arg0K0 = (((long) current_addr_411X));
    goto L12112;}}
 L13318: {
  address_426X = (((char *) (-3 + cell_406X))) + -4;
  if ((0 == (((long) address_426X)))) {
    arg0K0 = -1;
    goto L13486;}
  else {
    arg0K0 = (((long) address_426X));
    goto L13486;}}
 L13405: {
  v_427X = arg0K0;
  v_428X = table_ref((Sstob_tableS), v_427X);
  if ((NULL == v_428X)) {
    new_address_429X = s48_allocate_tracedAgc((4 + (((size_in_cells_407X)<<2))));
    image_location_430X = (struct image_location*)malloc(sizeof(struct image_location));
    if ((NULL == image_location_430X)) {
      arg2K0 = image_location_430X;
      goto L11321;}
    else {
      image_location_430X->new_descriptor = (((long) new_address_429X));
      image_location_430X->next = 0;
      arg2K0 = image_location_430X;
      goto L11321;}}
  else {
    if ((0 == (((long) current_addr_404X)))) {
      arg0K0 = -1;
      goto L10532;}
    else {
      arg0K0 = (((long) current_addr_404X));
      goto L10532;}}}
 L13376: {
  val_431X = arg2K0;
  if ((0 == (((long) current_addr_404X)))) {
    arg0K0 = -1;
    goto L13378;}
  else {
    arg0K0 = (((long) current_addr_404X));
    goto L13378;}}
 L13283: {
  arg1K0 = (current_addr_404X + (4 + (((size_in_cells_407X)<<2))));
  goto L13245;}
 L12138: {
  val_432X = arg2K0;
  if ((0 == (((long) current_addr_411X)))) {
    arg0K0 = -1;
    goto L12140;}
  else {
    arg0K0 = (((long) current_addr_411X));
    goto L12140;}}
 L12112: {
  v_433X = arg0K0;table_setB((Sstob_tableS), v_433X, val_425X);
  merged_arg1K0 = current_addr_411X;
  merged_arg0K1 = image_format_116X;
  old_Gnew_addr_return_tag = 8;
  goto old_Gnew_addr;
 old_Gnew_addr_return_8:
  v_434X = old_Gnew_addr0_return_value;
  memmove((void *)new_address_416X, (void *)v_434X,(((size_in_cells_414X)<<2)));
  goto L13318;}
 L13486: {
  v_435X = arg0K0;
  image_location_436X = table_ref((Sstob_tableS), v_435X);
  *((long *) (Sheap_object_pointerS)) = (long) ((3 + (((long) ((((char *) (image_location_436X->new_descriptor))) + 4)))));
  Sheap_object_remaining_cellsS = (-1 + (Sheap_object_remaining_cellsS));
  Sheap_object_pointerS = ((Sheap_object_pointerS) + 4);
  goto L13327;}
 L11321: {
  val_437X = arg2K0;
  if ((0 == (((long) current_addr_404X)))) {
    arg0K0 = -1;
    goto L11323;}
  else {
    arg0K0 = (((long) current_addr_404X));
    goto L11323;}}
 L10532: {
  v_438X = arg0K0;
  image_location_439X = table_ref((Sstob_tableS), v_438X);
  new_address_440X = ((char *) (image_location_439X->new_descriptor));
  if ((2 == (3 & cell_406X))) {
    goto L10517;}
  else {
    ps_error("cell was not a header", 0);
    goto L10517;}}
 L13378: {
  v_441X = arg0K0;table_setB((Sstob_tableS), v_441X, val_431X);
  merged_arg1K0 = current_addr_404X;
  merged_arg0K1 = image_format_116X;
  old_Gnew_addr_return_tag = 9;
  goto old_Gnew_addr;
 old_Gnew_addr_return_9:
  v_442X = old_Gnew_addr0_return_value;
  memmove((void *)new_address_421X, (void *)v_442X,(((size_in_cells_420X)<<2)));
  goto L13283;}
 L12140: {
  v_443X = arg0K0;table_setB((Sstob_tableS), v_443X, val_432X);
  *((long *) new_address_423X) = (long) ((-954 + (((size_in_bytes_415X)<<8))));
  arg1K0 = (new_address_423X + 4);
  goto L12069;}
 L11323: {
  v_444X = arg0K0;table_setB((Sstob_tableS), v_444X, val_437X);
  if ((2 == (3 & cell_406X))) {
    goto L11300;}
  else {
    ps_error("cell was not a header", 0);
    goto L11300;}}
 L10517: {
  *((long *) new_address_440X) = (long) (cell_406X);
  Sheap_object_pointerS = new_address_440X;
  Sheap_object_remaining_cellsS = (1 + ((((3 + ((long)(((unsigned long)cell_406X)>>8))))>>2)));
  Sheap_object_remaining_cellsS = (-1 + (Sheap_object_remaining_cellsS));
  Sheap_object_pointerS = ((Sheap_object_pointerS) + 4);
  goto L13298;}
 L12069: {
  index_445X = arg1K0;
  if ((index_445X == (new_address_423X + (-4 & (3 + size_in_bytes_415X))))) {
    goto L13318;}
  else {
    *((long *) index_445X) = (long) (0);
    arg1K0 = (index_445X + 4);
    goto L12069;}}
 L11300: {
  *((long *) new_address_429X) = (long) (cell_406X);
  Sheap_object_pointerS = new_address_429X;
  Sheap_object_remaining_cellsS = (1 + ((((3 + ((long)(((unsigned long)cell_406X)>>8))))>>2)));
  Sheap_object_remaining_cellsS = (-1 + (Sheap_object_remaining_cellsS));
  Sheap_object_pointerS = ((Sheap_object_pointerS) + 4);
  goto L13298;}
 L13298: {
  arg1K0 = (current_addr_404X + 4);
  goto L13245;}
 parse_reachable_objects_return:
  switch (parse_reachable_objects_return_tag) {
  case 0: goto parse_reachable_objects_return_0;
  case 1: goto parse_reachable_objects_return_1;
  case 2: goto parse_reachable_objects_return_2;
  default: goto parse_reachable_objects_return_3;
  }}

 old_Gnew_addr: {
  addr_112X = merged_arg1K0;
  format_113X = merged_arg0K1;{
  if ((0 == format_113X)) {
    old_Gnew_addr0_return_value = ((Sheap_image_pointerS) + (addr_112X - (Simg_start_addrS)));
    goto old_Gnew_addr_return;}
  else {
    if ((1 == format_113X)) {
      y_446X = Ssmall_img_start_addrS;
      if ((addr_112X < y_446X)) {
        goto L3785;}
      else {
        if (((Ssmall_img_hp_addrS) < addr_112X)) {
          goto L3785;}
        else {
          SoffsetS = (((Sweaks_img_end_addrS) - (Sweaks_img_start_addrS)) + ((Slarge_img_end_addrS) - (Slarge_img_start_addrS)));
          Sarea_startS = (Ssmall_img_start_addrS);
          goto L3837;}}}
    else {
      ps_error("old->new-addr: Unknown image format", 0);
      old_Gnew_addr0_return_value = v_447X;
      goto old_Gnew_addr_return;}}}
 L3785: {
  y_448X = Slarge_img_start_addrS;
  if ((addr_112X < y_448X)) {
    goto L3811;}
  else {
    if (((Slarge_img_hp_addrS) < addr_112X)) {
      goto L3811;}
    else {
      SoffsetS = ((Sweaks_img_end_addrS) - (Sweaks_img_start_addrS));
      Sarea_startS = (Slarge_img_start_addrS);
      goto L3837;}}}
 L3837: {
  old_Gnew_addr0_return_value = ((Sheap_image_pointerS) + ((SoffsetS) + (addr_112X - (Sarea_startS))));
  goto old_Gnew_addr_return;}
 L3811: {
  y_449X = Sweaks_img_start_addrS;
  if ((addr_112X < y_449X)) {
    goto L3833;}
  else {
    if (((Sweaks_img_hp_addrS) < addr_112X)) {
      goto L3833;}
    else {
      SoffsetS = 0;
      Sarea_startS = (Sweaks_img_start_addrS);
      goto L3837;}}}
 L3833: {
  ps_error("Unknown address area!", 0);
  goto L3837;}
 old_Gnew_addr_return:
  switch (old_Gnew_addr_return_tag) {
  case 0: goto old_Gnew_addr_return_0;
  case 1: goto old_Gnew_addr_return_1;
  case 2: goto old_Gnew_addr_return_2;
  case 3: goto old_Gnew_addr_return_3;
  case 4: goto old_Gnew_addr_return_4;
  case 5: goto old_Gnew_addr_return_5;
  case 6: goto old_Gnew_addr_return_6;
  case 7: goto old_Gnew_addr_return_7;
  case 8: goto old_Gnew_addr_return_8;
  default: goto old_Gnew_addr_return_9;
  }}

 relocateD0: {
  address_111X = merged_arg0K0;{
  address_450X = (((char *) (-3 + address_111X))) + -4;
  if ((0 == (((long) address_450X)))) {
    arg0K0 = -1;
    goto L12930;}
  else {
    arg0K0 = (((long) address_450X));
    goto L12930;}}
 L12930: {
  v_451X = arg0K0;
  image_location_452X = table_ref(stob_table_110X, v_451X);
  relocateD00_return_value = (3 + (((long) ((((char *) (image_location_452X->new_descriptor))) + 4))));
  goto relocateD0_return;}
 relocateD0_return:
  switch (relocateD0_return_tag) {
  case 0: goto relocateD0_return_0;
  default: goto relocateD0_return_1;
  }}

 relocate_binding_table_bibopB: {
  table_109X = merged_arg0K0;
  stob_table_110X = merged_arg5K1;{
  if ((3 == (3 & table_109X))) {
    if ((2 == (31 & ((((*((long *) ((((char *) (-3 + table_109X))) + -4))))>>2))))) {
      arg0K0 = 0;
      goto L12960;}
    else {
      goto relocate_binding_table_bibopB_return;}}
  else {
    goto relocate_binding_table_bibopB_return;}}
 L12960: {
  i_453X = arg0K0;
  if ((1024 == i_453X)) {
    goto relocate_binding_table_bibopB_return;}
  else {
    link_454X = *((long *) ((((char *) (-3 + table_109X))) + (((i_453X)<<2))));
    if ((0 == (3 & link_454X))) {
      arg0K0 = (3 + (-4 & link_454X));
      goto L12966;}
    else {
      arg0K0 = link_454X;
      goto L12966;}}}
 L12966: {
  bucket_455X = arg0K0;
  if ((1 == bucket_455X)) {
    goto L12962;}
  else {
    merged_arg0K0 = bucket_455X;
    relocateD0_return_tag = 0;
    goto relocateD0;
   relocateD0_return_0:
    bucket_456X = relocateD00_return_value;
    if ((3 == (3 & bucket_456X))) {
      arg0K0 = (-4 & bucket_456X);
      goto L12971;}
    else {
      arg0K0 = bucket_456X;
      goto L12971;}}}
 L12962: {
  arg0K0 = (1 + i_453X);
  goto L12960;}
 L12971: {
  value_457X = arg0K0;
  addr_458X = (((char *) (-3 + table_109X))) + (((i_453X)<<2));S48_WRITE_BARRIER(table_109X, addr_458X, value_457X);
  *((long *) addr_458X) = (long) (value_457X);
  arg0K0 = bucket_456X;
  goto L12982;}
 L12982: {
  entry_459X = arg0K0;
  link_460X = *((long *) ((((char *) (-3 + entry_459X))) + 12));
  if ((0 == (3 & link_460X))) {
    arg0K0 = (3 + (-4 & link_460X));
    goto L12986;}
  else {
    arg0K0 = link_460X;
    goto L12986;}}
 L12986: {
  next_461X = arg0K0;
  if ((1 == next_461X)) {
    goto L12962;}
  else {
    merged_arg0K0 = next_461X;
    relocateD0_return_tag = 1;
    goto relocateD0;
   relocateD0_return_1:
    next_462X = relocateD00_return_value;
    if ((3 == (3 & next_462X))) {
      arg0K0 = (-4 & next_462X);
      goto L12991;}
    else {
      arg0K0 = next_462X;
      goto L12991;}}}
 L12991: {
  val_463X = arg0K0;
  addr_464X = (((char *) (-3 + entry_459X))) + 12;S48_WRITE_BARRIER(entry_459X, addr_464X, val_463X);
  *((long *) addr_464X) = (long) (val_463X);
  arg0K0 = next_462X;
  goto L12982;}
 relocate_binding_table_bibopB_return:
  switch (relocate_binding_table_bibopB_return_tag) {
  case 0: goto relocate_binding_table_bibopB_return_0;
  default: goto relocate_binding_table_bibopB_return_1;
  }}

 relocate_binding_table_two_spaceB: {
  table_107X = merged_arg0K0;
  delta_108X = merged_arg0K1;{
  if ((3 == (3 & table_107X))) {
    if ((2 == (31 & ((((*((long *) ((((char *) (-3 + table_107X))) + -4))))>>2))))) {
      arg0K0 = 0;
      goto L12713;}
    else {
      goto relocate_binding_table_two_spaceB_return;}}
  else {
    goto relocate_binding_table_two_spaceB_return;}}
 L12713: {
  i_465X = arg0K0;
  if ((1024 == i_465X)) {
    goto relocate_binding_table_two_spaceB_return;}
  else {
    link_466X = *((long *) ((((char *) (-3 + table_107X))) + (((i_465X)<<2))));
    if ((0 == (3 & link_466X))) {
      arg0K0 = (3 + (-4 & link_466X));
      goto L12719;}
    else {
      arg0K0 = link_466X;
      goto L12719;}}}
 L12719: {
  bucket_467X = arg0K0;
  if ((1 == bucket_467X)) {
    goto L12715;}
  else {
    bucket_468X = bucket_467X + delta_108X;
    if ((3 == (3 & bucket_468X))) {
      arg0K0 = (-4 & bucket_468X);
      goto L12724;}
    else {
      arg0K0 = bucket_468X;
      goto L12724;}}}
 L12715: {
  arg0K0 = (1 + i_465X);
  goto L12713;}
 L12724: {
  value_469X = arg0K0;
  addr_470X = (((char *) (-3 + table_107X))) + (((i_465X)<<2));S48_WRITE_BARRIER(table_107X, addr_470X, value_469X);
  *((long *) addr_470X) = (long) (value_469X);
  arg0K0 = bucket_468X;
  goto L12735;}
 L12735: {
  entry_471X = arg0K0;
  link_472X = *((long *) ((((char *) (-3 + entry_471X))) + 12));
  if ((0 == (3 & link_472X))) {
    arg0K0 = (3 + (-4 & link_472X));
    goto L12739;}
  else {
    arg0K0 = link_472X;
    goto L12739;}}
 L12739: {
  next_473X = arg0K0;
  if ((1 == next_473X)) {
    goto L12715;}
  else {
    next_474X = next_473X + delta_108X;
    if ((3 == (3 & next_474X))) {
      arg0K0 = (-4 & next_474X);
      goto L12744;}
    else {
      arg0K0 = next_474X;
      goto L12744;}}}
 L12744: {
  val_475X = arg0K0;
  addr_476X = (((char *) (-3 + entry_471X))) + 12;S48_WRITE_BARRIER(entry_471X, addr_476X, val_475X);
  *((long *) addr_476X) = (long) (val_475X);
  arg0K0 = next_474X;
  goto L12735;}
 relocate_binding_table_two_spaceB_return:
  switch (relocate_binding_table_two_spaceB_return_tag) {
  case 0: goto relocate_binding_table_two_spaceB_return_0;
  default: goto relocate_binding_table_two_spaceB_return_1;
  }}

 relocate_image: {
  delta_104X = merged_arg0K0;
  start_105X = merged_arg1K1;
  end_106X = merged_arg1K2;{
  arg1K0 = start_105X;
  goto L10912;}
 L10912: {
  ptr_477X = arg1K0;
  if ((ptr_477X < end_106X)) {
    descriptor_478X = *((long *) ptr_477X);
    if ((3 == (3 & descriptor_478X))) {
      arg0K0 = (3 + (((long) ((((char *) (-3 + descriptor_478X))) + delta_104X))));
      goto L10917;}
    else {
      arg0K0 = descriptor_478X;
      goto L10917;}}
  else {
    goto relocate_image_return;}}
 L10917: {
  d_479X = arg0K0;
  *((long *) ptr_477X) = (long) (d_479X);
  if ((2 == (3 & d_479X))) {
    if (((31 & (((d_479X)>>2))) < 16)) {
      goto L10929;}
    else {
      arg1K0 = (ptr_477X + (4 + (-4 & (3 + ((long)(((unsigned long)d_479X)>>8))))));
      goto L10912;}}
  else {
    goto L10929;}}
 L10929: {
  arg1K0 = (ptr_477X + 4);
  goto L10912;}
 relocate_image_return:
  switch (relocate_image_return_tag) {
  case 0: goto relocate_image_return_0;
  case 1: goto relocate_image_return_1;
  default: goto relocate_image_return_2;
  }}

 reverse_byte_orderB: {
  start_102X = merged_arg1K0;
  end_103X = merged_arg1K1;{
  ps_write_string("Correcting byte order of resumed image.", (stderr));
  { long ignoreXX;
  PS_WRITE_CHAR(10, (stderr), ignoreXX) }
  arg1K0 = start_102X;
  goto L10806;}
 L10806: {
  ptr_480X = arg1K0;
  if ((ptr_480X < end_103X)) {
    arg0K0 = 0;
    arg0K1 = 3;
    goto L10846;}
  else {
    goto reverse_byte_orderB_return;}}
 L10846: {
  i_481X = arg0K0;
  j_482X = arg0K1;
  if ((i_481X < j_482X)) {
    addr_a_483X = ptr_480X + i_481X;
    addr_b_484X = ptr_480X + j_482X;
    byte_a_485X = *((unsigned char *) addr_a_483X);
    *((unsigned char *) addr_a_483X) = (unsigned char) ((*((unsigned char *) addr_b_484X)));
    *((unsigned char *) addr_b_484X) = (unsigned char) (byte_a_485X);
    arg0K0 = (1 + i_481X);
    arg0K1 = (-1 + j_482X);
    goto L10846;}
  else {
    value_486X = *((long *) ptr_480X);
    next_487X = ptr_480X + 4;
    if ((2 == (3 & value_486X))) {
      if (((31 & (((value_486X)>>2))) < 16)) {
        arg1K0 = next_487X;
        goto L10806;}
      else {
        arg1K0 = (next_487X + (-4 & (3 + ((long)(((unsigned long)value_486X)>>8)))));
        goto L10806;}}
    else {
      arg1K0 = next_487X;
      goto L10806;}}}
 reverse_byte_orderB_return:
  switch (reverse_byte_orderB_return_tag) {
  case 0: goto reverse_byte_orderB_return_0;
  case 1: goto reverse_byte_orderB_return_1;
  case 2: goto reverse_byte_orderB_return_2;
  default: goto reverse_byte_orderB_return_3;
  }}

 read_image_area: {
  new_start_addr_99X = merged_arg1K0;
  img_heap_size_100X = merged_arg0K1;
  port_101X = merged_arg6K2;{
  need_488X = ((img_heap_size_100X)<<2);
  got_489X = ps_read_block(port_101X, ((char *) new_start_addr_99X), need_488X, &eofP_490X, &status_491X);
  if ((status_491X == NO_ERRORS)) {
    if (eofP_490X) {
      arg3K0 = 0;
      arg4K1 = "Premature EOF when reading image file";
      goto L4638;}
    else {
      if ((got_489X < need_488X)) {
        arg3K0 = 0;
        arg4K1 = "Read returned too few bytes";
        goto L4638;}
      else {
        arg3K0 = 1;
        arg4K1 = "";
        goto L4638;}}}
  else {
    SstatusS = status_491X;
    arg3K0 = 0;
    arg4K1 = "Error reading from image file";
    goto L4638;}}
 L4638: {
  okayP_492X = arg3K0;
  string_493X = arg4K1;
  if (okayP_492X) {
    read_image_area0_return_value = 0;
    goto read_image_area_return;}
  else {
    ps_write_string(string_493X, (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    status_494X = SstatusS;
    if ((status_494X == NO_ERRORS)) {
      goto L4681;}
    else {
      ps_write_string((ps_error_string((SstatusS))), (stderr));
      { long ignoreXX;
      PS_WRITE_CHAR(10, (stderr), ignoreXX) }
      goto L4681;}}}
 L4681: {
  status_495X = ps_close(port_101X);
  if ((status_495X == NO_ERRORS)) {
    read_image_area0_return_value = -1;
    goto read_image_area_return;}
  else {
    ps_write_string("Error closing image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    read_image_area0_return_value = -1;
    goto read_image_area_return;}}
 read_image_area_return:
  switch (read_image_area_return_tag) {
  case 0: goto read_image_area_return_0;
  case 1: goto read_image_area_return_1;
  default: goto read_image_area_return_2;
  }}

 really_read_image_area: {
  new_start_addr_96X = merged_arg1K0;
  img_heap_size_97X = merged_arg0K1;
  port_98X = merged_arg6K2;{
  need_496X = ((img_heap_size_97X)<<2);
  got_497X = ps_read_block(port_98X, ((char *) new_start_addr_96X), need_496X, &eofP_498X, &status_499X);
  if ((status_499X == NO_ERRORS)) {
    if (eofP_498X) {
      arg3K0 = 0;
      arg4K1 = "Premature EOF when reading image file";
      goto L4552;}
    else {
      if ((got_497X < need_496X)) {
        arg3K0 = 0;
        arg4K1 = "Read returned too few bytes";
        goto L4552;}
      else {
        arg3K0 = 1;
        arg4K1 = "";
        goto L4552;}}}
  else {
    SstatusS = status_499X;
    arg3K0 = 0;
    arg4K1 = "Error reading from image file";
    goto L4552;}}
 L4552: {
  okayP_500X = arg3K0;
  string_501X = arg4K1;
  if (okayP_500X) {
    really_read_image_area0_return_value = 0;
    goto really_read_image_area_return;}
  else {
    ps_write_string(string_501X, (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    status_502X = SstatusS;
    if ((status_502X == NO_ERRORS)) {
      goto L4595;}
    else {
      ps_write_string((ps_error_string((SstatusS))), (stderr));
      { long ignoreXX;
      PS_WRITE_CHAR(10, (stderr), ignoreXX) }
      goto L4595;}}}
 L4595: {
  status_503X = ps_close(port_98X);
  if ((status_503X == NO_ERRORS)) {
    really_read_image_area0_return_value = -1;
    goto really_read_image_area_return;}
  else {
    ps_write_string("Error closing image file", (stderr));
    { long ignoreXX;
    PS_WRITE_CHAR(10, (stderr), ignoreXX) }
    really_read_image_area0_return_value = -1;
    goto really_read_image_area_return;}}
 really_read_image_area_return:
  switch (really_read_image_area_return_tag) {
  case 0: goto really_read_image_area_return_0;
  case 1: goto really_read_image_area_return_1;
  default: goto really_read_image_area_return_2;
  }}

}
long s48_write_image(long resume_proc_504X, long undumpables_505X, FILE * port_506X)
{
  struct table *arg5K0;
  struct bibop_areas *arg7K0;
  long arg0K0;
  char * arg1K0;
  char * merged_arg1K0;
  long merged_arg0K1;
  long merged_arg0K0;

  int write_shared_table_return_tag;
  char write_shared_table0_return_value;
  int write_stob_return_tag;
  int copy_image_data_return_tag;
  long table_507X;
  long stob_508X;
  char * start_509X;
  long size_510X;
  long v_674X;
  long value_673X;
  struct image_location *have_672X;
  long thing_671X;
  long link_670X;
  struct image_location *v_669X;
  long next_668X;
  long shared_667X;
  long link_666X;
  char temp_665X;
  long i_664X;
  long value_663X;
  long v_662X;
  struct image_location *have_661X;
  long v_660X;
  long v_659X;
  struct image_location *have_658X;
  long thing_657X;
  struct image_location *have_656X;
  long thing_655X;
  long x_654X;
  char * addr_653X;
  long v_652X;
  long value_651X;
  struct image_location *have_650X;
  long thing_649X;
  char * addr_648X;
  char * start_647X;
  long header_646X;
  long next_645X;
  struct image_location *have_644X;
  long thing_643X;
  struct image_location *have_642X;
  char * addr_641X;
  long link_640X;
  struct image_location *v_639X;
  long next_638X;
  char * start_637X;
  long header_636X;
  long next_635X;
  long have_634X;
  long available_633X;
  long size_632X;
  char * start_631X;
  long header_630X;
  long shared_629X;
  long link_628X;
  struct image_location *v_627X;
  long next_626X;
  long link_625X;
  long symbol_624X;
  long v_623X;
  long link_622X;
  struct image_location *have_621X;
  long thing_620X;
  long id_619X;
  char * addr_618X;
  char * start_617X;
  long header_616X;
  struct image_location *have_615X;
  long thing_614X;
  struct image_location *v_613X;
  long thing_612X;
  long have_611X;
  long v_610X;
  long value_609X;
  struct image_location *have_608X;
  long thing_607X;
  long i_606X;
  long link_605X;
  struct image_location *v_604X;
  long next_603X;
  struct image_location **values_602X;
  long *keys_601X;
  struct table *table_600X;
  long symbol_599X;
  long have_598X;
  char v_597X;
  struct image_location *location_596X;
  long stob_595X;
  long link_594X;
  long v_593X;
  long v_592X;
  long i_591X;
  long table_590X;
  long i_589X;
  long i_588X;
  long i_587X;
  long v_586X;
  long v_585X;
  long v_584X;
  long v_583X;
  long n_582X;
  struct image_location *have_581X;
  long thing_580X;
  long v_579X;
  long n_578X;
  struct image_location *have_577X;
  long thing_576X;
  long v_575X;
  long n_574X;
  struct image_location *have_573X;
  long thing_572X;
  long v_571X;
  long cells_570X;
  long v_569X;
  long cells_568X;
  long v_567X;
  long cells_566X;
  long v_565X;
  long cells_564X;
  long v_563X;
  long cells_562X;
  long v_561X;
  long cells_560X;
  long v_559X;
  long cells_558X;
  long v_557X;
  long v_556X;
  long v_555X;
  long v_554X;
  long i_553X;
  long v_552X;
  struct image_location *image_location_551X;
  long stob_550X;
  struct image_location **values_549X;
  long *keys_548X;
  struct table *table_547X;
  long v_546X;
  long resumer_records_545X;
  long i_544X;
  struct image_location *image_location_543X;
  long stob_542X;
  long i_541X;
  long n_540X;
  long v_539X;
  long n_538X;
  long v_537X;
  long n_536X;
  long v_535X;
  struct table *stob_table_534X;
  long v_533X;
  long v_532X;
  long v_531X;
  long v_530X;
  struct image_location *last_529X;
  char * addr_528X;
  long next_527X;
  struct image_location *image_location_526X;
  char * start_525X;
  long link_524X;
  long entry_523X;
  long header_522X;
  long stob_521X;
  long link_520X;
  long i_519X;
  long table_518X;
  long resume_proc_517X;
  struct bibop_areas *v_516X;
  struct bibop_areas *bibop_areas_515X;
  struct table *v_514X;
  struct table *table_513X;
  long i_512X;
  long *keys_511X;
 {  keys_511X = (long*)malloc(sizeof(long) * 4097);
  arg0K0 = 0;
  goto L7757;}
 L7757: {
  i_512X = arg0K0;
  if ((i_512X < 4097)) {
    *(keys_511X + i_512X) = 0;
    arg0K0 = (1 + i_512X);
    goto L7757;}
  else {
    table_513X = (struct table*)malloc(sizeof(struct table));
    if ((NULL == table_513X)) {
      arg5K0 = table_513X;
      goto L7730;}
    else {
      table_513X->keys = keys_511X;
      table_513X->values = ((struct image_location**)malloc(sizeof(struct image_location*) * 4096));
      table_513X->count = 0;
      table_513X->size = 4096;
      arg5K0 = table_513X;
      goto L7730;}}}
 L7730: {
  v_514X = arg5K0;
  Sstob_tableS = v_514X;
  Sfirst_stobS = 1;
  Slast_stobS = (NULL);
  Sundumpable_recordsS = undumpables_505X;
  Sundumpable_countS = 0;
  Sresumer_countS = 0;
  small_image_start_address = (((long) (Snew_small_start_addrS)));
  Ssmall_image_beginS = (((char *) (small_image_start_address)));
  Ssmall_image_hpS = (((char *) (small_image_start_address)));
  Ssmall_image_endS = NULL;
  Slarge_image_beginS = (((char *) 0));
  Slarge_image_hpS = (((char *) 0));
  Slarge_image_endS = NULL;
  Sweaks_image_beginS = (((char *) 0));
  Sweaks_image_hpS = (((char *) 0));
  Sweaks_image_endS = NULL;
  bibop_areas_515X = (struct bibop_areas*)malloc(sizeof(struct bibop_areas));
  if ((NULL == bibop_areas_515X)) {
    arg7K0 = bibop_areas_515X;
    goto L5166;}
  else {
    bibop_areas_515X->small = ((long*)malloc(sizeof(long) * 1048576));
    bibop_areas_515X->small_index = 0;
    bibop_areas_515X->large = ((long*)malloc(sizeof(long) * 1048576));
    bibop_areas_515X->large_index = 0;
    bibop_areas_515X->weaks = ((long*)malloc(sizeof(long) * 1048576));
    bibop_areas_515X->weaks_index = 0;
    arg7K0 = bibop_areas_515X;
    goto L5166;}}
 L5166: {
  v_516X = arg7K0;
  Sbibop_areasS = v_516X;
  Straced_last_stobPS = 0;
  Simage_portS = port_506X;
  Simage_bufferS = ((char *)malloc(4096));
  Simage_buffer_pointerS = (Simage_bufferS);
  SstatusS = NO_ERRORS;
  if (((Simage_bufferS) == NULL)) {
    return ENOMEM;}
  else {
    resume_proc_517X = trace_image_value(resume_proc_504X);
    table_518X = s48_exported_bindings();
    arg0K0 = 0;
    goto L11471;}}
 L11471: {
  i_519X = arg0K0;
  if ((1024 == i_519X)) {
    arg0K0 = (Sfirst_stobS);
    goto L15404;}
  else {
    link_520X = *((long *) ((((char *) (-3 + table_518X))) + (((i_519X)<<2))));
    if ((0 == (3 & link_520X))) {
      arg0K0 = (3 + (-4 & link_520X));
      goto L11445;}
    else {
      arg0K0 = link_520X;
      goto L11445;}}}
 L15404: {
  stob_521X = arg0K0;
  header_522X = *((long *) ((((char *) (-3 + stob_521X))) + -4));
  if ((2 == (3 & header_522X))) {
    if (((31 & (((header_522X)>>2))) < 16)) {
      goto L15268;}
    else {
      goto L15406;}}
  else {
    goto L15268;}}
 L11445: {
  entry_523X = arg0K0;
  if ((1 == entry_523X)) {
    arg0K0 = (1 + i_519X);
    goto L11471;}
  else {trace_image_value(entry_523X);
    link_524X = *((long *) ((((char *) (-3 + entry_523X))) + 12));
    if ((0 == (3 & link_524X))) {
      arg0K0 = (3 + (-4 & link_524X));
      goto L11445;}
    else {
      arg0K0 = link_524X;
      goto L11445;}}}
 L15268: {
  if ((1078 == header_522X)) {
    goto L15406;}
  else {
    start_525X = ((char *) (-3 + stob_521X));
    arg1K0 = start_525X;
    goto L15287;}}
 L15406: {
  if ((0 < ((Sstob_tableS)->size))) {
    image_location_526X = table_ref((Sstob_tableS), stob_521X);
    next_527X = image_location_526X->next;
    if ((3 == (3 & next_527X))) {
      arg0K0 = next_527X;
      goto L15404;}
    else {
      goto L15476;}}
  else {
    goto L15476;}}
 L15287: {
  addr_528X = arg1K0;
  if ((addr_528X == (start_525X + (-4 & (3 + ((long)(((unsigned long)header_522X)>>8))))))) {
    goto L15406;}
  else {trace_image_value((*((long *) addr_528X)));
    arg1K0 = (addr_528X + 4);
    goto L15287;}}
 L15476: {
  last_529X = Slast_stobS;
  Straced_last_stobPS = 1;
  v_530X = s48_symbol_table();trace_image_value(v_530X);
  v_531X = s48_imported_bindings();trace_image_value(v_531X);
  v_532X = s48_exported_bindings();trace_image_value(v_532X);
  last_529X->next = 1;
  v_533X = image_alloc(0, ((((Sresumer_countS))<<2)));
  Sresumer_recordsS = v_533X;
  stob_table_534X = Sstob_tableS;
  v_535X = (Ssmall_image_hpS) - (Ssmall_image_beginS);
  if ((0 == v_535X)) {
    arg0K0 = 1;
    goto L7627;}
  else {
    arg0K0 = ((Ssmall_image_hpS) - (Ssmall_image_beginS));
    goto L7627;}}
 L7627: {
  n_536X = arg0K0;
  Ssmall_image_endS = ((Ssmall_image_beginS) + (-4096 & (4095 + n_536X)));
  v_537X = (Slarge_image_hpS) - (Slarge_image_beginS);
  if ((0 == v_537X)) {
    arg0K0 = 1;
    goto L7638;}
  else {
    arg0K0 = ((Slarge_image_hpS) - (Slarge_image_beginS));
    goto L7638;}}
 L7638: {
  n_538X = arg0K0;
  Slarge_image_endS = ((Slarge_image_beginS) + (-4096 & (4095 + n_538X)));
  v_539X = (Sweaks_image_hpS) - (Sweaks_image_beginS);
  if ((0 == v_539X)) {
    arg0K0 = 1;
    goto L7649;}
  else {
    arg0K0 = ((Sweaks_image_hpS) - (Sweaks_image_beginS));
    goto L7649;}}
 L7649: {
  n_540X = arg0K0;
  Sweaks_image_endS = ((Sweaks_image_beginS) + (-4096 & (4095 + n_540X)));
  arg0K0 = 0;
  goto L4797;}
 L4797: {
  i_541X = arg0K0;
  if ((i_541X == ((Sbibop_areasS)->large_index))) {
    Slarge_image_beginS = ((Ssmall_image_endS) + (((long) (Slarge_image_beginS))));
    Slarge_image_hpS = ((Ssmall_image_endS) + (((long) (Slarge_image_hpS))));
    Slarge_image_endS = ((Ssmall_image_endS) + (((long) (Slarge_image_endS))));
    arg0K0 = 0;
    goto L4932;}
  else {
    stob_542X = *(((Sbibop_areasS)->large) + i_541X);
    if ((3 == (3 & stob_542X))) {
      if ((1 == stob_542X)) {
        goto L4839;}
      else {
        image_location_543X = table_ref(stob_table_534X, stob_542X);
        image_location_543X->new_descriptor = (3 + (((long) ((Ssmall_image_endS) + (((long) (((char *) (-3 + (image_location_543X->new_descriptor))))))))));
        goto L4839;}}
    else {
      goto L4839;}}}
 L4932: {
  i_544X = arg0K0;
  if ((i_544X == ((Sbibop_areasS)->weaks_index))) {
    Sweaks_image_beginS = ((Slarge_image_endS) + (((long) (Sweaks_image_beginS))));
    Sweaks_image_hpS = ((Slarge_image_endS) + (((long) (Sweaks_image_hpS))));
    Sweaks_image_endS = ((Slarge_image_endS) + (((long) (Sweaks_image_endS))));
    if ((0 < ((Sstob_tableS)->size))) {
      resumer_records_545X = Sresumer_recordsS;
      if (((SstatusS) == NO_ERRORS)) {
        PS_WRITE_CHAR(10, port_506X, v_546X)
        SstatusS = v_546X;
        goto L6859;}
      else {
        goto L6859;}}
    else {
      table_547X = Sstob_tableS;
      keys_548X = table_547X->keys;
      values_549X = table_547X->values;
      arg0K0 = 0;
      goto L15790;}}
  else {
    stob_550X = *(((Sbibop_areasS)->weaks) + i_544X);
    if ((3 == (3 & stob_550X))) {
      if ((1 == stob_550X)) {
        goto L4974;}
      else {
        image_location_551X = table_ref(stob_table_534X, stob_550X);
        image_location_551X->new_descriptor = (3 + (((long) ((Slarge_image_endS) + (((long) (((char *) (-3 + (image_location_551X->new_descriptor))))))))));
        goto L4974;}}
    else {
      goto L4974;}}}
 L4839: {
  arg0K0 = (1 + i_541X);
  goto L4797;}
 L6859: {
  if (((SstatusS) == NO_ERRORS)) {
    PS_WRITE_CHAR(12, (Simage_portS), v_552X)
    SstatusS = v_552X;
    goto L6861;}
  else {
    goto L6861;}}
 L15790: {
  i_553X = arg0K0;
  if ((i_553X == (table_547X->size))) {
    free(keys_548X);
    free(values_549X);
    free(table_547X);
    free((Simage_bufferS));
    return ENOMEM;}
  else {
    if ((0 == (*(keys_548X + i_553X)))) {
      goto L15792;}
    else {
      free((*(values_549X + i_553X)));
      goto L15792;}}}
 L4974: {
  arg0K0 = (1 + i_544X);
  goto L4932;}
 L6861: {
  if (((SstatusS) == NO_ERRORS)) {
    PS_WRITE_CHAR(10, port_506X, v_554X)
    SstatusS = v_554X;
    goto L6870;}
  else {
    goto L6870;}}
 L15792: {
  arg0K0 = (1 + i_553X);
  goto L15790;}
 L6870: {
  if (((SstatusS) == NO_ERRORS)) {
    SstatusS = (ps_write_string("Vanilla 34", port_506X));
    goto L6877;}
  else {
    goto L6877;}}
 L6877: {
  if (((SstatusS) == NO_ERRORS)) {
    PS_WRITE_CHAR(10, port_506X, v_555X)
    SstatusS = v_555X;
    goto L6886;}
  else {
    goto L6886;}}
 L6886: {
  if (((SstatusS) == NO_ERRORS)) {
    SstatusS = (ps_write_integer(1, port_506X));
    goto L6893;}
  else {
    goto L6893;}}
 L6893: {
  if (((SstatusS) == NO_ERRORS)) {
    PS_WRITE_CHAR(10, port_506X, v_556X)
    SstatusS = v_556X;
    goto L6902;}
  else {
    goto L6902;}}
 L6902: {
  if (((SstatusS) == NO_ERRORS)) {
    SstatusS = (ps_write_integer(4, (Simage_portS)));
    goto L6965;}
  else {
    goto L6965;}}
 L6965: {
  if (((SstatusS) == NO_ERRORS)) {
    PS_WRITE_CHAR(10, (Simage_portS), v_557X)
    SstatusS = v_557X;
    goto L6904;}
  else {
    goto L6904;}}
 L6904: {
  cells_558X = ((long) (Ssmall_image_beginS));
  if (((SstatusS) == NO_ERRORS)) {
    SstatusS = (ps_write_integer((((cells_558X)>>2)), (Simage_portS)));
    goto L6982;}
  else {
    goto L6982;}}
 L6982: {
  if (((SstatusS) == NO_ERRORS)) {
    PS_WRITE_CHAR(10, (Simage_portS), v_559X)
    SstatusS = v_559X;
    goto L6908;}
  else {
    goto L6908;}}
 L6908: {
  cells_560X = ((long) (Ssmall_image_hpS));
  if (((SstatusS) == NO_ERRORS)) {
    SstatusS = (ps_write_integer((((cells_560X)>>2)), (Simage_portS)));
    goto L6999;}
  else {
    goto L6999;}}
 L6999: {
  if (((SstatusS) == NO_ERRORS)) {
    PS_WRITE_CHAR(10, (Simage_portS), v_561X)
    SstatusS = v_561X;
    goto L6912;}
  else {
    goto L6912;}}
 L6912: {
  cells_562X = ((long) (Slarge_image_beginS));
  if (((SstatusS) == NO_ERRORS)) {
    SstatusS = (ps_write_integer((((cells_562X)>>2)), (Simage_portS)));
    goto L7016;}
  else {
    goto L7016;}}
 L7016: {
  if (((SstatusS) == NO_ERRORS)) {
    PS_WRITE_CHAR(10, (Simage_portS), v_563X)
    SstatusS = v_563X;
    goto L6916;}
  else {
    goto L6916;}}
 L6916: {
  cells_564X = ((long) (Slarge_image_hpS));
  if (((SstatusS) == NO_ERRORS)) {
    SstatusS = (ps_write_integer((((cells_564X)>>2)), (Simage_portS)));
    goto L7033;}
  else {
    goto L7033;}}
 L7033: {
  if (((SstatusS) == NO_ERRORS)) {
    PS_WRITE_CHAR(10, (Simage_portS), v_565X)
    SstatusS = v_565X;
    goto L6920;}
  else {
    goto L6920;}}
 L6920: {
  cells_566X = ((long) (Sweaks_image_beginS));
  if (((SstatusS) == NO_ERRORS)) {
    SstatusS = (ps_write_integer((((cells_566X)>>2)), (Simage_portS)));
    goto L7050;}
  else {
    goto L7050;}}
 L7050: {
  if (((SstatusS) == NO_ERRORS)) {
    PS_WRITE_CHAR(10, (Simage_portS), v_567X)
    SstatusS = v_567X;
    goto L6924;}
  else {
    goto L6924;}}
 L6924: {
  cells_568X = ((long) (Sweaks_image_hpS));
  if (((SstatusS) == NO_ERRORS)) {
    SstatusS = (ps_write_integer((((cells_568X)>>2)), (Simage_portS)));
    goto L7067;}
  else {
    goto L7067;}}
 L7067: {
  if (((SstatusS) == NO_ERRORS)) {
    PS_WRITE_CHAR(10, (Simage_portS), v_569X)
    SstatusS = v_569X;
    goto L6928;}
  else {
    goto L6928;}}
 L6928: {
  cells_570X = ((long) (Sweaks_image_endS));
  if (((SstatusS) == NO_ERRORS)) {
    SstatusS = (ps_write_integer((((cells_570X)>>2)), (Simage_portS)));
    goto L7084;}
  else {
    goto L7084;}}
 L7084: {
  if (((SstatusS) == NO_ERRORS)) {
    PS_WRITE_CHAR(10, (Simage_portS), v_571X)
    SstatusS = v_571X;
    goto L6932;}
  else {
    goto L6932;}}
 L6932: {
  thing_572X = s48_symbol_table();
  if ((3 == (3 & thing_572X))) {
    have_573X = table_ref((Sstob_tableS), thing_572X);
    if ((NULL == have_573X)) {
      ps_error("traced object has no descriptor in image", 0);
      goto L16027;}
    else {
      goto L16027;}}
  else {
    arg0K0 = thing_572X;
    goto L6936;}}
 L16027: {
  arg0K0 = (have_573X->new_descriptor);
  goto L6936;}
 L6936: {
  n_574X = arg0K0;
  if (((SstatusS) == NO_ERRORS)) {
    SstatusS = (ps_write_integer(n_574X, (Simage_portS)));
    goto L7098;}
  else {
    goto L7098;}}
 L7098: {
  if (((SstatusS) == NO_ERRORS)) {
    PS_WRITE_CHAR(10, (Simage_portS), v_575X)
    SstatusS = v_575X;
    goto L6938;}
  else {
    goto L6938;}}
 L6938: {
  thing_576X = s48_imported_bindings();
  if ((3 == (3 & thing_576X))) {
    have_577X = table_ref((Sstob_tableS), thing_576X);
    if ((NULL == have_577X)) {
      ps_error("traced object has no descriptor in image", 0);
      goto L16041;}
    else {
      goto L16041;}}
  else {
    arg0K0 = thing_576X;
    goto L6942;}}
 L16041: {
  arg0K0 = (have_577X->new_descriptor);
  goto L6942;}
 L6942: {
  n_578X = arg0K0;
  if (((SstatusS) == NO_ERRORS)) {
    SstatusS = (ps_write_integer(n_578X, (Simage_portS)));
    goto L7112;}
  else {
    goto L7112;}}
 L7112: {
  if (((SstatusS) == NO_ERRORS)) {
    PS_WRITE_CHAR(10, (Simage_portS), v_579X)
    SstatusS = v_579X;
    goto L6944;}
  else {
    goto L6944;}}
 L6944: {
  thing_580X = s48_exported_bindings();
  if ((3 == (3 & thing_580X))) {
    have_581X = table_ref((Sstob_tableS), thing_580X);
    if ((NULL == have_581X)) {
      ps_error("traced object has no descriptor in image", 0);
      goto L16055;}
    else {
      goto L16055;}}
  else {
    arg0K0 = thing_580X;
    goto L6948;}}
 L16055: {
  arg0K0 = (have_581X->new_descriptor);
  goto L6948;}
 L6948: {
  n_582X = arg0K0;
  if (((SstatusS) == NO_ERRORS)) {
    SstatusS = (ps_write_integer(n_582X, (Simage_portS)));
    goto L7126;}
  else {
    goto L7126;}}
 L7126: {
  if (((SstatusS) == NO_ERRORS)) {
    PS_WRITE_CHAR(10, (Simage_portS), v_583X)
    SstatusS = v_583X;
    goto L6950;}
  else {
    goto L6950;}}
 L6950: {
  if (((SstatusS) == NO_ERRORS)) {
    SstatusS = (ps_write_integer(resumer_records_545X, (Simage_portS)));
    goto L7140;}
  else {
    goto L7140;}}
 L7140: {
  if (((SstatusS) == NO_ERRORS)) {
    PS_WRITE_CHAR(10, (Simage_portS), v_584X)
    SstatusS = v_584X;
    goto L6952;}
  else {
    goto L6952;}}
 L6952: {
  if (((SstatusS) == NO_ERRORS)) {
    SstatusS = (ps_write_integer(resume_proc_517X, (Simage_portS)));
    goto L7154;}
  else {
    goto L7154;}}
 L7154: {
  if (((SstatusS) == NO_ERRORS)) {
    PS_WRITE_CHAR(10, (Simage_portS), v_585X)
    SstatusS = v_585X;
    goto L6954;}
  else {
    goto L6954;}}
 L6954: {
  if (((SstatusS) == NO_ERRORS)) {
    PS_WRITE_CHAR(12, (Simage_portS), v_586X)
    SstatusS = v_586X;
    goto L15691;}
  else {
    goto L15691;}}
 L15691: {
write_descriptor(1);
  arg0K0 = 0;
  goto L4473;}
 L4473: {
  i_587X = arg0K0;
  if ((i_587X == ((Sbibop_areasS)->weaks_index))) {
    goto L4461;}
  else {
    if ((1 == (*(((Sbibop_areasS)->weaks) + i_587X)))) {
      goto L4461;}
    else {
      merged_arg0K0 = (*(((Sbibop_areasS)->weaks) + i_587X));
      write_stob_return_tag = 0;
      goto write_stob;
     write_stob_return_0:
      arg0K0 = (1 + i_587X);
      goto L4473;}}}
 L4461: {
  arg0K0 = 0;
  goto L4492;}
 L4492: {
  i_588X = arg0K0;
  if ((i_588X == ((Sbibop_areasS)->large_index))) {
    goto L4463;}
  else {
    if ((1 == (*(((Sbibop_areasS)->large) + i_588X)))) {
      goto L4463;}
    else {
      merged_arg0K0 = (*(((Sbibop_areasS)->large) + i_588X));
      write_stob_return_tag = 1;
      goto write_stob;
     write_stob_return_1:
      arg0K0 = (1 + i_588X);
      goto L4492;}}}
 L4463: {
  arg0K0 = 0;
  goto L4511;}
 L4511: {
  i_589X = arg0K0;
  if ((i_589X == ((Sbibop_areasS)->small_index))) {
    goto L14893;}
  else {
    if ((1 == (*(((Sbibop_areasS)->small) + i_589X)))) {
      goto L14893;}
    else {
      merged_arg0K0 = (*(((Sbibop_areasS)->small) + i_589X));
      write_stob_return_tag = 2;
      goto write_stob;
     write_stob_return_2:
      arg0K0 = (1 + i_589X);
      goto L4511;}}}
 L14893: {
  table_590X = s48_symbol_table();write_descriptor((*((long *) ((((char *) (-3 + table_590X))) + -4))));
  arg0K0 = 0;
  goto L11644;}
 L11644: {
  i_591X = arg0K0;
  if ((i_591X == ((((3 + ((long)(((unsigned long)(*((long *) ((((char *) (-3 + table_590X))) + -4))))>>8))))>>2)))) {
    v_592X = s48_imported_bindings();
    merged_arg0K0 = v_592X;
    write_shared_table_return_tag = 0;
    goto write_shared_table;
   write_shared_table_return_0:
    v_593X = s48_exported_bindings();
    merged_arg0K0 = v_593X;
    write_shared_table_return_tag = 1;
    goto write_shared_table;
   write_shared_table_return_1:write_descriptor((10 + ((((Sresumer_countS))<<10))));
    arg0K0 = (Sfirst_stobS);
    goto L14914;}
  else {
    link_594X = *((long *) ((((char *) (-3 + table_590X))) + (((i_591X)<<2))));
    if ((0 == (3 & link_594X))) {
      arg0K0 = (3 + (-4 & link_594X));
      goto L11654;}
    else {
      arg0K0 = link_594X;
      goto L11654;}}}
 L14914: {
  stob_595X = arg0K0;
  if ((3 == (3 & stob_595X))) {
    location_596X = table_ref((Sstob_tableS), stob_595X);
    v_597X = resumer_recordP(stob_595X);
    if (v_597X) {write_descriptor((location_596X->new_descriptor));
      goto L14921;}
    else {
      goto L14921;}}
  else {
    have_598X = (Simage_buffer_pointerS) - (Simage_bufferS);
    if ((0 < have_598X)) {
      if (((SstatusS) == NO_ERRORS)) {
        SstatusS = (ps_write_block((Simage_portS), ((char *) (Simage_bufferS)), have_598X));
        goto L15736;}
      else {
        goto L15736;}}
    else {
      goto L15697;}}}
 L11654: {
  symbol_599X = arg0K0;
  arg0K0 = symbol_599X;
  goto L11688;}
 L14921: {
  arg0K0 = (location_596X->next);
  goto L14914;}
 L15736: {
  Simage_buffer_pointerS = (Simage_bufferS);
  goto L15697;}
 L15697: {
  table_600X = Sstob_tableS;
  keys_601X = table_600X->keys;
  values_602X = table_600X->values;
  arg0K0 = 0;
  goto L15756;}
 L11688: {
  next_603X = arg0K0;
  if ((3 == (3 & next_603X))) {
    v_604X = table_ref((Sstob_tableS), next_603X);
    if ((NULL == v_604X)) {
      link_605X = *((long *) ((((char *) (-3 + next_603X))) + 4));
      if ((0 == (3 & link_605X))) {
        arg0K0 = (3 + (-4 & link_605X));
        goto L11688;}
      else {
        arg0K0 = link_605X;
        goto L11688;}}
    else {
      arg0K0 = next_603X;
      goto L11656;}}
  else {
    arg0K0 = next_603X;
    goto L11656;}}
 L15756: {
  i_606X = arg0K0;
  if ((i_606X == (table_600X->size))) {
    free(keys_601X);
    free(values_602X);
    free(table_600X);
    free((Simage_bufferS));
    return (SstatusS);}
  else {
    if ((0 == (*(keys_601X + i_606X)))) {
      goto L15758;}
    else {
      free((*(values_602X + i_606X)));
      goto L15758;}}}
 L11656: {
  thing_607X = arg0K0;
  if ((3 == (3 & thing_607X))) {
    have_608X = table_ref((Sstob_tableS), thing_607X);
    if ((NULL == have_608X)) {
      ps_error("traced object has no descriptor in image", 0);
      goto L11707;}
    else {
      goto L11707;}}
  else {
    arg0K0 = thing_607X;
    goto L11658;}}
 L15758: {
  arg0K0 = (1 + i_606X);
  goto L15756;}
 L11707: {
  arg0K0 = (have_608X->new_descriptor);
  goto L11658;}
 L11658: {
  value_609X = arg0K0;
  if ((3 == (3 & value_609X))) {
    arg0K0 = (-4 & value_609X);
    goto L11660;}
  else {
    arg0K0 = value_609X;
    goto L11660;}}
 L11660: {
  v_610X = arg0K0;write_descriptor(v_610X);
  arg0K0 = (1 + i_591X);
  goto L11644;}
 copy_image_data: {
  start_509X = merged_arg1K0;
  size_510X = merged_arg0K1;{
  memmove((void *)(Simage_buffer_pointerS), (void *)start_509X,size_510X);
  Simage_buffer_pointerS = ((Simage_buffer_pointerS) + size_510X);
  if ((4096 == ((Simage_buffer_pointerS) - (Simage_bufferS)))) {
    have_611X = (Simage_buffer_pointerS) - (Simage_bufferS);
    if ((0 < have_611X)) {
      if (((SstatusS) == NO_ERRORS)) {
        SstatusS = (ps_write_block((Simage_portS), ((char *) (Simage_bufferS)), have_611X));
        goto L7366;}
      else {
        goto L7366;}}
    else {
      goto copy_image_data_return;}}
  else {
    goto copy_image_data_return;}}
 L7366: {
  Simage_buffer_pointerS = (Simage_bufferS);
  goto copy_image_data_return;}
 copy_image_data_return:
  switch (copy_image_data_return_tag) {
  case 0: goto copy_image_data_return_0;
  case 1: goto copy_image_data_return_1;
  default: goto copy_image_data_return_2;
  }}

 write_stob: {
  stob_508X = merged_arg0K0;{
  if ((3 == (3 & stob_508X))) {
    if ((13 == (31 & ((((*((long *) ((((char *) (-3 + stob_508X))) + -4))))>>2))))) {write_descriptor(1078);
      thing_612X = *((long *) (((char *) (-3 + stob_508X))));
      if ((3 == (3 & thing_612X))) {
        v_613X = table_ref((Sstob_tableS), thing_612X);
        if ((NULL == v_613X)) {
          write_descriptor(1);
          goto write_stob_return;}
        else {
          goto L13531;}}
      else {
        goto L13531;}}
    else {
      goto L13537;}}
  else {
    goto L13537;}}
 L13531: {
  thing_614X = *((long *) (((char *) (-3 + stob_508X))));
  if ((3 == (3 & thing_614X))) {
    have_615X = table_ref((Sstob_tableS), thing_614X);
    if ((NULL == have_615X)) {
      ps_error("traced object has no descriptor in image", 0);
      goto L13595;}
    else {
      goto L13595;}}
  else {
    write_descriptor(thing_614X);
    goto write_stob_return;}}
 L13537: {
  if ((3 == (3 & stob_508X))) {
    if ((6 == (31 & ((((*((long *) ((((char *) (-3 + stob_508X))) + -4))))>>2))))) {
      header_616X = *((long *) ((((char *) (-3 + stob_508X))) + -4));write_descriptor(header_616X);write_descriptor(0);
      start_617X = (((char *) (-3 + stob_508X))) + 4;
      arg1K0 = start_617X;
      goto L10704;}
    else {
      goto L13541;}}
  else {
    goto L13541;}}
 L13595: {
  write_descriptor((have_615X->new_descriptor));
  goto write_stob_return;}
 L10704: {
  addr_618X = arg1K0;
  if ((addr_618X == (start_617X + (-4 + (-4 & (3 + ((long)(((unsigned long)header_616X)>>8)))))))) {
    ps_write_string("Channel closed in dumped image: ", (stderr));
    id_619X = *((long *) ((((char *) (-3 + stob_508X))) + 4));
    if ((0 == (3 & id_619X))) {
      ps_write_integer((((id_619X)>>2)), (stderr));
      goto L10681;}
    else {
      ps_write_string((((char *)(((char *) (-3 + id_619X))))), (stderr));
      goto L10681;}}
  else {
    thing_620X = *((long *) addr_618X);
    if ((3 == (3 & thing_620X))) {
      have_621X = table_ref((Sstob_tableS), thing_620X);
      if ((NULL == have_621X)) {
        ps_error("traced object has no descriptor in image", 0);
        goto L10718;}
      else {
        goto L10718;}}
    else {
      arg0K0 = thing_620X;
      goto L10709;}}}
 L13541: {
  if ((3 == (3 & stob_508X))) {
    if ((1 == (31 & ((((*((long *) ((((char *) (-3 + stob_508X))) + -4))))>>2))))) {
      link_622X = *((long *) ((((char *) (-3 + stob_508X))) + 4));
      if ((0 == (3 & link_622X))) {
        arg0K0 = (3 + (-4 & link_622X));
        goto L12490;}
      else {
        arg0K0 = link_622X;
        goto L12490;}}
    else {
      goto L13545;}}
  else {
    goto L13545;}}
 L10681: {
  { long ignoreXX;
  PS_WRITE_CHAR(10, (stderr), ignoreXX) }
  goto write_stob_return;}
 L10718: {
  arg0K0 = (have_621X->new_descriptor);
  goto L10709;}
 L10709: {
  v_623X = arg0K0;write_descriptor(v_623X);
  arg1K0 = (addr_618X + 4);
  goto L10704;}
 L12490: {
  symbol_624X = arg0K0;
  arg0K0 = symbol_624X;
  goto L12523;}
 L13545: {
  if ((3 == (3 & stob_508X))) {
    if ((14 == (31 & ((((*((long *) ((((char *) (-3 + stob_508X))) + -4))))>>2))))) {
      link_625X = *((long *) ((((char *) (-3 + stob_508X))) + 12));
      if ((0 == (3 & link_625X))) {
        arg0K0 = (3 + (-4 & link_625X));
        goto L12333;}
      else {
        arg0K0 = link_625X;
        goto L12333;}}
    else {
      goto L13549;}}
  else {
    goto L13549;}}
 L12523: {
  next_626X = arg0K0;
  if ((3 == (3 & next_626X))) {
    v_627X = table_ref((Sstob_tableS), next_626X);
    if ((NULL == v_627X)) {
      link_628X = *((long *) ((((char *) (-3 + next_626X))) + 4));
      if ((0 == (3 & link_628X))) {
        arg0K0 = (3 + (-4 & link_628X));
        goto L12523;}
      else {
        arg0K0 = link_628X;
        goto L12523;}}
    else {
      arg0K0 = next_626X;
      goto L12492;}}
  else {
    arg0K0 = next_626X;
    goto L12492;}}
 L12333: {
  shared_629X = arg0K0;
  arg0K0 = shared_629X;
  goto L12382;}
 L13549: {
  header_630X = *((long *) ((((char *) (-3 + stob_508X))) + -4));
  start_631X = ((char *) (-3 + stob_508X));write_descriptor(header_630X);
  if ((2 == (3 & header_630X))) {
    if (((31 & (((header_630X)>>2))) < 16)) {
      goto L13565;}
    else {
      size_632X = -4 & (3 + ((long)(((unsigned long)header_630X)>>8)));
      available_633X = 4096 - ((Simage_buffer_pointerS) - (Simage_bufferS));
      if ((available_633X < size_632X)) {
        if ((4096 < size_632X)) {
          have_634X = (Simage_buffer_pointerS) - (Simage_bufferS);
          if ((0 < have_634X)) {
            if (((SstatusS) == NO_ERRORS)) {
              SstatusS = (ps_write_block((Simage_portS), ((char *) (Simage_bufferS)), have_634X));
              goto L9770;}
            else {
              goto L9770;}}
          else {
            goto L9744;}}
        else {
          merged_arg1K0 = start_631X;
          merged_arg0K1 = available_633X;
          copy_image_data_return_tag = 0;
          goto copy_image_data;
         copy_image_data_return_0:
          merged_arg1K0 = (start_631X + available_633X);
          merged_arg0K1 = (size_632X - available_633X);
          copy_image_data_return_tag = 1;
          goto copy_image_data;
         copy_image_data_return_1:
          goto write_stob_return;}}
      else {
        merged_arg1K0 = start_631X;
        merged_arg0K1 = size_632X;
        copy_image_data_return_tag = 2;
        goto copy_image_data;
       copy_image_data_return_2:
        goto write_stob_return;}}}
  else {
    goto L13565;}}
 L12492: {
  next_635X = arg0K0;
  header_636X = *((long *) ((((char *) (-3 + stob_508X))) + -4));write_descriptor(header_636X);
  start_637X = ((char *) (-3 + stob_508X));
  arg1K0 = start_637X;
  goto L12552;}
 L12382: {
  next_638X = arg0K0;
  if ((3 == (3 & next_638X))) {
    v_639X = table_ref((Sstob_tableS), next_638X);
    if ((NULL == v_639X)) {
      link_640X = *((long *) ((((char *) (-3 + next_638X))) + 12));
      if ((0 == (3 & link_640X))) {
        arg0K0 = (3 + (-4 & link_640X));
        goto L12382;}
      else {
        arg0K0 = link_640X;
        goto L12382;}}
    else {
      arg0K0 = next_638X;
      goto L12335;}}
  else {
    arg0K0 = next_638X;
    goto L12335;}}
 L13565: {
  arg1K0 = start_631X;
  goto L13667;}
 L9770: {
  Simage_buffer_pointerS = (Simage_bufferS);
  goto L9744;}
 L9744: {
  if (((SstatusS) == NO_ERRORS)) {
    SstatusS = (ps_write_block((Simage_portS), ((char *) start_631X), size_632X));
    goto write_stob_return;}
  else {
    goto write_stob_return;}}
 L12552: {
  addr_641X = arg1K0;
  if ((addr_641X == (start_637X + (-4 + (-4 & (3 + ((long)(((unsigned long)header_636X)>>8)))))))) {
    if ((3 == (3 & next_635X))) {
      have_642X = table_ref((Sstob_tableS), next_635X);
      if ((NULL == have_642X)) {
        ps_error("traced object has no descriptor in image", 0);
        goto L12582;}
      else {
        goto L12582;}}
    else {
      arg0K0 = next_635X;
      goto L12505;}}
  else {
    thing_643X = *((long *) addr_641X);
    if ((3 == (3 & thing_643X))) {
      have_644X = table_ref((Sstob_tableS), thing_643X);
      if ((NULL == have_644X)) {
        ps_error("traced object has no descriptor in image", 0);
        goto L12566;}
      else {
        goto L12566;}}
    else {
      arg0K0 = thing_643X;
      goto L12557;}}}
 L12335: {
  next_645X = arg0K0;
  header_646X = *((long *) ((((char *) (-3 + stob_508X))) + -4));write_descriptor(header_646X);
  start_647X = ((char *) (-3 + stob_508X));
  arg1K0 = start_647X;
  goto L12411;}
 L13667: {
  addr_648X = arg1K0;
  if ((addr_648X == (start_631X + (-4 & (3 + ((long)(((unsigned long)header_630X)>>8))))))) {
    goto write_stob_return;}
  else {
    thing_649X = *((long *) addr_648X);
    if ((3 == (3 & thing_649X))) {
      have_650X = table_ref((Sstob_tableS), thing_649X);
      if ((NULL == have_650X)) {
        ps_error("traced object has no descriptor in image", 0);
        goto L13681;}
      else {
        goto L13681;}}
    else {
      arg0K0 = thing_649X;
      goto L13672;}}}
 L12582: {
  arg0K0 = (have_642X->new_descriptor);
  goto L12505;}
 L12505: {
  value_651X = arg0K0;
  if ((3 == (3 & value_651X))) {
    write_descriptor((-4 & value_651X));
    goto write_stob_return;}
  else {
    write_descriptor(value_651X);
    goto write_stob_return;}}
 L12566: {
  arg0K0 = (have_644X->new_descriptor);
  goto L12557;}
 L12557: {
  v_652X = arg0K0;write_descriptor(v_652X);
  arg1K0 = (addr_641X + 4);
  goto L12552;}
 L12411: {
  addr_653X = arg1K0;
  if ((addr_653X == (start_647X + (-8 + (-4 & (3 + ((long)(((unsigned long)header_646X)>>8)))))))) {
    x_654X = *((long *) ((((char *) (-3 + stob_508X))) + 4));
    if ((5 == x_654X)) {
      arg0K0 = 529;
      goto L12360;}
    else {
      thing_655X = *((long *) ((((char *) (-3 + stob_508X))) + 8));
      if ((3 == (3 & thing_655X))) {
        have_656X = table_ref((Sstob_tableS), thing_655X);
        if ((NULL == have_656X)) {
          ps_error("traced object has no descriptor in image", 0);
          goto L12472;}
        else {
          goto L12472;}}
      else {
        arg0K0 = thing_655X;
        goto L12360;}}}
  else {
    thing_657X = *((long *) addr_653X);
    if ((3 == (3 & thing_657X))) {
      have_658X = table_ref((Sstob_tableS), thing_657X);
      if ((NULL == have_658X)) {
        ps_error("traced object has no descriptor in image", 0);
        goto L12425;}
      else {
        goto L12425;}}
    else {
      arg0K0 = thing_657X;
      goto L12416;}}}
 L13681: {
  arg0K0 = (have_650X->new_descriptor);
  goto L13672;}
 L13672: {
  v_659X = arg0K0;write_descriptor(v_659X);
  arg1K0 = (addr_648X + 4);
  goto L13667;}
 L12360: {
  v_660X = arg0K0;write_descriptor(v_660X);
  if ((3 == (3 & next_645X))) {
    have_661X = table_ref((Sstob_tableS), next_645X);
    if ((NULL == have_661X)) {
      ps_error("traced object has no descriptor in image", 0);
      goto L12448;}
    else {
      goto L12448;}}
  else {
    arg0K0 = next_645X;
    goto L12364;}}
 L12472: {
  arg0K0 = (have_656X->new_descriptor);
  goto L12360;}
 L12425: {
  arg0K0 = (have_658X->new_descriptor);
  goto L12416;}
 L12416: {
  v_662X = arg0K0;write_descriptor(v_662X);
  arg1K0 = (addr_653X + 4);
  goto L12411;}
 L12448: {
  arg0K0 = (have_661X->new_descriptor);
  goto L12364;}
 L12364: {
  value_663X = arg0K0;
  if ((3 == (3 & value_663X))) {
    write_descriptor((-4 & value_663X));
    goto write_stob_return;}
  else {
    write_descriptor(value_663X);
    goto write_stob_return;}}
 write_stob_return:
  switch (write_stob_return_tag) {
  case 0: goto write_stob_return_0;
  case 1: goto write_stob_return_1;
  default: goto write_stob_return_2;
  }}

 write_shared_table: {
  table_507X = merged_arg0K0;{write_descriptor((*((long *) ((((char *) (-3 + table_507X))) + -4))));
  arg0K0 = 0;
  goto L11554;}
 L11554: {
  i_664X = arg0K0;
  temp_665X = i_664X == ((((3 + ((long)(((unsigned long)(*((long *) ((((char *) (-3 + table_507X))) + -4))))>>8))))>>2));
  if (temp_665X) {
    write_shared_table0_return_value = temp_665X;
    goto write_shared_table_return;}
  else {
    link_666X = *((long *) ((((char *) (-3 + table_507X))) + (((i_664X)<<2))));
    if ((0 == (3 & link_666X))) {
      arg0K0 = (3 + (-4 & link_666X));
      goto L11564;}
    else {
      arg0K0 = link_666X;
      goto L11564;}}}
 L11564: {
  shared_667X = arg0K0;
  arg0K0 = shared_667X;
  goto L11598;}
 L11598: {
  next_668X = arg0K0;
  if ((3 == (3 & next_668X))) {
    v_669X = table_ref((Sstob_tableS), next_668X);
    if ((NULL == v_669X)) {
      link_670X = *((long *) ((((char *) (-3 + next_668X))) + 12));
      if ((0 == (3 & link_670X))) {
        arg0K0 = (3 + (-4 & link_670X));
        goto L11598;}
      else {
        arg0K0 = link_670X;
        goto L11598;}}
    else {
      arg0K0 = next_668X;
      goto L11566;}}
  else {
    arg0K0 = next_668X;
    goto L11566;}}
 L11566: {
  thing_671X = arg0K0;
  if ((3 == (3 & thing_671X))) {
    have_672X = table_ref((Sstob_tableS), thing_671X);
    if ((NULL == have_672X)) {
      ps_error("traced object has no descriptor in image", 0);
      goto L11617;}
    else {
      goto L11617;}}
  else {
    arg0K0 = thing_671X;
    goto L11568;}}
 L11617: {
  arg0K0 = (have_672X->new_descriptor);
  goto L11568;}
 L11568: {
  value_673X = arg0K0;
  if ((3 == (3 & value_673X))) {
    arg0K0 = (-4 & value_673X);
    goto L11570;}
  else {
    arg0K0 = value_673X;
    goto L11570;}}
 L11570: {
  v_674X = arg0K0;write_descriptor(v_674X);
  arg0K0 = (1 + i_664X);
  goto L11554;}
 write_shared_table_return:
  switch (write_shared_table_return_tag) {
  case 0: goto write_shared_table_return_0;
  default: goto write_shared_table_return_1;
  }}

}void
s48_heap_init(void)
{
Smax_heap_sizeS = 0;
Smin_heap_sizeS = 0;
Snew_small_start_addrS = NULL;
Snew_large_start_addrS = NULL;
Snew_weaks_start_addrS = NULL;
SstatusS = NO_ERRORS;
SeofPS = 0;
Sstartup_procedureS = 0;
SsymbolsS = 0;
Simported_bindingsS = 0;
Sexported_bindingsS = 0;
Sresumer_recordsS = 0;
Simg_start_addrS = NULL;
Simg_end_addrS = NULL;
Simg_heap_sizeS = 0;
Ssmall_img_start_addrS = NULL;
Ssmall_img_hp_addrS = NULL;
Ssmall_img_end_addrS = NULL;
Ssmall_img_heap_sizeS = 0;
Slarge_img_start_addrS = NULL;
Slarge_img_hp_addrS = NULL;
Slarge_img_end_addrS = NULL;
Slarge_img_heap_sizeS = 0;
Sweaks_img_start_addrS = NULL;
Sweaks_img_hp_addrS = NULL;
Sweaks_img_end_addrS = NULL;
Sweaks_img_heap_sizeS = 0;
SoffsetS = 0;
SinitializingPS = 1;
SstatusS = NO_ERRORS;
small_image_start_address = 0;
Straced_last_stobPS = 0;
Sstob_table_obj_nrS = 0;
}
