/*
 * AUTHOR: Pedro Lineu Orso                      orso@penguintech.com.br
 *                                                            1998, 2005
 * SARG Squid Analysis Report Generator      http://sarg.sourceforge.net
 *
 * SARG donations:
 *      please look at http://sarg.sourceforge.net/donations.php
 * ---------------------------------------------------------------------
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 */

#include "include/conf.h"

void download_report()
{

   FILE *fp_in = NULL, *fp_ou = NULL;
      
   char url[MAXLEN];
   char html[MAXLEN];
   char html2[MAXLEN];
   char report_in[MAXLEN];
   char report_ou[MAXLEN];
   char wdirname[MAXLEN];
   char report[MAXLEN];
   char periodo[100];
   char ip[MAXLEN];
   char oip[MAXLEN];
   char user[MAXLEN];
   char ouser[MAXLEN];
   char ouser2[MAXLEN];
   char data[15];
   char hora[15];
   char ftime[128];
   char *str;
   int  z=0;
   int  count=0;

   ouser[0]='\0';

   sprintf(report_in,"%s/sarg/download.log",TempDir);
   if(access(report_in, R_OK) != 0)
      return;

   strcpy(wdirname,dirname);
   sprintf(report,"%s/download.html",wdirname);
   strcat(wdirname,"/");
   strcat(wdirname,"periodo");

   if ((fp_in = fopen(wdirname, "r")) == 0) {
      fprintf(stderr, "SARG: (download) %s: %s\n",text[45],wdirname);
      exit(1);
   }

   fgets(periodo,sizeof(periodo),fp_in);
   fclose(fp_in);

   if((fp_in=fopen(report_in,"r"))==NULL) {
     fprintf(stderr, "SARG: (download) %s: %s\n",text[8],report_in);
     exit(1);
   }

   if((fp_ou=fopen(report,"w"))==NULL) {
     fprintf(stderr, "SARG: (download) %s: %s\n",text[8],report);
     exit(1);
   }

   fputs("<html>\n",fp_ou);
   fputs("<head>\n",fp_ou);
   sprintf(html,"  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=%s\">\n",CharSet);
   fputs(html,fp_ou);
   css(fp_ou);
   fputs("</head>\n",fp_ou);

   sprintf(url,"<body bgcolor=%s text=%s background='%s'>\n",BgColor,TxColor,BgImage);
   fputs(url,fp_ou);

   fputs("<center><table cellpadding=0 cellspacing=0>\n",fp_ou);

   if(strlen(LogoImage) > 0) {
      fputs("<center><table cellpadding=\"0\" cellspacing=\"0\">\n",fp_ou);
      sprintf(url,"<tr><th class=\"logo\"><img src='%s' border=0 align=absmiddle width=%s height=%s>&nbsp;%s</th></tr>\n",LogoImage,Width,Height,LogoText);
      fputs(url,fp_ou);
      fputs("<tr><td height=\"5\"></td></tr>\n",fp_ou);
      fputs("</table>\n",fp_ou);
   }

   show_sarg(fp_ou, "..");
   sprintf(url,"<tr><th class=\"title\">%s</b></th></tr>\n",Title);
   fputs(url,fp_ou);

   sprintf(url,"<tr><td class=\"header\">%s: %s</td></tr>\n",text[89],periodo);
   fputs(url,fp_ou);
   sprintf(url,"<tr><th class=\"header3\">%s %s</th></tr>\n",text[125],text[55]);
   fputs(url,fp_ou);
   fputs("</table></center>\n",fp_ou);

   fputs("<center><table cellpadding=0 cellspacing=2>\n",fp_ou);
   fputs("<tr><td></td></tr>\n",fp_ou);
   fputs("<tr><td></td></tr>\n",fp_ou);
   fputs("<tr><td></td></tr>\n",fp_ou);
   sprintf(url,"<tr><th class=\"header\">%s</th><th class=\"header\">%s</th><th class=\"header\">%s</th><th class=\"header\">%s</th></tr>\n",text[98],text[111],text[110],text[91]);
   fputs(url,fp_ou);

   while(fgets(buf,sizeof(buf),fp_in)!=NULL) {
      getword(data,buf,' ');
      getword(hora,buf,' ');
      getword(user,buf,' ');
      getword(ip,buf,' ');
      getword(url,buf,' ');

      if((str=(char *) strstr(user, "_")) != (char *) NULL ) {
         if((str=(char *) strstr(str+1, "_")) != (char *) NULL )
            fixip(user);
      }

      if(strcmp(Ip2Name,"yes") == 0) 
         ip2name(ip);

      if(!z) {
         strcpy(ouser,user);
         strcpy(oip,ip);
         z++;
      } else {
         if(strcmp(ouser,user) == 0)
            user[0]='\0';
         if(user[0] != '\0')
            strcpy(ouser,user);
         if(strcmp(oip,ip) == 0) 
            ip[0]='\0';
         if(ip[0] != '\0')
            strcpy(oip,ip);
      }

      if(UserTabFile[0] != '\0') {
         sprintf(warea,":%s:",user);
         if((str=(char *) strstr(userfile,warea)) != (char *) NULL ) {
            z1=0;
            str2=(char *) strstr(str+1,":");
            str2++;
            bzero(name, MAXLEN);
            while(str2[z1] != ':') {
               name[z1]=str2[z1];
               z1++;
            }
         } else strcpy(name,user);
      } else strcpy(name,user);

      if(dotinuser && strstr(name,"_")) {
         str2=(char *)subs(name,"_",".");
         strcpy(name,str2);
      }

      if(DownloadReportLimit) {
         if(strcmp(ouser2,name) == 0) {
            count++; 
         } else {
            count=1;
            strcpy(ouser2,name);
         }
         if(count >= DownloadReportLimit)
            continue;
      }

      if(strlen(BlockIt) > 0)
         sprintf(BlockImage,"<a href=\"%s%s?url=%s\"><img src=\"../images/sarg-squidguard-block.png\" border=\"0\"></a>&nbsp;",wwwDocumentRoot,BlockIt,url);
      else BlockImage[0]='\0';

      sprintf(html2,"<tr><td class=\"data\">%s</td><td class=\"data\">%s</td><td class=\"data\">%s-%s</td><td class=\"data2\">%s<a href=\"%s\">%s</a></td></th>\n",name,ip,data,hora,BlockImage,url,url);
      fputs(html2,fp_ou);
   }

   fputs("</table>\n",fp_ou);

   show_info(fp_ou);
   fputs("</html>\n",fp_ou);

   fclose(fp_in);
   fclose(fp_ou);

   unlink(report_in);

   return;
}
