/* Copyright (c) 2000, Len Budney. See COPYING for details. */

#include "hostname.h"
#include "stralloc.h"
#include "strerr.h"
#include "tai.h"
#include "taia.h"
#include "fmt.h"
#include <unistd.h>

static
void die_nomem() { strerr_die2x(111,"safecat: fatal: ","out of memory"); }

/* ****************************************************************** */
void mk_tempfile(stralloc *tmpf) {
  char host[256];
  char secbuf[11];
  char atto[TAIA_FMTFRAC];
  struct taia now;
  struct tai sec;
  unsigned long int pid = (unsigned long)getpid();
  int b = 10;

  /* Get a microsecond timestamp with which to build a filename. */
  taia_now(&now);
  taia_tai(&now,&sec);

  /* Record the second timestamp on the string. */
  secbuf[fmt_uint64(secbuf,(uint64) sec.x - 4611686018427387904)] = '\0';
  if (!stralloc_cats(tmpf, secbuf)) die_nomem();
  if (!stralloc_append(tmpf, ".")) die_nomem();
  
  /* Record the millisecond timestamp + PID on the string. */
  taia_fmtfrac(atto,&now);
  atto[b--] = '\0';
  for(; b>5 || pid>0; pid /= 10) {
    atto[b--] = (char) ((pid % 10) + '0');
  }
  if (!stralloc_cats(tmpf, atto)) die_nomem();
  if (!stralloc_append(tmpf, ".")) die_nomem();
  
  /* Copy the hostname to the buffer. */
  get_hostname(host,sizeof(host));
  if (!stralloc_cats(tmpf, host)) die_nomem();
  if (!stralloc_0(tmpf)) die_nomem();
}
/* ****************************************************************** */


