/* -*- c-file-style: "ruby" -*- */
/************************************************

  rbgtkcheckmenuitem.c -

  $Author: klamath $
  $Date: 2001/10/04 02:13:39 $

  Copyright (C) 1998-2000 Yukihiro Matsumoto,
                          Daisuke Kanda,
                          Hiroshi Igarashi
************************************************/

#include "global.h"

static VALUE
cmitem_initialize(argc, argv, self)
    int argc;
    VALUE *argv;
{
    VALUE label;
    GtkWidget *widget;

    if (rb_scan_args(argc, argv, "01", &label) == 1) {
	widget = gtk_check_menu_item_new_with_label(STR2CSTR(label));
    }
    else {
	widget = gtk_check_menu_item_new();
    }

    set_widget(self, widget);
    return Qnil;
}

static VALUE
cmitem_set_state(self, state)
    VALUE self, state;
{
    gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(get_widget(self)), 
				  NUM2INT(state));
    return self;
}

static VALUE
cmitem_set_active(self, state)
    VALUE self, state;
{
    gtk_check_menu_item_set_state(GTK_CHECK_MENU_ITEM(get_widget(self)), 
				  RGTEST(state));
    return self;
}

static VALUE
cmitem_is_active(self)
    VALUE self;
{
    return GTK_CHECK_MENU_ITEM(get_widget(self))->active==0?Qfalse:Qtrue;
}

static VALUE
cmitem_set_show_toggle(self, always)
    VALUE self, always;
{
    gtk_check_menu_item_set_show_toggle(GTK_CHECK_MENU_ITEM(get_widget(self)), 
					(gboolean)RGTEST(always));
    return self;
}

static VALUE
cmitem_toggled(self)
    VALUE self;
{
    gtk_check_menu_item_toggled(GTK_CHECK_MENU_ITEM(get_widget(self)));
    return self;
}

void Init_gtk_check_menu_item()
{
    gCMenuItem = rb_define_class_under(mGtk, "CheckMenuItem", gMenuItem);

    rb_define_const(gCMenuItem, "SIGNAL_TOGGLED", rb_str_new2("toggled"));

    rb_define_method(gCMenuItem, "initialize", cmitem_initialize, -1);
    rb_define_method(gCMenuItem, "set_state", cmitem_set_state, 1);
    rb_define_method(gCMenuItem, "set_active", cmitem_set_active, 1);
    rb_define_method(gCMenuItem, "active=", cmitem_set_active, 1);
    rb_define_method(gCMenuItem, "active?", cmitem_is_active, 0);
    rb_define_method(gCMenuItem, "set_show_toggle", cmitem_set_show_toggle, 1);
    rb_define_method(gCMenuItem, "toggled", cmitem_toggled, 0);

    /* child initialization */
    Init_gtk_radio_menu_item();
}
