#! /bin/sh -

Basename="basename"
Split="split -l 100"

if [ "x$1" = "x" -o "x$1" = "x.h" ]; then
  echo "set input legal header file name."
  exit
fi
if [ "x$2" = "x" ]; then
  echo "set public function name."
  exit
fi

func=$2

if [ ! -r "$1" ]; then
  echo "cannot found $1"
  exit
fi

name=`$Basename $1 .h`

#echo "$name"
if [ ! -d "$name" ]; then
  mkdir $name || exit 1
  cd $name; $Split ../$name.h "_${name}."; cd ..
else
  rm -f $name/Makefile
fi

cp Makefile $name/Makefile
cd $name
echo "" >> Makefile
echo "# -----------------------------------------" >> Makefile
echo -n "../lib${name}.a: " >> Makefile

echo -n "${name}.o " >> Makefile

rm -f ${name}.[ch]
echo "#include \"ruby.h\"" >> ${name}.c
echo "#include <gdk/gdkkeysyms.h>" >> ${name}.c
echo "#include \"../global.h\"" >> ${name}.c
echo "#include \"${name}.h\"" >> ${name}.c
echo "void ${func}() {" >> ${name}.c

for i in _${name}.[a-z][a-z]; do
  echo -n "${i}.o " >> Makefile

  j=`echo $i | tr "." "_"`

  echo "extern void Init_gtk_${j}();" >> ${name}.h
  echo "	Init_gtk_${j}();" >> ${name}.c

  rm -f $i.c
  echo "#include \"ruby.h\"" >> $i.c
  echo "#include <gdk/gdkkeysyms.h>" >> $i.c
  echo "#include \"../global.h\"" >> $i.c
  echo "void Init_gtk_${j}() {" >> $i.c
  echo "  #include \"${i}\"" >> $i.c
  echo "}" >> $i.c
done

echo "}" >> ${name}.c

echo "" >> Makefile
echo "	\$(AR) -rs \$@ \$?" >> Makefile
echo "# if your \$(AR) don't accept -s options, test below:" >> Makefile
echo "#	\$(AR) -r \$@" >> Makefile
echo "#	\$(RANLIB) \$@" >> Makefile
