/* $Id: parse.y,v 1.3 2007/01/26 11:05:29 mbalmer Exp $ */

/*
 * Copyright (c) 2006 Marc Balmer <mbalmer@openbsd.org>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

%{
#include <err.h>
#include <stdarg.h>
#include <stdio.h>
#include <syslog.h>

extern FILE	*yyin;
extern int	 yylineno;
extern char	*yytext;

extern char	*cfgfile;
extern char	*host;

static int	 yyerrcnt;

int	yyerror(const char *, ...);
int	yyparse(void);
int	yylex(void);
%}

%union {
	long  number;
	char *string;
}

%token	STREAM TO HOST PORT
%token	<string>	NUMBER
%token	<string>	TEXT

%%
statement	: /* empty */
		| statement '\n'
		| statement stream '\n'
		;

stream		: STREAM TO TEXT			{
			if (host == NULL)
				host = $3;
			else
				free($3);
		}
		;
%%

void
rtunes_init(void)
{
	yylineno = 1;
	yyerrcnt = 0;
	if ((yyin = fopen(cfgfile, "r")) != NULL) {
		while (!feof(yyin))
			yyparse();
		fclose(yyin);
	}
	if (yyerrcnt)
		errx(1, "configuration file contains errors, terminating");
}

int
yyerror(const char *fmt, ...)
{
	va_list ap;
	char *nfmt;

	++yyerrcnt;
	va_start(ap, fmt);
	if (asprintf(&nfmt, "%s, line %d: %s near '%s'",
	    cfgfile, yylineno, fmt, yytext) == -1)
		errx(1, "yyerror asprintf");
	va_end(ap);
	fprintf(stderr, "%s\n", nfmt);
	free(nfmt);
	return 0;
}
