#!/usr/bin/perl
# Create rrdtool graph ... 

use CGI;
use POSIX;
use lib qw( ../rrdtool/lib/perl );
use RRDs;

my $query = new CGI;

$start = $query->param("start"); # Get params from URL
$end = $query->param("end");
$title = $query->param("title"); # Title of graph
$img_hight=$query->param("hight"); # Image size
$img_width=$query->param("width");

$expiredate = strftime "%a, %e %b %Y %H:%M:%S GMT", gmtime(time); # Formated date(now)

print "Content-type: image/png\n"; # Use html
print "Cache-Control: no-cache\n"; # Ensure no cashing of page
print "Expires: $expiredate\n"; # Expire now
print "Refresh: 30\n\n";

# Modify as needed ( first 2 lines contains parameters from map.cgi, need not be modified )
($avg,$xsize,$ysize) = RRDs::graph "-","--title", "$title",
"--height","$img_hight","--width","$img_width","--start",$start,"--end",$end,
"DEF:ut=../ballerup01.rrd:CPU_Utilization:AVERAGE","LINE1:ut#00FF00:CPU",
"DEF:mm=../ballerup01.rrd:Memory_Usage:AVERAGE","CDEF:kmm=mm,10.24,/","LINE2:kmm#FF0000:Mem",
"DEF:df=../ballerup01.rrd:D_Space_Remaining:AVERAGE","CDEF:kdf=df,1024,/","LINE3:kdf#0000FF:D_Free";

if ($ERROR = RRDs::error) {
  print "ERROR: $ERROR\n";
}
