#!/bin/sh

die() {
	echo "$*" >&2
	echo "Aborting..." >&2
	exit 1
}

# Create the directory if it doesn't exist. Exit if it can't be created.
endir() {
	if [ ! -d "$1" ]; then
		mkdir -p "$1" || die "Can't create $1 directory!"
	fi
}

confirm_or_die() {
	while [ 1 -eq 1 ]; do
		printf "[yes/no] >>> "
		read CONFIRM
		case $CONFIRM in
			[yY]*) return;;
			[nN]*) die "OK.";;
		esac
	done
}

# Installs a file in Choices if it isn't there already.
install_if_missing() {
	dest="$CHOICES/$1"
	if [ -f "$CHOICES/$1" ]; then
		echo "'$dest' already exists - skipping..."
	else
		echo "Installing '$dest'"
		cp "Choices/$1" $dest
	fi
}

cd `dirname $0`

umask 022


cat << EOF


These icons and defaults need to be installed where applications such
as ROX-Filer can find them. The directories searched are given by
the CHOICESPATH variable. In your case, the following would be checked:

EOF

if [ ! -n "$CHOICESPATH" ]; then
	CHOICESPATH=${HOME}/Choices:/usr/local/share/Choices:/usr/share/Choices
	echo "(CHOICESPATH unset - using default)"
fi
IFS=":"
WARN="  *** Warning : CHOICESPATH is set, but empty! ***\n"
MYCHOICES=""
for DIR in $CHOICESPATH; do
  if [ -n "$DIR" ]; then
    echo "    $DIR"
    WARN=""
    if [ ! -n "$MYCHOICES" ]; then
      MYCHOICES="$DIR"
    fi
  fi
done
printf "$WARN"
if [ ! -n "$MYCHOICES" ]; then
  MYCHOICES="${HOME}/Choices"
fi

cat << EOF

in that order. You can choose a different search path by setting
the CHOICESPATH environment variable before running the program.

Which Choices directory would you like to use? Option (1) is recommended
if you have root access; otherwise option (2) is best.

1) /usr/local/share/Choices
2) ${MYCHOICES}
3) /usr/share/Choices

Enter 1, 2, 3 or a path (starting with /):
EOF
printf ">>> "

read REPLY
echo

case $REPLY in
	1) CHOICES=/usr/local/share/Choices;;
	2) CHOICES=${MYCHOICES};;
	3) CHOICES=/usr/share/Choices;;
	/*) CHOICES="$REPLY"
	    echo "*** NOTE that if you install into a non-standard Choices "
	    echo "*** directory then you must ensure that CHOICESPATH is set "
	    echo "*** correctly before running any programs!"
	    echo;;
	*) die "Invalid choice!";;
esac

echo "Default icons and run actions will be installed into '$CHOICES'."

endir "$CHOICES"

if [ -d "$CHOICES/MIME-icons" ]; then
	cat << EOF
WARNING: You already have a $CHOICES/MIME-icons
directory --- any icons you have modified will be overwritten!

Continue?
EOF
	confirm_or_die
fi

endir "$CHOICES/MIME-icons"
endir "$CHOICES/MIME-info"
endir "$CHOICES/MIME-types"

echo "Installing icons..."
cp Choices/MIME-icons/* "$CHOICES/MIME-icons"

echo
echo "Installing handlers..."
install_if_missing MIME-types/application_postscript
install_if_missing MIME-types/text

echo "Installing rules for guessing MIME types."
cp Choices/MIME-info/* "$CHOICES/MIME-info"

echo
echo "OK, done. Now you can install and use ROX-Filer!"
