.TH ROOTTAIL 1 "2004-03-27" "Version 1.0"
.UC 5
.SH NAME
root-tail \- print text directly to X11 root window
.SH SYNOPSIS
.B root-tail
.RB [ \-g \|| --geometry
.IR GEOMETRY ]
.RB [ \-fn \|| --font
.IR FONTSPEC ]
.RB [ \--color
.IR color ]
.RB [ \--reload
.IR SEC
.IR COMMAND ]
.RB [ \--shade ]
.RB [ \--outline ]
.RB [ \--noflicker ]
.RB [ \-f \|| \--fork ]
.RB [ \--reverse ]
.RB [ \--whole ]
.RB [ \--partial ]
.RB [ \--update ]
.RB [ \--cont
.IR STRING ]
.RB [ \--wordwrap ]
.RB [ \--justify ]
.RB [ \--noinitial ]
.RB [ \--frame ]
.RB [ \-id
.IR ID ]
.RB [ \-i \|| \--interval
.IR SECONDS ]
.RB [ \-V ]
file1[,color[,desc]]
[file2[,color[,desc]]]
.\" Die Beschreibung
.SH DESCRIPTION
Displays a given file anywhere on your X11 root window with a transparent
background. It was made because I'm very lazy and this was easier than
making a new rxvt pixmap each time I changed my background to simulate
that transparent effect. A null desc (example: "/var/log/messages,red,")
will prevent the printing of a description and the []'s.
.PP
.SS General Options
.TP
.BI \--color " COLOR"
Use COLOR as default.
.TP
.BI "\--font \|| -fn" " FONTSPEC"
Use font FONTSPEC. This can be either a fixed width font like \fB-fn\fI
fixed\fR or any font using \fB-fn \fR'\fI-*-*-*-*-*-*-*-*-*-*-*-*-*-*\fR' with
the appropriate fields filled out (see xfontsel).  Specifying a
different FONTSPEC before each filename will cause each file to be
displayed in a different font.
.TP
.B -f \|| \--fork
Forks to the background.
.TP
.B \--reverse
Display the files in reverse order, with the newest lines at the top.
.TP
.B \--whole
Only display whole lines. If the last line of a file doesn't yet end
with a newline character then wait until it does before displaying
it. This is the default if more than one file is being displayed.
.TP
.B \--partial
This is the opposite of the \fB--whole\fR option (see above). It displays
lines even if they don't yet have a newline at the end. This is the
default if only one file is being displayed.
.TP
.B \--update
Update partial lines 'in place' if they are still on the screen when
they are updated in their files. Using \fB--update\fR automatically turns on
\fB--partial\fR.
.TP
.BI \--cont " STRING"
When partial lines are broken into two lines in the display, prefix
the 2nd line with STRING. Defaults to "\fI|| \fR". Specify the "\fB--whole\fR"
argument to ensure partial lines are never displayed, or specify "\fB--update\fR"
to attempt to "repair" broken lines in-place.
.TP
.BI \--cont-color " COLOR"
Use COLOR when displaying the continuation string (as optionally
specified with the \fB--cont\fR option above).
.TP
.B \--wordwrap
The default behaviour is to fit as much as possible onto each line of
output, even if this means splitting a word between one line and the
next. The \fB--wordwrap\fR argument splits lines at spaces if
possible.
.TP
.B \--justify
After wrapping long lines, attempt to justify the text to produce a
smooth right-hand margin.  Implies \fB--wordwrap\fR.
.TP
.BI \--reload " SEC COMMAND"
Re-display the file(s) and run COMMAND every SEC seconds. The
default is to never re-display the file(s).
.TP
.B \--shade
Add black shading to the font.
.TP
.B \--outline
Add a black outline to the font (making redraws quite a bit slower).
.TP
.B \--noflicker
Use slower but flicker-free update.
.TP
.B \--noinitial
Don't display the end of the file(s) initially.
.TP
.BI "\-id" " ID"
Use the given window ID for output instead of the root window.
.TP
.BI "\-i \|| \--interval" " SECONDS"
Use the specified sleeping interval between checks instead of the
default 2.4 seconds. Fractional values are OK.
.TP
.B \-V
Print version information.
.TP
.B \--frame
Draw a frame around the selected area.  This is useful when trying to
find the perfect geometry.
.IP
.SH EXAMPLE
.PP
root-tail -g 800x250+100+50 -font 10x20 /var/log/messages,green -font 12x24 /var/log/secure,red,'ALERT'
.SH BUGS
.PP
Some desktop environments open a virtual root window and make it difficult to share it. If
you cannot see anything after starting root-tail, try to find a setting "allow programs
on desktop" or similar, or manually specify a window id.
.PP
Should you happen to find any bugs please fix them and send me a diff.
.PP
NOTE: This program was modified by Marc Lehmann <pcg@goof.com>, who
couldn't reach the original author. Please direct bug-reports etc. to
pcg@goof.com.
.PP
http://root-tail.plan9.de/
