/***********************************************************
* Rocks'n'Diamonds -- McDuffin Strikes Back!               *
*----------------------------------------------------------*
* (c) 1995-2002 Artsoft Entertainment                      *
*               Holger Schemel                             *
*               Detmolder Strasse 189                      *
*               33604 Bielefeld                            *
*               Germany                                    *
*               e-mail: info@artsoft.org                   *
*----------------------------------------------------------*
* conf_gfx.c                                               *
***********************************************************/

#include "libgame/libgame.h"
#include "main.h"


/* List values that are not defined in the configuration file are set to
   reliable default values. If that value is GFX_ARG_UNDEFINED, it will
   be dynamically determined, using some of the other list values. */

struct ConfigTypeInfo image_config_suffix[] =
{
  { ".x",				ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".y",				ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".xpos",				ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".ypos",				ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".width",				ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".height",				ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".vertical",			"false",	TYPE_BOOLEAN	},
  { ".offset",				ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".xoffset",				ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".yoffset",				ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".2nd_movement_tile",		"false",	TYPE_BOOLEAN	},
  { ".2nd_vertical",			ARG_UNDEFINED,	TYPE_BOOLEAN	},
  { ".2nd_offset",			ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".2nd_xoffset",			ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".2nd_yoffset",			ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".2nd_swap_tiles",			ARG_UNDEFINED,	TYPE_BOOLEAN	},
  { ".frames",				ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".frames_per_line",			ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".start_frame",			ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".delay",				"1",		TYPE_INTEGER	},
  { ".anim_mode",			ARG_UNDEFINED,	TYPE_STRING	},
  { ".global_sync",			"false",	TYPE_BOOLEAN	},
  { ".crumbled_like",			ARG_UNDEFINED,	TYPE_TOKEN	},
  { ".diggable_like",			ARG_UNDEFINED,	TYPE_TOKEN	},
  { ".border_size",			ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".step_offset",			"4",		TYPE_INTEGER	},
  { ".step_delay",			"1",		TYPE_INTEGER	},
  { ".direction",			ARG_UNDEFINED,	TYPE_STRING	},
  { ".position",			ARG_UNDEFINED,	TYPE_STRING	},
  { ".draw_xoffset",			"0",		TYPE_INTEGER	},
  { ".draw_yoffset",			"0",		TYPE_INTEGER	},
  { ".draw_masked",			"false",	TYPE_BOOLEAN	},
  { ".anim_delay_fixed",		ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".anim_delay_random",		ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".post_delay_fixed",		ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".post_delay_random",		ARG_UNDEFINED,	TYPE_INTEGER	},
  { ".name",				ARG_UNDEFINED,	TYPE_STRING	},
  { ".scale_up_factor",			ARG_UNDEFINED,	TYPE_INTEGER	},

  { NULL,				NULL,		0		}
};

struct ConfigInfo image_config[] =
{
  /* images for Boulder Dash style elements and actions */

  { "bd_wall",					"RocksDC.pcx"		},
  { "bd_wall.xpos",				"12"			},
  { "bd_wall.ypos",				"9"			},
  { "bd_wall.frames",				"1"			},
  { "bd_wall.EDITOR",				"RocksDC.pcx"		},
  { "bd_wall.EDITOR.xpos",			"14"			},
  { "bd_wall.EDITOR.ypos",			"13"			},

  { "bd_rock",					"RocksDC.pcx"		},
  { "bd_rock.xpos",				"12"			},
  { "bd_rock.ypos",				"10"			},
  { "bd_rock.frames",				"1"			},
  { "bd_rock.EDITOR",				"RocksDC.pcx"		},
  { "bd_rock.EDITOR.xpos",			"14"			},
  { "bd_rock.EDITOR.ypos",			"14"			},
  { "bd_rock.moving.left",			"RocksDC.pcx"		},
  { "bd_rock.moving.left.xpos",			"12"			},
  { "bd_rock.moving.left.ypos",			"10"			},
  { "bd_rock.moving.left.frames",		"4"			},
  { "bd_rock.moving.left.delay",		"2"			},
  { "bd_rock.moving.left.anim_mode",		"reverse"		},
  { "bd_rock.moving.right",			"RocksDC.pcx"		},
  { "bd_rock.moving.right.xpos",		"12"			},
  { "bd_rock.moving.right.ypos",		"10"			},
  { "bd_rock.moving.right.frames",		"4"			},
  { "bd_rock.moving.right.start_frame",		"1"			},
  { "bd_rock.moving.right.delay",		"2"			},
  { "bd_rock.pushing.left",			"RocksDC.pcx"		},
  { "bd_rock.pushing.left.xpos",		"12"			},
  { "bd_rock.pushing.left.ypos",		"10"			},
  { "bd_rock.pushing.left.frames",		"4"			},
  { "bd_rock.pushing.left.delay",		"2"			},
  { "bd_rock.pushing.left.anim_mode",		"reverse"		},
  { "bd_rock.pushing.right",			"RocksDC.pcx"		},
  { "bd_rock.pushing.right.xpos",		"12"			},
  { "bd_rock.pushing.right.ypos",		"10"			},
  { "bd_rock.pushing.right.frames",		"4"			},
  { "bd_rock.pushing.right.start_frame",	"1"			},
  { "bd_rock.pushing.right.delay",		"2"			},

  { "bd_diamond",				"RocksElements.pcx"	},
  { "bd_diamond.xpos",				"0"			},
  { "bd_diamond.ypos",				"10"			},
  { "bd_diamond.frames",			"4"			},
  { "bd_diamond.delay",				"4"			},
  { "bd_diamond.anim_mode",			"reverse"		},
  { "bd_diamond.moving",			"RocksElements.pcx"	},
  { "bd_diamond.moving.xpos",			"3"			},
  { "bd_diamond.moving.ypos",			"10"			},
  { "bd_diamond.moving.frames",			"2"			},
  { "bd_diamond.moving.delay",			"4"			},
  { "bd_diamond.falling",			"RocksElements.pcx"	},
  { "bd_diamond.falling.xpos",			"3"			},
  { "bd_diamond.falling.ypos",			"10"			},
  { "bd_diamond.falling.frames",		"2"			},
  { "bd_diamond.falling.delay",			"4"			},

  { "bd_magic_wall",				"RocksElements.pcx"	},
  { "bd_magic_wall.xpos",			"12"			},
  { "bd_magic_wall.ypos",			"10"			},
  { "bd_magic_wall.frames",			"1"			},
  { "bd_magic_wall.active",			"RocksElements.pcx"	},
  { "bd_magic_wall.active.xpos",		"12"			},
  { "bd_magic_wall.active.ypos",		"10"			},
  { "bd_magic_wall.active.frames",		"4"			},
  { "bd_magic_wall.active.anim_mode",		"reverse"		},
  { "bd_magic_wall.active.delay",		"4"			},
  { "bd_magic_wall.active.global_sync",		"true"			},
  { "bd_magic_wall.filling",			"RocksElements.pcx"	},
  { "bd_magic_wall.filling.xpos",		"12"			},
  { "bd_magic_wall.filling.ypos",		"10"			},
  { "bd_magic_wall.filling.frames",		"4"			},
  { "bd_magic_wall.filling.anim_mode",		"reverse"		},
  { "bd_magic_wall.filling.delay",		"4"			},
  { "bd_magic_wall.filling.global_sync",	"true"			},
  { "bd_magic_wall_full",			"RocksElements.pcx"	},
  { "bd_magic_wall_full.xpos",			"12"			},
  { "bd_magic_wall_full.ypos",			"10"			},
  { "bd_magic_wall_full.frames",		"4"			},
  { "bd_magic_wall_full.anim_mode",		"reverse"		},
  { "bd_magic_wall_full.delay",			"4"			},
  { "bd_magic_wall_full.global_sync",		"true"			},
  { "bd_magic_wall.emptying",			"RocksElements.pcx"	},
  { "bd_magic_wall.emptying.xpos",		"12"			},
  { "bd_magic_wall.emptying.ypos",		"10"			},
  { "bd_magic_wall.emptying.frames",		"4"			},
  { "bd_magic_wall.emptying.anim_mode",		"reverse"		},
  { "bd_magic_wall.emptying.delay",		"4"			},
  { "bd_magic_wall.emptying.global_sync",	"true"			},
  { "bd_magic_wall_dead",			"RocksElements.pcx"	},
  { "bd_magic_wall_dead.xpos",			"12"			},
  { "bd_magic_wall_dead.ypos",			"10"			},
  { "bd_magic_wall_dead.frames",		"1"			},

  { "bd_amoeba",				"RocksElements.pcx"	},
  { "bd_amoeba.xpos",				"8"			},
  { "bd_amoeba.ypos",				"6"			},
  { "bd_amoeba.frames",				"4"			},
  { "bd_amoeba.delay",				"1000000"		},
  { "bd_amoeba.anim_mode",			"random"		},
  { "bd_amoeba.EDITOR",				"RocksElements.pcx"	},
  { "bd_amoeba.EDITOR.xpos",			"8"			},
  { "bd_amoeba.EDITOR.ypos",			"7"			},

  { "bd_butterfly",				"RocksElements.pcx"	},
  { "bd_butterfly.xpos",			"4"			},
  { "bd_butterfly.ypos",			"12"			},
  { "bd_butterfly.frames",			"2"			},
  { "bd_butterfly.anim_mode",			"pingpong"		},
  { "bd_butterfly.delay",			"4"			},
  { "bd_butterfly.global_sync",			"true"			},
  { "bd_butterfly.right",			"RocksElements.pcx"	},
  { "bd_butterfly.right.xpos",			"4"			},
  { "bd_butterfly.right.ypos",			"12"			},
  { "bd_butterfly.right.frames",		"2"			},
  { "bd_butterfly.right.anim_mode",		"pingpong"		},
  { "bd_butterfly.right.delay",			"4"			},
  { "bd_butterfly.right.global_sync",		"true"			},
  { "bd_butterfly.right.EDITOR",		"RocksElements.pcx"	},
  { "bd_butterfly.right.EDITOR.xpos",		"8"			},
  { "bd_butterfly.right.EDITOR.ypos",		"12"			},
  { "bd_butterfly.up",				"RocksElements.pcx"	},
  { "bd_butterfly.up.xpos",			"4"			},
  { "bd_butterfly.up.ypos",			"12"			},
  { "bd_butterfly.up.frames",			"2"			},
  { "bd_butterfly.up.anim_mode",		"pingpong"		},
  { "bd_butterfly.up.delay",			"4"			},
  { "bd_butterfly.up.global_sync",		"true"			},
  { "bd_butterfly.up.EDITOR",			"RocksElements.pcx"	},
  { "bd_butterfly.up.EDITOR.xpos",		"9"			},
  { "bd_butterfly.up.EDITOR.ypos",		"12"			},
  { "bd_butterfly.left",			"RocksElements.pcx"	},
  { "bd_butterfly.left.xpos",			"4"			},
  { "bd_butterfly.left.ypos",			"12"			},
  { "bd_butterfly.left.frames",			"2"			},
  { "bd_butterfly.left.anim_mode",		"pingpong"		},
  { "bd_butterfly.left.delay",			"4"			},
  { "bd_butterfly.left.global_sync",		"true"			},
  { "bd_butterfly.left.EDITOR",			"RocksElements.pcx"	},
  { "bd_butterfly.left.EDITOR.xpos",		"10"			},
  { "bd_butterfly.left.EDITOR.ypos",		"12"			},
  { "bd_butterfly.down",			"RocksElements.pcx"	},
  { "bd_butterfly.down.xpos",			"4"			},
  { "bd_butterfly.down.ypos",			"12"			},
  { "bd_butterfly.down.frames",			"2"			},
  { "bd_butterfly.down.anim_mode",		"pingpong"		},
  { "bd_butterfly.down.delay",			"4"			},
  { "bd_butterfly.down.global_sync",		"true"			},
  { "bd_butterfly.down.EDITOR",			"RocksElements.pcx"	},
  { "bd_butterfly.down.EDITOR.xpos",		"11"			},
  { "bd_butterfly.down.EDITOR.ypos",		"12"			},

  { "bd_firefly",				"RocksElements.pcx"	},
  { "bd_firefly.xpos",				"6"			},
  { "bd_firefly.ypos",				"12"			},
  { "bd_firefly.frames",			"2"			},
  { "bd_firefly.anim_mode",			"pingpong"		},
  { "bd_firefly.delay",				"4"			},
  { "bd_firefly.global_sync",			"true"			},
  { "bd_firefly.right",				"RocksElements.pcx"	},
  { "bd_firefly.right.xpos",			"6"			},
  { "bd_firefly.right.ypos",			"12"			},
  { "bd_firefly.right.frames",			"2"			},
  { "bd_firefly.right.anim_mode",		"pingpong"		},
  { "bd_firefly.right.delay",			"4"			},
  { "bd_firefly.right.global_sync",		"true"			},
  { "bd_firefly.right.EDITOR",			"RocksElements.pcx"	},
  { "bd_firefly.right.EDITOR.xpos",		"12"			},
  { "bd_firefly.right.EDITOR.ypos",		"12"			},
  { "bd_firefly.up",				"RocksElements.pcx"	},
  { "bd_firefly.up.xpos",			"6"			},
  { "bd_firefly.up.ypos",			"12"			},
  { "bd_firefly.up.frames",			"2"			},
  { "bd_firefly.up.anim_mode",			"pingpong"		},
  { "bd_firefly.up.delay",			"4"			},
  { "bd_firefly.up.global_sync",		"true"			},
  { "bd_firefly.up.EDITOR",			"RocksElements.pcx"	},
  { "bd_firefly.up.EDITOR.xpos",		"13"			},
  { "bd_firefly.up.EDITOR.ypos",		"12"			},
  { "bd_firefly.left",				"RocksElements.pcx"	},
  { "bd_firefly.left.xpos",			"6"			},
  { "bd_firefly.left.ypos",			"12"			},
  { "bd_firefly.left.frames",			"2"			},
  { "bd_firefly.left.anim_mode",		"pingpong"		},
  { "bd_firefly.left.delay",			"4"			},
  { "bd_firefly.left.global_sync",		"true"			},
  { "bd_firefly.left.EDITOR",			"RocksElements.pcx"	},
  { "bd_firefly.left.EDITOR.xpos",		"14"			},
  { "bd_firefly.left.EDITOR.ypos",		"12"			},
  { "bd_firefly.down",				"RocksElements.pcx"	},
  { "bd_firefly.down.xpos",			"6"			},
  { "bd_firefly.down.ypos",			"12"			},
  { "bd_firefly.down.frames",			"2"			},
  { "bd_firefly.down.anim_mode",		"pingpong"		},
  { "bd_firefly.down.delay",			"4"			},
  { "bd_firefly.down.global_sync",		"true"			},
  { "bd_firefly.down.EDITOR",			"RocksElements.pcx"	},
  { "bd_firefly.down.EDITOR.xpos",		"15"			},
  { "bd_firefly.down.EDITOR.ypos",		"12"			},

  /* images for Supaplex style elements and actions */

  { "[sp_default].exploding",			"RocksSP.pcx"		},
  { "[sp_default].exploding.xpos",		"8"			},
  { "[sp_default].exploding.ypos",		"3"			},
  { "[sp_default].exploding.frames",		"8"			},
  { "[sp_default].exploding.delay",		"3"			},
  { "[sp_default].exploding.anim_mode",		"linear"		},

  { "sp_zonk",					"RocksSP.pcx"		},
  { "sp_zonk.xpos",				"1"			},
  { "sp_zonk.ypos",				"0"			},
  { "sp_zonk.frames",				"1"			},
  { "sp_zonk.moving.left",			"RocksSP.pcx"		},
  { "sp_zonk.moving.left.xpos",			"0"			},
  { "sp_zonk.moving.left.ypos",			"6"			},
  { "sp_zonk.moving.left.frames",		"4"			},
  { "sp_zonk.moving.left.delay",		"2"			},
  { "sp_zonk.moving.left.anim_mode",		"reverse"		},
  { "sp_zonk.moving.right",			"RocksSP.pcx"		},
  { "sp_zonk.moving.right.xpos",		"0"			},
  { "sp_zonk.moving.right.ypos",		"6"			},
  { "sp_zonk.moving.right.frames",		"4"			},
  { "sp_zonk.moving.right.start_frame",		"1"			},
  { "sp_zonk.moving.right.delay",		"2"			},
  { "sp_zonk.pushing.left",			"RocksSP.pcx"		},
  { "sp_zonk.pushing.left.xpos",		"0"			},
  { "sp_zonk.pushing.left.ypos",		"6"			},
  { "sp_zonk.pushing.left.frames",		"4"			},
  { "sp_zonk.pushing.left.delay",		"2"			},
  { "sp_zonk.pushing.left.anim_mode",		"reverse"		},
  { "sp_zonk.pushing.right",			"RocksSP.pcx"		},
  { "sp_zonk.pushing.right.xpos",		"0"			},
  { "sp_zonk.pushing.right.ypos",		"6"			},
  { "sp_zonk.pushing.right.frames",		"4"			},
  { "sp_zonk.pushing.right.start_frame",	"1"			},
  { "sp_zonk.pushing.right.delay",		"2"			},

  { "sp_base",					"RocksSP.pcx"		},
  { "sp_base.xpos",				"2"			},
  { "sp_base.ypos",				"0"			},
  { "sp_base.frames",				"1"			},

  { "sp_murphy",				"RocksSP.pcx"		},
  { "sp_murphy.xpos",				"3"			},
  { "sp_murphy.ypos",				"0"			},
  { "sp_murphy.frames",				"1"			},
  { "sp_murphy.moving.left",			"RocksSP.pcx"		},
  { "sp_murphy.moving.left.xpos",		"8"			},
  { "sp_murphy.moving.left.ypos",		"0"			},
  { "sp_murphy.moving.left.frames",		"3"			},
  { "sp_murphy.moving.left.anim_mode",		"pingpong"		},
  { "sp_murphy.moving.left.delay",		"2"			},
  { "sp_murphy.moving.right",			"RocksSP.pcx"		},
  { "sp_murphy.moving.right.xpos",		"11"			},
  { "sp_murphy.moving.right.ypos",		"0"			},
  { "sp_murphy.moving.right.frames",		"3"			},
  { "sp_murphy.moving.right.anim_mode",		"pingpong"		},
  { "sp_murphy.moving.right.delay",		"2"			},
  { "sp_murphy.digging.left",			"RocksSP.pcx"		},
  { "sp_murphy.digging.left.xpos",		"8"			},
  { "sp_murphy.digging.left.ypos",		"0"			},
  { "sp_murphy.digging.left.frames",		"3"			},
  { "sp_murphy.digging.left.anim_mode",		"pingpong"		},
  { "sp_murphy.digging.left.delay",		"2"			},
  { "sp_murphy.digging.right",			"RocksSP.pcx"		},
  { "sp_murphy.digging.right.xpos",		"11"			},
  { "sp_murphy.digging.right.ypos",		"0"			},
  { "sp_murphy.digging.right.frames",		"3"			},
  { "sp_murphy.digging.right.anim_mode",	"pingpong"		},
  { "sp_murphy.digging.right.delay",		"2"			},
  { "sp_murphy.collecting.left",		"RocksSP.pcx"		},
  { "sp_murphy.collecting.left.xpos",		"8"			},
  { "sp_murphy.collecting.left.ypos",		"0"			},
  { "sp_murphy.collecting.left.frames",		"3"			},
  { "sp_murphy.collecting.left.anim_mode",	"pingpong"		},
  { "sp_murphy.collecting.left.delay",		"2"			},
  { "sp_murphy.collecting.right",		"RocksSP.pcx"		},
  { "sp_murphy.collecting.right.xpos",		"11"			},
  { "sp_murphy.collecting.right.ypos",		"0"			},
  { "sp_murphy.collecting.right.frames",	"3"			},
  { "sp_murphy.collecting.right.anim_mode",	"pingpong"		},
  { "sp_murphy.collecting.right.delay",		"2"			},
  { "sp_murphy.pushing.left",			"RocksSP.pcx"		},
  { "sp_murphy.pushing.left.xpos",		"11"			},
  { "sp_murphy.pushing.left.ypos",		"1"			},
  { "sp_murphy.pushing.left.frames",		"1"			},
  { "sp_murphy.pushing.right",			"RocksSP.pcx"		},
  { "sp_murphy.pushing.right.xpos",		"10"			},
  { "sp_murphy.pushing.right.ypos",		"1"			},
  { "sp_murphy.pushing.right.frames",		"1"			},
  { "sp_murphy.snapping.left",			"RocksSP.pcx"		},
  { "sp_murphy.snapping.left.xpos",		"9"			},
  { "sp_murphy.snapping.left.ypos",		"1"			},
  { "sp_murphy.snapping.left.frames",		"1"			},
  { "sp_murphy.snapping.right",			"RocksSP.pcx"		},
  { "sp_murphy.snapping.right.xpos",		"8"			},
  { "sp_murphy.snapping.right.ypos",		"1"			},
  { "sp_murphy.snapping.right.frames",		"1"			},
  { "sp_murphy.snapping.up",			"RocksSP.pcx"		},
  { "sp_murphy.snapping.up.xpos",		"14"			},
  { "sp_murphy.snapping.up.ypos",		"0"			},
  { "sp_murphy.snapping.up.frames",		"1"			},
  { "sp_murphy.snapping.down",			"RocksSP.pcx"		},
  { "sp_murphy.snapping.down.xpos",		"15"			},
  { "sp_murphy.snapping.down.ypos",		"0"			},
  { "sp_murphy.snapping.down.frames",		"1"			},

  { "sp_murphy_clone",				"RocksSP.pcx"		},
  { "sp_murphy_clone.xpos",			"3"			},
  { "sp_murphy_clone.ypos",			"0"			},
  { "sp_murphy_clone.frames",			"1"			},

  { "sp_infotron",				"RocksSP.pcx"		},
  { "sp_infotron.xpos",				"4"			},
  { "sp_infotron.ypos",				"0"			},
  { "sp_infotron.frames",			"1"			},
  { "sp_infotron.EDITOR",			"RocksSP.pcx"		},
  { "sp_infotron.EDITOR.xpos",			"8"			},
  { "sp_infotron.EDITOR.ypos",			"11"			},

  { "sp_chip_single",				"RocksSP.pcx"		},
  { "sp_chip_single.xpos",			"5"			},
  { "sp_chip_single.ypos",			"0"			},
  { "sp_chip_single.frames",			"1"			},
  { "sp_chip_left",				"RocksSP.pcx"		},
  { "sp_chip_left.xpos",			"2"			},
  { "sp_chip_left.ypos",			"3"			},
  { "sp_chip_left.frames",			"1"			},
  { "sp_chip_right",				"RocksSP.pcx"		},
  { "sp_chip_right.xpos",			"3"			},
  { "sp_chip_right.ypos",			"3"			},
  { "sp_chip_right.frames",			"1"			},
  { "sp_chip_top",				"RocksSP.pcx"		},
  { "sp_chip_top.xpos",				"6"			},
  { "sp_chip_top.ypos",				"4"			},
  { "sp_chip_top.frames",			"1"			},
  { "sp_chip_bottom",				"RocksSP.pcx"		},
  { "sp_chip_bottom.xpos",			"7"			},
  { "sp_chip_bottom.ypos",			"4"			},
  { "sp_chip_bottom.frames",			"1"			},

  { "sp_hardware_gray",				"RocksSP.pcx"		},
  { "sp_hardware_gray.xpos",			"6"			},
  { "sp_hardware_gray.ypos",			"0"			},
  { "sp_hardware_gray.frames",			"1"			},
  { "sp_hardware_green",			"RocksSP.pcx"		},
  { "sp_hardware_green.xpos",			"5"			},
  { "sp_hardware_green.ypos",			"3"			},
  { "sp_hardware_green.frames",			"1"			},
  { "sp_hardware_blue",				"RocksSP.pcx"		},
  { "sp_hardware_blue.xpos",			"6"			},
  { "sp_hardware_blue.ypos",			"3"			},
  { "sp_hardware_blue.frames",			"1"			},
  { "sp_hardware_red",				"RocksSP.pcx"		},
  { "sp_hardware_red.xpos",			"7"			},
  { "sp_hardware_red.ypos",			"3"			},
  { "sp_hardware_red.frames",			"1"			},
  { "sp_hardware_yellow",			"RocksSP.pcx"		},
  { "sp_hardware_yellow.xpos",			"0"			},
  { "sp_hardware_yellow.ypos",			"4"			},
  { "sp_hardware_yellow.frames",		"1"			},

  { "sp_exit_closed",				"RocksSP.pcx"		},
  { "sp_exit_closed.xpos",			"7"			},
  { "sp_exit_closed.ypos",			"0"			},
  { "sp_exit_closed.frames",			"1"			},
  { "sp_exit.opening",				"RocksSP.pcx"		},
  { "sp_exit.opening.xpos",			"7"			},
  { "sp_exit.opening.ypos",			"0"			},
  { "sp_exit.opening.frames",			"1"			},
  { "sp_exit_open",				"RocksSP.pcx"		},
  { "sp_exit_open.xpos",			"7"			},
  { "sp_exit_open.ypos",			"0"			},
  { "sp_exit_open.frames",			"1"			},
  { "sp_exit.closing",				"RocksSP.pcx"		},
  { "sp_exit.closing.xpos",			"7"			},
  { "sp_exit.closing.ypos",			"0"			},
  { "sp_exit.closing.frames",			"1"			},

  { "sp_disk_orange",				"RocksSP.pcx"		},
  { "sp_disk_orange.xpos",			"0"			},
  { "sp_disk_orange.ypos",			"1"			},
  { "sp_disk_orange.frames",			"1"			},

  { "sp_disk_yellow",				"RocksSP.pcx"		},
  { "sp_disk_yellow.xpos",			"2"			},
  { "sp_disk_yellow.ypos",			"2"			},
  { "sp_disk_yellow.frames",			"1"			},

  { "sp_disk_red",				"RocksSP.pcx"		},
  { "sp_disk_red.xpos",				"4"			},
  { "sp_disk_red.ypos",				"2"			},
  { "sp_disk_red.frames",			"1"			},
  { "sp_disk_red.collecting",			"RocksSP.pcx"		},
  { "sp_disk_red.collecting.xpos",		"8"			},
  { "sp_disk_red.collecting.ypos",		"5"			},
  { "sp_disk_red.collecting.frames",		"8"			},
  { "sp_disk_red.active",			"RocksSP.pcx"		},
  { "sp_disk_red.active.xpos",			"4"			},
  { "sp_disk_red.active.ypos",			"2"			},
  { "sp_disk_red.active.frames",		"1"			},

  { "sp_port_right",				"RocksSP.pcx"		},
  { "sp_port_right.xpos",			"1"			},
  { "sp_port_right.ypos",			"1"			},
  { "sp_port_right.frames",			"1"			},
  { "sp_port_down",				"RocksSP.pcx"		},
  { "sp_port_down.xpos",			"2"			},
  { "sp_port_down.ypos",			"1"			},
  { "sp_port_down.frames",			"1"			},
  { "sp_port_left",				"RocksSP.pcx"		},
  { "sp_port_left.xpos",			"3"			},
  { "sp_port_left.ypos",			"1"			},
  { "sp_port_left.frames",			"1"			},
  { "sp_port_up",				"RocksSP.pcx"		},
  { "sp_port_up.xpos",				"4"			},
  { "sp_port_up.ypos",				"1"			},
  { "sp_port_up.frames",			"1"			},
  { "sp_port_horizontal",			"RocksSP.pcx"		},
  { "sp_port_horizontal.xpos",			"6"			},
  { "sp_port_horizontal.ypos",			"2"			},
  { "sp_port_horizontal.frames",		"1"			},
  { "sp_port_vertical",				"RocksSP.pcx"		},
  { "sp_port_vertical.xpos",			"5"			},
  { "sp_port_vertical.ypos",			"2"			},
  { "sp_port_vertical.frames",			"1"			},
  { "sp_port_any",				"RocksSP.pcx"		},
  { "sp_port_any.xpos",				"7"			},
  { "sp_port_any.ypos",				"2"			},
  { "sp_port_any.frames",			"1"			},
  { "sp_gravity_port_right",			"RocksSP.pcx"		},
  { "sp_gravity_port_right.xpos",		"1"			},
  { "sp_gravity_port_right.ypos",		"1"			},
  { "sp_gravity_port_right.frames",		"1"			},
  { "sp_gravity_port_right.EDITOR",		"RocksSP.pcx"		},
  { "sp_gravity_port_right.EDITOR.xpos",	"5"			},
  { "sp_gravity_port_right.EDITOR.ypos",	"1"			},
  { "sp_gravity_port_down",			"RocksSP.pcx"		},
  { "sp_gravity_port_down.xpos",		"2"			},
  { "sp_gravity_port_down.ypos",		"1"			},
  { "sp_gravity_port_down.frames",		"1"			},
  { "sp_gravity_port_down.EDITOR",		"RocksSP.pcx"		},
  { "sp_gravity_port_down.EDITOR.xpos",		"6"			},
  { "sp_gravity_port_down.EDITOR.ypos",		"1"			},
  { "sp_gravity_port_left",			"RocksSP.pcx"		},
  { "sp_gravity_port_left.xpos",		"3"			},
  { "sp_gravity_port_left.ypos",		"1"			},
  { "sp_gravity_port_left.frames",		"1"			},
  { "sp_gravity_port_left.EDITOR",		"RocksSP.pcx"		},
  { "sp_gravity_port_left.EDITOR.xpos",		"7"			},
  { "sp_gravity_port_left.EDITOR.ypos",		"1"			},
  { "sp_gravity_port_up",			"RocksSP.pcx"		},
  { "sp_gravity_port_up.xpos",			"4"			},
  { "sp_gravity_port_up.ypos",			"1"			},
  { "sp_gravity_port_up.frames",		"1"			},
  { "sp_gravity_port_up.EDITOR",		"RocksSP.pcx"		},
  { "sp_gravity_port_up.EDITOR.xpos",		"0"			},
  { "sp_gravity_port_up.EDITOR.ypos",		"2"			},
  { "sp_gravity_on_port_right",			"RocksSP.pcx"		},
  { "sp_gravity_on_port_right.xpos",		"1"			},
  { "sp_gravity_on_port_right.ypos",		"1"			},
  { "sp_gravity_on_port_right.frames",		"1"			},
  { "sp_gravity_on_port_right.EDITOR",		"RocksSP.pcx"		},
  { "sp_gravity_on_port_right.EDITOR.xpos",	"5"			},
  { "sp_gravity_on_port_right.EDITOR.ypos",	"1"			},
  { "sp_gravity_on_port_down",			"RocksSP.pcx"		},
  { "sp_gravity_on_port_down.xpos",		"2"			},
  { "sp_gravity_on_port_down.ypos",		"1"			},
  { "sp_gravity_on_port_down.frames",		"1"			},
  { "sp_gravity_on_port_down.EDITOR",		"RocksSP.pcx"		},
  { "sp_gravity_on_port_down.EDITOR.xpos",	"6"			},
  { "sp_gravity_on_port_down.EDITOR.ypos",	"1"			},
  { "sp_gravity_on_port_left",			"RocksSP.pcx"		},
  { "sp_gravity_on_port_left.xpos",		"3"			},
  { "sp_gravity_on_port_left.ypos",		"1"			},
  { "sp_gravity_on_port_left.frames",		"1"			},
  { "sp_gravity_on_port_left.EDITOR",		"RocksSP.pcx"		},
  { "sp_gravity_on_port_left.EDITOR.xpos",	"7"			},
  { "sp_gravity_on_port_left.EDITOR.ypos",	"1"			},
  { "sp_gravity_on_port_up",			"RocksSP.pcx"		},
  { "sp_gravity_on_port_up.xpos",		"4"			},
  { "sp_gravity_on_port_up.ypos",		"1"			},
  { "sp_gravity_on_port_up.frames",		"1"			},
  { "sp_gravity_on_port_up.EDITOR",		"RocksSP.pcx"		},
  { "sp_gravity_on_port_up.EDITOR.xpos",	"0"			},
  { "sp_gravity_on_port_up.EDITOR.ypos",	"2"			},
  { "sp_gravity_off_port_right",		"RocksSP.pcx"		},
  { "sp_gravity_off_port_right.xpos",		"1"			},
  { "sp_gravity_off_port_right.ypos",		"1"			},
  { "sp_gravity_off_port_right.frames",		"1"			},
  { "sp_gravity_off_port_right.EDITOR",		"RocksSP.pcx"		},
  { "sp_gravity_off_port_right.EDITOR.xpos",	"5"			},
  { "sp_gravity_off_port_right.EDITOR.ypos",	"1"			},
  { "sp_gravity_off_port_down",			"RocksSP.pcx"		},
  { "sp_gravity_off_port_down.xpos",		"2"			},
  { "sp_gravity_off_port_down.ypos",		"1"			},
  { "sp_gravity_off_port_down.frames",		"1"			},
  { "sp_gravity_off_port_down.EDITOR",		"RocksSP.pcx"		},
  { "sp_gravity_off_port_down.EDITOR.xpos",	"6"			},
  { "sp_gravity_off_port_down.EDITOR.ypos",	"1"			},
  { "sp_gravity_off_port_left",			"RocksSP.pcx"		},
  { "sp_gravity_off_port_left.xpos",		"3"			},
  { "sp_gravity_off_port_left.ypos",		"1"			},
  { "sp_gravity_off_port_left.frames",		"1"			},
  { "sp_gravity_off_port_left.EDITOR",		"RocksSP.pcx"		},
  { "sp_gravity_off_port_left.EDITOR.xpos",	"7"			},
  { "sp_gravity_off_port_left.EDITOR.ypos",	"1"			},
  { "sp_gravity_off_port_up",			"RocksSP.pcx"		},
  { "sp_gravity_off_port_up.xpos",		"4"			},
  { "sp_gravity_off_port_up.ypos",		"1"			},
  { "sp_gravity_off_port_up.frames",		"1"			},
  { "sp_gravity_off_port_up.EDITOR",		"RocksSP.pcx"		},
  { "sp_gravity_off_port_up.EDITOR.xpos",	"0"			},
  { "sp_gravity_off_port_up.EDITOR.ypos",	"2"			},

  { "sp_sniksnak",				"RocksSP.pcx"		},
  { "sp_sniksnak.xpos",				"1"			},
  { "sp_sniksnak.ypos",				"2"			},
  { "sp_sniksnak.frames",			"1"			},
  { "sp_sniksnak.left",				"RocksSP.pcx"		},
  { "sp_sniksnak.left.xpos",			"8"			},
  { "sp_sniksnak.left.ypos",			"8"			},
  { "sp_sniksnak.left.frames",			"4"			},
  { "sp_sniksnak.left.anim_mode",		"pingpong2"		},
  { "sp_sniksnak.right",			"RocksSP.pcx"		},
  { "sp_sniksnak.right.xpos",			"12"			},
  { "sp_sniksnak.right.ypos",			"8"			},
  { "sp_sniksnak.right.frames",			"4"			},
  { "sp_sniksnak.right.anim_mode",		"pingpong2"		},
  { "sp_sniksnak.up",				"RocksSP.pcx"		},
  { "sp_sniksnak.up.xpos",			"8"			},
  { "sp_sniksnak.up.ypos",			"9"			},
  { "sp_sniksnak.up.frames",			"4"			},
  { "sp_sniksnak.up.anim_mode",			"pingpong2"		},
  { "sp_sniksnak.down",				"RocksSP.pcx"		},
  { "sp_sniksnak.down.xpos",			"12"			},
  { "sp_sniksnak.down.ypos",			"9"			},
  { "sp_sniksnak.down.frames",			"4"			},
  { "sp_sniksnak.down.anim_mode",		"pingpong2"		},
  { "sp_sniksnak.turning_from_left.up",		"RocksSP.pcx"		},
  { "sp_sniksnak.turning_from_left.up.xpos",	"12"			},
  { "sp_sniksnak.turning_from_left.up.ypos",	"6"			},
  { "sp_sniksnak.turning_from_left.up.frames",	"2"			},
  { "sp_sniksnak.turning_from_left.up.delay",	"4"			},
  { "sp_sniksnak.turning_from_left.up.offset",	"1408"			},
  { "sp_sniksnak.turning_from_left.up.anim_mode","linear"		},
  { "sp_sniksnak.turning_from_left.down",	"RocksSP.pcx"		},
  { "sp_sniksnak.turning_from_left.down.xpos",	"13"			},
  { "sp_sniksnak.turning_from_left.down.ypos",	"6"			},
  { "sp_sniksnak.turning_from_left.down.frames","2"			},
  { "sp_sniksnak.turning_from_left.down.delay",	"4"			},
  { "sp_sniksnak.turning_from_left.down.offset","1504"			},
  { "sp_sniksnak.turning_from_left.down.anim_mode","linear"		},
  { "sp_sniksnak.turning_from_right.up",	"RocksSP.pcx"		},
  { "sp_sniksnak.turning_from_right.up.xpos",	"15"			},
  { "sp_sniksnak.turning_from_right.up.ypos",	"6"			},
  { "sp_sniksnak.turning_from_right.up.frames",	"2"			},
  { "sp_sniksnak.turning_from_right.up.delay",	"4"			},
  { "sp_sniksnak.turning_from_right.up.offset",	"1312"			},
  { "sp_sniksnak.turning_from_right.up.anim_mode","linear"		},
  { "sp_sniksnak.turning_from_right.down",	"RocksSP.pcx"		},
  { "sp_sniksnak.turning_from_right.down.xpos",	"14"			},
  { "sp_sniksnak.turning_from_right.down.ypos",	"6"			},
  { "sp_sniksnak.turning_from_right.down.frames","2"			},
  { "sp_sniksnak.turning_from_right.down.delay","4"			},
  { "sp_sniksnak.turning_from_right.down.offset","1472"			},
  { "sp_sniksnak.turning_from_right.down.anim_mode","linear"		},
  { "sp_sniksnak.turning_from_up.left",		"RocksSP.pcx"		},
  { "sp_sniksnak.turning_from_up.left.xpos",	"12"			},
  { "sp_sniksnak.turning_from_up.left.ypos",	"6"			},
  { "sp_sniksnak.turning_from_up.left.frames",	"2"			},
  { "sp_sniksnak.turning_from_up.left.delay",	"4"			},
  { "sp_sniksnak.turning_from_up.left.offset",	"896"			},
  { "sp_sniksnak.turning_from_up.left.anim_mode","linear"		},
  { "sp_sniksnak.turning_from_up.right",	"RocksSP.pcx"		},
  { "sp_sniksnak.turning_from_up.right.xpos",	"15"			},
  { "sp_sniksnak.turning_from_up.right.ypos",	"6"			},
  { "sp_sniksnak.turning_from_up.right.frames",	"2"			},
  { "sp_sniksnak.turning_from_up.right.delay",	"4"			},
  { "sp_sniksnak.turning_from_up.right.offset",	"928"			},
  { "sp_sniksnak.turning_from_up.right.anim_mode","linear"		},
  { "sp_sniksnak.turning_from_down.left",	"RocksSP.pcx"		},
  { "sp_sniksnak.turning_from_down.left.xpos",	"13"			},
  { "sp_sniksnak.turning_from_down.left.ypos",	"6"			},
  { "sp_sniksnak.turning_from_down.left.frames","2"			},
  { "sp_sniksnak.turning_from_down.left.delay",	"4"			},
  { "sp_sniksnak.turning_from_down.left.offset","864"			},
  { "sp_sniksnak.turning_from_down.left.anim_mode","linear"		},
  { "sp_sniksnak.turning_from_down.right",	"RocksSP.pcx"		},
  { "sp_sniksnak.turning_from_down.right.xpos",	"14"			},
  { "sp_sniksnak.turning_from_down.right.ypos",	"6"			},
  { "sp_sniksnak.turning_from_down.right.frames","2"			},
  { "sp_sniksnak.turning_from_down.right.delay","4"			},
  { "sp_sniksnak.turning_from_down.right.offset","960"			},
  { "sp_sniksnak.turning_from_down.right.anim_mode","linear"		},

  { "sp_electron",				"RocksSP.pcx"		},
  { "sp_electron.xpos",				"8"			},
  { "sp_electron.ypos",				"10"			},
  { "sp_electron.frames",			"8"			},
  { "sp_electron.delay",			"4"			},
  { "sp_electron.global_sync",			"true"			},
  { "sp_electron.EDITOR",			"RocksSP.pcx"		},
  { "sp_electron.EDITOR.xpos",			"10"			},
  { "sp_electron.EDITOR.ypos",			"11"			},
  { "sp_electron.exploding",			"RocksSP.pcx"		},
  { "sp_electron.exploding.xpos",		"8"			},
  { "sp_electron.exploding.ypos",		"4"			},
  { "sp_electron.exploding.frames",		"8"			},
  { "sp_electron.exploding.delay",		"3"			},
  { "sp_electron.exploding.anim_mode",		"linear"		},

  { "sp_terminal",				"RocksSP.pcx"		},
  { "sp_terminal.xpos",				"0"			},
  { "sp_terminal.ypos",				"10"			},
  { "sp_terminal.frames",			"7"			},
  { "sp_terminal.delay",			"12"			},
  { "sp_terminal.EDITOR",			"RocksSP.pcx"		},
  { "sp_terminal.EDITOR.xpos",			"9"			},
  { "sp_terminal.EDITOR.ypos",			"11"			},
  { "sp_terminal.active",			"RocksSP.pcx"		},
  { "sp_terminal.active.xpos",			"0"			},
  { "sp_terminal.active.ypos",			"11"			},
  { "sp_terminal.active.frames",		"7"			},
  { "sp_terminal.active.delay",			"4"			},

  { "sp_buggy_base",				"RocksSP.pcx"		},
  { "sp_buggy_base.xpos",			"1"			},
  { "sp_buggy_base.ypos",			"3"			},
  { "sp_buggy_base.frames",			"1"			},
  { "sp_buggy_base.EDITOR",			"RocksSP.pcx"		},
  { "sp_buggy_base.EDITOR.xpos",		"9"			},
  { "sp_buggy_base.EDITOR.ypos",		"6"			},
  { "sp_buggy_base.activating",			"RocksSP.pcx"		},
  { "sp_buggy_base.activating.xpos",		"15"			},
  { "sp_buggy_base.activating.ypos",		"2"			},
  { "sp_buggy_base.activating.frames",		"1"			},
  { "sp_buggy_base.active",			"RocksSP.pcx"		},
  { "sp_buggy_base.active.xpos",		"8"			},
  { "sp_buggy_base.active.ypos",		"6"			},
  { "sp_buggy_base.active.frames",		"4"			},
  { "sp_buggy_base.active.anim_mode",		"random"		},

  { "sp_hardware_base_1",			"RocksSP.pcx"		},
  { "sp_hardware_base_1.xpos",			"4"			},
  { "sp_hardware_base_1.ypos",			"3"			},
  { "sp_hardware_base_1.frames",		"1"			},
  { "sp_hardware_base_2",			"RocksSP.pcx"		},
  { "sp_hardware_base_2.xpos",			"1"			},
  { "sp_hardware_base_2.ypos",			"4"			},
  { "sp_hardware_base_2.frames",		"1"			},
  { "sp_hardware_base_3",			"RocksSP.pcx"		},
  { "sp_hardware_base_3.xpos",			"2"			},
  { "sp_hardware_base_3.ypos",			"4"			},
  { "sp_hardware_base_3.frames",		"1"			},
  { "sp_hardware_base_4",			"RocksSP.pcx"		},
  { "sp_hardware_base_4.xpos",			"3"			},
  { "sp_hardware_base_4.ypos",			"4"			},
  { "sp_hardware_base_4.frames",		"1"			},
  { "sp_hardware_base_5",			"RocksSP.pcx"		},
  { "sp_hardware_base_5.xpos",			"4"			},
  { "sp_hardware_base_5.ypos",			"4"			},
  { "sp_hardware_base_5.frames",		"1"			},
  { "sp_hardware_base_6",			"RocksSP.pcx"		},
  { "sp_hardware_base_6.xpos",			"5"			},
  { "sp_hardware_base_6.ypos",			"4"			},
  { "sp_hardware_base_6.frames",		"1"			},

  /* images for Sokoban style elements and actions */

  { "sokoban_object",				"RocksElements.pcx"	},
  { "sokoban_object.xpos",			"9"			},
  { "sokoban_object.ypos",			"7"			},
  { "sokoban_object.frames",			"1"			},
  { "sokoban_object.EDITOR",			"RocksElements.pcx"	},
  { "sokoban_object.EDITOR.xpos",		"2"			},
  { "sokoban_object.EDITOR.ypos",		"14"			},

  { "sokoban_field_empty",			"RocksElements.pcx"	},
  { "sokoban_field_empty.xpos",			"10"			},
  { "sokoban_field_empty.ypos",			"7"			},
  { "sokoban_field_empty.frames",		"1"			},

  { "sokoban_field_full",			"RocksElements.pcx"	},
  { "sokoban_field_full.xpos",			"11"			},
  { "sokoban_field_full.ypos",			"7"			},
  { "sokoban_field_full.frames",		"1"			},

  { "sokoban_field_player",			"RocksHeroes.pcx"	},
  { "sokoban_field_player.xpos",		"0"			},
  { "sokoban_field_player.ypos",		"15"			},
  { "sokoban_field_player.frames",		"1"			},
  { "sokoban_field_player.EDITOR",		"RocksHeroes.pcx"	},
  { "sokoban_field_player.EDITOR.xpos",		"1"			},
  { "sokoban_field_player.EDITOR.ypos",		"15"			},

  /* images for Emerald Mine style elements and actions */

  { "empty_space",				"RocksSP.pcx"		},
  { "empty_space.xpos",				"0"			},
  { "empty_space.ypos",				"0"			},
  { "empty_space.frames",			"1"			},

  { "sand",					"RocksElements.pcx"	},
  { "sand.xpos",				"0"			},
  { "sand.ypos",				"0"			},
  { "sand.frames",				"1"			},
  { "sand.CRUMBLED",				"RocksElements.pcx"	},
  { "sand.CRUMBLED.xpos",			"1"			},
  { "sand.CRUMBLED.ypos",			"0"			},
  { "sand.CRUMBLED.frames",			"1"			},
  { "sand.digging.left",			"RocksMore.pcx"		},
  { "sand.digging.left.xpos",			"6"			},
  { "sand.digging.left.ypos",			"3"			},
  { "sand.digging.left.frames",			"3"			},
  { "sand.digging.left.delay",			"2"			},
  { "sand.digging.left.anim_mode",		"linear"		},
  { "sand.digging.right",			"RocksMore.pcx"		},
  { "sand.digging.right.xpos",			"9"			},
  { "sand.digging.right.ypos",			"3"			},
  { "sand.digging.right.frames",		"3"			},
  { "sand.digging.right.delay",			"2"			},
  { "sand.digging.right.anim_mode",		"linear"		},
  { "sand.digging.up",				"RocksMore.pcx"		},
  { "sand.digging.up.xpos",			"0"			},
  { "sand.digging.up.ypos",			"3"			},
  { "sand.digging.up.frames",			"3"			},
  { "sand.digging.up.delay",			"2"			},
  { "sand.digging.up.anim_mode",		"linear"		},
  { "sand.digging.down",			"RocksMore.pcx"		},
  { "sand.digging.down.xpos",			"3"			},
  { "sand.digging.down.ypos",			"3"			},
  { "sand.digging.down.frames",			"3"			},
  { "sand.digging.down.delay",			"2"			},
  { "sand.digging.down.anim_mode",		"linear"		},
  { "sand.digging.left.CRUMBLED",		"RocksMore.pcx"		},
  { "sand.digging.left.CRUMBLED.xpos",		"6"			},
  { "sand.digging.left.CRUMBLED.ypos",		"0"			},
  { "sand.digging.left.CRUMBLED.frames",	"3"			},
  { "sand.digging.left.CRUMBLED.delay",		"2"			},
  { "sand.digging.left.CRUMBLED.anim_mode",	"linear"		},
  { "sand.digging.right.CRUMBLED",		"RocksMore.pcx"		},
  { "sand.digging.right.CRUMBLED.xpos",		"9"			},
  { "sand.digging.right.CRUMBLED.ypos",		"0"			},
  { "sand.digging.right.CRUMBLED.frames",	"3"			},
  { "sand.digging.right.CRUMBLED.delay",	"2"			},
  { "sand.digging.right.CRUMBLED.anim_mode",	"linear"		},
  { "sand.digging.up.CRUMBLED",			"RocksMore.pcx"		},
  { "sand.digging.up.CRUMBLED.xpos",		"0"			},
  { "sand.digging.up.CRUMBLED.ypos",		"0"			},
  { "sand.digging.up.CRUMBLED.frames",		"3"			},
  { "sand.digging.up.CRUMBLED.delay",		"2"			},
  { "sand.digging.up.CRUMBLED.anim_mode",	"linear"		},
  { "sand.digging.down.CRUMBLED",		"RocksMore.pcx"		},
  { "sand.digging.down.CRUMBLED.xpos",		"3"			},
  { "sand.digging.down.CRUMBLED.ypos",		"0"			},
  { "sand.digging.down.CRUMBLED.frames",	"3"			},
  { "sand.digging.down.CRUMBLED.delay",		"2"			},
  { "sand.digging.down.CRUMBLED.anim_mode",	"linear"		},

  { "wall",					"RocksElements.pcx"	},
  { "wall.xpos",				"5"			},
  { "wall.ypos",				"0"			},
  { "wall.frames",				"1"			},

  { "wall_slippery",				"RocksElements.pcx"	},
  { "wall_slippery.xpos",			"6"			},
  { "wall_slippery.ypos",			"0"			},
  { "wall_slippery.frames",			"1"			},

  { "steelwall",				"RocksElements.pcx"	},
  { "steelwall.xpos",				"4"			},
  { "steelwall.ypos",				"0"			},
  { "steelwall.frames",				"1"			},

  { "rock",					"RocksElements.pcx"	},
  { "rock.xpos",				"12"			},
  { "rock.ypos",				"0"			},
  { "rock.frames",				"1"			},
  { "rock.moving.left",				"RocksElements.pcx"	},
  { "rock.moving.left.xpos",			"12"			},
  { "rock.moving.left.ypos",			"0"			},
  { "rock.moving.left.frames",			"4"			},
  { "rock.moving.left.delay",			"2"			},
  { "rock.moving.left.anim_mode",		"reverse"		},
  { "rock.moving.right",			"RocksElements.pcx"	},
  { "rock.moving.right.xpos",			"12"			},
  { "rock.moving.right.ypos",			"0"			},
  { "rock.moving.right.frames",			"4"			},
  { "rock.moving.right.start_frame",		"1"			},
  { "rock.moving.right.delay",			"2"			},
  { "rock.pushing.left",			"RocksElements.pcx"	},
  { "rock.pushing.left.xpos",			"12"			},
  { "rock.pushing.left.ypos",			"0"			},
  { "rock.pushing.left.frames",			"4"			},
  { "rock.pushing.left.delay",			"2"			},
  { "rock.pushing.left.anim_mode",		"reverse"		},
  { "rock.pushing.right",			"RocksElements.pcx"	},
  { "rock.pushing.right.xpos",			"12"			},
  { "rock.pushing.right.ypos",			"0"			},
  { "rock.pushing.right.frames",		"4"			},
  { "rock.pushing.right.start_frame",		"1"			},
  { "rock.pushing.right.delay",			"2"			},

  { "emerald",					"RocksElements.pcx"	},
  { "emerald.xpos",				"8"			},
  { "emerald.ypos",				"0"			},
  { "emerald.frames",				"1"			},
  { "emerald.moving",				"RocksElements.pcx"	},
  { "emerald.moving.xpos",			"8"			},
  { "emerald.moving.ypos",			"0"			},
  { "emerald.moving.frames",			"2"			},
  { "emerald.moving.delay",			"4"			},
  { "emerald.falling",				"RocksElements.pcx"	},
  { "emerald.falling.xpos",			"8"			},
  { "emerald.falling.ypos",			"0"			},
  { "emerald.falling.frames",			"2"			},
  { "emerald.falling.delay",			"4"			},
  { "emerald.collecting",			"RocksMore.pcx"		},
  { "emerald.collecting.xpos",			"3"			},
  { "emerald.collecting.ypos",			"2"			},
  { "emerald.collecting.frames",		"3"			},
  { "emerald.collecting.delay",			"2"			},
  { "emerald.collecting.anim_mode",		"linear"		},

  { "diamond",					"RocksElements.pcx"	},
  { "diamond.xpos",				"10"			},
  { "diamond.ypos",				"0"			},
  { "diamond.frames",				"1"			},
  { "diamond.moving",				"RocksElements.pcx"	},
  { "diamond.moving.xpos",			"10"			},
  { "diamond.moving.ypos",			"0"			},
  { "diamond.moving.frames",			"2"			},
  { "diamond.moving.delay",			"4"			},
  { "diamond.falling",				"RocksElements.pcx"	},
  { "diamond.falling.xpos",			"10"			},
  { "diamond.falling.ypos",			"0"			},
  { "diamond.falling.frames",			"2"			},
  { "diamond.falling.delay",			"4"			},
  { "diamond.collecting",			"RocksMore.pcx"		},
  { "diamond.collecting.xpos",			"7"			},
  { "diamond.collecting.ypos",			"2"			},
  { "diamond.collecting.frames",		"3"			},
  { "diamond.collecting.delay",			"2"			},
  { "diamond.collecting.anim_mode",		"linear"		},

  { "bomb",					"RocksElements.pcx"	},
  { "bomb.xpos",				"11"			},
  { "bomb.ypos",				"1"			},
  { "bomb.frames",				"1"			},

  { "nut",					"RocksElements.pcx"	},
  { "nut.xpos",					"12"			},
  { "nut.ypos",					"1"			},
  { "nut.frames",				"1"			},
  { "nut.breaking",				"RocksElements.pcx"	},
  { "nut.breaking.xpos",			"13"			},
  { "nut.breaking.ypos",			"1"			},
  { "nut.breaking.frames",			"3"			},
  { "nut.breaking.delay",			"2"			},
  { "nut.breaking.anim_mode",			"linear"		},

  { "dynamite",					"RocksElements.pcx"	},
  { "dynamite.xpos",				"0"			},
  { "dynamite.ypos",				"3"			},
  { "dynamite.frames",				"1"			},
  { "dynamite.EDITOR",				"RocksElements.pcx"	},
  { "dynamite.EDITOR.xpos",			"0"			},
  { "dynamite.EDITOR.ypos",			"14"			},
  { "dynamite.active",				"RocksElements.pcx"	},
  { "dynamite.active.xpos",			"1"			},
  { "dynamite.active.ypos",			"3"			},
  { "dynamite.active.frames",			"7"			},
  { "dynamite.active.delay",			"12"			},
  { "dynamite.active.anim_mode",		"linear"		},
  { "dynamite.active.EDITOR",			"RocksElements.pcx"	},
  { "dynamite.active.EDITOR.xpos",		"1"			},
  { "dynamite.active.EDITOR.ypos",		"14"			},

  { "wall_emerald",				"RocksElements.pcx"	},
  { "wall_emerald.xpos",			"4"			},
  { "wall_emerald.ypos",			"8"			},
  { "wall_emerald.frames",			"1"			},

  { "wall_diamond",				"RocksElements.pcx"	},
  { "wall_diamond.xpos",			"5"			},
  { "wall_diamond.ypos",			"8"			},
  { "wall_diamond.frames",			"1"			},

  { "bug",					"RocksElements.pcx"	},
  { "bug.xpos",					"8"			},
  { "bug.ypos",					"4"			},
  { "bug.frames",				"4"			},
  { "bug.delay",				"8"			},
  { "bug.right",				"RocksElements.pcx"	},
  { "bug.right.xpos",				"8"			},
  { "bug.right.ypos",				"4"			},
  { "bug.right.frames",				"1"			},
  { "bug.up",					"RocksElements.pcx"	},
  { "bug.up.xpos",				"9"			},
  { "bug.up.ypos",				"4"			},
  { "bug.up.frames",				"1"			},
  { "bug.left",					"RocksElements.pcx"	},
  { "bug.left.xpos",				"10"			},
  { "bug.left.ypos",				"4"			},
  { "bug.left.frames",				"1"			},
  { "bug.down",					"RocksElements.pcx"	},
  { "bug.down.xpos",				"11"			},
  { "bug.down.ypos",				"4"			},
  { "bug.down.frames",				"1"			},
  { "bug.moving.right",				"RocksElements.pcx"	},
  { "bug.moving.right.xpos",			"8"			},
  { "bug.moving.right.ypos",			"4"			},
  { "bug.moving.right.frames",			"2"			},
  { "bug.moving.right.delay",			"4"			},
  { "bug.moving.right.offset",			"128"			},
  { "bug.moving.up",				"RocksElements.pcx"	},
  { "bug.moving.up.xpos",			"9"			},
  { "bug.moving.up.ypos",			"4"			},
  { "bug.moving.up.frames",			"2"			},
  { "bug.moving.up.delay",			"4"			},
  { "bug.moving.up.offset",			"128"			},
  { "bug.moving.left",				"RocksElements.pcx"	},
  { "bug.moving.left.xpos",			"10"			},
  { "bug.moving.left.ypos",			"4"			},
  { "bug.moving.left.frames",			"2"			},
  { "bug.moving.left.delay",			"4"			},
  { "bug.moving.left.offset",			"128"			},
  { "bug.moving.down",				"RocksElements.pcx"	},
  { "bug.moving.down.xpos",			"11"			},
  { "bug.moving.down.ypos",			"4"			},
  { "bug.moving.down.frames",			"2"			},
  { "bug.moving.down.delay",			"4"			},
  { "bug.moving.down.offset",			"128"			},
  { "bug.turning_from_right.up",		"RocksMore.pcx"		},
  { "bug.turning_from_right.up.xpos",		"0"			},
  { "bug.turning_from_right.up.ypos",		"6"			},
  { "bug.turning_from_right.up.frames",		"4"			},
  { "bug.turning_from_right.up.delay",		"2"			},
  { "bug.turning_from_right.up.anim_mode",	"linear,reverse"	},
  { "bug.turning_from_up.left",			"RocksMore.pcx"		},
  { "bug.turning_from_up.left.xpos",		"12"			},
  { "bug.turning_from_up.left.ypos",		"6"			},
  { "bug.turning_from_up.left.frames",		"4"			},
  { "bug.turning_from_up.left.delay",		"2"			},
  { "bug.turning_from_up.left.anim_mode",	"linear,reverse"	},
  { "bug.turning_from_left.down",		"RocksMore.pcx"		},
  { "bug.turning_from_left.down.xpos",		"8"			},
  { "bug.turning_from_left.down.ypos",		"6"			},
  { "bug.turning_from_left.down.frames",	"4"			},
  { "bug.turning_from_left.down.delay",		"2"			},
  { "bug.turning_from_left.down.anim_mode",	"linear,reverse"	},
  { "bug.turning_from_down.right",		"RocksMore.pcx"		},
  { "bug.turning_from_down.right.xpos",		"4"			},
  { "bug.turning_from_down.right.ypos",		"6"			},
  { "bug.turning_from_down.right.frames",	"4"			},
  { "bug.turning_from_down.right.delay",	"2"			},
  { "bug.turning_from_down.right.anim_mode",	"linear,reverse"	},
  { "bug.turning_from_right.down",		"RocksMore.pcx"		},
  { "bug.turning_from_right.down.xpos",		"5"			},
  { "bug.turning_from_right.down.ypos",		"6"			},
  { "bug.turning_from_right.down.frames",	"4"			},
  { "bug.turning_from_right.down.delay",	"2"			},
  { "bug.turning_from_right.down.anim_mode",	"linear"		},
  { "bug.turning_from_up.right",		"RocksMore.pcx"		},
  { "bug.turning_from_up.right.xpos",		"1"			},
  { "bug.turning_from_up.right.ypos",		"6"			},
  { "bug.turning_from_up.right.frames",		"4"			},
  { "bug.turning_from_up.right.delay",		"2"			},
  { "bug.turning_from_up.right.anim_mode",	"linear"		},
  { "bug.turning_from_left.up",			"RocksMore.pcx"		},
  { "bug.turning_from_left.up.xpos",		"13"			},
  { "bug.turning_from_left.up.ypos",		"6"			},
  { "bug.turning_from_left.up.frames",		"4"			},
  { "bug.turning_from_left.up.delay",		"2"			},
  { "bug.turning_from_left.up.anim_mode",	"linear"		},
  { "bug.turning_from_down.left",		"RocksMore.pcx"		},
  { "bug.turning_from_down.left.xpos",		"9"			},
  { "bug.turning_from_down.left.ypos",		"6"			},
  { "bug.turning_from_down.left.frames",	"4"			},
  { "bug.turning_from_down.left.delay",		"2"			},
  { "bug.turning_from_down.left.anim_mode",	"linear"		},

  { "spaceship",				"RocksElements.pcx"	},
  { "spaceship.xpos",				"8"			},
  { "spaceship.ypos",				"3"			},
  { "spaceship.frames",				"4"			},
  { "spaceship.delay",				"8"			},
  { "spaceship.right",				"RocksElements.pcx"	},
  { "spaceship.right.xpos",			"8"			},
  { "spaceship.right.ypos",			"3"			},
  { "spaceship.right.frames",			"1"			},
  { "spaceship.up",				"RocksElements.pcx"	},
  { "spaceship.up.xpos",			"9"			},
  { "spaceship.up.ypos",			"3"			},
  { "spaceship.up.frames",			"1"			},
  { "spaceship.left",				"RocksElements.pcx"	},
  { "spaceship.left.xpos",			"10"			},
  { "spaceship.left.ypos",			"3"			},
  { "spaceship.left.frames",			"1"			},
  { "spaceship.down",				"RocksElements.pcx"	},
  { "spaceship.down.xpos",			"11"			},
  { "spaceship.down.ypos",			"3"			},
  { "spaceship.down.frames",			"1"			},
  { "spaceship.moving.right",			"RocksElements.pcx"	},
  { "spaceship.moving.right.xpos",		"8"			},
  { "spaceship.moving.right.ypos",		"3"			},
  { "spaceship.moving.right.frames",		"2"			},
  { "spaceship.moving.right.delay",		"4"			},
  { "spaceship.moving.right.offset",		"128"			},
  { "spaceship.moving.up",			"RocksElements.pcx"	},
  { "spaceship.moving.up.xpos",			"9"			},
  { "spaceship.moving.up.ypos",			"3"			},
  { "spaceship.moving.up.frames",		"2"			},
  { "spaceship.moving.up.delay",		"4"			},
  { "spaceship.moving.up.offset",		"128"			},
  { "spaceship.moving.left",			"RocksElements.pcx"	},
  { "spaceship.moving.left.xpos",		"10"			},
  { "spaceship.moving.left.ypos",		"3"			},
  { "spaceship.moving.left.frames",		"2"			},
  { "spaceship.moving.left.delay",		"4"			},
  { "spaceship.moving.left.offset",		"128"			},
  { "spaceship.moving.down",			"RocksElements.pcx"	},
  { "spaceship.moving.down.xpos",		"11"			},
  { "spaceship.moving.down.ypos",		"3"			},
  { "spaceship.moving.down.frames",		"2"			},
  { "spaceship.moving.down.delay",		"4"			},
  { "spaceship.moving.down.offset",		"128"			},
  { "spaceship.turning_from_right.up",		"RocksMore.pcx"		},
  { "spaceship.turning_from_right.up.xpos",	"0"			},
  { "spaceship.turning_from_right.up.ypos",	"5"			},
  { "spaceship.turning_from_right.up.frames",	"4"			},
  { "spaceship.turning_from_right.up.delay",	"2"			},
  { "spaceship.turning_from_right.up.anim_mode","linear,reverse"	},
  { "spaceship.turning_from_up.left",		"RocksMore.pcx"		},
  { "spaceship.turning_from_up.left.xpos",	"12"			},
  { "spaceship.turning_from_up.left.ypos",	"5"			},
  { "spaceship.turning_from_up.left.frames",	"4"			},
  { "spaceship.turning_from_up.left.delay",	"2"			},
  { "spaceship.turning_from_up.left.anim_mode",	"linear,reverse"	},
  { "spaceship.turning_from_left.down",		"RocksMore.pcx"		},
  { "spaceship.turning_from_left.down.xpos",	"8"			},
  { "spaceship.turning_from_left.down.ypos",	"5"			},
  { "spaceship.turning_from_left.down.frames",	"4"			},
  { "spaceship.turning_from_left.down.delay",	"2"			},
  { "spaceship.turning_from_left.down.anim_mode","linear,reverse"	},
  { "spaceship.turning_from_down.right",	"RocksMore.pcx"		},
  { "spaceship.turning_from_down.right.xpos",	"4"			},
  { "spaceship.turning_from_down.right.ypos",	"5"			},
  { "spaceship.turning_from_down.right.frames",	"4"			},
  { "spaceship.turning_from_down.right.delay",	"2"			},
  { "spaceship.turning_from_down.right.anim_mode","linear,reverse"	},
  { "spaceship.turning_from_right.down",	"RocksMore.pcx"		},
  { "spaceship.turning_from_right.down.xpos",	"5"			},
  { "spaceship.turning_from_right.down.ypos",	"5"			},
  { "spaceship.turning_from_right.down.frames",	"4"			},
  { "spaceship.turning_from_right.down.delay",	"2"			},
  { "spaceship.turning_from_right.down.anim_mode","linear"		},
  { "spaceship.turning_from_up.right",		"RocksMore.pcx"		},
  { "spaceship.turning_from_up.right.xpos",	"1"			},
  { "spaceship.turning_from_up.right.ypos",	"5"			},
  { "spaceship.turning_from_up.right.frames",	"4"			},
  { "spaceship.turning_from_up.right.delay",	"2"			},
  { "spaceship.turning_from_up.right.anim_mode","linear"		},
  { "spaceship.turning_from_left.up",		"RocksMore.pcx"		},
  { "spaceship.turning_from_left.up.xpos",	"13"			},
  { "spaceship.turning_from_left.up.ypos",	"5"			},
  { "spaceship.turning_from_left.up.frames",	"4"			},
  { "spaceship.turning_from_left.up.delay",	"2"			},
  { "spaceship.turning_from_left.up.anim_mode",	"linear"		},
  { "spaceship.turning_from_down.left",		"RocksMore.pcx"		},
  { "spaceship.turning_from_down.left.xpos",	"9"			},
  { "spaceship.turning_from_down.left.ypos",	"5"			},
  { "spaceship.turning_from_down.left.frames",	"4"			},
  { "spaceship.turning_from_down.left.delay",	"2"			},
  { "spaceship.turning_from_down.left.anim_mode","linear"		},

  { "yamyam",					"RocksElements.pcx"	},
  { "yamyam.xpos",				"0"			},
  { "yamyam.ypos",				"5"			},
  { "yamyam.frames",				"4"			},
  { "yamyam.anim_mode",				"pingpong2"		},
  { "yamyam.moving",				"RocksElements.pcx"	},
  { "yamyam.moving.xpos",			"0"			},
  { "yamyam.moving.ypos",			"5"			},
  { "yamyam.moving.frames",			"1"			},

  { "robot",					"RocksElements.pcx"	},
  { "robot.xpos",				"4"			},
  { "robot.ypos",				"5"			},
  { "robot.frames",				"4"			},
  { "robot.anim_mode",				"pingpong2"		},
  { "robot.moving",				"RocksElements.pcx"	},
  { "robot.moving.xpos",			"4"			},
  { "robot.moving.ypos",			"5"			},
  { "robot.moving.frames",			"1"			},

  { "robot_wheel",				"RocksElements.pcx"	},
  { "robot_wheel.xpos",				"0"			},
  { "robot_wheel.ypos",				"6"			},
  { "robot_wheel.frames",			"1"			},
  { "robot_wheel.active",			"RocksElements.pcx"	},
  { "robot_wheel.active.xpos",			"0"			},
  { "robot_wheel.active.ypos",			"6"			},
  { "robot_wheel.active.frames",		"4"			},

  { "magic_wall",				"RocksElements.pcx"	},
  { "magic_wall.xpos",				"0"			},
  { "magic_wall.ypos",				"8"			},
  { "magic_wall.frames",			"1"			},
  { "magic_wall.active",			"RocksElements.pcx"	},
  { "magic_wall.active.xpos",			"0"			},
  { "magic_wall.active.ypos",			"8"			},
  { "magic_wall.active.frames",			"4"			},
  { "magic_wall.active.anim_mode",		"reverse"		},
  { "magic_wall.active.delay",			"4"			},
  { "magic_wall.active.global_sync",		"true"			},
  { "magic_wall.filling",			"RocksElements.pcx"	},
  { "magic_wall.filling.xpos",			"0"			},
  { "magic_wall.filling.ypos",			"8"			},
  { "magic_wall.filling.frames",		"4"			},
  { "magic_wall.filling.anim_mode",		"reverse"		},
  { "magic_wall.filling.delay",			"4"			},
  { "magic_wall.filling.global_sync",		"true"			},
  { "magic_wall_full",				"RocksElements.pcx"	},
  { "magic_wall_full.xpos",			"0"			},
  { "magic_wall_full.ypos",			"8"			},
  { "magic_wall_full.frames",			"4"			},
  { "magic_wall_full.anim_mode",		"reverse"		},
  { "magic_wall_full.delay",			"4"			},
  { "magic_wall_full.global_sync",		"true"			},
  { "magic_wall.emptying",			"RocksElements.pcx"	},
  { "magic_wall.emptying.xpos",			"0"			},
  { "magic_wall.emptying.ypos",			"8"			},
  { "magic_wall.emptying.frames",		"4"			},
  { "magic_wall.emptying.anim_mode",		"reverse"		},
  { "magic_wall.emptying.delay",		"4"			},
  { "magic_wall.emptying.global_sync",		"true"			},
  { "magic_wall_dead",				"RocksElements.pcx"	},
  { "magic_wall_dead.xpos",			"0"			},
  { "magic_wall_dead.ypos",			"8"			},
  { "magic_wall_dead.frames",			"1"			},

  { "quicksand_empty",				"RocksElements.pcx"	},
  { "quicksand_empty.xpos",			"2"			},
  { "quicksand_empty.ypos",			"0"			},
  { "quicksand_empty.frames",			"1"			},
  { "quicksand.filling",			"RocksElements.pcx"	},
  { "quicksand.filling.xpos",			"3"			},
  { "quicksand.filling.ypos",			"0"			},
  { "quicksand.filling.frames",			"1"			},
  { "quicksand_full",				"RocksElements.pcx"	},
  { "quicksand_full.xpos",			"3"			},
  { "quicksand_full.ypos",			"0"			},
  { "quicksand_full.frames",			"1"			},
  { "quicksand_full.EDITOR",			"RocksElements.pcx"	},
  { "quicksand_full.EDITOR.xpos",		"3"			},
  { "quicksand_full.EDITOR.ypos",		"14"			},
  { "quicksand.emptying",			"RocksElements.pcx"	},
  { "quicksand.emptying.xpos",			"3"			},
  { "quicksand.emptying.ypos",			"0"			},
  { "quicksand.emptying.frames",		"1"			},

  { "acid_pool_topleft",			"RocksElements.pcx"	},
  { "acid_pool_topleft.xpos",			"0"			},
  { "acid_pool_topleft.ypos",			"1"			},
  { "acid_pool_topleft.frames",			"1"			},
  { "acid_pool_topright",			"RocksElements.pcx"	},
  { "acid_pool_topright.xpos",			"2"			},
  { "acid_pool_topright.ypos",			"1"			},
  { "acid_pool_topright.frames",		"1"			},
  { "acid_pool_bottomleft",			"RocksElements.pcx"	},
  { "acid_pool_bottomleft.xpos",		"0"			},
  { "acid_pool_bottomleft.ypos",		"2"			},
  { "acid_pool_bottomleft.frames",		"1"			},
  { "acid_pool_bottom",				"RocksElements.pcx"	},
  { "acid_pool_bottom.xpos",			"1"			},
  { "acid_pool_bottom.ypos",			"2"			},
  { "acid_pool_bottom.frames",			"1"			},
  { "acid_pool_bottomright",			"RocksElements.pcx"	},
  { "acid_pool_bottomright.xpos",		"2"			},
  { "acid_pool_bottomright.ypos",		"2"			},
  { "acid_pool_bottomright.frames",		"1"			},

  { "acid",					"RocksElements.pcx"	},
  { "acid.xpos",				"12"			},
  { "acid.ypos",				"7"			},
  { "acid.frames",				"4"			},
  { "acid.delay",				"10"			},
  { "acid.global_sync",				"true"			},

  { "acid_splash_left",				"RocksHeroes.pcx"	},
  { "acid_splash_left.xpos",			"8"			},
  { "acid_splash_left.ypos",			"10"			},
  { "acid_splash_left.frames",			"4"			},
  { "acid_splash_left.delay",			"2"			},
  { "acid_splash_left.anim_mode",		"linear"		},
  { "acid_splash_right",			"RocksHeroes.pcx"	},
  { "acid_splash_right.xpos",			"12"			},
  { "acid_splash_right.ypos",			"10"			},
  { "acid_splash_right.frames",			"4"			},
  { "acid_splash_right.delay",			"2"			},
  { "acid_splash_right.anim_mode",		"linear"		},

  { "amoeba_drop",				"RocksElements.pcx"	},
  { "amoeba_drop.xpos",				"5"			},
  { "amoeba_drop.ypos",				"6"			},
  { "amoeba_drop.frames",			"1"			},
  { "amoeba.growing",				"RocksElements.pcx"	},
  { "amoeba.growing.xpos",			"5"			},
  { "amoeba.growing.ypos",			"6"			},
  { "amoeba.growing.frames",			"3"			},
  { "amoeba.growing.delay",			"2"			},
  { "amoeba.growing.anim_mode",			"linear"		},
  { "amoeba.shrinking",				"RocksElements.pcx"	},
  { "amoeba.shrinking.xpos",			"5"			},
  { "amoeba.shrinking.ypos",			"6"			},
  { "amoeba.shrinking.frames",			"3"			},
  { "amoeba.shrinking.delay",			"2"			},
  { "amoeba.shrinking.anim_mode",		"linear,reverse"	},
  { "amoeba_wet",				"RocksElements.pcx"	},
  { "amoeba_wet.xpos",				"8"			},
  { "amoeba_wet.ypos",				"6"			},
  { "amoeba_wet.frames",			"4"			},
  { "amoeba_wet.delay",				"1000000"		},
  { "amoeba_wet.anim_mode",			"random"		},
  { "amoeba_wet.EDITOR",			"RocksElements.pcx"	},
  { "amoeba_wet.EDITOR.xpos",			"4"			},
  { "amoeba_wet.EDITOR.ypos",			"6"			},
  { "amoeba.dropping",				"RocksElements.pcx"	},
  { "amoeba.dropping.xpos",			"8"			},
  { "amoeba.dropping.ypos",			"6"			},
  { "amoeba.dropping.frames",			"4"			},
  { "amoeba.dropping.delay",			"1000000"		},
  { "amoeba.dropping.anim_mode",		"random"		},
  { "amoeba_dry",				"RocksElements.pcx"	},
  { "amoeba_dry.xpos",				"8"			},
  { "amoeba_dry.ypos",				"6"			},
  { "amoeba_dry.frames",			"4"			},
  { "amoeba_dry.delay",				"1000000"		},
  { "amoeba_dry.anim_mode",			"random"		},
  { "amoeba_full",				"RocksElements.pcx"	},
  { "amoeba_full.xpos",				"8"			},
  { "amoeba_full.ypos",				"6"			},
  { "amoeba_full.frames",			"4"			},
  { "amoeba_full.delay",			"1000000"		},
  { "amoeba_full.anim_mode",			"random"		},
  { "amoeba_full.EDITOR",			"RocksElements.pcx"	},
  { "amoeba_full.EDITOR.xpos",			"8"			},
  { "amoeba_full.EDITOR.ypos",			"7"			},
  { "amoeba_dead",				"RocksElements.pcx"	},
  { "amoeba_dead.xpos",				"12"			},
  { "amoeba_dead.ypos",				"6"			},
  { "amoeba_dead.frames",			"4"			},
  { "amoeba_dead.delay",			"1000000"		},
  { "amoeba_dead.anim_mode",			"random"		},
  { "amoeba_dead.EDITOR",			"RocksElements.pcx"	},
  { "amoeba_dead.EDITOR.xpos",			"12"			},
  { "amoeba_dead.EDITOR.ypos",			"6"			},

  { "em_key_1",					"RocksSP.pcx"		},
  { "em_key_1.xpos",				"4"			},
  { "em_key_1.ypos",				"6"			},
  { "em_key_1.frames",				"1"			},
  { "em_key_2",					"RocksSP.pcx"		},
  { "em_key_2.xpos",				"5"			},
  { "em_key_2.ypos",				"6"			},
  { "em_key_2.frames",				"1"			},
  { "em_key_3",					"RocksSP.pcx"		},
  { "em_key_3.xpos",				"6"			},
  { "em_key_3.ypos",				"6"			},
  { "em_key_3.frames",				"1"			},
  { "em_key_4",					"RocksSP.pcx"		},
  { "em_key_4.xpos",				"7"			},
  { "em_key_4.ypos",				"6"			},
  { "em_key_4.frames",				"1"			},

  { "em_gate_1",				"RocksSP.pcx"		},
  { "em_gate_1.xpos",				"0"			},
  { "em_gate_1.ypos",				"7"			},
  { "em_gate_1.frames",				"1"			},
  { "em_gate_2",				"RocksSP.pcx"		},
  { "em_gate_2.xpos",				"1"			},
  { "em_gate_2.ypos",				"7"			},
  { "em_gate_2.frames",				"1"			},
  { "em_gate_3",				"RocksSP.pcx"		},
  { "em_gate_3.xpos",				"2"			},
  { "em_gate_3.ypos",				"7"			},
  { "em_gate_3.frames",				"1"			},
  { "em_gate_4",				"RocksSP.pcx"		},
  { "em_gate_4.xpos",				"3"			},
  { "em_gate_4.ypos",				"7"			},
  { "em_gate_4.frames",				"1"			},
  { "em_gate_1_gray",				"RocksSP.pcx"		},
  { "em_gate_1_gray.xpos",			"4"			},
  { "em_gate_1_gray.ypos",			"7"			},
  { "em_gate_1_gray.frames",			"1"			},
  { "em_gate_1_gray.EDITOR",			"RocksSP.pcx"		},
  { "em_gate_1_gray.EDITOR.xpos",		"12"			},
  { "em_gate_1_gray.EDITOR.ypos",		"11"			},
  { "em_gate_2_gray",				"RocksSP.pcx"		},
  { "em_gate_2_gray.xpos",			"5"			},
  { "em_gate_2_gray.ypos",			"7"			},
  { "em_gate_2_gray.frames",			"1"			},
  { "em_gate_2_gray.EDITOR",			"RocksSP.pcx"		},
  { "em_gate_2_gray.EDITOR.xpos",		"13"			},
  { "em_gate_2_gray.EDITOR.ypos",		"11"			},
  { "em_gate_3_gray",				"RocksSP.pcx"		},
  { "em_gate_3_gray.xpos",			"6"			},
  { "em_gate_3_gray.ypos",			"7"			},
  { "em_gate_3_gray.frames",			"1"			},
  { "em_gate_3_gray.EDITOR",			"RocksSP.pcx"		},
  { "em_gate_3_gray.EDITOR.xpos",		"14"			},
  { "em_gate_3_gray.EDITOR.ypos",		"11"			},
  { "em_gate_4_gray",				"RocksSP.pcx"		},
  { "em_gate_4_gray.xpos",			"7"			},
  { "em_gate_4_gray.ypos",			"7"			},
  { "em_gate_4_gray.frames",			"1"			},
  { "em_gate_4_gray.EDITOR",			"RocksSP.pcx"		},
  { "em_gate_4_gray.EDITOR.xpos",		"15"			},
  { "em_gate_4_gray.EDITOR.ypos",		"11"			},

  { "exit_closed",				"RocksElements.pcx"	},
  { "exit_closed.xpos",				"0"			},
  { "exit_closed.ypos",				"11"			},
  { "exit_closed.frames",			"1"			},
  { "exit.opening",				"RocksElements.pcx"	},
  { "exit.opening.xpos",			"0"			},
  { "exit.opening.ypos",			"11"			},
  { "exit.opening.frames",			"5"			},
  { "exit.opening.delay",			"6"			},
  { "exit.opening.anim_mode",			"linear"		},
  { "exit_open",				"RocksElements.pcx"	},
  { "exit_open.xpos",				"4"			},
  { "exit_open.ypos",				"11"			},
  { "exit_open.frames",				"4"			},
  { "exit_open.delay",				"4"			},
  { "exit_open.anim_mode",			"pingpong"		},
  { "exit.closing",				"RocksElements.pcx"	},
  { "exit.closing.xpos",			"0"			},
  { "exit.closing.ypos",			"11"			},
  { "exit.closing.frames",			"5"			},
  { "exit.closing.delay",			"6"			},
  { "exit.closing.anim_mode",			"linear,reverse"	},

  /* images for Emerald Mine Club style elements and actions */

  { "balloon",					"RocksDC.pcx"		},
  { "balloon.xpos",				"12"			},
  { "balloon.ypos",				"7"			},
  { "balloon.frames",				"1"			},
  { "balloon.moving",				"RocksDC.pcx"		},
  { "balloon.moving.xpos",			"12"			},
  { "balloon.moving.ypos",			"7"			},
  { "balloon.moving.frames",			"4"			},
  { "balloon.moving.anim_mode",			"pingpong"		},
  { "balloon.moving.delay",			"2"			},
  { "balloon.pushing",				"RocksDC.pcx"		},
  { "balloon.pushing.xpos",			"12"			},
  { "balloon.pushing.ypos",			"7"			},
  { "balloon.pushing.frames",			"4"			},
  { "balloon.pushing.anim_mode",		"pingpong"		},
  { "balloon.pushing.delay",			"2"			},
  { "balloon_switch_left",			"RocksDC.pcx"		},
  { "balloon_switch_left.xpos",			"8"			},
  { "balloon_switch_left.ypos",			"7"			},
  { "balloon_switch_left.frames",		"1"			},
  { "balloon_switch_right",			"RocksDC.pcx"		},
  { "balloon_switch_right.xpos",		"9"			},
  { "balloon_switch_right.ypos",		"7"			},
  { "balloon_switch_right.frames",		"1"			},
  { "balloon_switch_up",			"RocksDC.pcx"		},
  { "balloon_switch_up.xpos",			"10"			},
  { "balloon_switch_up.ypos",			"7"			},
  { "balloon_switch_up.frames",			"1"			},
  { "balloon_switch_down",			"RocksDC.pcx"		},
  { "balloon_switch_down.xpos",			"11"			},
  { "balloon_switch_down.ypos",			"7"			},
  { "balloon_switch_down.frames",		"1"			},
  { "balloon_switch_any",			"RocksDC.pcx"		},
  { "balloon_switch_any.xpos",			"15"			},
  { "balloon_switch_any.ypos",			"0"			},
  { "balloon_switch_any.frames",		"1"			},
  { "balloon_switch_none",			"RocksDC.pcx"		},
  { "balloon_switch_none.xpos",			"13"			},
  { "balloon_switch_none.ypos",			"5"			},
  { "balloon_switch_none.frames",		"1"			},

  { "spring",					"RocksDC.pcx"		},
  { "spring.xpos",				"8"			},
  { "spring.ypos",				"13"			},
  { "spring.frames",				"1"			},

  { "emc_steelwall_1",				"RocksDC.pcx"		},
  { "emc_steelwall_1.xpos",			"14"			},
  { "emc_steelwall_1.ypos",			"0"			},
  { "emc_steelwall_1.frames",			"1"			},
  { "emc_steelwall_2",				"RocksEMC.pcx"		},
  { "emc_steelwall_2.xpos",			"9"			},
  { "emc_steelwall_2.ypos",			"8"			},
  { "emc_steelwall_2.frames",			"1"			},
  { "emc_steelwall_3",				"RocksEMC.pcx"		},
  { "emc_steelwall_3.xpos",			"9"			},
  { "emc_steelwall_3.ypos",			"9"			},
  { "emc_steelwall_3.frames",			"1"			},
  { "emc_steelwall_4",				"RocksEMC.pcx"		},
  { "emc_steelwall_4.xpos",			"9"			},
  { "emc_steelwall_4.ypos",			"10"			},
  { "emc_steelwall_4.frames",			"1"			},

  { "emc_wall_1",				"RocksDC.pcx"		},
  { "emc_wall_1.xpos",				"13"			},
  { "emc_wall_1.ypos",				"6"			},
  { "emc_wall_1.frames",			"1"			},
  { "emc_wall_2",				"RocksDC.pcx"		},
  { "emc_wall_2.xpos",				"14"			},
  { "emc_wall_2.ypos",				"6"			},
  { "emc_wall_2.frames",			"1"			},
  { "emc_wall_3",				"RocksDC.pcx"		},
  { "emc_wall_3.xpos",				"15"			},
  { "emc_wall_3.ypos",				"6"			},
  { "emc_wall_3.frames",			"1"			},
  { "emc_wall_4",				"RocksDC.pcx"		},
  { "emc_wall_4.xpos",				"14"			},
  { "emc_wall_4.ypos",				"1"			},
  { "emc_wall_4.frames",			"1"			},
  { "emc_wall_5",				"RocksDC.pcx"		},
  { "emc_wall_5.xpos",				"15"			},
  { "emc_wall_5.ypos",				"1"			},
  { "emc_wall_5.frames",			"1"			},
  { "emc_wall_6",				"RocksDC.pcx"		},
  { "emc_wall_6.xpos",				"14"			},
  { "emc_wall_6.ypos",				"2"			},
  { "emc_wall_6.frames",			"1"			},
  { "emc_wall_7",				"RocksDC.pcx"		},
  { "emc_wall_7.xpos",				"15"			},
  { "emc_wall_7.ypos",				"2"			},
  { "emc_wall_7.frames",			"1"			},
  { "emc_wall_8",				"RocksEMC.pcx"		},
  { "emc_wall_8.xpos",				"8"			},
  { "emc_wall_8.ypos",				"7"			},
  { "emc_wall_8.frames",			"1"			},

  /* images for Diamond Caves style elements and actions */

  { "invisible_steelwall",			"RocksSP.pcx"		},
  { "invisible_steelwall.xpos",			"3"			},
  { "invisible_steelwall.ypos",			"5"			},
  { "invisible_steelwall.frames",		"1"			},
  { "invisible_steelwall.EDITOR",		"RocksSP.pcx"		},
  { "invisible_steelwall.EDITOR.xpos",		"1"			},
  { "invisible_steelwall.EDITOR.ypos",		"5"			},
  { "invisible_steelwall.active",		"RocksSP.pcx"		},
  { "invisible_steelwall.active.xpos",		"1"			},
  { "invisible_steelwall.active.ypos",		"5"			},
  { "invisible_steelwall.active.frames",	"1"			},

  { "invisible_wall",				"RocksSP.pcx"		},
  { "invisible_wall.xpos",			"7"			},
  { "invisible_wall.ypos",			"5"			},
  { "invisible_wall.frames",			"1"			},
  { "invisible_wall.EDITOR",			"RocksSP.pcx"		},
  { "invisible_wall.EDITOR.xpos",		"5"			},
  { "invisible_wall.EDITOR.ypos",		"5"			},
  { "invisible_wall.active",			"RocksSP.pcx"		},
  { "invisible_wall.active.xpos",		"5"			},
  { "invisible_wall.active.ypos",		"5"			},
  { "invisible_wall.active.frames",		"1"			},

  { "invisible_sand",				"RocksSP.pcx"		},
  { "invisible_sand.xpos",			"0"			},
  { "invisible_sand.ypos",			"0"			},
  { "invisible_sand.frames",			"1"			},
  { "invisible_sand.EDITOR",			"RocksEMC.pcx"		},
  { "invisible_sand.EDITOR.xpos",		"2"			},
  { "invisible_sand.EDITOR.ypos",		"4"			},
  { "invisible_sand.active",			"RocksEMC.pcx"		},
  { "invisible_sand.active.xpos",		"2"			},
  { "invisible_sand.active.ypos",		"4"			},
  { "invisible_sand.active.frames",		"1"			},
  { "invisible_sand.active.CRUMBLED",		"RocksEMC.pcx"		},
  { "invisible_sand.active.CRUMBLED.xpos",	"3"			},
  { "invisible_sand.active.CRUMBLED.ypos",	"4"			},
  { "invisible_sand.active.CRUMBLED.frames",	"1"			},
  { "invisible_sand.active.digging.left",	"RocksEMC.pcx"		},
  { "invisible_sand.active.digging.left.xpos",	"6"			},
  { "invisible_sand.active.digging.left.ypos",	"2"			},
  { "invisible_sand.active.digging.left.frames","3"			},
  { "invisible_sand.active.digging.left.delay",	"2"			},
  { "invisible_sand.active.digging.left.anim_mode","linear"		},
  { "invisible_sand.active.digging.right",	"RocksEMC.pcx"		},
  { "invisible_sand.active.digging.right.xpos",	"9"			},
  { "invisible_sand.active.digging.right.ypos",	"2"			},
  { "invisible_sand.active.digging.right.frames","3"			},
  { "invisible_sand.active.digging.right.delay","2"			},
  { "invisible_sand.active.digging.right.anim_mode","linear"		},
  { "invisible_sand.active.digging.up",		"RocksEMC.pcx"		},
  { "invisible_sand.active.digging.up.xpos",	"0"			},
  { "invisible_sand.active.digging.up.ypos",	"2"			},
  { "invisible_sand.active.digging.up.frames",	"3"			},
  { "invisible_sand.active.digging.up.delay",	"2"			},
  { "invisible_sand.active.digging.up.anim_mode","linear"		},
  { "invisible_sand.active.digging.down",	"RocksEMC.pcx"		},
  { "invisible_sand.active.digging.down.xpos",	"3"			},
  { "invisible_sand.active.digging.down.ypos",	"2"			},
  { "invisible_sand.active.digging.down.frames","3"			},
  { "invisible_sand.active.digging.down.delay",	"2"			},
  { "invisible_sand.active.digging.down.anim_mode","linear"		},
  { "invisible_sand.active.digging.left.CRUMBLED",	"RocksEMC.pcx"	},
  { "invisible_sand.active.digging.left.CRUMBLED.xpos",	"6"		},
  { "invisible_sand.active.digging.left.CRUMBLED.ypos",	"3"		},
  { "invisible_sand.active.digging.left.CRUMBLED.frames","3"		},
  { "invisible_sand.active.digging.left.CRUMBLED.delay","2"		},
  { "invisible_sand.active.digging.left.CRUMBLED.anim_mode","linear"	},
  { "invisible_sand.active.digging.right.CRUMBLED",	"RocksEMC.pcx"	},
  { "invisible_sand.active.digging.right.CRUMBLED.xpos","9"		},
  { "invisible_sand.active.digging.right.CRUMBLED.ypos","3"		},
  { "invisible_sand.active.digging.right.CRUMBLED.frames","3"		},
  { "invisible_sand.active.digging.right.CRUMBLED.delay","2"		},
  { "invisible_sand.active.digging.right.CRUMBLED.anim_mode","linear"	},
  { "invisible_sand.active.digging.up.CRUMBLED",	"RocksEMC.pcx"	},
  { "invisible_sand.active.digging.up.CRUMBLED.xpos",	"0"		},
  { "invisible_sand.active.digging.up.CRUMBLED.ypos",	"3"		},
  { "invisible_sand.active.digging.up.CRUMBLED.frames",	"3"		},
  { "invisible_sand.active.digging.up.CRUMBLED.delay",	"2"		},
  { "invisible_sand.active.digging.up.CRUMBLED.anim_mode","linear"	},
  { "invisible_sand.active.digging.down.CRUMBLED",	"RocksEMC.pcx"	},
  { "invisible_sand.active.digging.down.CRUMBLED.xpos",	"3"		},
  { "invisible_sand.active.digging.down.CRUMBLED.ypos",	"3"		},
  { "invisible_sand.active.digging.down.CRUMBLED.frames","3"		},
  { "invisible_sand.active.digging.down.CRUMBLED.delay","2"		},
  { "invisible_sand.active.digging.down.CRUMBLED.anim_mode","linear"	},

  { "conveyor_belt_1_middle",			"RocksDC.pcx"		},
  { "conveyor_belt_1_middle.xpos",		"0"			},
  { "conveyor_belt_1_middle.ypos",		"0"			},
  { "conveyor_belt_1_middle.frames",		"1"			},
  { "conveyor_belt_1_middle.active",		"RocksDC.pcx"		},
  { "conveyor_belt_1_middle.active.xpos",	"0"			},
  { "conveyor_belt_1_middle.active.ypos",	"0"			},
  { "conveyor_belt_1_middle.active.frames",	"8"			},
  { "conveyor_belt_1_middle.active.delay",	"2"			},
  { "conveyor_belt_1_left",			"RocksDC.pcx"		},
  { "conveyor_belt_1_left.xpos",		"0"			},
  { "conveyor_belt_1_left.ypos",		"1"			},
  { "conveyor_belt_1_left.frames",		"1"			},
  { "conveyor_belt_1_left.active",		"RocksDC.pcx"		},
  { "conveyor_belt_1_left.active.xpos",		"0"			},
  { "conveyor_belt_1_left.active.ypos",		"1"			},
  { "conveyor_belt_1_left.active.frames",	"8"			},
  { "conveyor_belt_1_left.active.delay",	"2"			},
  { "conveyor_belt_1_right",			"RocksDC.pcx"		},
  { "conveyor_belt_1_right.xpos",		"0"			},
  { "conveyor_belt_1_right.ypos",		"2"			},
  { "conveyor_belt_1_right.frames",		"1"			},
  { "conveyor_belt_1_right.active",		"RocksDC.pcx"		},
  { "conveyor_belt_1_right.active.xpos",	"0"			},
  { "conveyor_belt_1_right.active.ypos",	"2"			},
  { "conveyor_belt_1_right.active.frames",	"8"			},
  { "conveyor_belt_1_right.active.delay",	"2"			},
  { "conveyor_belt_1_switch_left",		"RocksDC.pcx"		},
  { "conveyor_belt_1_switch_left.xpos",		"0"			},
  { "conveyor_belt_1_switch_left.ypos",		"12"			},
  { "conveyor_belt_1_switch_left.frames",	"1"			},
  { "conveyor_belt_1_switch_middle",		"RocksDC.pcx"		},
  { "conveyor_belt_1_switch_middle.xpos",	"0"			},
  { "conveyor_belt_1_switch_middle.ypos",	"13"			},
  { "conveyor_belt_1_switch_middle.frames",	"1"			},
  { "conveyor_belt_1_switch_right",		"RocksDC.pcx"		},
  { "conveyor_belt_1_switch_right.xpos",	"0"			},
  { "conveyor_belt_1_switch_right.ypos",	"14"			},
  { "conveyor_belt_1_switch_right.frames",	"1"			},

  { "conveyor_belt_2_middle",			"RocksDC.pcx"		},
  { "conveyor_belt_2_middle.xpos",		"0"			},
  { "conveyor_belt_2_middle.ypos",		"3"			},
  { "conveyor_belt_2_middle.frames",		"1"			},
  { "conveyor_belt_2_middle.active",		"RocksDC.pcx"		},
  { "conveyor_belt_2_middle.active.xpos",	"0"			},
  { "conveyor_belt_2_middle.active.ypos",	"3"			},
  { "conveyor_belt_2_middle.active.frames",	"8"			},
  { "conveyor_belt_2_middle.active.delay",	"2"			},
  { "conveyor_belt_2_left",			"RocksDC.pcx"		},
  { "conveyor_belt_2_left.xpos",		"0"			},
  { "conveyor_belt_2_left.ypos",		"4"			},
  { "conveyor_belt_2_left.frames",		"1"			},
  { "conveyor_belt_2_left.active",		"RocksDC.pcx"		},
  { "conveyor_belt_2_left.active.xpos",		"0"			},
  { "conveyor_belt_2_left.active.ypos",		"4"			},
  { "conveyor_belt_2_left.active.frames",	"8"			},
  { "conveyor_belt_2_left.active.delay",	"2"			},
  { "conveyor_belt_2_right",			"RocksDC.pcx"		},
  { "conveyor_belt_2_right.xpos",		"0"			},
  { "conveyor_belt_2_right.ypos",		"5"			},
  { "conveyor_belt_2_right.frames",		"1"			},
  { "conveyor_belt_2_right.active",		"RocksDC.pcx"		},
  { "conveyor_belt_2_right.active.xpos",	"0"			},
  { "conveyor_belt_2_right.active.ypos",	"5"			},
  { "conveyor_belt_2_right.active.frames",	"8"			},
  { "conveyor_belt_2_right.active.delay",	"2"			},
  { "conveyor_belt_2_switch_left",		"RocksDC.pcx"		},
  { "conveyor_belt_2_switch_left.xpos",		"1"			},
  { "conveyor_belt_2_switch_left.ypos",		"12"			},
  { "conveyor_belt_2_switch_left.frames",	"1"			},
  { "conveyor_belt_2_switch_middle",		"RocksDC.pcx"		},
  { "conveyor_belt_2_switch_middle.xpos",	"1"			},
  { "conveyor_belt_2_switch_middle.ypos",	"13"			},
  { "conveyor_belt_2_switch_middle.frames",	"1"			},
  { "conveyor_belt_2_switch_right",		"RocksDC.pcx"		},
  { "conveyor_belt_2_switch_right.xpos",	"1"			},
  { "conveyor_belt_2_switch_right.ypos",	"14"			},
  { "conveyor_belt_2_switch_right.frames",	"1"			},

  { "conveyor_belt_3_middle",			"RocksDC.pcx"		},
  { "conveyor_belt_3_middle.xpos",		"0"			},
  { "conveyor_belt_3_middle.ypos",		"6"			},
  { "conveyor_belt_3_middle.frames",		"1"			},
  { "conveyor_belt_3_middle.active",		"RocksDC.pcx"		},
  { "conveyor_belt_3_middle.active.xpos",	"0"			},
  { "conveyor_belt_3_middle.active.ypos",	"6"			},
  { "conveyor_belt_3_middle.active.frames",	"8"			},
  { "conveyor_belt_3_middle.active.delay",	"2"			},
  { "conveyor_belt_3_left",			"RocksDC.pcx"		},
  { "conveyor_belt_3_left.xpos",		"0"			},
  { "conveyor_belt_3_left.ypos",		"7"			},
  { "conveyor_belt_3_left.frames",		"1"			},
  { "conveyor_belt_3_left.active",		"RocksDC.pcx"		},
  { "conveyor_belt_3_left.active.xpos",		"0"			},
  { "conveyor_belt_3_left.active.ypos",		"7"			},
  { "conveyor_belt_3_left.active.frames",	"8"			},
  { "conveyor_belt_3_left.active.delay",	"2"			},
  { "conveyor_belt_3_right",			"RocksDC.pcx"		},
  { "conveyor_belt_3_right.xpos",		"0"			},
  { "conveyor_belt_3_right.ypos",		"8"			},
  { "conveyor_belt_3_right.frames",		"1"			},
  { "conveyor_belt_3_right.active",		"RocksDC.pcx"		},
  { "conveyor_belt_3_right.active.xpos",	"0"			},
  { "conveyor_belt_3_right.active.ypos",	"8"			},
  { "conveyor_belt_3_right.active.frames",	"8"			},
  { "conveyor_belt_3_right.active.delay",	"2"			},
  { "conveyor_belt_3_switch_left",		"RocksDC.pcx"		},
  { "conveyor_belt_3_switch_left.xpos",		"2"			},
  { "conveyor_belt_3_switch_left.ypos",		"12"			},
  { "conveyor_belt_3_switch_left.frames",	"1"			},
  { "conveyor_belt_3_switch_middle",		"RocksDC.pcx"		},
  { "conveyor_belt_3_switch_middle.xpos",	"2"			},
  { "conveyor_belt_3_switch_middle.ypos",	"13"			},
  { "conveyor_belt_3_switch_middle.frames",	"1"			},
  { "conveyor_belt_3_switch_right",		"RocksDC.pcx"		},
  { "conveyor_belt_3_switch_right.xpos",	"2"			},
  { "conveyor_belt_3_switch_right.ypos",	"14"			},
  { "conveyor_belt_3_switch_right.frames",	"1"			},

  { "conveyor_belt_4_middle",			"RocksDC.pcx"		},
  { "conveyor_belt_4_middle.xpos",		"0"			},
  { "conveyor_belt_4_middle.ypos",		"9"			},
  { "conveyor_belt_4_middle.frames",		"1"			},
  { "conveyor_belt_4_middle.active",		"RocksDC.pcx"		},
  { "conveyor_belt_4_middle.active.xpos",	"0"			},
  { "conveyor_belt_4_middle.active.ypos",	"9"			},
  { "conveyor_belt_4_middle.active.frames",	"8"			},
  { "conveyor_belt_4_middle.active.delay",	"2"			},
  { "conveyor_belt_4_left",			"RocksDC.pcx"		},
  { "conveyor_belt_4_left.xpos",		"0"			},
  { "conveyor_belt_4_left.ypos",		"10"			},
  { "conveyor_belt_4_left.frames",		"1"			},
  { "conveyor_belt_4_left.active",		"RocksDC.pcx"		},
  { "conveyor_belt_4_left.active.xpos",		"0"			},
  { "conveyor_belt_4_left.active.ypos",		"10"			},
  { "conveyor_belt_4_left.active.frames",	"8"			},
  { "conveyor_belt_4_left.active.delay",	"2"			},
  { "conveyor_belt_4_right",			"RocksDC.pcx"		},
  { "conveyor_belt_4_right.xpos",		"0"			},
  { "conveyor_belt_4_right.ypos",		"11"			},
  { "conveyor_belt_4_right.frames",		"1"			},
  { "conveyor_belt_4_right.active",		"RocksDC.pcx"		},
  { "conveyor_belt_4_right.active.xpos",	"0"			},
  { "conveyor_belt_4_right.active.ypos",	"11"			},
  { "conveyor_belt_4_right.active.frames",	"8"			},
  { "conveyor_belt_4_right.active.delay",	"2"			},
  { "conveyor_belt_4_switch_left",		"RocksDC.pcx"		},
  { "conveyor_belt_4_switch_left.xpos",		"3"			},
  { "conveyor_belt_4_switch_left.ypos",		"12"			},
  { "conveyor_belt_4_switch_left.frames",	"1"			},
  { "conveyor_belt_4_switch_middle",		"RocksDC.pcx"		},
  { "conveyor_belt_4_switch_middle.xpos",	"3"			},
  { "conveyor_belt_4_switch_middle.ypos",	"13"			},
  { "conveyor_belt_4_switch_middle.frames",	"1"			},
  { "conveyor_belt_4_switch_right",		"RocksDC.pcx"		},
  { "conveyor_belt_4_switch_right.xpos",	"3"			},
  { "conveyor_belt_4_switch_right.ypos",	"14"			},
  { "conveyor_belt_4_switch_right.frames",	"1"			},

  { "switchgate_switch_up",			"RocksDC.pcx"		},
  { "switchgate_switch_up.xpos",		"4"			},
  { "switchgate_switch_up.ypos",		"12"			},
  { "switchgate_switch_up.frames",		"1"			},
  { "switchgate_switch_down",			"RocksDC.pcx"		},
  { "switchgate_switch_down.xpos",		"5"			},
  { "switchgate_switch_down.ypos",		"12"			},
  { "switchgate_switch_down.frames",		"1"			},

  { "light_switch",				"RocksDC.pcx"		},
  { "light_switch.xpos",			"6"			},
  { "light_switch.ypos",			"12"			},
  { "light_switch.frames",			"1"			},
  { "light_switch.active",			"RocksDC.pcx"		},
  { "light_switch.active.xpos",			"7"			},
  { "light_switch.active.ypos",			"12"			},
  { "light_switch.active.frames",		"1"			},

  { "timegate_switch",				"RocksDC.pcx"		},
  { "timegate_switch.xpos",			"0"			},
  { "timegate_switch.ypos",			"15"			},
  { "timegate_switch.frames",			"1"			},
  { "timegate_switch.active",			"RocksDC.pcx"		},
  { "timegate_switch.active.xpos",		"0"			},
  { "timegate_switch.active.ypos",		"15"			},
  { "timegate_switch.active.frames",		"4"			},

  { "envelope_1",				"RocksMore.pcx"		},
  { "envelope_1.xpos",				"0"			},
  { "envelope_1.ypos",				"4"			},
  { "envelope_1.frames",			"1"			},
  { "envelope_1.collecting",			"RocksMore.pcx"		},
  { "envelope_1.collecting.xpos",		"5"			},
  { "envelope_1.collecting.ypos",		"4"			},
  { "envelope_1.collecting.frames",		"3"			},
  { "envelope_1.collecting.delay",		"2"			},
  { "envelope_1.collecting.anim_mode",		"linear"		},
  { "envelope_2",				"RocksMore.pcx"		},
  { "envelope_2.xpos",				"1"			},
  { "envelope_2.ypos",				"4"			},
  { "envelope_2.frames",			"1"			},
  { "envelope_2.collecting",			"RocksMore.pcx"		},
  { "envelope_2.collecting.xpos",		"5"			},
  { "envelope_2.collecting.ypos",		"4"			},
  { "envelope_2.collecting.frames",		"3"			},
  { "envelope_2.collecting.delay",		"2"			},
  { "envelope_2.collecting.anim_mode",		"linear"		},
  { "envelope_3",				"RocksMore.pcx"		},
  { "envelope_3.xpos",				"2"			},
  { "envelope_3.ypos",				"4"			},
  { "envelope_3.frames",			"1"			},
  { "envelope_3.collecting",			"RocksMore.pcx"		},
  { "envelope_3.collecting.xpos",		"5"			},
  { "envelope_3.collecting.ypos",		"4"			},
  { "envelope_3.collecting.frames",		"3"			},
  { "envelope_3.collecting.delay",		"2"			},
  { "envelope_3.collecting.anim_mode",		"linear"		},
  { "envelope_4",				"RocksMore.pcx"		},
  { "envelope_4.xpos",				"3"			},
  { "envelope_4.ypos",				"4"			},
  { "envelope_4.frames",			"1"			},
  { "envelope_4.collecting",			"RocksMore.pcx"		},
  { "envelope_4.collecting.xpos",		"5"			},
  { "envelope_4.collecting.ypos",		"4"			},
  { "envelope_4.collecting.frames",		"3"			},
  { "envelope_4.collecting.delay",		"2"			},
  { "envelope_4.collecting.anim_mode",		"linear"		},

  { "sign_exclamation",				"RocksDC.pcx"		},
  { "sign_exclamation.xpos",			"5"			},
  { "sign_exclamation.ypos",			"14"			},
  { "sign_exclamation.frames",			"1"			},

  { "sign_stop",				"RocksDC.pcx"		},
  { "sign_stop.xpos",				"6"			},
  { "sign_stop.ypos",				"14"			},
  { "sign_stop.frames",				"1"			},

  { "landmine",					"RocksDC.pcx"		},
  { "landmine.xpos",				"7"			},
  { "landmine.ypos",				"14"			},
  { "landmine.frames",				"1"			},
  { "landmine.crumbled_like",			"sand"			},

  { "steelwall_slippery",			"RocksDC.pcx"		},
  { "steelwall_slippery.xpos",			"5"			},
  { "steelwall_slippery.ypos",			"15"			},
  { "steelwall_slippery.frames",		"1"			},

  { "extra_time",				"RocksDC.pcx"		},
  { "extra_time.xpos",				"8"			},
  { "extra_time.ypos",				"0"			},
  { "extra_time.frames",			"6"			},
  { "extra_time.delay",				"4"			},

  { "shield_normal",				"RocksDC.pcx"		},
  { "shield_normal.xpos",			"8"			},
  { "shield_normal.ypos",			"2"			},
  { "shield_normal.frames",			"6"			},
  { "shield_normal.delay",			"4"			},
  { "shield_normal.active",			"RocksHeroes.pcx"	},
  { "shield_normal.active.xpos",		"1"			},
  { "shield_normal.active.ypos",		"13"			},
  { "shield_normal.active.frames",		"3"			},
  { "shield_normal.active.delay",		"8"			},
  { "shield_normal.active.anim_mode",		"pingpong"		},

  { "shield_deadly",				"RocksDC.pcx"		},
  { "shield_deadly.xpos",			"8"			},
  { "shield_deadly.ypos",			"1"			},
  { "shield_deadly.frames",			"6"			},
  { "shield_deadly.delay",			"4"			},
  { "shield_deadly.active",			"RocksHeroes.pcx"	},
  { "shield_deadly.active.xpos",		"5"			},
  { "shield_deadly.active.ypos",		"13"			},
  { "shield_deadly.active.frames",		"3"			},
  { "shield_deadly.active.delay",		"8"			},
  { "shield_deadly.active.anim_mode",		"pingpong"		},

  { "switchgate_closed",			"RocksDC.pcx"		},
  { "switchgate_closed.xpos",			"8"			},
  { "switchgate_closed.ypos",			"5"			},
  { "switchgate_closed.frames",			"1"			},
  { "switchgate.opening",			"RocksDC.pcx"		},
  { "switchgate.opening.xpos",			"8"			},
  { "switchgate.opening.ypos",			"5"			},
  { "switchgate.opening.frames",		"5"			},
  { "switchgate.opening.delay",			"6"			},
  { "switchgate_open",				"RocksDC.pcx"		},
  { "switchgate_open.xpos",			"12"			},
  { "switchgate_open.ypos",			"5"			},
  { "switchgate_open.frames",			"1"			},
  { "switchgate.closing",			"RocksDC.pcx"		},
  { "switchgate.closing.xpos",			"8"			},
  { "switchgate.closing.ypos",			"5"			},
  { "switchgate.closing.frames",		"5"			},
  { "switchgate.closing.delay",			"6"			},
  { "switchgate.closing.anim_mode",		"reverse"		},

  { "timegate_closed",				"RocksDC.pcx"		},
  { "timegate_closed.xpos",			"8"			},
  { "timegate_closed.ypos",			"6"			},
  { "timegate_closed.frames",			"1"			},
  { "timegate.opening",				"RocksDC.pcx"		},
  { "timegate.opening.xpos",			"8"			},
  { "timegate.opening.ypos",			"6"			},
  { "timegate.opening.frames",			"5"			},
  { "timegate.opening.delay",			"6"			},
  { "timegate_open",				"RocksDC.pcx"		},
  { "timegate_open.xpos",			"12"			},
  { "timegate_open.ypos",			"6"			},
  { "timegate_open.frames",			"1"			},
  { "timegate.closing",				"RocksDC.pcx"		},
  { "timegate.closing.xpos",			"8"			},
  { "timegate.closing.ypos",			"6"			},
  { "timegate.closing.frames",			"5"			},
  { "timegate.closing.delay",			"6"			},
  { "timegate.closing.anim_mode",		"reverse"		},

  { "pearl",					"RocksDC.pcx"		},
  { "pearl.xpos",				"8"			},
  { "pearl.ypos",				"11"			},
  { "pearl.frames",				"1"			},
  { "pearl.breaking",				"RocksDC.pcx"		},
  { "pearl.breaking.xpos",			"8"			},
  { "pearl.breaking.ypos",			"12"			},
  { "pearl.breaking.frames",			"4"			},
  { "pearl.breaking.delay",			"2"			},
  { "pearl.breaking.anim_mode",			"linear"		},

  { "crystal",					"RocksDC.pcx"		},
  { "crystal.xpos",				"9"			},
  { "crystal.ypos",				"11"			},
  { "crystal.frames",				"1"			},

  { "wall_pearl",				"RocksDC.pcx"		},
  { "wall_pearl.xpos",				"10"			},
  { "wall_pearl.ypos",				"11"			},
  { "wall_pearl.frames",			"1"			},

  { "wall_crystal",				"RocksDC.pcx"		},
  { "wall_crystal.xpos",			"11"			},
  { "wall_crystal.ypos",			"11"			},
  { "wall_crystal.frames",			"1"			},

  /* images for DX Boulderdash style elements and actions */

  { "tube_right_down",				"RocksDC.pcx"		},
  { "tube_right_down.xpos",			"9"			},
  { "tube_right_down.ypos",			"13"			},
  { "tube_right_down.frames",			"1"			},

  { "tube_horizontal_down",			"RocksDC.pcx"		},
  { "tube_horizontal_down.xpos",		"10"			},
  { "tube_horizontal_down.ypos",		"13"			},
  { "tube_horizontal_down.frames",		"1"			},

  { "tube_left_down",				"RocksDC.pcx"		},
  { "tube_left_down.xpos",			"11"			},
  { "tube_left_down.ypos",			"13"			},
  { "tube_left_down.frames",			"1"			},

  { "tube_horizontal",				"RocksDC.pcx"		},
  { "tube_horizontal.xpos",			"8"			},
  { "tube_horizontal.ypos",			"14"			},
  { "tube_horizontal.frames",			"1"			},

  { "tube_vertical_right",			"RocksDC.pcx"		},
  { "tube_vertical_right.xpos",			"9"			},
  { "tube_vertical_right.ypos",			"14"			},
  { "tube_vertical_right.frames",		"1"			},

  { "tube_any",					"RocksDC.pcx"		},
  { "tube_any.xpos",				"10"			},
  { "tube_any.ypos",				"14"			},
  { "tube_any.frames",				"1"			},

  { "tube_vertical_left",			"RocksDC.pcx"		},
  { "tube_vertical_left.xpos",			"11"			},
  { "tube_vertical_left.ypos",			"14"			},
  { "tube_vertical_left.frames",		"1"			},

  { "tube_vertical",				"RocksDC.pcx"		},
  { "tube_vertical.xpos",			"8"			},
  { "tube_vertical.ypos",			"15"			},
  { "tube_vertical.frames",			"1"			},

  { "tube_right_up",				"RocksDC.pcx"		},
  { "tube_right_up.xpos",			"9"			},
  { "tube_right_up.ypos",			"15"			},
  { "tube_right_up.frames",			"1"			},

  { "tube_horizontal_up",			"RocksDC.pcx"		},
  { "tube_horizontal_up.xpos",			"10"			},
  { "tube_horizontal_up.ypos",			"15"			},
  { "tube_horizontal_up.frames",		"1"			},

  { "tube_left_up",				"RocksDC.pcx"		},
  { "tube_left_up.xpos",			"11"			},
  { "tube_left_up.ypos",			"15"			},
  { "tube_left_up.frames",			"1"			},

  { "trap",					"RocksDC.pcx"		},
  { "trap.xpos",				"12"			},
  { "trap.ypos",				"8"			},
  { "trap.frames",				"1"			},
  { "trap.crumbled_like",			"sand"			},
  { "trap.diggable_like",			"sand"			},
  { "trap.active",				"RocksDC.pcx"		},
  { "trap.active.xpos",				"12"			},
  { "trap.active.ypos",				"8"			},
  { "trap.active.frames",			"4"			},
  { "trap.active.delay",			"4"			},
  { "trap.active.anim_mode",			"pingpong2"		},
  { "trap.active.crumbled_like",		"sand"			},

  { "dx_supabomb",				"RocksDC.pcx"		},
  { "dx_supabomb.xpos",				"15"			},
  { "dx_supabomb.ypos",				"9"			},
  { "dx_supabomb.frames",			"1"			},

  /* images for Rocks'n'Diamonds style elements and actions */

  { "key_1",					"RocksElements.pcx"	},
  { "key_1.xpos",				"4"			},
  { "key_1.ypos",				"1"			},
  { "key_1.frames",				"1"			},
  { "key_1.EDITOR",				"RocksElements.pcx"	},
  { "key_1.EDITOR.xpos",			"4"			},
  { "key_1.EDITOR.ypos",			"14"			},
  { "key_2",					"RocksElements.pcx"	},
  { "key_2.xpos",				"5"			},
  { "key_2.ypos",				"1"			},
  { "key_2.frames",				"1"			},
  { "key_2.EDITOR",				"RocksElements.pcx"	},
  { "key_2.EDITOR.xpos",			"5"			},
  { "key_2.EDITOR.ypos",			"14"			},
  { "key_3",					"RocksElements.pcx"	},
  { "key_3.xpos",				"6"			},
  { "key_3.ypos",				"1"			},
  { "key_3.frames",				"1"			},
  { "key_3.EDITOR",				"RocksElements.pcx"	},
  { "key_3.EDITOR.xpos",			"6"			},
  { "key_3.EDITOR.ypos",			"14"			},
  { "key_4",					"RocksElements.pcx"	},
  { "key_4.xpos",				"7"			},
  { "key_4.ypos",				"1"			},
  { "key_4.frames",				"1"			},
  { "key_4.EDITOR",				"RocksElements.pcx"	},
  { "key_4.EDITOR.xpos",			"7"			},
  { "key_4.EDITOR.ypos",			"14"			},

  { "gate_1",					"RocksElements.pcx"	},
  { "gate_1.xpos",				"4"			},
  { "gate_1.ypos",				"2"			},
  { "gate_1.frames",				"1"			},
  { "gate_2",					"RocksElements.pcx"	},
  { "gate_2.xpos",				"5"			},
  { "gate_2.ypos",				"2"			},
  { "gate_2.frames",				"1"			},
  { "gate_3",					"RocksElements.pcx"	},
  { "gate_3.xpos",				"6"			},
  { "gate_3.ypos",				"2"			},
  { "gate_3.frames",				"1"			},
  { "gate_4",					"RocksElements.pcx"	},
  { "gate_4.xpos",				"7"			},
  { "gate_4.ypos",				"2"			},
  { "gate_4.frames",				"1"			},
  { "gate_1_gray",				"RocksElements.pcx"	},
  { "gate_1_gray.xpos",				"8"			},
  { "gate_1_gray.ypos",				"2"			},
  { "gate_1_gray.frames",			"1"			},
  { "gate_1_gray.EDITOR",			"RocksElements.pcx"	},
  { "gate_1_gray.EDITOR.xpos",			"8"			},
  { "gate_1_gray.EDITOR.ypos",			"14"			},
  { "gate_2_gray",				"RocksElements.pcx"	},
  { "gate_2_gray.xpos",				"9"			},
  { "gate_2_gray.ypos",				"2"			},
  { "gate_2_gray.frames",			"1"			},
  { "gate_2_gray.EDITOR",			"RocksElements.pcx"	},
  { "gate_2_gray.EDITOR.xpos",			"9"			},
  { "gate_2_gray.EDITOR.ypos",			"14"			},
  { "gate_3_gray",				"RocksElements.pcx"	},
  { "gate_3_gray.xpos",				"10"			},
  { "gate_3_gray.ypos",				"2"			},
  { "gate_3_gray.frames",			"1"			},
  { "gate_3_gray.EDITOR",			"RocksElements.pcx"	},
  { "gate_3_gray.EDITOR.xpos",			"10"			},
  { "gate_3_gray.EDITOR.ypos",			"14"			},
  { "gate_4_gray",				"RocksElements.pcx"	},
  { "gate_4_gray.xpos",				"11"			},
  { "gate_4_gray.ypos",				"2"			},
  { "gate_4_gray.frames",			"1"			},
  { "gate_4_gray.EDITOR",			"RocksElements.pcx"	},
  { "gate_4_gray.EDITOR.xpos",			"11"			},
  { "gate_4_gray.EDITOR.ypos",			"14"			},

  { "game_of_life",				"RocksElements.pcx"	},
  { "game_of_life.xpos",			"8"			},
  { "game_of_life.ypos",			"1"			},
  { "game_of_life.frames",			"1"			},

  { "biomaze",					"RocksElements.pcx"	},
  { "biomaze.xpos",				"9"			},
  { "biomaze.ypos",				"1"			},
  { "biomaze.frames",				"1"			},

  { "pacman",					"RocksElements.pcx"	},
  { "pacman.xpos",				"8"			},
  { "pacman.ypos",				"5"			},
  { "pacman.frames",				"1"			},
  { "pacman.right",				"RocksElements.pcx"	},
  { "pacman.right.xpos",			"8"			},
  { "pacman.right.ypos",			"5"			},
  { "pacman.right.frames",			"2"			},
  { "pacman.right.delay",			"4"			},
  { "pacman.right.offset",			"128"			},
  { "pacman.up",				"RocksElements.pcx"	},
  { "pacman.up.xpos",				"9"			},
  { "pacman.up.ypos",				"5"			},
  { "pacman.up.frames",				"2"			},
  { "pacman.up.delay",				"4"			},
  { "pacman.up.offset",				"128"			},
  { "pacman.left",				"RocksElements.pcx"	},
  { "pacman.left.xpos",				"10"			},
  { "pacman.left.ypos",				"5"			},
  { "pacman.left.frames",			"2"			},
  { "pacman.left.delay",			"4"			},
  { "pacman.left.offset",			"128"			},
  { "pacman.down",				"RocksElements.pcx"	},
  { "pacman.down.xpos",				"11"			},
  { "pacman.down.ypos",				"5"			},
  { "pacman.down.frames",			"2"			},
  { "pacman.down.delay",			"4"			},
  { "pacman.down.offset",			"128"			},
  { "pacman.turning_from_right",		"RocksElements.pcx"	},
  { "pacman.turning_from_right.xpos",		"12"			},
  { "pacman.turning_from_right.ypos",		"5"			},
  { "pacman.turning_from_right.frames",		"1"			},
  { "pacman.turning_from_up",			"RocksElements.pcx"	},
  { "pacman.turning_from_up.xpos",		"13"			},
  { "pacman.turning_from_up.ypos",		"5"			},
  { "pacman.turning_from_up.frames",		"1"			},
  { "pacman.turning_from_left",			"RocksElements.pcx"	},
  { "pacman.turning_from_left.xpos",		"14"			},
  { "pacman.turning_from_left.ypos",		"5"			},
  { "pacman.turning_from_left.frames",		"1"			},
  { "pacman.turning_from_down",			"RocksElements.pcx"	},
  { "pacman.turning_from_down.xpos",		"15"			},
  { "pacman.turning_from_down.ypos",		"5"			},
  { "pacman.turning_from_down.frames",		"1"			},

  { "lamp",					"RocksElements.pcx"	},
  { "lamp.xpos",				"0"			},
  { "lamp.ypos",				"7"			},
  { "lamp.frames",				"1"			},
  { "lamp.EDITOR",				"RocksElements.pcx"	},
  { "lamp.EDITOR.xpos",				"2"			},
  { "lamp.EDITOR.ypos",				"14"			},
  { "lamp.active",				"RocksElements.pcx"	},
  { "lamp.active.xpos",				"1"			},
  { "lamp.active.ypos",				"7"			},
  { "lamp.active.frames",			"1"			},

  { "time_orb_full",				"RocksElements.pcx"	},
  { "time_orb_full.xpos",			"2"			},
  { "time_orb_full.ypos",			"7"			},
  { "time_orb_full.frames",			"1"			},
  { "time_orb_empty",				"RocksElements.pcx"	},
  { "time_orb_empty.xpos",			"3"			},
  { "time_orb_empty.ypos",			"7"			},
  { "time_orb_empty.frames",			"1"			},

  { "emerald_yellow",				"RocksElements.pcx"	},
  { "emerald_yellow.xpos",			"10"			},
  { "emerald_yellow.ypos",			"8"			},
  { "emerald_yellow.frames",			"1"			},
  { "emerald_yellow.moving",			"RocksElements.pcx"	},
  { "emerald_yellow.moving.xpos",		"10"			},
  { "emerald_yellow.moving.ypos",		"8"			},
  { "emerald_yellow.moving.frames",		"2"			},
  { "emerald_yellow.moving.delay",		"4"			},
  { "emerald_yellow.falling",			"RocksElements.pcx"	},
  { "emerald_yellow.falling.xpos",		"10"			},
  { "emerald_yellow.falling.ypos",		"8"			},
  { "emerald_yellow.falling.frames",		"2"			},
  { "emerald_yellow.falling.delay",		"4"			},
  { "emerald_red",				"RocksElements.pcx"	},
  { "emerald_red.xpos",				"8"			},
  { "emerald_red.ypos",				"9"			},
  { "emerald_red.frames",			"1"			},
  { "emerald_red.moving",			"RocksElements.pcx"	},
  { "emerald_red.moving.xpos",			"8"			},
  { "emerald_red.moving.ypos",			"9"			},
  { "emerald_red.moving.frames",		"2"			},
  { "emerald_red.moving.delay",			"4"			},
  { "emerald_red.falling",			"RocksElements.pcx"	},
  { "emerald_red.falling.xpos",			"8"			},
  { "emerald_red.falling.ypos",			"9"			},
  { "emerald_red.falling.frames",		"2"			},
  { "emerald_red.falling.delay",		"4"			},
  { "emerald_purple",				"RocksElements.pcx"	},
  { "emerald_purple.xpos",			"10"			},
  { "emerald_purple.ypos",			"9"			},
  { "emerald_purple.frames",			"1"			},
  { "emerald_purple.moving",			"RocksElements.pcx"	},
  { "emerald_purple.moving.xpos",		"10"			},
  { "emerald_purple.moving.ypos",		"9"			},
  { "emerald_purple.moving.frames",		"2"			},
  { "emerald_purple.moving.delay",		"4"			},
  { "emerald_purple.falling",			"RocksElements.pcx"	},
  { "emerald_purple.falling.xpos",		"10"			},
  { "emerald_purple.falling.ypos",		"9"			},
  { "emerald_purple.falling.frames",		"2"			},
  { "emerald_purple.falling.delay",		"4"			},

  { "wall_emerald_yellow",			"RocksElements.pcx"	},
  { "wall_emerald_yellow.xpos",			"8"			},
  { "wall_emerald_yellow.ypos",			"8"			},
  { "wall_emerald_yellow.frames",		"1"			},
  { "wall_emerald_red",				"RocksElements.pcx"	},
  { "wall_emerald_red.xpos",			"6"			},
  { "wall_emerald_red.ypos",			"8"			},
  { "wall_emerald_red.frames",			"1"			},
  { "wall_emerald_purple",			"RocksElements.pcx"	},
  { "wall_emerald_purple.xpos",			"7"			},
  { "wall_emerald_purple.ypos",			"8"			},
  { "wall_emerald_purple.frames",		"1"			},
  { "wall_bd_diamond",				"RocksElements.pcx"	},
  { "wall_bd_diamond.xpos",			"9"			},
  { "wall_bd_diamond.ypos",			"8"			},
  { "wall_bd_diamond.frames",			"1"			},

  { "expandable_wall",				"RocksElements.pcx"	},
  { "expandable_wall.xpos",			"11"			},
  { "expandable_wall.ypos",			"10"			},
  { "expandable_wall.frames",			"1"			},
  { "expandable_wall_horizontal",		"RocksElements.pcx"	},
  { "expandable_wall_horizontal.xpos",		"5"			},
  { "expandable_wall_horizontal.ypos",		"9"			},
  { "expandable_wall_horizontal.frames",	"1"			},
  { "expandable_wall_horizontal.EDITOR",	"RocksElements.pcx"	},
  { "expandable_wall_horizontal.EDITOR.xpos",	"13"			},
  { "expandable_wall_horizontal.EDITOR.ypos",	"13"			},
  { "expandable_wall_vertical",			"RocksElements.pcx"	},
  { "expandable_wall_vertical.xpos",		"6"			},
  { "expandable_wall_vertical.ypos",		"9"			},
  { "expandable_wall_vertical.frames",		"1"			},
  { "expandable_wall_vertical.EDITOR",		"RocksElements.pcx"	},
  { "expandable_wall_vertical.EDITOR.xpos",	"14"			},
  { "expandable_wall_vertical.EDITOR.ypos",	"13"			},
  { "expandable_wall_any",			"RocksElements.pcx"	},
  { "expandable_wall_any.xpos",			"4"			},
  { "expandable_wall_any.ypos",			"9"			},
  { "expandable_wall_any.frames",		"1"			},
  { "expandable_wall_any.EDITOR",		"RocksElements.pcx"	},
  { "expandable_wall_any.EDITOR.xpos",		"12"			},
  { "expandable_wall_any.EDITOR.ypos",		"13"			},

  { "expandable_wall.growing.left",		"RocksElements.pcx"	},
  { "expandable_wall.growing.left.xpos",	"8"			},
  { "expandable_wall.growing.left.ypos",	"10"			},
  { "expandable_wall.growing.left.frames",	"3"			},
  { "expandable_wall.growing.left.delay",	"6"			},
  { "expandable_wall.growing.left.anim_mode",	"linear"		},
  { "expandable_wall.growing.right",		"RocksElements.pcx"	},
  { "expandable_wall.growing.right.xpos",	"5"			},
  { "expandable_wall.growing.right.ypos",	"10"			},
  { "expandable_wall.growing.right.frames",	"3"			},
  { "expandable_wall.growing.right.delay",	"6"			},
  { "expandable_wall.growing.right.anim_mode",	"linear"		},
  { "expandable_wall.growing.up",		"RocksHeroes.pcx"	},
  { "expandable_wall.growing.up.xpos",		"3"			},
  { "expandable_wall.growing.up.ypos",		"12"			},
  { "expandable_wall.growing.up.frames",	"3"			},
  { "expandable_wall.growing.up.delay",		"6"			},
  { "expandable_wall.growing.up.anim_mode",	"linear"		},
  { "expandable_wall.growing.down",		"RocksHeroes.pcx"	},
  { "expandable_wall.growing.down.xpos",	"0"			},
  { "expandable_wall.growing.down.ypos",	"12"			},
  { "expandable_wall.growing.down.frames",	"3"			},
  { "expandable_wall.growing.down.delay",	"6"			},
  { "expandable_wall.growing.down.anim_mode",	"linear"		},

  { "black_orb",				"RocksElements.pcx"	},
  { "black_orb.xpos",				"13"			},
  { "black_orb.ypos",				"9"			},
  { "black_orb.frames",				"1"			},

  { "speed_pill",				"RocksElements.pcx"	},
  { "speed_pill.xpos",				"14"			},
  { "speed_pill.ypos",				"9"			},
  { "speed_pill.frames",			"1"			},

  { "dark_yamyam",				"RocksElements.pcx"	},
  { "dark_yamyam.xpos",				"8"			},
  { "dark_yamyam.ypos",				"11"			},
  { "dark_yamyam.frames",			"4"			},
  { "dark_yamyam.anim_mode",			"pingpong2"		},

  { "dynabomb",					"RocksElements.pcx"	},
  { "dynabomb.xpos",				"12"			},
  { "dynabomb.ypos",				"11"			},
  { "dynabomb.frames",				"1"			},
  { "dynabomb.active",				"RocksElements.pcx"	},
  { "dynabomb.active.xpos",			"12"			},
  { "dynabomb.active.ypos",			"11"			},
  { "dynabomb.active.frames",			"4"			},
  { "dynabomb.active.delay",			"6"			},
  { "dynabomb.active.anim_mode",		"pingpong"		},
  { "dynabomb_player_1",			"RocksElements.pcx"	},
  { "dynabomb_player_1.xpos",			"12"			},
  { "dynabomb_player_1.ypos",			"11"			},
  { "dynabomb_player_1.frames",			"1"			},
  { "dynabomb_player_1.active",			"RocksElements.pcx"	},
  { "dynabomb_player_1.active.xpos",		"12"			},
  { "dynabomb_player_1.active.ypos",		"11"			},
  { "dynabomb_player_1.active.frames",		"4"			},
  { "dynabomb_player_1.active.delay",		"6"			},
  { "dynabomb_player_1.active.anim_mode",	"pingpong"		},
  { "dynabomb_player_2",			"RocksElements.pcx"	},
  { "dynabomb_player_2.xpos",			"12"			},
  { "dynabomb_player_2.ypos",			"11"			},
  { "dynabomb_player_2.frames",			"1"			},
  { "dynabomb_player_2.active",			"RocksElements.pcx"	},
  { "dynabomb_player_2.active.xpos",		"12"			},
  { "dynabomb_player_2.active.ypos",		"11"			},
  { "dynabomb_player_2.active.frames",		"4"			},
  { "dynabomb_player_2.active.delay",		"6"			},
  { "dynabomb_player_2.active.anim_mode",	"pingpong"		},
  { "dynabomb_player_3",			"RocksElements.pcx"	},
  { "dynabomb_player_3.xpos",			"12"			},
  { "dynabomb_player_3.ypos",			"11"			},
  { "dynabomb_player_3.frames",			"1"			},
  { "dynabomb_player_3.active",			"RocksElements.pcx"	},
  { "dynabomb_player_3.active.xpos",		"12"			},
  { "dynabomb_player_3.active.ypos",		"11"			},
  { "dynabomb_player_3.active.frames",		"4"			},
  { "dynabomb_player_3.active.delay",		"6"			},
  { "dynabomb_player_3.active.anim_mode",	"pingpong"		},
  { "dynabomb_player_4",			"RocksElements.pcx"	},
  { "dynabomb_player_4.xpos",			"12"			},
  { "dynabomb_player_4.ypos",			"11"			},
  { "dynabomb_player_4.frames",			"1"			},
  { "dynabomb_player_4.active",			"RocksElements.pcx"	},
  { "dynabomb_player_4.active.xpos",		"12"			},
  { "dynabomb_player_4.active.ypos",		"11"			},
  { "dynabomb_player_4.active.frames",		"4"			},
  { "dynabomb_player_4.active.delay",		"6"			},
  { "dynabomb_player_4.active.anim_mode",	"pingpong"		},
  { "dynabomb_increase_number",			"RocksElements.pcx"	},
  { "dynabomb_increase_number.xpos",		"12"			},
  { "dynabomb_increase_number.ypos",		"11"			},
  { "dynabomb_increase_number.frames",		"1"			},
  { "dynabomb_increase_size",			"RocksElements.pcx"	},
  { "dynabomb_increase_size.xpos",		"15"			},
  { "dynabomb_increase_size.ypos",		"11"			},
  { "dynabomb_increase_size.frames",		"1"			},
  { "dynabomb_increase_power",			"RocksElements.pcx"	},
  { "dynabomb_increase_power.xpos",		"12"			},
  { "dynabomb_increase_power.ypos",		"9"			},
  { "dynabomb_increase_power.frames",		"1"			},

  { "pig",					"RocksHeroes.pcx"	},
  { "pig.xpos",					"8"			},
  { "pig.ypos",					"0"			},
  { "pig.frames",				"1"			},
  { "pig.down",					"RocksHeroes.pcx"	},
  { "pig.down.xpos",				"8"			},
  { "pig.down.ypos",				"0"			},
  { "pig.down.frames",				"1"			},
  { "pig.up",					"RocksHeroes.pcx"	},
  { "pig.up.xpos",				"12"			},
  { "pig.up.ypos",				"0"			},
  { "pig.up.frames",				"1"			},
  { "pig.left",					"RocksHeroes.pcx"	},
  { "pig.left.xpos",				"8"			},
  { "pig.left.ypos",				"1"			},
  { "pig.left.frames",				"1"			},
  { "pig.right",				"RocksHeroes.pcx"	},
  { "pig.right.xpos",				"12"			},
  { "pig.right.ypos",				"1"			},
  { "pig.right.frames",				"1"			},
  { "pig.moving.down",				"RocksHeroes.pcx"	},
  { "pig.moving.down.xpos",			"8"			},
  { "pig.moving.down.ypos",			"0"			},
  { "pig.moving.down.frames",			"4"			},
  { "pig.moving.down.delay",			"2"			},
  { "pig.moving.up",				"RocksHeroes.pcx"	},
  { "pig.moving.up.xpos",			"12"			},
  { "pig.moving.up.ypos",			"0"			},
  { "pig.moving.up.frames",			"4"			},
  { "pig.moving.up.delay",			"2"			},
  { "pig.moving.left",				"RocksHeroes.pcx"	},
  { "pig.moving.left.xpos",			"8"			},
  { "pig.moving.left.ypos",			"1"			},
  { "pig.moving.left.frames",			"4"			},
  { "pig.moving.left.delay",			"2"			},
  { "pig.moving.right",				"RocksHeroes.pcx"	},
  { "pig.moving.right.xpos",			"12"			},
  { "pig.moving.right.ypos",			"1"			},
  { "pig.moving.right.frames",			"4"			},
  { "pig.moving.right.delay",			"2"			},
  { "pig.digging.down",				"RocksHeroes.pcx"	},
  { "pig.digging.down.xpos",			"8"			},
  { "pig.digging.down.ypos",			"0"			},
  { "pig.digging.down.frames",			"4"			},
  { "pig.digging.down.delay",			"2"			},
  { "pig.digging.up",				"RocksHeroes.pcx"	},
  { "pig.digging.up.xpos",			"12"			},
  { "pig.digging.up.ypos",			"0"			},
  { "pig.digging.up.frames",			"4"			},
  { "pig.digging.up.delay",			"2"			},
  { "pig.digging.left",				"RocksHeroes.pcx"	},
  { "pig.digging.left.xpos",			"8"			},
  { "pig.digging.left.ypos",			"1"			},
  { "pig.digging.left.frames",			"4"			},
  { "pig.digging.left.delay",			"2"			},
  { "pig.digging.right",			"RocksHeroes.pcx"	},
  { "pig.digging.right.xpos",			"12"			},
  { "pig.digging.right.ypos",			"1"			},
  { "pig.digging.right.frames",			"4"			},
  { "pig.digging.right.delay",			"2"			},

  { "dragon",					"RocksHeroes.pcx"	},
  { "dragon.xpos",				"8"			},
  { "dragon.ypos",				"2"			},
  { "dragon.frames",				"1"			},
  { "dragon.down",				"RocksHeroes.pcx"	},
  { "dragon.down.xpos",				"8"			},
  { "dragon.down.ypos",				"2"			},
  { "dragon.down.frames",			"1"			},
  { "dragon.up",				"RocksHeroes.pcx"	},
  { "dragon.up.xpos",				"12"			},
  { "dragon.up.ypos",				"2"			},
  { "dragon.up.frames",				"1"			},
  { "dragon.left",				"RocksHeroes.pcx"	},
  { "dragon.left.xpos",				"8"			},
  { "dragon.left.ypos",				"3"			},
  { "dragon.left.frames",			"1"			},
  { "dragon.right",				"RocksHeroes.pcx"	},
  { "dragon.right.xpos",			"12"			},
  { "dragon.right.ypos",			"3"			},
  { "dragon.right.frames",			"1"			},
  { "dragon.moving.down",			"RocksHeroes.pcx"	},
  { "dragon.moving.down.xpos",			"8"			},
  { "dragon.moving.down.ypos",			"2"			},
  { "dragon.moving.down.frames",		"4"			},
  { "dragon.moving.down.delay",			"2"			},
  { "dragon.moving.up",				"RocksHeroes.pcx"	},
  { "dragon.moving.up.xpos",			"12"			},
  { "dragon.moving.up.ypos",			"2"			},
  { "dragon.moving.up.frames",			"4"			},
  { "dragon.moving.up.delay",			"2"			},
  { "dragon.moving.left",			"RocksHeroes.pcx"	},
  { "dragon.moving.left.xpos",			"8"			},
  { "dragon.moving.left.ypos",			"3"			},
  { "dragon.moving.left.frames",		"4"			},
  { "dragon.moving.left.delay",			"2"			},
  { "dragon.moving.right",			"RocksHeroes.pcx"	},
  { "dragon.moving.right.xpos",			"12"			},
  { "dragon.moving.right.ypos",			"3"			},
  { "dragon.moving.right.frames",		"4"			},
  { "dragon.moving.right.delay",		"2"			},
  { "dragon.attacking.down",			"RocksHeroes.pcx"	},
  { "dragon.attacking.down.xpos",		"8"			},
  { "dragon.attacking.down.ypos",		"2"			},
  { "dragon.attacking.down.frames",		"1"			},
  { "dragon.attacking.up",			"RocksHeroes.pcx"	},
  { "dragon.attacking.up.xpos",			"12"			},
  { "dragon.attacking.up.ypos",			"2"			},
  { "dragon.attacking.up.frames",		"1"			},
  { "dragon.attacking.left",			"RocksHeroes.pcx"	},
  { "dragon.attacking.left.xpos",		"8"			},
  { "dragon.attacking.left.ypos",		"3"			},
  { "dragon.attacking.left.frames",		"1"			},
  { "dragon.attacking.right",			"RocksHeroes.pcx"	},
  { "dragon.attacking.right.xpos",		"12"			},
  { "dragon.attacking.right.ypos",		"3"			},
  { "dragon.attacking.right.frames",		"1"			},

  { "mole",					"RocksHeroes.pcx"	},
  { "mole.xpos",				"8"			},
  { "mole.ypos",				"4"			},
  { "mole.frames",				"1"			},
  { "mole.down",				"RocksHeroes.pcx"	},
  { "mole.down.xpos",				"8"			},
  { "mole.down.ypos",				"4"			},
  { "mole.down.frames",				"1"			},
  { "mole.up",					"RocksHeroes.pcx"	},
  { "mole.up.xpos",				"12"			},
  { "mole.up.ypos",				"4"			},
  { "mole.up.frames",				"1"			},
  { "mole.left",				"RocksHeroes.pcx"	},
  { "mole.left.xpos",				"8"			},
  { "mole.left.ypos",				"5"			},
  { "mole.left.frames",				"1"			},
  { "mole.right",				"RocksHeroes.pcx"	},
  { "mole.right.xpos",				"12"			},
  { "mole.right.ypos",				"5"			},
  { "mole.right.frames",			"1"			},
  { "mole.moving.down",				"RocksHeroes.pcx"	},
  { "mole.moving.down.xpos",			"8"			},
  { "mole.moving.down.ypos",			"4"			},
  { "mole.moving.down.frames",			"4"			},
  { "mole.moving.down.delay",			"2"			},
  { "mole.moving.up",				"RocksHeroes.pcx"	},
  { "mole.moving.up.xpos",			"12"			},
  { "mole.moving.up.ypos",			"4"			},
  { "mole.moving.up.frames",			"4"			},
  { "mole.moving.up.delay",			"2"			},
  { "mole.moving.left",				"RocksHeroes.pcx"	},
  { "mole.moving.left.xpos",			"8"			},
  { "mole.moving.left.ypos",			"5"			},
  { "mole.moving.left.frames",			"4"			},
  { "mole.moving.left.delay",			"2"			},
  { "mole.moving.right",			"RocksHeroes.pcx"	},
  { "mole.moving.right.xpos",			"12"			},
  { "mole.moving.right.ypos",			"5"			},
  { "mole.moving.right.frames",			"4"			},
  { "mole.moving.right.delay",			"2"			},
  { "mole.digging.down",			"RocksHeroes.pcx"	},
  { "mole.digging.down.xpos",			"8"			},
  { "mole.digging.down.ypos",			"4"			},
  { "mole.digging.down.frames",			"4"			},
  { "mole.digging.down.delay",			"2"			},
  { "mole.digging.up",				"RocksHeroes.pcx"	},
  { "mole.digging.up.xpos",			"12"			},
  { "mole.digging.up.ypos",			"4"			},
  { "mole.digging.up.frames",			"4"			},
  { "mole.digging.up.delay",			"2"			},
  { "mole.digging.left",			"RocksHeroes.pcx"	},
  { "mole.digging.left.xpos",			"8"			},
  { "mole.digging.left.ypos",			"5"			},
  { "mole.digging.left.frames",			"4"			},
  { "mole.digging.left.delay",			"2"			},
  { "mole.digging.right",			"RocksHeroes.pcx"	},
  { "mole.digging.right.xpos",			"12"			},
  { "mole.digging.right.ypos",			"5"			},
  { "mole.digging.right.frames",		"4"			},
  { "mole.digging.right.delay",			"2"			},

  { "penguin",					"RocksHeroes.pcx"	},
  { "penguin.xpos",				"8"			},
  { "penguin.ypos",				"6"			},
  { "penguin.frames",				"1"			},
  { "penguin.EDITOR",				"RocksElements.pcx"	},
  { "penguin.EDITOR.xpos",			"12"			},
  { "penguin.EDITOR.ypos",			"14"			},
  { "penguin.down",				"RocksHeroes.pcx"	},
  { "penguin.down.xpos",			"8"			},
  { "penguin.down.ypos",			"6"			},
  { "penguin.down.frames",			"1"			},
  { "penguin.up",				"RocksHeroes.pcx"	},
  { "penguin.up.xpos",				"12"			},
  { "penguin.up.ypos",				"6"			},
  { "penguin.up.frames",			"1"			},
  { "penguin.left",				"RocksHeroes.pcx"	},
  { "penguin.left.xpos",			"8"			},
  { "penguin.left.ypos",			"7"			},
  { "penguin.left.frames",			"1"			},
  { "penguin.right",				"RocksHeroes.pcx"	},
  { "penguin.right.xpos",			"12"			},
  { "penguin.right.ypos",			"7"			},
  { "penguin.right.frames",			"1"			},
  { "penguin.moving.down",			"RocksHeroes.pcx"	},
  { "penguin.moving.down.xpos",			"8"			},
  { "penguin.moving.down.ypos",			"6"			},
  { "penguin.moving.down.frames",		"4"			},
  { "penguin.moving.down.delay",		"2"			},
  { "penguin.moving.up",			"RocksHeroes.pcx"	},
  { "penguin.moving.up.xpos",			"12"			},
  { "penguin.moving.up.ypos",			"6"			},
  { "penguin.moving.up.frames",			"4"			},
  { "penguin.moving.up.delay",			"2"			},
  { "penguin.moving.left",			"RocksHeroes.pcx"	},
  { "penguin.moving.left.xpos",			"8"			},
  { "penguin.moving.left.ypos",			"7"			},
  { "penguin.moving.left.frames",		"4"			},
  { "penguin.moving.left.delay",		"2"			},
  { "penguin.moving.right",			"RocksHeroes.pcx"	},
  { "penguin.moving.right.xpos",		"12"			},
  { "penguin.moving.right.ypos",		"7"			},
  { "penguin.moving.right.frames",		"4"			},
  { "penguin.moving.right.delay",		"2"			},

  { "satellite",				"RocksHeroes.pcx"	},
  { "satellite.xpos",				"8"			},
  { "satellite.ypos",				"9"			},
  { "satellite.frames",				"8"			},
  { "satellite.delay",				"2"			},
  { "satellite.global_sync",			"true"			},

  { "flames_1_left",				"RocksHeroes.pcx"	},
  { "flames_1_left.xpos",			"8"			},
  { "flames_1_left.ypos",			"12"			},
  { "flames_1_left.frames",			"2"			},
  { "flames_1_left.offset",			"96"			},
  { "flames_2_left",				"RocksHeroes.pcx"	},
  { "flames_2_left.xpos",			"9"			},
  { "flames_2_left.ypos",			"12"			},
  { "flames_2_left.frames",			"2"			},
  { "flames_2_left.offset",			"96"			},
  { "flames_3_left",				"RocksHeroes.pcx"	},
  { "flames_3_left.xpos",			"10"			},
  { "flames_3_left.ypos",			"12"			},
  { "flames_3_left.frames",			"2"			},
  { "flames_3_left.offset",			"96"			},

  { "flames_1_right",				"RocksHeroes.pcx"	},
  { "flames_1_right.xpos",			"8"			},
  { "flames_1_right.ypos",			"13"			},
  { "flames_1_right.frames",			"2"			},
  { "flames_1_right.offset",			"96"			},
  { "flames_2_right",				"RocksHeroes.pcx"	},
  { "flames_2_right.xpos",			"9"			},
  { "flames_2_right.ypos",			"13"			},
  { "flames_2_right.frames",			"2"			},
  { "flames_2_right.offset",			"96"			},
  { "flames_3_right",				"RocksHeroes.pcx"	},
  { "flames_3_right.xpos",			"10"			},
  { "flames_3_right.ypos",			"13"			},
  { "flames_3_right.frames",			"2"			},
  { "flames_3_right.offset",			"96"			},

  { "flames_1_up",				"RocksHeroes.pcx"	},
  { "flames_1_up.xpos",				"8"			},
  { "flames_1_up.ypos",				"14"			},
  { "flames_1_up.frames",			"2"			},
  { "flames_1_up.offset",			"96"			},
  { "flames_2_up",				"RocksHeroes.pcx"	},
  { "flames_2_up.xpos",				"9"			},
  { "flames_2_up.ypos",				"14"			},
  { "flames_2_up.frames",			"2"			},
  { "flames_2_up.offset",			"96"			},
  { "flames_3_up",				"RocksHeroes.pcx"	},
  { "flames_3_up.xpos",				"10"			},
  { "flames_3_up.ypos",				"14"			},
  { "flames_3_up.frames",			"2"			},
  { "flames_3_up.offset",			"96"			},

  { "flames_1_down",				"RocksHeroes.pcx"	},
  { "flames_1_down.xpos",			"8"			},
  { "flames_1_down.ypos",			"15"			},
  { "flames_1_down.frames",			"2"			},
  { "flames_1_down.offset",			"96"			},
  { "flames_2_down",				"RocksHeroes.pcx"	},
  { "flames_2_down.xpos",			"9"			},
  { "flames_2_down.ypos",			"15"			},
  { "flames_2_down.frames",			"2"			},
  { "flames_2_down.offset",			"96"			},
  { "flames_3_down",				"RocksHeroes.pcx"	},
  { "flames_3_down.xpos",			"10"			},
  { "flames_3_down.ypos",			"15"			},
  { "flames_3_down.frames",			"2"			},
  { "flames_3_down.offset",			"96"			},

  { "stoneblock",				"RocksElements.pcx"	},
  { "stoneblock.xpos",				"10"			},
  { "stoneblock.ypos",				"1"			},
  { "stoneblock.frames",			"1"			},

  /* images for other elements and actions */

  { "player_1",					"RocksHeroes.pcx"	},
  { "player_1.xpos",				"0"			},
  { "player_1.ypos",				"0"			},
  { "player_1.frames",				"1"			},
  { "player_1.EDITOR",				"RocksElements.pcx"	},
  { "player_1.EDITOR.xpos",			"4"			},
  { "player_1.EDITOR.ypos",			"7"			},
  { "player_1.down",				"RocksHeroes.pcx"	},
  { "player_1.down.xpos",			"0"			},
  { "player_1.down.ypos",			"0"			},
  { "player_1.down.frames",			"1"			},
  { "player_1.up",				"RocksHeroes.pcx"	},
  { "player_1.up.xpos",				"4"			},
  { "player_1.up.ypos",				"0"			},
  { "player_1.up.frames",			"1"			},
  { "player_1.left",				"RocksHeroes.pcx"	},
  { "player_1.left.xpos",			"0"			},
  { "player_1.left.ypos",			"1"			},
  { "player_1.left.frames",			"1"			},
  { "player_1.right",				"RocksHeroes.pcx"	},
  { "player_1.right.xpos",			"4"			},
  { "player_1.right.ypos",			"1"			},
  { "player_1.right.frames",			"1"			},
  { "player_1.moving.down",			"RocksHeroes.pcx"	},
  { "player_1.moving.down.xpos",		"0"			},
  { "player_1.moving.down.ypos",		"0"			},
  { "player_1.moving.down.frames",		"4"			},
  { "player_1.moving.down.start_frame",		"1"			},
  { "player_1.moving.down.delay",		"4"			},
  { "player_1.moving.up",			"RocksHeroes.pcx"	},
  { "player_1.moving.up.xpos",			"4"			},
  { "player_1.moving.up.ypos",			"0"			},
  { "player_1.moving.up.frames",		"4"			},
  { "player_1.moving.up.start_frame",		"1"			},
  { "player_1.moving.up.delay",			"4"			},
  { "player_1.moving.left",			"RocksHeroes.pcx"	},
  { "player_1.moving.left.xpos",		"0"			},
  { "player_1.moving.left.ypos",		"1"			},
  { "player_1.moving.left.frames",		"4"			},
  { "player_1.moving.left.start_frame",		"1"			},
  { "player_1.moving.left.delay",		"4"			},
  { "player_1.moving.right",			"RocksHeroes.pcx"	},
  { "player_1.moving.right.xpos",		"4"			},
  { "player_1.moving.right.ypos",		"1"			},
  { "player_1.moving.right.frames",		"4"			},
  { "player_1.moving.right.start_frame",	"1"			},
  { "player_1.moving.right.delay",		"4"			},
  { "player_1.digging.down",			"RocksHeroes.pcx"	},
  { "player_1.digging.down.xpos",		"0"			},
  { "player_1.digging.down.ypos",		"0"			},
  { "player_1.digging.down.frames",		"4"			},
  { "player_1.digging.down.start_frame",	"1"			},
  { "player_1.digging.down.delay",		"4"			},
  { "player_1.digging.up",			"RocksHeroes.pcx"	},
  { "player_1.digging.up.xpos",			"4"			},
  { "player_1.digging.up.ypos",			"0"			},
  { "player_1.digging.up.frames",		"4"			},
  { "player_1.digging.up.start_frame",		"1"			},
  { "player_1.digging.up.delay",		"4"			},
  { "player_1.digging.left",			"RocksHeroes.pcx"	},
  { "player_1.digging.left.xpos",		"0"			},
  { "player_1.digging.left.ypos",		"1"			},
  { "player_1.digging.left.frames",		"4"			},
  { "player_1.digging.left.start_frame",	"1"			},
  { "player_1.digging.left.delay",		"4"			},
  { "player_1.digging.right",			"RocksHeroes.pcx"	},
  { "player_1.digging.right.xpos",		"4"			},
  { "player_1.digging.right.ypos",		"1"			},
  { "player_1.digging.right.frames",		"4"			},
  { "player_1.digging.right.start_frame",	"1"			},
  { "player_1.digging.right.delay",		"4"			},
  { "player_1.collecting.down",			"RocksHeroes.pcx"	},
  { "player_1.collecting.down.xpos",		"0"			},
  { "player_1.collecting.down.ypos",		"0"			},
  { "player_1.collecting.down.frames",		"4"			},
  { "player_1.collecting.down.start_frame",	"1"			},
  { "player_1.collecting.down.delay",		"4"			},
  { "player_1.collecting.up",			"RocksHeroes.pcx"	},
  { "player_1.collecting.up.xpos",		"4"			},
  { "player_1.collecting.up.ypos",		"0"			},
  { "player_1.collecting.up.frames",		"4"			},
  { "player_1.collecting.up.start_frame",	"1"			},
  { "player_1.collecting.up.delay",		"4"			},
  { "player_1.collecting.left",			"RocksHeroes.pcx"	},
  { "player_1.collecting.left.xpos",		"0"			},
  { "player_1.collecting.left.ypos",		"1"			},
  { "player_1.collecting.left.frames",		"4"			},
  { "player_1.collecting.left.start_frame",	"1"			},
  { "player_1.collecting.left.delay",		"4"			},
  { "player_1.collecting.right",		"RocksHeroes.pcx"	},
  { "player_1.collecting.right.xpos",		"4"			},
  { "player_1.collecting.right.ypos",		"1"			},
  { "player_1.collecting.right.frames",		"4"			},
  { "player_1.collecting.right.start_frame",	"1"			},
  { "player_1.collecting.right.delay",		"4"			},
  { "player_1.pushing.down",			"RocksHeroes.pcx"	},
  { "player_1.pushing.down.xpos",		"0"			},
  { "player_1.pushing.down.ypos",		"0"			},
  { "player_1.pushing.down.frames",		"4"			},
  { "player_1.pushing.down.delay",		"4"			},
  { "player_1.pushing.up",			"RocksHeroes.pcx"	},
  { "player_1.pushing.up.xpos",			"4"			},
  { "player_1.pushing.up.ypos",			"0"			},
  { "player_1.pushing.up.frames",		"4"			},
  { "player_1.pushing.up.delay",		"4"			},
  { "player_1.pushing.left",			"RocksHeroes.pcx"	},
  { "player_1.pushing.left.xpos",		"4"			},
  { "player_1.pushing.left.ypos",		"2"			},
  { "player_1.pushing.left.frames",		"4"			},
  { "player_1.pushing.left.delay",		"4"			},
  { "player_1.pushing.right",			"RocksHeroes.pcx"	},
  { "player_1.pushing.right.xpos",		"0"			},
  { "player_1.pushing.right.ypos",		"2"			},
  { "player_1.pushing.right.frames",		"4"			},
  { "player_1.pushing.right.delay",		"4"			},
  { "player_1.snapping.down",			"RocksHeroes.pcx"	},
  { "player_1.snapping.down.xpos",		"0"			},
  { "player_1.snapping.down.ypos",		"0"			},
  { "player_1.snapping.down.frames",		"1"			},
  { "player_1.snapping.up",			"RocksHeroes.pcx"	},
  { "player_1.snapping.up.xpos",		"4"			},
  { "player_1.snapping.up.ypos",		"0"			},
  { "player_1.snapping.up.frames",		"1"			},
  { "player_1.snapping.left",			"RocksHeroes.pcx"	},
  { "player_1.snapping.left.xpos",		"0"			},
  { "player_1.snapping.left.ypos",		"1"			},
  { "player_1.snapping.left.frames",		"1"			},
  { "player_1.snapping.right",			"RocksHeroes.pcx"	},
  { "player_1.snapping.right.xpos",		"4"			},
  { "player_1.snapping.right.ypos",		"1"			},
  { "player_1.snapping.right.frames",		"1"			},

  { "player_2",					"RocksHeroes.pcx"	},
  { "player_2.xpos",				"0"			},
  { "player_2.ypos",				"3"			},
  { "player_2.frames",				"1"			},
  { "player_2.EDITOR",				"RocksElements.pcx"	},
  { "player_2.EDITOR.xpos",			"5"			},
  { "player_2.EDITOR.ypos",			"7"			},
  { "player_2.down",				"RocksHeroes.pcx"	},
  { "player_2.down.xpos",			"0"			},
  { "player_2.down.ypos",			"3"			},
  { "player_2.down.frames",			"1"			},
  { "player_2.up",				"RocksHeroes.pcx"	},
  { "player_2.up.xpos",				"4"			},
  { "player_2.up.ypos",				"3"			},
  { "player_2.up.frames",			"1"			},
  { "player_2.left",				"RocksHeroes.pcx"	},
  { "player_2.left.xpos",			"0"			},
  { "player_2.left.ypos",			"4"			},
  { "player_2.left.frames",			"1"			},
  { "player_2.right",				"RocksHeroes.pcx"	},
  { "player_2.right.xpos",			"4"			},
  { "player_2.right.ypos",			"4"			},
  { "player_2.right.frames",			"1"			},
  { "player_2.moving.down",			"RocksHeroes.pcx"	},
  { "player_2.moving.down.xpos",		"0"			},
  { "player_2.moving.down.ypos",		"3"			},
  { "player_2.moving.down.frames",		"4"			},
  { "player_2.moving.down.start_frame",		"1"			},
  { "player_2.moving.down.delay",		"4"			},
  { "player_2.moving.up",			"RocksHeroes.pcx"	},
  { "player_2.moving.up.xpos",			"4"			},
  { "player_2.moving.up.ypos",			"3"			},
  { "player_2.moving.up.frames",		"4"			},
  { "player_2.moving.up.start_frame",		"1"			},
  { "player_2.moving.up.delay",			"4"			},
  { "player_2.moving.left",			"RocksHeroes.pcx"	},
  { "player_2.moving.left.xpos",		"0"			},
  { "player_2.moving.left.ypos",		"4"			},
  { "player_2.moving.left.frames",		"4"			},
  { "player_2.moving.left.start_frame",		"1"			},
  { "player_2.moving.left.delay",		"4"			},
  { "player_2.moving.right",			"RocksHeroes.pcx"	},
  { "player_2.moving.right.xpos",		"4"			},
  { "player_2.moving.right.ypos",		"4"			},
  { "player_2.moving.right.frames",		"4"			},
  { "player_2.moving.right.start_frame",	"1"			},
  { "player_2.moving.right.delay",		"4"			},
  { "player_2.digging.down",			"RocksHeroes.pcx"	},
  { "player_2.digging.down.xpos",		"0"			},
  { "player_2.digging.down.ypos",		"3"			},
  { "player_2.digging.down.frames",		"4"			},
  { "player_2.digging.down.start_frame",	"1"			},
  { "player_2.digging.down.delay",		"4"			},
  { "player_2.digging.up",			"RocksHeroes.pcx"	},
  { "player_2.digging.up.xpos",			"4"			},
  { "player_2.digging.up.ypos",			"3"			},
  { "player_2.digging.up.frames",		"4"			},
  { "player_2.digging.up.start_frame",		"1"			},
  { "player_2.digging.up.delay",		"4"			},
  { "player_2.digging.left",			"RocksHeroes.pcx"	},
  { "player_2.digging.left.xpos",		"0"			},
  { "player_2.digging.left.ypos",		"4"			},
  { "player_2.digging.left.frames",		"4"			},
  { "player_2.digging.left.start_frame",	"1"			},
  { "player_2.digging.left.delay",		"4"			},
  { "player_2.digging.right",			"RocksHeroes.pcx"	},
  { "player_2.digging.right.xpos",		"4"			},
  { "player_2.digging.right.ypos",		"4"			},
  { "player_2.digging.right.frames",		"4"			},
  { "player_2.digging.right.start_frame",	"1"			},
  { "player_2.digging.right.delay",		"4"			},
  { "player_2.collecting.down",			"RocksHeroes.pcx"	},
  { "player_2.collecting.down.xpos",		"0"			},
  { "player_2.collecting.down.ypos",		"3"			},
  { "player_2.collecting.down.frames",		"4"			},
  { "player_2.collecting.down.start_frame",	"1"			},
  { "player_2.collecting.down.delay",		"4"			},
  { "player_2.collecting.up",			"RocksHeroes.pcx"	},
  { "player_2.collecting.up.xpos",		"4"			},
  { "player_2.collecting.up.ypos",		"3"			},
  { "player_2.collecting.up.frames",		"4"			},
  { "player_2.collecting.up.start_frame",	"1"			},
  { "player_2.collecting.up.delay",		"4"			},
  { "player_2.collecting.left",			"RocksHeroes.pcx"	},
  { "player_2.collecting.left.xpos",		"0"			},
  { "player_2.collecting.left.ypos",		"4"			},
  { "player_2.collecting.left.frames",		"4"			},
  { "player_2.collecting.left.start_frame",	"1"			},
  { "player_2.collecting.left.delay",		"4"			},
  { "player_2.collecting.right",		"RocksHeroes.pcx"	},
  { "player_2.collecting.right.xpos",		"4"			},
  { "player_2.collecting.right.ypos",		"4"			},
  { "player_2.collecting.right.frames",		"4"			},
  { "player_2.collecting.right.start_frame",	"1"			},
  { "player_2.collecting.right.delay",		"4"			},
  { "player_2.pushing.down",			"RocksHeroes.pcx"	},
  { "player_2.pushing.down.xpos",		"0"			},
  { "player_2.pushing.down.ypos",		"3"			},
  { "player_2.pushing.down.frames",		"4"			},
  { "player_2.pushing.down.delay",		"4"			},
  { "player_2.pushing.up",			"RocksHeroes.pcx"	},
  { "player_2.pushing.up.xpos",			"4"			},
  { "player_2.pushing.up.ypos",			"3"			},
  { "player_2.pushing.up.frames",		"4"			},
  { "player_2.pushing.up.delay",		"4"			},
  { "player_2.pushing.left",			"RocksHeroes.pcx"	},
  { "player_2.pushing.left.xpos",		"4"			},
  { "player_2.pushing.left.ypos",		"5"			},
  { "player_2.pushing.left.frames",		"4"			},
  { "player_2.pushing.left.delay",		"4"			},
  { "player_2.pushing.right",			"RocksHeroes.pcx"	},
  { "player_2.pushing.right.xpos",		"0"			},
  { "player_2.pushing.right.ypos",		"5"			},
  { "player_2.pushing.right.frames",		"4"			},
  { "player_2.pushing.right.delay",		"4"			},
  { "player_2.snapping.down",			"RocksHeroes.pcx"	},
  { "player_2.snapping.down.xpos",		"0"			},
  { "player_2.snapping.down.ypos",		"3"			},
  { "player_2.snapping.down.frames",		"1"			},
  { "player_2.snapping.up",			"RocksHeroes.pcx"	},
  { "player_2.snapping.up.xpos",		"4"			},
  { "player_2.snapping.up.ypos",		"3"			},
  { "player_2.snapping.up.frames",		"1"			},
  { "player_2.snapping.left",			"RocksHeroes.pcx"	},
  { "player_2.snapping.left.xpos",		"0"			},
  { "player_2.snapping.left.ypos",		"4"			},
  { "player_2.snapping.left.frames",		"1"			},
  { "player_2.snapping.right",			"RocksHeroes.pcx"	},
  { "player_2.snapping.right.xpos",		"4"			},
  { "player_2.snapping.right.ypos",		"4"			},
  { "player_2.snapping.right.frames",		"1"			},

  { "player_3",					"RocksHeroes.pcx"	},
  { "player_3.xpos",				"0"			},
  { "player_3.ypos",				"6"			},
  { "player_3.frames",				"1"			},
  { "player_3.EDITOR",				"RocksElements.pcx"	},
  { "player_3.EDITOR.xpos",			"6"			},
  { "player_3.EDITOR.ypos",			"7"			},
  { "player_3.down",				"RocksHeroes.pcx"	},
  { "player_3.down.xpos",			"0"			},
  { "player_3.down.ypos",			"6"			},
  { "player_3.down.frames",			"1"			},
  { "player_3.up",				"RocksHeroes.pcx"	},
  { "player_3.up.xpos",				"4"			},
  { "player_3.up.ypos",				"6"			},
  { "player_3.up.frames",			"1"			},
  { "player_3.left",				"RocksHeroes.pcx"	},
  { "player_3.left.xpos",			"0"			},
  { "player_3.left.ypos",			"7"			},
  { "player_3.left.frames",			"1"			},
  { "player_3.right",				"RocksHeroes.pcx"	},
  { "player_3.right.xpos",			"4"			},
  { "player_3.right.ypos",			"7"			},
  { "player_3.right.frames",			"1"			},
  { "player_3.moving.down",			"RocksHeroes.pcx"	},
  { "player_3.moving.down.xpos",		"0"			},
  { "player_3.moving.down.ypos",		"6"			},
  { "player_3.moving.down.frames",		"4"			},
  { "player_3.moving.down.start_frame",		"1"			},
  { "player_3.moving.down.delay",		"4"			},
  { "player_3.moving.up",			"RocksHeroes.pcx"	},
  { "player_3.moving.up.xpos",			"4"			},
  { "player_3.moving.up.ypos",			"6"			},
  { "player_3.moving.up.frames",		"4"			},
  { "player_3.moving.up.start_frame",		"1"			},
  { "player_3.moving.up.delay",			"4"			},
  { "player_3.moving.left",			"RocksHeroes.pcx"	},
  { "player_3.moving.left.xpos",		"0"			},
  { "player_3.moving.left.ypos",		"7"			},
  { "player_3.moving.left.frames",		"4"			},
  { "player_3.moving.left.start_frame",		"1"			},
  { "player_3.moving.left.delay",		"4"			},
  { "player_3.moving.right",			"RocksHeroes.pcx"	},
  { "player_3.moving.right.xpos",		"4"			},
  { "player_3.moving.right.ypos",		"7"			},
  { "player_3.moving.right.frames",		"4"			},
  { "player_3.moving.right.start_frame",	"1"			},
  { "player_3.moving.right.delay",		"4"			},
  { "player_3.digging.down",			"RocksHeroes.pcx"	},
  { "player_3.digging.down.xpos",		"0"			},
  { "player_3.digging.down.ypos",		"6"			},
  { "player_3.digging.down.frames",		"4"			},
  { "player_3.digging.down.start_frame",	"1"			},
  { "player_3.digging.down.delay",		"4"			},
  { "player_3.digging.up",			"RocksHeroes.pcx"	},
  { "player_3.digging.up.xpos",			"4"			},
  { "player_3.digging.up.ypos",			"6"			},
  { "player_3.digging.up.frames",		"4"			},
  { "player_3.digging.up.start_frame",		"1"			},
  { "player_3.digging.up.delay",		"4"			},
  { "player_3.digging.left",			"RocksHeroes.pcx"	},
  { "player_3.digging.left.xpos",		"0"			},
  { "player_3.digging.left.ypos",		"7"			},
  { "player_3.digging.left.frames",		"4"			},
  { "player_3.digging.left.start_frame",	"1"			},
  { "player_3.digging.left.delay",		"4"			},
  { "player_3.digging.right",			"RocksHeroes.pcx"	},
  { "player_3.digging.right.xpos",		"4"			},
  { "player_3.digging.right.ypos",		"7"			},
  { "player_3.digging.right.frames",		"4"			},
  { "player_3.digging.right.start_frame",	"1"			},
  { "player_3.digging.right.delay",		"4"			},
  { "player_3.collecting.down",			"RocksHeroes.pcx"	},
  { "player_3.collecting.down.xpos",		"0"			},
  { "player_3.collecting.down.ypos",		"6"			},
  { "player_3.collecting.down.frames",		"4"			},
  { "player_3.collecting.down.start_frame",	"1"			},
  { "player_3.collecting.down.delay",		"4"			},
  { "player_3.collecting.up",			"RocksHeroes.pcx"	},
  { "player_3.collecting.up.xpos",		"4"			},
  { "player_3.collecting.up.ypos",		"6"			},
  { "player_3.collecting.up.frames",		"4"			},
  { "player_3.collecting.up.start_frame",	"1"			},
  { "player_3.collecting.up.delay",		"4"			},
  { "player_3.collecting.left",			"RocksHeroes.pcx"	},
  { "player_3.collecting.left.xpos",		"0"			},
  { "player_3.collecting.left.ypos",		"7"			},
  { "player_3.collecting.left.frames",		"4"			},
  { "player_3.collecting.left.start_frame",	"1"			},
  { "player_3.collecting.left.delay",		"4"			},
  { "player_3.collecting.right",		"RocksHeroes.pcx"	},
  { "player_3.collecting.right.xpos",		"4"			},
  { "player_3.collecting.right.ypos",		"7"			},
  { "player_3.collecting.right.frames",		"4"			},
  { "player_3.collecting.right.start_frame",	"1"			},
  { "player_3.collecting.right.delay",		"4"			},
  { "player_3.pushing.down",			"RocksHeroes.pcx"	},
  { "player_3.pushing.down.xpos",		"0"			},
  { "player_3.pushing.down.ypos",		"6"			},
  { "player_3.pushing.down.frames",		"4"			},
  { "player_3.pushing.down.delay",		"4"			},
  { "player_3.pushing.up",			"RocksHeroes.pcx"	},
  { "player_3.pushing.up.xpos",			"4"			},
  { "player_3.pushing.up.ypos",			"6"			},
  { "player_3.pushing.up.frames",		"4"			},
  { "player_3.pushing.up.delay",		"4"			},
  { "player_3.pushing.left",			"RocksHeroes.pcx"	},
  { "player_3.pushing.left.xpos",		"4"			},
  { "player_3.pushing.left.ypos",		"8"			},
  { "player_3.pushing.left.frames",		"4"			},
  { "player_3.pushing.left.delay",		"4"			},
  { "player_3.pushing.right",			"RocksHeroes.pcx"	},
  { "player_3.pushing.right.xpos",		"0"			},
  { "player_3.pushing.right.ypos",		"8"			},
  { "player_3.pushing.right.frames",		"4"			},
  { "player_3.pushing.right.delay",		"4"			},
  { "player_3.snapping.down",			"RocksHeroes.pcx"	},
  { "player_3.snapping.down.xpos",		"0"			},
  { "player_3.snapping.down.ypos",		"6"			},
  { "player_3.snapping.down.frames",		"1"			},
  { "player_3.snapping.up",			"RocksHeroes.pcx"	},
  { "player_3.snapping.up.xpos",		"4"			},
  { "player_3.snapping.up.ypos",		"6"			},
  { "player_3.snapping.up.frames",		"1"			},
  { "player_3.snapping.left",			"RocksHeroes.pcx"	},
  { "player_3.snapping.left.xpos",		"0"			},
  { "player_3.snapping.left.ypos",		"7"			},
  { "player_3.snapping.left.frames",		"1"			},
  { "player_3.snapping.right",			"RocksHeroes.pcx"	},
  { "player_3.snapping.right.xpos",		"4"			},
  { "player_3.snapping.right.ypos",		"7"			},
  { "player_3.snapping.right.frames",		"1"			},

  { "player_4",					"RocksHeroes.pcx"	},
  { "player_4.xpos",				"0"			},
  { "player_4.ypos",				"9"			},
  { "player_4.frames",				"1"			},
  { "player_4.EDITOR",				"RocksElements.pcx"	},
  { "player_4.EDITOR.xpos",			"7"			},
  { "player_4.EDITOR.ypos",			"7"			},
  { "player_4.down",				"RocksHeroes.pcx"	},
  { "player_4.down.xpos",			"0"			},
  { "player_4.down.ypos",			"9"			},
  { "player_4.down.frames",			"1"			},
  { "player_4.up",				"RocksHeroes.pcx"	},
  { "player_4.up.xpos",				"4"			},
  { "player_4.up.ypos",				"9"			},
  { "player_4.up.frames",			"1"			},
  { "player_4.left",				"RocksHeroes.pcx"	},
  { "player_4.left.xpos",			"0"			},
  { "player_4.left.ypos",			"10"			},
  { "player_4.left.frames",			"1"			},
  { "player_4.right",				"RocksHeroes.pcx"	},
  { "player_4.right.xpos",			"4"			},
  { "player_4.right.ypos",			"10"			},
  { "player_4.right.frames",			"1"			},
  { "player_4.moving.down",			"RocksHeroes.pcx"	},
  { "player_4.moving.down.xpos",		"0"			},
  { "player_4.moving.down.ypos",		"9"			},
  { "player_4.moving.down.frames",		"4"			},
  { "player_4.moving.down.start_frame",		"1"			},
  { "player_4.moving.down.delay",		"4"			},
  { "player_4.moving.up",			"RocksHeroes.pcx"	},
  { "player_4.moving.up.xpos",			"4"			},
  { "player_4.moving.up.ypos",			"9"			},
  { "player_4.moving.up.frames",		"4"			},
  { "player_4.moving.up.start_frame",		"1"			},
  { "player_4.moving.up.delay",			"4"			},
  { "player_4.moving.left",			"RocksHeroes.pcx"	},
  { "player_4.moving.left.xpos",		"0"			},
  { "player_4.moving.left.ypos",		"10"			},
  { "player_4.moving.left.frames",		"4"			},
  { "player_4.moving.left.start_frame",		"1"			},
  { "player_4.moving.left.delay",		"4"			},
  { "player_4.moving.right",			"RocksHeroes.pcx"	},
  { "player_4.moving.right.xpos",		"4"			},
  { "player_4.moving.right.ypos",		"10"			},
  { "player_4.moving.right.frames",		"4"			},
  { "player_4.moving.right.start_frame",	"1"			},
  { "player_4.moving.right.delay",		"4"			},
  { "player_4.digging.down",			"RocksHeroes.pcx"	},
  { "player_4.digging.down.xpos",		"0"			},
  { "player_4.digging.down.ypos",		"9"			},
  { "player_4.digging.down.frames",		"4"			},
  { "player_4.digging.down.start_frame",	"1"			},
  { "player_4.digging.down.delay",		"4"			},
  { "player_4.digging.up",			"RocksHeroes.pcx"	},
  { "player_4.digging.up.xpos",			"4"			},
  { "player_4.digging.up.ypos",			"9"			},
  { "player_4.digging.up.frames",		"4"			},
  { "player_4.digging.up.start_frame",		"1"			},
  { "player_4.digging.up.delay",		"4"			},
  { "player_4.digging.left",			"RocksHeroes.pcx"	},
  { "player_4.digging.left.xpos",		"0"			},
  { "player_4.digging.left.ypos",		"10"			},
  { "player_4.digging.left.frames",		"4"			},
  { "player_4.digging.left.start_frame",	"1"			},
  { "player_4.digging.left.delay",		"4"			},
  { "player_4.digging.right",			"RocksHeroes.pcx"	},
  { "player_4.digging.right.xpos",		"4"			},
  { "player_4.digging.right.ypos",		"10"			},
  { "player_4.digging.right.frames",		"4"			},
  { "player_4.digging.right.start_frame",	"1"			},
  { "player_4.digging.right.delay",		"4"			},
  { "player_4.collecting.down",			"RocksHeroes.pcx"	},
  { "player_4.collecting.down.xpos",		"0"			},
  { "player_4.collecting.down.ypos",		"9"			},
  { "player_4.collecting.down.frames",		"4"			},
  { "player_4.collecting.down.start_frame",	"1"			},
  { "player_4.collecting.down.delay",		"4"			},
  { "player_4.collecting.up",			"RocksHeroes.pcx"	},
  { "player_4.collecting.up.xpos",		"4"			},
  { "player_4.collecting.up.ypos",		"9"			},
  { "player_4.collecting.up.frames",		"4"			},
  { "player_4.collecting.up.start_frame",	"1"			},
  { "player_4.collecting.up.delay",		"4"			},
  { "player_4.collecting.left",			"RocksHeroes.pcx"	},
  { "player_4.collecting.left.xpos",		"0"			},
  { "player_4.collecting.left.ypos",		"10"			},
  { "player_4.collecting.left.frames",		"4"			},
  { "player_4.collecting.left.start_frame",	"1"			},
  { "player_4.collecting.left.delay",		"4"			},
  { "player_4.collecting.right",		"RocksHeroes.pcx"	},
  { "player_4.collecting.right.xpos",		"4"			},
  { "player_4.collecting.right.ypos",		"10"			},
  { "player_4.collecting.right.frames",		"4"			},
  { "player_4.collecting.right.start_frame",	"1"			},
  { "player_4.collecting.right.delay",		"4"			},
  { "player_4.pushing.down",			"RocksHeroes.pcx"	},
  { "player_4.pushing.down.xpos",		"0"			},
  { "player_4.pushing.down.ypos",		"9"			},
  { "player_4.pushing.down.frames",		"4"			},
  { "player_4.pushing.down.delay",		"4"			},
  { "player_4.pushing.up",			"RocksHeroes.pcx"	},
  { "player_4.pushing.up.xpos",			"4"			},
  { "player_4.pushing.up.ypos",			"9"			},
  { "player_4.pushing.up.frames",		"4"			},
  { "player_4.pushing.up.delay",		"4"			},
  { "player_4.pushing.left",			"RocksHeroes.pcx"	},
  { "player_4.pushing.left.xpos",		"4"			},
  { "player_4.pushing.left.ypos",		"11"			},
  { "player_4.pushing.left.frames",		"4"			},
  { "player_4.pushing.left.delay",		"4"			},
  { "player_4.pushing.right",			"RocksHeroes.pcx"	},
  { "player_4.pushing.right.xpos",		"0"			},
  { "player_4.pushing.right.ypos",		"11"			},
  { "player_4.pushing.right.frames",		"4"			},
  { "player_4.pushing.right.delay",		"4"			},
  { "player_4.snapping.down",			"RocksHeroes.pcx"	},
  { "player_4.snapping.down.xpos",		"0"			},
  { "player_4.snapping.down.ypos",		"9"			},
  { "player_4.snapping.down.frames",		"1"			},
  { "player_4.snapping.up",			"RocksHeroes.pcx"	},
  { "player_4.snapping.up.xpos",		"4"			},
  { "player_4.snapping.up.ypos",		"9"			},
  { "player_4.snapping.up.frames",		"1"			},
  { "player_4.snapping.left",			"RocksHeroes.pcx"	},
  { "player_4.snapping.left.xpos",		"0"			},
  { "player_4.snapping.left.ypos",		"10"			},
  { "player_4.snapping.left.frames",		"1"			},
  { "player_4.snapping.right",			"RocksHeroes.pcx"	},
  { "player_4.snapping.right.xpos",		"4"			},
  { "player_4.snapping.right.ypos",		"10"			},
  { "player_4.snapping.right.frames",		"1"			},

  { "[default].exploding",			"RocksElements.pcx"	},
  { "[default].exploding.xpos",			"0"			},
  { "[default].exploding.ypos",			"4"			},
  { "[default].exploding.frames",		"8"			},
  { "[default].exploding.delay",		"2"			},
  { "[default].exploding.anim_mode",		"linear"		},

  { "twinkle_blue",				"RocksHeroes.pcx"	},
  { "twinkle_blue.xpos",			"9"			},
  { "twinkle_blue.ypos",			"11"			},
  { "twinkle_blue.frames",			"3"			},
  { "twinkle_blue.delay",			"2"			},
  { "twinkle_blue.anim_mode",			"pingpong"		},
  { "twinkle_blue.global_sync",			"false"			},
  { "twinkle_white",				"RocksHeroes.pcx"	},
  { "twinkle_white.xpos",			"13"			},
  { "twinkle_white.ypos",			"11"			},
  { "twinkle_white.frames",			"3"			},
  { "twinkle_white.delay",			"2"			},
  { "twinkle_white.anim_mode",			"pingpong"		},
  { "twinkle_white.global_sync",		"false"			},

  { "steelwall_topleft",			"RocksElements.pcx"	},
  { "steelwall_topleft.xpos",			"4"			},
  { "steelwall_topleft.ypos",			"0"			},
  { "steelwall_topleft.frames",			"1"			},
  { "steelwall_topright",			"RocksElements.pcx"	},
  { "steelwall_topright.xpos",			"4"			},
  { "steelwall_topright.ypos",			"0"			},
  { "steelwall_topright.frames",		"1"			},
  { "steelwall_bottomleft",			"RocksElements.pcx"	},
  { "steelwall_bottomleft.xpos",		"4"			},
  { "steelwall_bottomleft.ypos",		"0"			},
  { "steelwall_bottomleft.frames",		"1"			},
  { "steelwall_bottomright",			"RocksElements.pcx"	},
  { "steelwall_bottomright.xpos",		"4"			},
  { "steelwall_bottomright.ypos",		"0"			},
  { "steelwall_bottomright.frames",		"1"			},
  { "steelwall_horizontal",			"RocksElements.pcx"	},
  { "steelwall_horizontal.xpos",		"4"			},
  { "steelwall_horizontal.ypos",		"0"			},
  { "steelwall_horizontal.frames",		"1"			},
  { "steelwall_vertical",			"RocksElements.pcx"	},
  { "steelwall_vertical.xpos",			"4"			},
  { "steelwall_vertical.ypos",			"0"			},
  { "steelwall_vertical.frames",		"1"			},

  { "steelwall_topleft.EDITOR",			"RocksElements.pcx"	},
  { "steelwall_topleft.EDITOR.xpos",		"0"			},
  { "steelwall_topleft.EDITOR.ypos",		"13"			},
  { "steelwall_topright.EDITOR",		"RocksElements.pcx"	},
  { "steelwall_topright.EDITOR.xpos",		"1"			},
  { "steelwall_topright.EDITOR.ypos",		"13"			},
  { "steelwall_bottomleft.EDITOR",		"RocksElements.pcx"	},
  { "steelwall_bottomleft.EDITOR.xpos",		"2"			},
  { "steelwall_bottomleft.EDITOR.ypos",		"13"			},
  { "steelwall_bottomright.EDITOR",		"RocksElements.pcx"	},
  { "steelwall_bottomright.EDITOR.xpos",	"3"			},
  { "steelwall_bottomright.EDITOR.ypos",	"13"			},
  { "steelwall_horizontal.EDITOR",		"RocksElements.pcx"	},
  { "steelwall_horizontal.EDITOR.xpos",		"4"			},
  { "steelwall_horizontal.EDITOR.ypos",		"13"			},
  { "steelwall_vertical.EDITOR",		"RocksElements.pcx"	},
  { "steelwall_vertical.EDITOR.xpos",		"5"			},
  { "steelwall_vertical.EDITOR.ypos",		"13"			},

  { "invisible_steelwall_topleft",		"RocksSP.pcx"		},
  { "invisible_steelwall_topleft.xpos",		"0"			},
  { "invisible_steelwall_topleft.ypos",		"0"			},
  { "invisible_steelwall_topleft.frames",	"1"			},
  { "invisible_steelwall_topright",		"RocksSP.pcx"		},
  { "invisible_steelwall_topright.xpos",	"0"			},
  { "invisible_steelwall_topright.ypos",	"0"			},
  { "invisible_steelwall_topright.frames",	"1"			},
  { "invisible_steelwall_bottomleft",		"RocksSP.pcx"		},
  { "invisible_steelwall_bottomleft.xpos",	"0"			},
  { "invisible_steelwall_bottomleft.ypos",	"0"			},
  { "invisible_steelwall_bottomleft.frames",	"1"			},
  { "invisible_steelwall_bottomright",		"RocksSP.pcx"		},
  { "invisible_steelwall_bottomright.xpos",	"0"			},
  { "invisible_steelwall_bottomright.ypos",	"0"			},
  { "invisible_steelwall_bottomright.frames",	"1"			},
  { "invisible_steelwall_horizontal",		"RocksSP.pcx"		},
  { "invisible_steelwall_horizontal.xpos",	"0"			},
  { "invisible_steelwall_horizontal.ypos",	"0"			},
  { "invisible_steelwall_horizontal.frames",	"1"			},
  { "invisible_steelwall_vertical",		"RocksSP.pcx"		},
  { "invisible_steelwall_vertical.xpos",	"0"			},
  { "invisible_steelwall_vertical.ypos",	"0"			},
  { "invisible_steelwall_vertical.frames",	"1"			},

  { "invisible_steelwall_topleft.EDITOR",	"RocksElements.pcx"	},
  { "invisible_steelwall_topleft.EDITOR.xpos",	"6"			},
  { "invisible_steelwall_topleft.EDITOR.ypos",	"13"			},
  { "invisible_steelwall_topright.EDITOR",	"RocksElements.pcx"	},
  { "invisible_steelwall_topright.EDITOR.xpos",	"7"			},
  { "invisible_steelwall_topright.EDITOR.ypos",	"13"			},
  { "invisible_steelwall_bottomleft.EDITOR",	"RocksElements.pcx"	},
  { "invisible_steelwall_bottomleft.EDITOR.xpos","8"			},
  { "invisible_steelwall_bottomleft.EDITOR.ypos","13"			},
  { "invisible_steelwall_bottomright.EDITOR",	"RocksElements.pcx"	},
  { "invisible_steelwall_bottomright.EDITOR.xpos","9"			},
  { "invisible_steelwall_bottomright.EDITOR.ypos","13"			},
  { "invisible_steelwall_horizontal.EDITOR",	"RocksElements.pcx"	},
  { "invisible_steelwall_horizontal.EDITOR.xpos","10"			},
  { "invisible_steelwall_horizontal.EDITOR.ypos","13"			},
  { "invisible_steelwall_vertical.EDITOR",	"RocksElements.pcx"	},
  { "invisible_steelwall_vertical.EDITOR.xpos",	"11"			},
  { "invisible_steelwall_vertical.EDITOR.ypos",	"13"			},

  { "arrow_left",				"RocksDC.pcx"		},
  { "arrow_left.xpos",				"8"			},
  { "arrow_left.ypos",				"8"			},
  { "arrow_left.frames",			"1"			},
  { "arrow_right",				"RocksDC.pcx"		},
  { "arrow_right.xpos",				"9"			},
  { "arrow_right.ypos",				"8"			},
  { "arrow_right.frames",			"1"			},
  { "arrow_up",					"RocksDC.pcx"		},
  { "arrow_up.xpos",				"10"			},
  { "arrow_up.ypos",				"8"			},
  { "arrow_up.frames",				"1"			},
  { "arrow_down",				"RocksDC.pcx"		},
  { "arrow_down.xpos",				"11"			},
  { "arrow_down.ypos",				"8"			},
  { "arrow_down.frames",			"1"			},

  { "unknown",					"RocksFontEM.pcx"	},
  { "unknown.xpos",				"15"			},
  { "unknown.ypos",				"1"			},
  { "unknown.frames",				"1"			},

  { "trigger_element",				"RocksDC.pcx"		},
  { "trigger_element.xpos",			"15"			},
  { "trigger_element.ypos",			"14"			},
  { "trigger_element.frames",			"1"			},

  { "trigger_player",				"RocksDC.pcx"		},
  { "trigger_player.xpos",			"15"			},
  { "trigger_player.ypos",			"13"			},
  { "trigger_player.frames",			"1"			},

  { "emc_key_5",				"RocksEMC.pcx"		},
  { "emc_key_5.xpos",				"0"			},
  { "emc_key_5.ypos",				"5"			},
  { "emc_key_5.frames",				"1"			},
  { "emc_key_6",				"RocksEMC.pcx"		},
  { "emc_key_6.xpos",				"1"			},
  { "emc_key_6.ypos",				"5"			},
  { "emc_key_6.frames",				"1"			},
  { "emc_key_7",				"RocksEMC.pcx"		},
  { "emc_key_7.xpos",				"2"			},
  { "emc_key_7.ypos",				"5"			},
  { "emc_key_7.frames",				"1"			},
  { "emc_key_8",				"RocksEMC.pcx"		},
  { "emc_key_8.xpos",				"3"			},
  { "emc_key_8.ypos",				"5"			},
  { "emc_key_8.frames",				"1"			},

  { "emc_gate_5",				"RocksEMC.pcx"		},
  { "emc_gate_5.xpos",				"0"			},
  { "emc_gate_5.ypos",				"6"			},
  { "emc_gate_5.frames",			"1"			},
  { "emc_gate_5_gray",				"RocksEMC.pcx"		},
  { "emc_gate_5_gray.xpos",			"4"			},
  { "emc_gate_5_gray.ypos",			"7"			},
  { "emc_gate_5_gray.frames",			"1"			},
  { "emc_gate_5_gray.EDITOR",			"RocksEMC.pcx"		},
  { "emc_gate_5_gray.EDITOR.xpos",		"0"			},
  { "emc_gate_5_gray.EDITOR.ypos",		"7"			},
  { "emc_gate_6",				"RocksEMC.pcx"		},
  { "emc_gate_6.xpos",				"1"			},
  { "emc_gate_6.ypos",				"6"			},
  { "emc_gate_6.frames",			"1"			},
  { "emc_gate_6_gray",				"RocksEMC.pcx"		},
  { "emc_gate_6_gray.xpos",			"4"			},
  { "emc_gate_6_gray.ypos",			"7"			},
  { "emc_gate_6_gray.frames",			"1"			},
  { "emc_gate_6_gray.EDITOR",			"RocksEMC.pcx"		},
  { "emc_gate_6_gray.EDITOR.xpos",		"1"			},
  { "emc_gate_6_gray.EDITOR.ypos",		"7"			},
  { "emc_gate_7",				"RocksEMC.pcx"		},
  { "emc_gate_7.xpos",				"2"			},
  { "emc_gate_7.ypos",				"6"			},
  { "emc_gate_7.frames",			"1"			},
  { "emc_gate_7_gray",				"RocksEMC.pcx"		},
  { "emc_gate_7_gray.xpos",			"4"			},
  { "emc_gate_7_gray.ypos",			"7"			},
  { "emc_gate_7_gray.frames",			"1"			},
  { "emc_gate_7_gray.EDITOR",			"RocksEMC.pcx"		},
  { "emc_gate_7_gray.EDITOR.xpos",		"2"			},
  { "emc_gate_7_gray.EDITOR.ypos",		"7"			},
  { "emc_gate_8",				"RocksEMC.pcx"		},
  { "emc_gate_8.xpos",				"3"			},
  { "emc_gate_8.ypos",				"6"			},
  { "emc_gate_8.frames",			"1"			},
  { "emc_gate_8_gray",				"RocksEMC.pcx"		},
  { "emc_gate_8_gray.xpos",			"4"			},
  { "emc_gate_8_gray.ypos",			"7"			},
  { "emc_gate_8_gray.frames",			"1"			},
  { "emc_gate_8_gray.EDITOR",			"RocksEMC.pcx"		},
  { "emc_gate_8_gray.EDITOR.xpos",		"3"			},
  { "emc_gate_8_gray.EDITOR.ypos",		"7"			},

  { "emc_android",				"RocksEMC.pcx"		},
  { "emc_android.xpos",				"0"			},
  { "emc_android.ypos",				"8"			},
  { "emc_android.frames",			"8"			},

  { "emc_grass",				"RocksEMC.pcx"		},
  { "emc_grass.xpos",				"0"			},
  { "emc_grass.ypos",				"4"			},
  { "emc_grass.frames",				"1"			},
  { "emc_grass.CRUMBLED",			"RocksEMC.pcx"		},
  { "emc_grass.CRUMBLED.xpos",			"1"			},
  { "emc_grass.CRUMBLED.ypos",			"4"			},
  { "emc_grass.CRUMBLED.frames",		"1"			},
  { "emc_grass.digging.left",			"RocksEMC.pcx"		},
  { "emc_grass.digging.left.xpos",		"6"			},
  { "emc_grass.digging.left.ypos",		"0"			},
  { "emc_grass.digging.left.frames",		"3"			},
  { "emc_grass.digging.left.delay",		"2"			},
  { "emc_grass.digging.left.anim_mode",		"linear"		},
  { "emc_grass.digging.right",			"RocksEMC.pcx"		},
  { "emc_grass.digging.right.xpos",		"9"			},
  { "emc_grass.digging.right.ypos",		"0"			},
  { "emc_grass.digging.right.frames",		"3"			},
  { "emc_grass.digging.right.delay",		"2"			},
  { "emc_grass.digging.right.anim_mode",	"linear"		},
  { "emc_grass.digging.up",			"RocksEMC.pcx"		},
  { "emc_grass.digging.up.xpos",		"0"			},
  { "emc_grass.digging.up.ypos",		"0"			},
  { "emc_grass.digging.up.frames",		"3"			},
  { "emc_grass.digging.up.delay",		"2"			},
  { "emc_grass.digging.up.anim_mode",		"linear"		},
  { "emc_grass.digging.down",			"RocksEMC.pcx"		},
  { "emc_grass.digging.down.xpos",		"3"			},
  { "emc_grass.digging.down.ypos",		"0"			},
  { "emc_grass.digging.down.frames",		"3"			},
  { "emc_grass.digging.down.delay",		"2"			},
  { "emc_grass.digging.down.anim_mode",		"linear"		},
  { "emc_grass.digging.left.CRUMBLED",		"RocksEMC.pcx"		},
  { "emc_grass.digging.left.CRUMBLED.xpos",	"6"			},
  { "emc_grass.digging.left.CRUMBLED.ypos",	"1"			},
  { "emc_grass.digging.left.CRUMBLED.frames",	"3"			},
  { "emc_grass.digging.left.CRUMBLED.delay",	"2"			},
  { "emc_grass.digging.left.CRUMBLED.anim_mode","linear"		},
  { "emc_grass.digging.right.CRUMBLED",		"RocksEMC.pcx"		},
  { "emc_grass.digging.right.CRUMBLED.xpos",	"9"			},
  { "emc_grass.digging.right.CRUMBLED.ypos",	"1"			},
  { "emc_grass.digging.right.CRUMBLED.frames",	"3"			},
  { "emc_grass.digging.right.CRUMBLED.delay",	"2"			},
  { "emc_grass.digging.right.CRUMBLED.anim_mode","linear"		},
  { "emc_grass.digging.up.CRUMBLED",		"RocksEMC.pcx"		},
  { "emc_grass.digging.up.CRUMBLED.xpos",	"0"			},
  { "emc_grass.digging.up.CRUMBLED.ypos",	"1"			},
  { "emc_grass.digging.up.CRUMBLED.frames",	"3"			},
  { "emc_grass.digging.up.CRUMBLED.delay",	"2"			},
  { "emc_grass.digging.up.CRUMBLED.anim_mode",	"linear"		},
  { "emc_grass.digging.down.CRUMBLED",		"RocksEMC.pcx"		},
  { "emc_grass.digging.down.CRUMBLED.xpos",	"3"			},
  { "emc_grass.digging.down.CRUMBLED.ypos",	"1"			},
  { "emc_grass.digging.down.CRUMBLED.frames",	"3"			},
  { "emc_grass.digging.down.CRUMBLED.delay",	"2"			},
  { "emc_grass.digging.down.CRUMBLED.anim_mode","linear"		},

  { "emc_magic_ball",				"RocksEMC.pcx"		},
  { "emc_magic_ball.xpos",			"0"			},
  { "emc_magic_ball.ypos",			"9"			},
  { "emc_magic_ball.frames",			"1"			},

  { "emc_magic_ball.active",			"RocksEMC.pcx"		},
  { "emc_magic_ball.active.xpos",		"0"			},
  { "emc_magic_ball.active.ypos",		"9"			},
  { "emc_magic_ball.active.frames",		"16"			},
  { "emc_magic_ball.active.frames_per_line",	"8"			},

  { "emc_magic_ball_switch",			"RocksEMC.pcx"		},
  { "emc_magic_ball_switch.xpos",		"8"			},
  { "emc_magic_ball_switch.ypos",		"10"			},
  { "emc_magic_ball_switch.frames",		"1"			},

  { "emc_magic_ball_switch.active",		"RocksEMC.pcx"		},
  { "emc_magic_ball_switch.active.xpos",	"8"			},
  { "emc_magic_ball_switch.active.ypos",	"9"			},
  { "emc_magic_ball_switch.active.frames",	"1"			},

  { "emc_spring_bumper",			"RocksEMC.pcx"		},
  { "emc_spring_bumper.xpos",			"8"			},
  { "emc_spring_bumper.ypos",			"4"			},
  { "emc_spring_bumper.frames",			"1"			},

  { "emc_spring_bumper.active",			"RocksEMC.pcx"		},
  { "emc_spring_bumper.active.xpos",		"8"			},
  { "emc_spring_bumper.active.ypos",		"4"			},
  { "emc_spring_bumper.active.frames",		"4"			},
  { "emc_spring_bumper.active.anim_mode",	"pingpong2"		},

  { "emc_plant",				"RocksEMC.pcx"		},
  { "emc_plant.xpos",				"4"			},
  { "emc_plant.ypos",				"4"			},
  { "emc_plant.frames",				"1"			},
  { "emc_plant.CRUMBLED",			"RocksEMC.pcx"		},
  { "emc_plant.CRUMBLED.xpos",			"5"			},
  { "emc_plant.CRUMBLED.ypos",			"4"			},
  { "emc_plant.CRUMBLED.frames",		"1"			},

  { "emc_lenses",				"RocksEMC.pcx"		},
  { "emc_lenses.xpos",				"6"			},
  { "emc_lenses.ypos",				"4"			},
  { "emc_lenses.frames",			"1"			},

  { "emc_magnifier",				"RocksEMC.pcx"		},
  { "emc_magnifier.xpos",			"7"			},
  { "emc_magnifier.ypos",			"4"			},
  { "emc_magnifier.frames",			"1"			},

  { "emc_wall_9",				"RocksEMC.pcx"		},
  { "emc_wall_9.xpos",				"10"			},
  { "emc_wall_9.ypos",				"5"			},
  { "emc_wall_9.frames",			"1"			},
  { "emc_wall_10",				"RocksEMC.pcx"		},
  { "emc_wall_10.xpos",				"10"			},
  { "emc_wall_10.ypos",				"6"			},
  { "emc_wall_10.frames",			"1"			},
  { "emc_wall_11",				"RocksEMC.pcx"		},
  { "emc_wall_11.xpos",				"11"			},
  { "emc_wall_11.ypos",				"5"			},
  { "emc_wall_11.frames",			"1"			},
  { "emc_wall_12",				"RocksEMC.pcx"		},
  { "emc_wall_12.xpos",				"11"			},
  { "emc_wall_12.ypos",				"6"			},
  { "emc_wall_12.frames",			"1"			},
  { "emc_wall_13",				"RocksEMC.pcx"		},
  { "emc_wall_13.xpos",				"10"			},
  { "emc_wall_13.ypos",				"7"			},
  { "emc_wall_13.frames",			"1"			},
  { "emc_wall_14",				"RocksEMC.pcx"		},
  { "emc_wall_14.xpos",				"10"			},
  { "emc_wall_14.ypos",				"8"			},
  { "emc_wall_14.frames",			"1"			},
  { "emc_wall_15",				"RocksEMC.pcx"		},
  { "emc_wall_15.xpos",				"10"			},
  { "emc_wall_15.ypos",				"9"			},
  { "emc_wall_15.frames",			"1"			},
  { "emc_wall_16",				"RocksEMC.pcx"		},
  { "emc_wall_16.xpos",				"10"			},
  { "emc_wall_16.ypos",				"10"			},
  { "emc_wall_16.frames",			"1"			},

  { "emc_wall_slippery_1",			"RocksEMC.pcx"		},
  { "emc_wall_slippery_1.xpos",			"11"			},
  { "emc_wall_slippery_1.ypos",			"7"			},
  { "emc_wall_slippery_1.frames",		"1"			},
  { "emc_wall_slippery_2",			"RocksEMC.pcx"		},
  { "emc_wall_slippery_2.xpos",			"11"			},
  { "emc_wall_slippery_2.ypos",			"8"			},
  { "emc_wall_slippery_2.frames",		"1"			},
  { "emc_wall_slippery_3",			"RocksEMC.pcx"		},
  { "emc_wall_slippery_3.xpos",			"11"			},
  { "emc_wall_slippery_3.ypos",			"9"			},
  { "emc_wall_slippery_3.frames",		"1"			},
  { "emc_wall_slippery_4",			"RocksEMC.pcx"		},
  { "emc_wall_slippery_4.xpos",			"11"			},
  { "emc_wall_slippery_4.ypos",			"10"			},
  { "emc_wall_slippery_4.frames",		"1"			},

  { "emc_fake_grass",				"RocksEMC.pcx"		},
  { "emc_fake_grass.xpos",			"0"			},
  { "emc_fake_grass.ypos",			"4"			},
  { "emc_fake_grass.frames",			"1"			},
  { "emc_fake_grass.CRUMBLED",			"RocksEMC.pcx"		},
  { "emc_fake_grass.CRUMBLED.xpos",		"1"			},
  { "emc_fake_grass.CRUMBLED.ypos",		"4"			},
  { "emc_fake_grass.CRUMBLED.frames",		"1"			},
  { "emc_fake_grass.active",			"RocksEMC.pcx"		},
  { "emc_fake_grass.active.xpos",		"2"			},
  { "emc_fake_grass.active.ypos",		"4"			},
  { "emc_fake_grass.active.frames",		"1"			},
  { "emc_fake_grass.active.CRUMBLED",		"RocksEMC.pcx"		},
  { "emc_fake_grass.active.CRUMBLED.xpos",	"3"			},
  { "emc_fake_grass.active.CRUMBLED.ypos",	"4"			},
  { "emc_fake_grass.active.CRUMBLED.frames",	"1"			},

  { "emc_fake_acid",				"RocksElements.pcx"	},
  { "emc_fake_acid.xpos",			"12"			},
  { "emc_fake_acid.ypos",			"7"			},
  { "emc_fake_acid.frames",			"4"			},
  { "emc_fake_acid.delay",			"10"			},
  { "emc_fake_acid.global_sync",		"true"			},

  { "emc_dripper",				"RocksSP.pcx"		},
  { "emc_dripper.xpos",				"0"			},
  { "emc_dripper.ypos",				"0"			},
  { "emc_dripper.frames",			"1"			},
  { "emc_dripper.EDITOR",			"RocksEMC.pcx"		},
  { "emc_dripper.EDITOR.xpos",			"8"			},
  { "emc_dripper.EDITOR.ypos",			"8"			},
  { "emc_dripper.active",			"RocksEMC.pcx"		},
  { "emc_dripper.active.xpos",			"8"			},
  { "emc_dripper.active.ypos",			"8"			},
  { "emc_dripper.active.frames",		"1"			},

#include "conf_chr.c"	/* include auto-generated data structure definitions */
#include "conf_cus.c"	/* include auto-generated data structure definitions */
#include "conf_grp.c"	/* include auto-generated data structure definitions */

  /* images not associated to game elements (used for menu screens etc.) */
  /* keyword to stop parser: "NO_MORE_ELEMENT_IMAGES" <-- do not change! */

#if 1
  /* !!! TEMPORARILY STORED HERE -- PROBABLY TO BE CHANGED !!! */

  /* (for testing, change filename back to "emc_object dot pcx") */
  { "emc_object",				"RocksEMC.pcx"		},
#if 0
  { "emc_object.scale_up_factor",		"2"			},
#endif

  /* (for testing, change filename back to "emc_sprite dot pcx") */
  { "emc_sprite",				"RocksEMC.pcx"		},
#if 0
  { "emc_sprite.scale_up_factor",		"2"			},
#endif
#endif

  { "toon_1",					"RocksToons.pcx"	},
  { "toon_1.x",					"2"			},
  { "toon_1.y",					"72"			},
  { "toon_1.width",				"40"			},
  { "toon_1.height",				"48"			},
  { "toon_1.frames",				"8"			},
  { "toon_1.delay",				"1"			},
  { "toon_1.step_offset",			"4"			},
  { "toon_1.step_delay",			"5"			},
  { "toon_1.direction",				"right"			},
  { "toon_1.position",				"bottom"		},

  { "toon_2",					"RocksToons.pcx"	},
  { "toon_2.x",					"2"			},
  { "toon_2.y",					"186"			},
  { "toon_2.width",				"40"			},
  { "toon_2.height",				"48"			},
  { "toon_2.frames",				"8"			},
  { "toon_2.delay",				"1"			},
  { "toon_2.step_offset",			"4"			},
  { "toon_2.step_delay",			"5"			},
  { "toon_2.direction",				"left"			},
  { "toon_2.position",				"bottom"		},

  { "toon_3",					"RocksToons.pcx"	},
  { "toon_3.x",					"2"			},
  { "toon_3.y",					"125"			},
  { "toon_3.width",				"48"			},
  { "toon_3.height",				"56"			},
  { "toon_3.frames",				"8"			},
  { "toon_3.delay",				"1"			},
  { "toon_3.step_offset",			"4"			},
  { "toon_3.step_delay",			"5"			},
  { "toon_3.direction",				"right"			},
  { "toon_3.position",				"bottom"		},

  { "toon_4",					"RocksToons.pcx"	},
  { "toon_4.x",					"327"			},
  { "toon_4.y",					"10"			},
  { "toon_4.width",				"80"			},
  { "toon_4.height",				"110"			},
  { "toon_4.frames",				"1"			},
  { "toon_4.delay",				"1"			},
  { "toon_4.step_offset",			"1"			},
  { "toon_4.step_delay",			"1"			},
  { "toon_4.direction",				"up"			},
  { "toon_4.position",				"any"			},

  { "toon_5",					"RocksToons.pcx"	},
  { "toon_5.x",					"2"			},
  { "toon_5.y",					"2"			},
  { "toon_5.width",				"32"			},
  { "toon_5.height",				"30"			},
  { "toon_5.frames",				"8"			},
  { "toon_5.delay",				"2"			},
  { "toon_5.anim_mode",				"pingpong2"		},
  { "toon_5.step_offset",			"2"			},
  { "toon_5.step_delay",			"1"			},
  { "toon_5.direction",				"right"			},
  { "toon_5.position",				"upper"			},

  { "toon_6",					"RocksToons.pcx"	},
  { "toon_6.x",					"2"			},
  { "toon_6.y",					"37"			},
  { "toon_6.width",				"32"			},
  { "toon_6.height",				"30"			},
  { "toon_6.frames",				"8"			},
  { "toon_6.delay",				"2"			},
  { "toon_6.anim_mode",				"pingpong2"		},
  { "toon_6.step_offset",			"2"			},
  { "toon_6.step_delay",			"1"			},
  { "toon_6.direction",				"left"			},
  { "toon_6.position",				"upper"			},

  { "toon_7",					"RocksMore.pcx"		},
  { "toon_7.xpos",				"0"			},
  { "toon_7.ypos",				"6"			},
  { "toon_7.frames",				"16"			},
  { "toon_7.delay",				"2"			},
  { "toon_7.direction",				"down"			},
  { "toon_7.position",				"any"			},

  { "toon_8",					"RocksHeroes.pcx"	},
  { "toon_8.xpos",				"4"			},
  { "toon_8.ypos",				"1"			},
  { "toon_8.frames",				"4"			},
  { "toon_8.delay",				"4"			},
  { "toon_8.direction",				"right"			},
  { "toon_8.position",				"bottom"		},

  { "toon_9",					"RocksHeroes.pcx"	},
  { "toon_9.xpos",				"8"			},
  { "toon_9.ypos",				"7"			},
  { "toon_9.frames",				"4"			},
  { "toon_9.delay",				"2"			},
  { "toon_9.direction",				"left"			},
  { "toon_9.position",				"bottom"		},

  { "toon_10",					"RocksHeroes.pcx"	},
  { "toon_10.xpos",				"12"			},
  { "toon_10.ypos",				"7"			},
  { "toon_10.frames",				"4"			},
  { "toon_10.delay",				"2"			},
  { "toon_10.direction",			"right"			},
  { "toon_10.position",				"bottom"		},

  { "toon_11",					"RocksHeroes.pcx"	},
  { "toon_11.xpos",				"8"			},
  { "toon_11.ypos",				"5"			},
  { "toon_11.frames",				"4"			},
  { "toon_11.delay",				"2"			},
  { "toon_11.direction",			"left"			},
  { "toon_11.position",				"bottom"		},

  { "toon_12",					"RocksHeroes.pcx"	},
  { "toon_12.xpos",				"12"			},
  { "toon_12.ypos",				"5"			},
  { "toon_12.frames",				"4"			},
  { "toon_12.delay",				"2"			},
  { "toon_12.direction",			"right"			},
  { "toon_12.position",				"bottom"		},

  { "toon_13",					"RocksHeroes.pcx"	},
  { "toon_13.xpos",				"8"			},
  { "toon_13.ypos",				"1"			},
  { "toon_13.frames",				"4"			},
  { "toon_13.delay",				"2"			},
  { "toon_13.direction",			"left"			},
  { "toon_13.position",				"bottom"		},

  { "toon_14",					"RocksHeroes.pcx"	},
  { "toon_14.xpos",				"12"			},
  { "toon_14.ypos",				"1"			},
  { "toon_14.frames",				"4"			},
  { "toon_14.delay",				"2"			},
  { "toon_14.direction",			"right"			},
  { "toon_14.position",				"bottom"		},

  { "toon_15",					"RocksHeroes.pcx"	},
  { "toon_15.xpos",				"8"			},
  { "toon_15.ypos",				"3"			},
  { "toon_15.frames",				"4"			},
  { "toon_15.delay",				"2"			},
  { "toon_15.direction",			"left"			},
  { "toon_15.position",				"bottom"		},

  { "toon_16",					"RocksHeroes.pcx"	},
  { "toon_16.xpos",				"12"			},
  { "toon_16.ypos",				"3"			},
  { "toon_16.frames",				"4"			},
  { "toon_16.delay",				"2"			},
  { "toon_16.direction",			"right"			},
  { "toon_16.position",				"bottom"		},

  { "toon_17",					"RocksHeroes.pcx"	},
  { "toon_17.xpos",				"8"			},
  { "toon_17.ypos",				"9"			},
  { "toon_17.frames",				"8"			},
  { "toon_17.delay",				"2"			},
  { "toon_17.direction",			"left"			},
  { "toon_17.position",				"any"			},

  { "toon_18",					"RocksHeroes.pcx"	},
  { "toon_18.xpos",				"8"			},
  { "toon_18.ypos",				"9"			},
  { "toon_18.frames",				"8"			},
  { "toon_18.delay",				"2"			},
  { "toon_18.direction",			"right"			},
  { "toon_18.position",				"any"			},

  { "toon_19",					"RocksElements.pcx"	},
  { "toon_19.xpos",				"8"			},
  { "toon_19.ypos",				"0"			},
  { "toon_19.frames",				"2"			},
  { "toon_19.delay",				"4"			},
  { "toon_19.direction",			"down"			},
  { "toon_19.position",				"any"			},

  { "toon_20",					"RocksElements.pcx"	},
  { "toon_20.xpos",				"10"			},
  { "toon_20.ypos",				"0"			},
  { "toon_20.frames",				"2"			},
  { "toon_20.delay",				"4"			},
  { "toon_20.direction",			"down"			},
  { "toon_20.position",				"any"			},

  { "menu.calibrate_red",			"RocksElements.pcx"	},
  { "menu.calibrate_red.xpos",			"12"			},
  { "menu.calibrate_red.ypos",			"8"			},
  { "menu.calibrate_red.frames",		"1"			},
  { "menu.calibrate_blue",			"RocksElements.pcx"	},
  { "menu.calibrate_blue.xpos",			"13"			},
  { "menu.calibrate_blue.ypos",			"8"			},
  { "menu.calibrate_blue.frames",		"1"			},
  { "menu.calibrate_yellow",			"RocksElements.pcx"	},
  { "menu.calibrate_yellow.xpos",		"14"			},
  { "menu.calibrate_yellow.ypos",		"8"			},
  { "menu.calibrate_yellow.frames",		"1"			},

  { "menu.button",				"RocksElements.pcx"	},
  { "menu.button.xpos",				"13"			},
  { "menu.button.ypos",				"8"			},
  { "menu.button.frames",			"1"			},
  { "menu.button.active",			"RocksElements.pcx"	},
  { "menu.button.active.xpos",			"12"			},
  { "menu.button.active.ypos",			"8"			},
  { "menu.button.active.frames",		"1"			},

  { "menu.button_left",				"RocksDC.pcx"		},
  { "menu.button_left.xpos",			"8"			},
  { "menu.button_left.ypos",			"8"			},
  { "menu.button_left.frames",			"1"			},
  { "menu.button_right",			"RocksDC.pcx"		},
  { "menu.button_right.xpos",			"9"			},
  { "menu.button_right.ypos",			"8"			},
  { "menu.button_right.frames",			"1"			},
  { "menu.button_up",				"RocksDC.pcx"		},
  { "menu.button_up.xpos",			"10"			},
  { "menu.button_up.ypos",			"8"			},
  { "menu.button_up.frames",			"1"			},
  { "menu.button_down",				"RocksDC.pcx"		},
  { "menu.button_down.xpos",			"11"			},
  { "menu.button_down.ypos",			"8"			},
  { "menu.button_down.frames",			"1"			},
  { "menu.button_left.active",			"RocksDC.pcx"		},
  { "menu.button_left.active.xpos",		"8"			},
  { "menu.button_left.active.ypos",		"9"			},
  { "menu.button_left.active.frames",		"1"			},
  { "menu.button_right.active",			"RocksDC.pcx"		},
  { "menu.button_right.active.xpos",		"9"			},
  { "menu.button_right.active.ypos",		"9"			},
  { "menu.button_right.active.frames",		"1"			},
  { "menu.button_up.active",			"RocksDC.pcx"		},
  { "menu.button_up.active.xpos",		"10"			},
  { "menu.button_up.active.ypos",		"9"			},
  { "menu.button_up.active.frames",		"1"			},
  { "menu.button_down.active",			"RocksDC.pcx"		},
  { "menu.button_down.active.xpos",		"11"			},
  { "menu.button_down.active.ypos",		"9"			},
  { "menu.button_down.active.frames",		"1"			},

  { "menu.scrollbar",				"RocksDC.pcx"		},
  { "menu.scrollbar.xpos",			"8"			},
  { "menu.scrollbar.ypos",			"10"			},
  { "menu.scrollbar.frames",			"1"			},
  { "menu.scrollbar.active",			"RocksDC.pcx"		},
  { "menu.scrollbar.active.xpos",		"9"			},
  { "menu.scrollbar.active.ypos",		"10"			},
  { "menu.scrollbar.active.frames",		"1"			},

  { "font.initial_1",				"RocksFontSmall.pcx"	},
  { "font.initial_1.x",				"0"			},
  { "font.initial_1.y",				"0"			},
  { "font.initial_1.width",			"14"			},
  { "font.initial_1.height",			"14"			},
  { "font.initial_2",				"RocksFontSmall.pcx"	},
  { "font.initial_2.x",				"0"			},
  { "font.initial_2.y",				"70"			},
  { "font.initial_2.width",			"14"			},
  { "font.initial_2.height",			"14"			},
  { "font.initial_3",				"RocksFontSmall.pcx"	},
  { "font.initial_3.x",				"0"			},
  { "font.initial_3.y",				"140"			},
  { "font.initial_3.width",			"14"			},
  { "font.initial_3.height",			"14"			},
  { "font.initial_4",				"RocksFontSmall.pcx"	},
  { "font.initial_4.x",				"0"			},
  { "font.initial_4.y",				"210"			},
  { "font.initial_4.width",			"14"			},
  { "font.initial_4.height",			"14"			},

  { "font.title_1",				"RocksFontBig.pcx"	},
  { "font.title_1.x",				"0"			},
  { "font.title_1.y",				"480"			},
  { "font.title_1.width",			"32"			},
  { "font.title_1.height",			"32"			},
  { "font.title_1.LEVELS",			"RocksFontBig.pcx"	},
  { "font.title_1.LEVELS.x",			"0"			},
  { "font.title_1.LEVELS.y",			"320"			},
  { "font.title_1.LEVELS.width",		"32"			},
  { "font.title_1.LEVELS.height",		"32"			},
  { "font.title_2",				"RocksFontSmall.pcx"	},
  { "font.title_2.x",				"0"			},
  { "font.title_2.y",				"0"			},
  { "font.title_2.width",			"14"			},
  { "font.title_2.height",			"14"			},

  { "font.menu_1",				"RocksFontBig.pcx"	},
  { "font.menu_1.x",				"0"			},
  { "font.menu_1.y",				"320"			},
  { "font.menu_1.width",			"32"			},
  { "font.menu_1.height",			"32"			},
  { "font.menu_2",				"RocksFontMedium.pcx"	},
  { "font.menu_2.x",				"0"			},
  { "font.menu_2.y",				"320"			},
  { "font.menu_2.width",			"16"			},
  { "font.menu_2.height",			"32"			},

  { "font.text_1",				"RocksFontSmall.pcx"	},
  { "font.text_1.x",				"0"			},
  { "font.text_1.y",				"140"			},
  { "font.text_1.width",			"14"			},
  { "font.text_1.height",			"14"			},
  { "font.text_1.LEVELS",			"RocksFontMedium.pcx"	},
  { "font.text_1.LEVELS.x",			"0"			},
  { "font.text_1.LEVELS.y",			"0"			},
  { "font.text_1.LEVELS.width",			"16"			},
  { "font.text_1.LEVELS.height",		"32"			},
  { "font.text_1.PREVIEW",			"RocksFontEM.pcx"	},
  { "font.text_1.PREVIEW.x",			"0"			},
  { "font.text_1.PREVIEW.y",			"160"			},
  { "font.text_1.PREVIEW.width",		"16"			},
  { "font.text_1.PREVIEW.height",		"16"			},
  { "font.text_1.SCORES",			"RocksFontMedium.pcx"	},
  { "font.text_1.SCORES.x",			"0"			},
  { "font.text_1.SCORES.y",			"480"			},
  { "font.text_1.SCORES.width",			"16"			},
  { "font.text_1.SCORES.height",		"32"			},
  { "font.text_1.active.SCORES",		"RocksFontMedium.pcx"	},
  { "font.text_1.active.SCORES.x",		"0"			},
  { "font.text_1.active.SCORES.y",		"0"			},
  { "font.text_1.active.SCORES.width",		"16"			},
  { "font.text_1.active.SCORES.height",		"32"			},
  { "font.text_2",				"RocksFontSmall.pcx"	},
  { "font.text_2.x",				"0"			},
  { "font.text_2.y",				"210"			},
  { "font.text_2.width",			"14"			},
  { "font.text_2.height",			"14"			},
  { "font.text_2.LEVELS",			"RocksFontMedium.pcx"	},
  { "font.text_2.LEVELS.x",			"0"			},
  { "font.text_2.LEVELS.y",			"160"			},
  { "font.text_2.LEVELS.width",			"16"			},
  { "font.text_2.LEVELS.height",		"32"			},
  { "font.text_2.PREVIEW",			"RocksFontEM.pcx"	},
  { "font.text_2.PREVIEW.x",			"0"			},
  { "font.text_2.PREVIEW.y",			"160"			},
  { "font.text_2.PREVIEW.width",		"16"			},
  { "font.text_2.PREVIEW.height",		"16"			},
  { "font.text_2.SCORES",			"RocksFontBig.pcx"	},
  { "font.text_2.SCORES.x",			"0"			},
  { "font.text_2.SCORES.y",			"320"			},
  { "font.text_2.SCORES.width",			"32"			},
  { "font.text_2.SCORES.height",		"32"			},
  { "font.text_2.active.SCORES",		"RocksFontBig.pcx"	},
  { "font.text_2.active.SCORES.x",		"0"			},
  { "font.text_2.active.SCORES.y",		"0"			},
  { "font.text_2.active.SCORES.width",		"32"			},
  { "font.text_2.active.SCORES.height",		"32"			},
  { "font.text_3",				"RocksFontSmall.pcx"	},
  { "font.text_3.x",				"0"			},
  { "font.text_3.y",				"0"			},
  { "font.text_3.width",			"14"			},
  { "font.text_3.height",			"14"			},
  { "font.text_3.LEVELS",			"RocksFontMedium.pcx"	},
  { "font.text_3.LEVELS.x",			"0"			},
  { "font.text_3.LEVELS.y",			"320"			},
  { "font.text_3.LEVELS.width",			"16"			},
  { "font.text_3.LEVELS.height",		"32"			},
  { "font.text_3.PREVIEW",			"RocksFontEM.pcx"	},
  { "font.text_3.PREVIEW.x",			"0"			},
  { "font.text_3.PREVIEW.y",			"160"			},
  { "font.text_3.PREVIEW.width",		"16"			},
  { "font.text_3.PREVIEW.height",		"16"			},
  { "font.text_3.SCORES",			"RocksFontMedium.pcx"	},
  { "font.text_3.SCORES.x",			"0"			},
  { "font.text_3.SCORES.y",			"480"			},
  { "font.text_3.SCORES.width",			"16"			},
  { "font.text_3.SCORES.height",		"32"			},
  { "font.text_3.active.SCORES",		"RocksFontMedium.pcx"	},
  { "font.text_3.active.SCORES.x",		"0"			},
  { "font.text_3.active.SCORES.y",		"0"			},
  { "font.text_3.active.SCORES.width",		"16"			},
  { "font.text_3.active.SCORES.height",		"32"			},
  { "font.text_4",				"RocksFontSmall.pcx"	},
  { "font.text_4.x",				"0"			},
  { "font.text_4.y",				"70"			},
  { "font.text_4.width",			"14"			},
  { "font.text_4.height",			"14"			},
  { "font.text_4.LEVELS",			"RocksFontMedium.pcx"	},
  { "font.text_4.LEVELS.x",			"0"			},
  { "font.text_4.LEVELS.y",			"480"			},
  { "font.text_4.LEVELS.width",			"16"			},
  { "font.text_4.LEVELS.height",		"32"			},
  { "font.text_4.SCORES",			"RocksFontMedium.pcx"	},
  { "font.text_4.SCORES.x",			"0"			},
  { "font.text_4.SCORES.y",			"480"			},
  { "font.text_4.SCORES.width",			"16"			},
  { "font.text_4.SCORES.height",		"32"			},
  { "font.text_4.active.SCORES",		"RocksFontMedium.pcx"	},
  { "font.text_4.active.SCORES.x",		"0"			},
  { "font.text_4.active.SCORES.y",		"0"			},
  { "font.text_4.active.SCORES.width",		"16"			},
  { "font.text_4.active.SCORES.height",		"32"			},

  { "font.envelope_1",				"RocksFontEM.pcx"	},
  { "font.envelope_1.x",			"0"			},
  { "font.envelope_1.y",			"160"			},
  { "font.envelope_1.width",			"16"			},
  { "font.envelope_1.height",			"16"			},
  { "font.envelope_2",				"RocksFontEM.pcx"	},
  { "font.envelope_2.x",			"0"			},
  { "font.envelope_2.y",			"160"			},
  { "font.envelope_2.width",			"16"			},
  { "font.envelope_2.height",			"16"			},
  { "font.envelope_3",				"RocksFontEM.pcx"	},
  { "font.envelope_3.x",			"0"			},
  { "font.envelope_3.y",			"160"			},
  { "font.envelope_3.width",			"16"			},
  { "font.envelope_3.height",			"16"			},
  { "font.envelope_4",				"RocksFontEM.pcx"	},
  { "font.envelope_4.x",			"0"			},
  { "font.envelope_4.y",			"160"			},
  { "font.envelope_4.width",			"16"			},
  { "font.envelope_4.height",			"16"			},

  { "font.input_1",				"RocksFontSmall.pcx"	},
  { "font.input_1.x",				"0"			},
  { "font.input_1.y",				"210"			},
  { "font.input_1.width",			"14"			},
  { "font.input_1.height",			"14"			},
  { "font.input_1.MAIN",			"RocksFontBig.pcx"	},
  { "font.input_1.MAIN.x",			"0"			},
  { "font.input_1.MAIN.y",			"0"			},
  { "font.input_1.MAIN.width",			"32"			},
  { "font.input_1.MAIN.height",			"32"			},
  { "font.input_1.active",			"RocksFontSmall.pcx"	},
  { "font.input_1.active.x",			"0"			},
  { "font.input_1.active.y",			"210"			},
  { "font.input_1.active.width",		"14"			},
  { "font.input_1.active.height",		"14"			},
  { "font.input_1.active.MAIN",			"RocksFontBig.pcx"	},
  { "font.input_1.active.MAIN.x",		"0"			},
  { "font.input_1.active.MAIN.y",		"480"			},
  { "font.input_1.active.MAIN.width",		"32"			},
  { "font.input_1.active.MAIN.height",		"32"			},
  { "font.input_1.active.SETUP",		"RocksFontBig.pcx"	},
  { "font.input_1.active.SETUP.x",		"0"			},
  { "font.input_1.active.SETUP.y",		"0"			},
  { "font.input_1.active.SETUP.width",		"32"			},
  { "font.input_1.active.SETUP.height",		"32"			},
  { "font.input_2",				"RocksFontSmall.pcx"	},
  { "font.input_2.x",				"0"			},
  { "font.input_2.y",				"210"			},
  { "font.input_2.width",			"14"			},
  { "font.input_2.height",			"14"			},
  { "font.input_2.active",			"RocksFontSmall.pcx"	},
  { "font.input_2.active.x",			"0"			},
  { "font.input_2.active.y",			"210"			},
  { "font.input_2.active.width",		"14"			},
  { "font.input_2.active.height",		"14"			},

  { "font.option_off",				"RocksFontBig.pcx"	},
  { "font.option_off.x",			"0"			},
  { "font.option_off.y",			"160"			},
  { "font.option_off.width",			"32"			},
  { "font.option_off.height",			"32"			},
  { "font.option_on",				"RocksFontBig.pcx"	},
  { "font.option_on.x",				"0"			},
  { "font.option_on.y",				"480"			},
  { "font.option_on.width",			"32"			},
  { "font.option_on.height",			"32"			},

  { "font.value_1",				"RocksFontBig.pcx"	},
  { "font.value_1.x",				"0"			},
  { "font.value_1.y",				"480"			},
  { "font.value_1.width",			"32"			},
  { "font.value_1.height",			"32"			},
  { "font.value_2",				"RocksFontMedium.pcx"	},
  { "font.value_2.x",				"0"			},
  { "font.value_2.y",				"480"			},
  { "font.value_2.width",			"16"			},
  { "font.value_2.height",			"32"			},
  { "font.value_old",				"RocksFontBig.pcx"	},
  { "font.value_old.x",				"0"			},
  { "font.value_old.y",				"160"			},
  { "font.value_old.width",			"32"			},
  { "font.value_old.height",			"32"			},

  { "font.level_number",			"RocksFontSmall.pcx"	},
  { "font.level_number.x",			"0"			},
  { "font.level_number.y",			"350"			},
  { "font.level_number.width",			"10"			},
  { "font.level_number.height",			"14"			},

  { "font.tape_recorder",			"RocksFontSmall.pcx"	},
  { "font.tape_recorder.x",			"0"			},
  { "font.tape_recorder.y",			"280"			},
  { "font.tape_recorder.width",			"11"			},
  { "font.tape_recorder.height",		"14"			},

  { "font.game_info",				"RocksFontEM.pcx"	},
  { "font.game_info.xpos",			"0"			},
  { "font.game_info.ypos",			"0"			},
  { "font.game_info.delay",			"10"			},

  { "global.border",				"RocksScreen.pcx"	},
  { "global.door",				"RocksDoor.pcx"		},

  { "editor.element_border",			"RocksElements.pcx"	},
  { "editor.element_border.xpos",		"0"			},
  { "editor.element_border.ypos",		"0"			},

  { "editor.element_border_input",		"RocksElements.pcx"	},
  { "editor.element_border_input.xpos",		"0"			},
  { "editor.element_border_input.ypos",		"0"			},

  { "background.envelope_1",			"RocksScreen.pcx"	},
  { "background.envelope_1.x",			"0"			},
  { "background.envelope_1.y",			"0"			},
  { "background.envelope_1.width",		"560"			},
  { "background.envelope_1.height",		"560"			},
  { "background.envelope_1.anim_mode",		"default"		},
  { "background.envelope_1.draw_masked",	"false"			},
  { "background.envelope_2",			"RocksScreen.pcx"	},
  { "background.envelope_2.x",			"0"			},
  { "background.envelope_2.y",			"0"			},
  { "background.envelope_2.width",		"560"			},
  { "background.envelope_2.height",		"560"			},
  { "background.envelope_2.anim_mode",		"default"		},
  { "background.envelope_2.draw_masked",	"false"			},
  { "background.envelope_3",			"RocksScreen.pcx"	},
  { "background.envelope_3.x",			"0"			},
  { "background.envelope_3.y",			"0"			},
  { "background.envelope_3.width",		"560"			},
  { "background.envelope_3.height",		"560"			},
  { "background.envelope_3.anim_mode",		"default"		},
  { "background.envelope_3.draw_masked",	"false"			},
  { "background.envelope_4",			"RocksScreen.pcx"	},
  { "background.envelope_4.x",			"0"			},
  { "background.envelope_4.y",			"0"			},
  { "background.envelope_4.width",		"560"			},
  { "background.envelope_4.height",		"560"			},
  { "background.envelope_4.anim_mode",		"default"		},
  { "background.envelope_4.draw_masked",	"false"			},

  { "background",				UNDEFINED_FILENAME	},
  { "background.MAIN",				UNDEFINED_FILENAME	},
  { "background.LEVELS",			UNDEFINED_FILENAME	},
  { "background.SCORES",			UNDEFINED_FILENAME	},
  { "background.EDITOR",			UNDEFINED_FILENAME	},
  { "background.INFO",				UNDEFINED_FILENAME	},
  { "background.INFO[ELEMENTS]",		UNDEFINED_FILENAME	},
  { "background.SETUP",				UNDEFINED_FILENAME	},
  { "background.DOOR",				UNDEFINED_FILENAME	},

  /* the following directives are not associated with an image, but
     probably make sense to be defined in "graphicsinfo.conf", too */

  { "global.num_toons",				"20"			},

  { "menu.draw_xoffset",			"0"			},
  { "menu.draw_yoffset",			"0"			},
  { "menu.draw_xoffset.MAIN",			"0"			},
  { "menu.draw_yoffset.MAIN",			"0"			},
  { "menu.draw_xoffset.LEVELS",			"0"			},
  { "menu.draw_yoffset.LEVELS",			"0"			},
  { "menu.draw_xoffset.SCORES",			"0"			},
  { "menu.draw_yoffset.SCORES",			"0"			},
  { "menu.draw_xoffset.EDITOR",			"0"			},
  { "menu.draw_yoffset.EDITOR",			"0"			},
  { "menu.draw_xoffset.INFO",			"0"			},
  { "menu.draw_yoffset.INFO",			"0"			},
  { "menu.draw_xoffset.SETUP",			"0"			},
  { "menu.draw_yoffset.SETUP",			"0"			},

  { "menu.scrollbar_xoffset",			"0"			},

  { "menu.list_size",				"-1"			},
  { "menu.list_size.LEVELS",			"-1"			},
  { "menu.list_size.SCORES",			"-1"			},
  { "menu.list_size.INFO",			"-1"			},

  { "door_1.step_offset",			"2"			},
  { "door_1.step_delay",			"10"			},
  { "door_1.anim_mode",				"default"		},
  { "door_2.step_offset",			"2"			},
  { "door_2.step_delay",			"10"			},
  { "door_2.anim_mode",				"default"		},

  { "[player].boring_delay_fixed",		"-1"			},
  { "[player].boring_delay_random",		"-1"			},
  { "[player].sleeping_delay_fixed",		"-1"			},
  { "[player].sleeping_delay_random",		"-1"			},

  { NULL,					NULL			}
};
