/*
 * Miscellaneous macros
 */
#define MAX_FILE        240		/* max length file */
#define MAX_PATTERN     40		/* max length pattern */
#define LOG_FILE        "pattern"	/* default logfile for -s and -x options */
#define DEFAULT_TIMEOUT 9		/* default timeout */
#define DEFAULT_WAIT	0		/* default wait time */
#define IPRANGE_SIZE	35		/* 255-255.255-255.255-255.255-255 */

#define VERSION "0.9.9a"
#define TITLE   "Resolver v"VERSION"  by s23a <s23a@mail.ru>"


/* functions prototypes */
void	usage(void);
int     executing(char *, FILE *, int*);
char    *get_vars();
int 	error(int);


/* extern variables */
extern struct err_code err_code_list[8];
extern float resolv_count;


/* 
 * These includes set output format 
 */ 
#define SA	" |--[A][%d-%d]\n"		
#define SB	" |   |--[B]-<%d.%d-%d>\n"
#define SC	" |   |   |--[C]-<%d.%d.%d-%d>\n"
#define SD	"%s-- %d.%d.%d.%d == %s\n"
#define STREE	" |   |   |   |"

#define SFLAGS	((fflag||mflag)? fildes: stdout)
#define DESC	((fflag||mflag)? file: stdout)


/* 
 * Used for -e option.
 */
/* struct simbols buffers sizes */
#define FORMAT_SIZE     255
#define MAKE_SIZE       500
#define STRING_SIZE	MAKE_SIZE
#define HOSTNAME_SIZE	FORMAT_SIZE

/* macros for flags field */
#define FMT_DAEMON      0x0001

struct simbols {
	char format[FORMAT_SIZE];	/* comand line string */
	char make[MAKE_SIZE];		/* system() function argument */
	char string[MAKE_SIZE];		/* system() function argument */
	char hostname[255];		/* hostname */
	char ip[15];			/* ip address */
	int flags;			/* flags for get_vargs() function */
} vars;
