#include "mbus.h"
#include "util.h"
#include "config.h"
#include <tcl.h>
#include <tk.h>

#ifdef WIN32
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#undef WIN32_LEAN_AND_MEAN
#include <winsock.h>
#endif

#define UNUSED(x) (x=x)

char        *mbus_name = NULL;
struct mbus *mbus_base = NULL;
struct mbus *mbus_chan = NULL;
char		*mbus_ui_name = NULL;
struct mbus *mbus_ui_base = NULL;
struct mbus *mbus_ui_chan = NULL;
Tcl_Interp  *theInterp = NULL;

#ifdef WIN32
extern void		WishPanic _ANSI_ARGS_(TCL_VARARGS(char *,format));
#endif

void receive(char *srce, char *cmnd, char *args, void *data)
{
	char		command[1500];
	unsigned int	i;

	UNUSED(data);
	
	/* ignore powermeters */
	if ((strcmp ("audio.output.powermeter",cmnd)) || 
		(strcmp ("audio.input.powermeter",cmnd))) {

		sprintf(command, "mbus_recv %s %s", cmnd, args);
		for (i = 0; i < strlen(command); i++) {
			if (command[i] == '[') command[i] = '(';
			if (command[i] == ']') command[i] = ')';
		}
		if (Tcl_Eval(theInterp, command) != TCL_OK) {
			#ifdef WIN32
			WishPanic(theInterp->result);
			#else
			printf (theInterp->result);
			#endif
		}
	}
}

int _mbus_init(ClientData cd, Tcl_Interp *interp, int argc, char *argv[])
{
	int c;

	UNUSED(cd);

	if (argc != 3) {
		interp->result = "mbus::init <addr> <chan>";
		return TCL_ERROR;
	}

 	if (Tcl_GetInt(interp, argv[2], &c) != TCL_OK) {
		return TCL_ERROR;
	}
	mbus_name = strdup(argv[1]);

	mbus_base = mbus_init(0, receive, NULL); 
	mbus_addr(mbus_base, mbus_name);

	if (c==0) {
		mbus_chan=mbus_base;
	} else {
		mbus_chan = mbus_init((unsigned short)c, receive, NULL); 
		mbus_addr(mbus_chan, mbus_name);
	}
	return TCL_OK;
}

int _mbus_ui_init(ClientData cd, Tcl_Interp *interp, int argc, char *argv[])
{
	int c;

	UNUSED(cd);

	if (argc != 3) {
		interp->result = "mbus::init <addr> <chan>";
		return TCL_ERROR;
	}

 	if (Tcl_GetInt(interp, argv[2], &c) != TCL_OK) {
		return TCL_ERROR;
	}
	mbus_ui_name = strdup(argv[1]);

	mbus_ui_base = mbus_init(0, receive, NULL); 
	mbus_addr(mbus_ui_base, mbus_ui_name);

	if (c==0) {
		mbus_ui_chan=mbus_ui_base;
	} else {
		mbus_ui_chan = mbus_init((unsigned short)c, receive, NULL); 
		mbus_addr(mbus_ui_chan, mbus_ui_name);
	}
	return TCL_OK;
}

int _mbus_send(ClientData cd, Tcl_Interp *interp, int argc, char *argv[])
{
	UNUSED(cd);

	if (argc != 4) {
		interp->result = "mbus::send <reliable> <cmnd> <args>";
	        return TCL_ERROR;
	}
	mbus_qmsg(mbus_chan, mbus_ui_name, argv[2], argv[3], strcmp(argv[1], "R") == 0);
	return TCL_OK;
}


int _mbus_encode_str(ClientData cd, Tcl_Interp *interp, int argc, char *argv[])
{
	UNUSED(cd);
	if (argc != 2) {
                interp->result = "mbus::encode_str <str>";
                return TCL_ERROR;
        }
        interp->result = mbus_encode_str(argv[1]);
        return TCL_OK;
}

void mbus_check()
{
	int	rc;

	mbus_retransmit(mbus_base);
	mbus_retransmit(mbus_chan);

	do {
		/* send to mbus channel*/
		mbus_send(mbus_base);
		/* check to see if we have received anything from this mbus channel*/
		rc  = mbus_recv(mbus_base, NULL);
		mbus_send(mbus_chan);
		rc |= mbus_recv(mbus_chan, NULL);
	} while (rc);
}

int init_mbus(Tcl_Interp *interp)
{
	Tcl_CreateCommand(interp, "mbus_init",       _mbus_init,       NULL, NULL);
	Tcl_CreateCommand(interp, "mbus_ui_init",    _mbus_ui_init,    NULL, NULL);
	Tcl_CreateCommand(interp, "mbus_send",       _mbus_send,       NULL, NULL);
	Tcl_CreateCommand(interp, "mbus_encode_str", _mbus_encode_str, NULL, NULL);

	theInterp = interp;
	return TCL_OK;
}
