#include <stdio.h>
#include <netdb.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <arpa/nameser.h>
#include <resolv.h>
#include <errno.h>
extern int res_query();
extern int res_search();
extern int errno;
extern int h_errno;

#include "stralloc.h"
#include "str.h"
#include "fmt.h"
#include "ip.h"

static unsigned short getshort(c) unsigned char *c;
{ unsigned short u; u = c[0]; return (u << 8) + c[1]; }

static union { HEADER hdr; unsigned char buf[PACKETSZ]; } response;
static char name[MAXDNAME];

int txt(sa,ip,base)
stralloc *sa;
struct ip_address *ip;
char *base;
{
  int n;
  int i;
  char *x;
  int len;
  unsigned char *pos;
  unsigned char *end;

  if (!stralloc_ready(sa,100 + str_len(base))) return -1;
  x = sa->s;
  x += fmt_ulong(x,(unsigned long) ip->d[3]); *x++ = '.';
  x += fmt_ulong(x,(unsigned long) ip->d[2]); *x++ = '.';
  x += fmt_ulong(x,(unsigned long) ip->d[1]); *x++ = '.';
  x += fmt_ulong(x,(unsigned long) ip->d[0]); *x++ = '.';
  x += fmt_str(x,base);
  *x = 0;

  errno = 0;
  len = res_query(sa->s,C_IN,T_TXT,response.buf,sizeof response);
  if (len < sizeof(HEADER)) {
    if (errno == ECONNREFUSED) return -1;
    if (h_errno == TRY_AGAIN) return -1;
    return 0;
  }

  if (len >= sizeof response)
    len = sizeof response;
  end = response.buf + len;
  pos = response.buf + sizeof(HEADER);

  n = ntohs(response.hdr.qdcount);
  while (n-- > 0) {
    i = dn_expand(response.buf,end,pos,name,MAXDNAME);
    if (i < 0) return -1;
    pos += i;
    if (end - pos < QFIXEDSZ) return -1;
    pos += QFIXEDSZ;
  }

  n = ntohs(response.hdr.ancount);
  while (n-- > 0) {
    if (pos == end) return -1;

    i = dn_expand(response.buf,end,pos,name,MAXDNAME);
    if (i < 0) return -1;
    pos += i;

    if (end - pos < 11) return -1;
    if (getshort(pos) == T_TXT) {
      i = (unsigned long) pos[10];
      if (pos + 11 + i > end) return -1;
      if (!stralloc_copyb(sa,pos + 11,i)) return -1;
      return 1;
    }

    pos += 10 + getshort(pos + 8);
  }

  return 0;
}
