/* 
 * Copyright (c) 2001 Secure Software Solutions
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef PERL_TOKENS_H
#define PERL_TOKENS_H

/*
 * Tokens that are specific to the Python language
 */

#define ID_SCALAR             (TOKEN_PERL_START +  0)
#define ID_ARRAY              (TOKEN_PERL_START +  1)
#define ID_HASHT              (TOKEN_PERL_START +  2)
#define ID_HANDLE             IDENTIFIER
#define REPEAT_ASSIGN	      (TOKEN_PERL_START +  3)
#define CONCAT_ASSIGN	      (TOKEN_PERL_START +  4)
#define BACKTICK_LITERAL      (TOKEN_PERL_START +  5)
#define QQSTRING_LITERAL      (TOKEN_PERL_START +  6)
#define QSTRING_LITERAL	      (TOKEN_PERL_START +  7)
#define TOKEN_NULL	      (TOKEN_PERL_START +  8)
#define TOKEN_DATA	      (TOKEN_PERL_START +  9)
#define TOKEN_FILE	      (TOKEN_PERL_START + 10)
#define TOKEN_LINE	      (TOKEN_PERL_START + 11)
#define TOKEN_PACKAGE	      (TOKEN_PERL_START + 12)
#define REGEXP		      (TOKEN_PERL_START + 13)
#define PERLPOD               (TOKEN_PERL_START + 14)

/*
#define ABS		      IDENTIFIER
#define ACCEPT                IDENTIFIER
#define ALARM		      IDENTIFIER
#define ATAN2		      IDENTIFIER
#define BIND		      IDENTIFIER
#define BINMODE		      IDENTIFIER
#define BLESS		      IDENTIFIER
#define CALLER		      IDENTIFIER
#define CHDIR		      IDENTIFIER
#define CHMOD		      IDENTIFIER
#define CHOMP                 IDENTIFIER
#define CHOP	              IDENTIFIER
#define CHOWN	              IDENTIFIER
#define CHR	              IDENTIFIER
#define CHROOT	              IDENTIFIER
#define CLOSE	              IDENTIFIER
#define CLOSEDIR              IDENTIFIER
#define CMP	              IDENTIFIER
#define CONNECT	              IDENTIFIER
#define COS	              IDENTIFIER
#define CRYPT	              IDENTIFIER
#define DBMCLOSE              IDENTIFIER
#define DBMOPEN               IDENTIFIER
#define DEFINED               IDENTIFIER
#define DELETE                IDENTIFIER
#define DIE                   IDENTIFIER
#define DUMP                  IDENTIFIER
#define EACH                  IDENTIFIER
#define ELSIF                 IDENTIFIER
#define ENDGRENT              IDENTIFIER
#define ENDHOSTENT		IDENTIFIER
#define ENDNETENT		IDENTIFIER
#define ENDPROTOENT		IDENTIFIER
#define ENDPWENT		IDENTIFIER
#define ENDSERVENT		IDENTIFIER
#define EQ		IDENTIFIER
#define EVAL		IDENTIFIER
#define EXISTS		IDENTIFIER
#define EXIT		IDENTIFIER
#define EXP		IDENTIFIER
#define FCNTL		IDENTIFIER
#define FILENO		IDENTIFIER
#define FLOCK		IDENTIFIER
#define FOREACH		IDENTIFIER
#define FORK		IDENTIFIER
#define FORMAT		IDENTIFIER
#define FORMLINE		IDENTIFIER
#define GE		IDENTIFIER
#define GETC		IDENTIFIER
#define GETGRENT		IDENTIFIER
#define GETGRGID		IDENTIFIER
#define GETGRNAM		IDENTIFIER
#define GETHOSTBYADDR		IDENTIFIER
#define GETHOSTBYNAME		IDENTIFIER
#define GETHOSTENT		IDENTIFIER
#define GETLOGIN		IDENTIFIER
#define GETNETBYADDR		IDENTIFIER
#define GETNETBYNAME		IDENTIFIER
#define GETNETENT		IDENTIFIER
#define GETPEERNAME		IDENTIFIER
#define GETPGRP		IDENTIFIER
#define GETPPID		IDENTIFIER
#define GETPRIORITY		IDENTIFIER
#define GETPROTOBYNAME		IDENTIFIER
#define GETPROTOBYNUMBER		IDENTIFIER
#define GETPROTOENT		IDENTIFIER
#define GETPWENT		IDENTIFIER
#define GETPWNAM		IDENTIFIER
#define GETPWUID		IDENTIFIER
#define GETSERVBYNAME		IDENTIFIER
#define GETSERVBYPORT		IDENTIFIER
#define GETSERVENT		IDENTIFIER
#define GETSOCKNAME		IDENTIFIER
#define GETSOCKOPT		IDENTIFIER
#define GLOB		IDENTIFIER
#define GMTIME		IDENTIFIER
#define GREP		IDENTIFIER
#define GT		IDENTIFIER
#define HEX		IDENTIFIER
#define INDEX		IDENTIFIER
#define IOCTL		IDENTIFIER
#define JOIN		IDENTIFIER
#define KEYS		IDENTIFIER
#define KILL		IDENTIFIER
#define LAST		IDENTIFIER
#define LC		IDENTIFIER
#define LCFIRST		IDENTIFIER
#define LE		IDENTIFIER
#define LENGTH		IDENTIFIER
#define LINK		IDENTIFIER
#define LISTEN		IDENTIFIER
#define LOCAL		IDENTIFIER
#define LOCALTIME		IDENTIFIER
#define LOCK		IDENTIFIER
#define LOG		IDENTIFIER
#define LSTAT		IDENTIFIER
#define LT		IDENTIFIER
#define MAP		IDENTIFIER
#define MKDIR		IDENTIFIER
#define MSGCTL		IDENTIFIER
#define MSGGET		IDENTIFIER
#define MSGRCV		IDENTIFIER
#define MSGSND		IDENTIFIER
#define MY		IDENTIFIER
#define NE		IDENTIFIER
#define NEXT		IDENTIFIER
#define NO		IDENTIFIER
#define OCT		IDENTIFIER
#define OPEN		IDENTIFIER
#define OPENDIR		IDENTIFIER
#define ORD		IDENTIFIER
#define OUR		IDENTIFIER
#define PACK		IDENTIFIER
#define PACKAGE		IDENTIFIER
#define PIPE		IDENTIFIER
#define POP		IDENTIFIER
#define POS		IDENTIFIER
#define PRINTF		IDENTIFIER
#define PROTOTYPE		IDENTIFIER
#define PUSH		IDENTIFIER
#define QQ		IDENTIFIER
#define QR		IDENTIFIER
#define QUOTEMETA		IDENTIFIER
#define QW		IDENTIFIER
#define QX		IDENTIFIER
#define RAND		IDENTIFIER
#define READ		IDENTIFIER
#define READDIR		IDENTIFIER
#define READLINE		IDENTIFIER
#define READLINK		IDENTIFIER
#define READPIPE		IDENTIFIER
#define RECV		IDENTIFIER
#define REDO		IDENTIFIER
#define REF		IDENTIFIER
#define RENAME		IDENTIFIER
#define REQUIRE		IDENTIFIER
#define RESET		IDENTIFIER
#define REVERSE		IDENTIFIER
#define REWINDDIR		IDENTIFIER
#define RINDEX		IDENTIFIER
#define RMDIR		IDENTIFIER
#define SCALAR		IDENTIFIER
#define SEEK		IDENTIFIER
#define SEEKDIR		IDENTIFIER
#define SELECT		IDENTIFIER
#define SEMCTL		IDENTIFIER
#define SEMGET		IDENTIFIER
#define SEMOP		IDENTIFIER
#define SEND		IDENTIFIER
#define SETGRENT		IDENTIFIER
#define SETHOSTENT		IDENTIFIER
#define SETNETENT		IDENTIFIER
#define SETPGRP		IDENTIFIER
#define SETPRIORITY		IDENTIFIER
#define SETPROTOENT		IDENTIFIER
#define SETPWENT		IDENTIFIER
#define SETSERVENT		IDENTIFIER
#define SETSOCKOPT		IDENTIFIER
#define SHIFT		IDENTIFIER
#define SHMCTL		IDENTIFIER
#define SHMGET		IDENTIFIER
#define SHMREAD		IDENTIFIER
#define SHMWRITE		IDENTIFIER
#define SHUTDOWN		IDENTIFIER
#define SIN		IDENTIFIER
#define SLEEP		IDENTIFIER
#define SOCKET		IDENTIFIER
#define SOCKETPAIR		IDENTIFIER
#define SORT		IDENTIFIER
#define SPLICE		IDENTIFIER
#define SPLIT		IDENTIFIER
#define SPRINTF		IDENTIFIER
#define SQRT		IDENTIFIER
#define SRAND		IDENTIFIER
#define STAT		IDENTIFIER
#define STUDY		IDENTIFIER
#define SUB		IDENTIFIER
#define SUBSTR		IDENTIFIER
#define SYMLINK		IDENTIFIER
#define SYSCALL		IDENTIFIER
#define SYSOPEN		IDENTIFIER
#define SYSREAD		IDENTIFIER
#define SYSSEEK		IDENTIFIER
#define SYSTEM		IDENTIFIER
#define SYSWRITE		IDENTIFIER
#define TELL		IDENTIFIER
#define TELLDIR		IDENTIFIER
#define TIE		IDENTIFIER
#define TIED		IDENTIFIER
#define TIME		IDENTIFIER
#define TIMES		IDENTIFIER
#define TR		IDENTIFIER
#define TRUNCATE		IDENTIFIER
#define UC		IDENTIFIER
#define UCFIRST		IDENTIFIER
#define UMASK		IDENTIFIER
#define UNDEF		IDENTIFIER
#define UNLESS		IDENTIFIER
#define UNLINK		IDENTIFIER
#define UNPACK		IDENTIFIER
#define UNSHIFT		IDENTIFIER
#define UNTIE		IDENTIFIER
#define UNTIL		IDENTIFIER
#define USE		IDENTIFIER
#define UTIME		IDENTIFIER
#define VALUES		IDENTIFIER
#define VEC		IDENTIFIER
#define WAIT		IDENTIFIER
#define WAITPID		IDENTIFIER
#define WANTARRAY		IDENTIFIER
#define WARN		IDENTIFIER
#define WRITE		IDENTIFIER
#define XOR		IDENTIFIER
*/

#endif /*PERL_TOKENS_H*/
