/* 
 * Copyright (c) 2001 Secure Software Solutions
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef REPORT_H
#define REPORT_H

#include "vuln_db.h"
#include "engine.h"

typedef enum _type_t type_t;
enum _type_t
{
    BOProblem,
    FSProblem,
    InputProblem,
    Info,
    RaceConditionCheck,
    RaceConditionUse,
    StaticLocalBuffer,
    StaticGlobalBuffer,
    Reference,
    None
};

typedef struct _toctou_use_t toctou_use_t;
struct _toctou_use_t
{
    char *  name;
    int     lineno;
};

typedef struct _vulnerability_t vulnerability_t;
struct _vulnerability_t
{
    char *              filename;
    int                 lineno;
    Vuln_t *            data;
    type_t              type;
    Severity_t          severity;
    toctou_use_t *      uses;
    vulnerability_t *   next;
    vulnerability_t *   prev;
};

typedef struct _input_t input_t;
struct _input_t
{
    char *      filename;
    int         lineno;
    Vuln_t *    data;
    input_t *   next;
};

extern int warning_level;

extern void log_staticbuffer(type_t type, int, Severity_t);
extern void log_toctou(toctou_t **, int, int, int);
extern void log_vulnerability(type_t, Severity_t);
extern void record_input(void);
extern void generate_report(void);

#endif
