/* 
 * Copyright (c) 2001 Secure Software Solutions
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef C_TOKENS_H
#define C_TOKENS_H

#define AUTO 256
#define BREAK 257
#define CASE 258
#define CHAR 259
#define CONST 260
#define CONTINUE 261
#define DEFAULT 262
#define DO 263
#define DOUBLE 264
#define ELSE 265
#define ENUM 266
#define EXTERN 267
#define FLOAT 268
#define FOR 269
#define GOTO 270
#define IF 271
#define INT 272
#define LONG 273
#define REGISTER 274
#define RETURN 275
#define SHORT 276
#define SIGNED 277
#define SIZEOF 278
#define STATIC 279
#define STRUCT 280
#define SWITCH 281
#define TYPEDEF 282
#define UNION 283
#define UNSIGNED 284
#define VOID 285
#define VOLATILE 286
#define WHILE 287

#define IDENTIFIER 288
#define HEX_CONST 289
#define OCT_CONST 290
#define DEC_CONST 291
#define FLOAT_CONST 292
#define CHAR_CONST 293
#define STRING_CONST 294

#define RIGHT_ASSIGN 295
#define LEFT_ASSIGN 296
#define ADD_ASSIGN 297
#define SUB_ASSIGN 298
#define MUL_ASSIGN 299
#define DIV_ASSIGN 300
#define MOD_ASSIGN 301
#define AND_ASSIGN 302
#define XOR_ASSIGN 303
#define OR_ASSIGN 304
#define RIGHT_OP 305
#define LEFT_OP 306
#define DEC_OP 307
#define INC_OP 308
#define PTR_OP 309
#define AND_OP 310
#define OR_OP 311
#define LE_OP 312
#define GE_OP 313
#define EQ_OP 314
#define NE_OP 315

extern int lex_lineno;
extern FILE * yyin;
extern char * yytext;
extern int yyleng;

int yylex();

#endif /*C_TOKENS_H*/
