/*
 * agc.c - Automatic Gain Control
 * 
 * $Revision: 1.1.1.1 $
 * $Date: 1998/08/15 19:16:48 $
 * 
 * Copyright (c) 1997 University College London
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, is permitted, for non-commercial use only, provided
 * that the following conditions are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Computer Science
 *      Department at University College London
 * 4. Neither the name of the University nor of the Department may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 * Use of this software for commercial purposes is explicitly forbidden
 * unless prior written permission is obtained from the authors.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHORS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <assert.h>
#include <stdio.h>
#include "agc.h"

#define ENERGY_MAX 32

static int agc_table[ENERGY_MAX];
static int agc_count;
static int agc_window;

void agc_table_init(void)
{
	int i;
	for (i=0; i<ENERGY_MAX; i++) {
		agc_table[i] = 0;
	}
	agc_count = 0;
	agc_window= 25;
}

void agc_table_update(int energy)
{
	int i, hi, lo;

	assert((energy>=0) && ((energy/4)<ENERGY_MAX));
	agc_table[energy/4]++;
	agc_count++;
	if (agc_count > agc_window) {
		/* Find lower peak... */
		lo = 0;
		for (i=1; i<ENERGY_MAX; i++) {
			if (agc_table[i] < agc_table[i-1]) {
				lo = i-1;
				break;
			}
		}
		/* Find upper peak... */
		hi = lo;
		for (i=ENERGY_MAX-2; i>lo; i--) {
			if (agc_table[i] < agc_table[i+1]) {
				hi = i+1;
				break;
			}
		}
#ifdef NDEF
		printf("AGC: lo=%d hi=%d window=%d\n", lo, hi, agc_window);
#endif
		/* Clear the table... */
		for (i=0; i<ENERGY_MAX; i++) {
			agc_table[i] = 0;
		}
		agc_count = 0;
		agc_window += 25;
		if (agc_window>200) {
			agc_window = 200;
		}
	}
}

