#include "config.h"

/* This function lowercases the passed in string. */
void lc(char *s);

/* This function behaves like malloc() only it checks to ensure that the memory
   was actually allocated.  If the allocation fails, it prints a message to
   stderr and exits. */
void *mymalloc(int size);

/* This function behaves like strdup() only it checks to ensure that the memory
   was actually allocated.  If the allocation fails, it prints a message to
   stderr and exits. */
char *mystrdup(const char *s);

/* This function returns a pointer to a statically allocated block of memory
   that contains the string representation of the given integer */
char *strnum(int num);

/* This function allocates new space for orig+increment and then returns
   the pointer to that space with the data copied over. */
char *strmem(char *orig, int increment);

/* This function returns true if the passed in string is a channel name */
extern int ischannel(char *string);

/* This function replaces the last character of the string with a
   0, effectively shortening the string's length by one. */
extern char *chop(char *);

#ifndef HAVE_HTONS
/* This function switches around the two bytes in the integer */
extern unsigned short htons(unsigned short n);
#endif

#ifndef HAVE_STRCMPI
/* This function does the same thing has strcmp, only in a case
   insensitive manner. */
extern int strcmpi(char *,char *);
#endif

/* This function does the same thing as strncmp, only in a case
   insensitive manner. */
int strncmpi(char *s, char *t, int n);

/* This function takes an argument (seperated by spaces) from the
   first string and places it in the second, deleting it from the
   first. */
//void getarg(char *, char *);

/* Parses the given text into prefix, command, and further parameters */
extern void parse(char *, char **, char **, char **, int *);

