#ifndef HEADER_SERVERDCC
#define HEADER_SERVERDCC

#include <errno.h>
#include <strings.h>

//#include <map>

#include "config.h"

#include <string>
#ifdef USING_STD_STRING
using std::string;
#endif

#ifdef DMALLOC
#include <dmalloc.h>
#endif

#include "defines.h"
#include "support.h"
#include "llist.h"
#include "nick.h"
#include "channel.h"
#include "query.h"
#include "illist.h"
#include "hash.h"
#include "network.h"

enum {
  DCC_OVERWRITE = 1<<0
};

class thide {
public:
  int n315;
  int n352;
  int n353;
  int n366;
  thide() {
    n315=0;
    n352=0;
    n353=0;
    n366=0;
  }
};

class tacceptitem {
 private:
  char *nick;
 public:
  int type;
  int port;
  char ip[IPLEN];
  int id;
  int size;
  char file[TEMPLEN];

  int operator>=(tacceptitem &acceptitem) {
    return(id==acceptitem.id);
  }
  int operator==(tacceptitem &acceptitem) {
    return(id==acceptitem.id);
  }

  const char *getnick(void) {
    return nick;
  }

  void setnick(const char *n) {
    free(nick);
    nick = mystrdup(n);
  }

  tacceptitem(tacceptitem &t) {
    nick = mystrdup(t.nick);
    type = t.type;
    port = t.port;
    memcpy(ip, t.ip, IPLEN);
    id = t.id;
    size = t.size;
    memcpy(file, t.file, TEMPLEN);
  }

  tacceptitem() {
    nick = mystrdup("");
  }
  
  ~tacceptitem() {
    free(nick);
  }
};

class tdcc : public handleable {
 private:
    char *nick;
  public:
    int port;
    int connected;
    int connecting;
    int listening;
    char ip[IPLEN];
    class tserver* server;
    char buffer[BUFLEN];
    char pathname[20];
    int errortest;
    char file[TEMPLEN]; 
    char destfile[TEMPLEN];
    int index;
    int entryindex;
    int flags;
    int checkflags;
    int sockfd;
    int filefd;
    int type;
    int lastchunk;
    long size;
    int transmitted;
    int written;
    int acknowledged;
    long long timestarted;
    long dccseconds;
    long dccmilliseconds;
    tdcc(class tserver *serverp, char *thenick);
    tdcc(class tserver *serverp, char *thenick, char *thefile);
    tdcc(class tserver *serverp, const char *thenick, char *theip, int theport);
    tdcc(class tserver *serverp, const char *thenick, char *theip, int theport, char *thefile, int thesize, int dccflags, char *renamedfile);
    int operator>=(tdcc &dcc) {
      if(strlen(dcc.nick)) return 0; else return 0;
    }
    int operator==(tdcc &dcc) {
      return(!strcasecmp(nick,dcc.nick)||!strcmp(pathname,dcc.pathname));
    }

    const char *getnick(void) {
      return nick;
    }

    void setnick(const char *n) {
      free(nick);
      nick = mystrdup(n);
    }

    void handle(int mask);
    int getflags();
    int getsockfd();
    void sendchunk();
    int handle_incoming();
    void usedata();
    void handle_outgoing();
    void complete_connect(void);
    int senddata(char *);
    int disconnect(void);
    void do_accept(void);
    void perror(char *message);
    void perror(char *message, int number);
    void filemessage(char *message);
    ~tdcc();
};

class tdccentry {
 public:
  int index;
  tdcc *dcc;
  int operator>=(tdccentry &entryitem) {
    return (index-entryitem.index);
  }
  int operator==(tdccentry &entryitem) {
    return(index==entryitem.index||dcc==entryitem.dcc);
  }
  tdccentry() {
    index=-1;
    dcc=0;
  }
};

class tpair {
 public:
  string name;
  string value;
  int operator>=(const tpair &pair) {
    return 0;
  }
  int operator==(const tpair &pair) {
    return (name==pair.name);
  }
};

class tfullpair {
 public:
  string name;
  string value;
  int operator>=(const tfullpair &fullpair) {
    return 0;
  }
  int operator==(const tfullpair &fullpair) {
    return (name==fullpair.name && value==fullpair.value);
  }
};

class tuserlist {
 public:
  string type;
  string info;
  list<tpair> flags;
  int index;
  int operator>=(const tuserlist &userlist) {
    return (index>=userlist.index);
  }
  int operator==(const tuserlist &userlist) {
    return (type==userlist.type && info==userlist.info);
  }
};

class tuserlistalias {
 public:
  string name;
  list<tfullpair> typeinfos;
  int operator>=(const tuserlistalias &userlistalias) {
    return 0;
  }
  int operator==(const tuserlistalias &userlistalias) {
    return(name==userlistalias.name);
  }
};

class tserver : public handleable {
  private:
    char temp[TEMPLEN];
    char *mynick;
  public:
    hash ial;
    //map<string,string> ial;
    char *name;
    char *desc;
    thide hide;
    int port;
    char ip[IPLEN];
    char localip[IPLEN];
    char buffer[BUFLEN];
    int flags;
    int sockfd;
    int connected;
    int connecting;
    char pathname[20];
    string pass;
    int index;
    list<tchan> chanlist;
    list<tquery> querylist;
    list<tglobalnick> nicklist;
    list<tacceptitem> acceptlist;
    list<tuserlistalias> aliaslist;
    ilist<tuserlist> userlist;
    int userlist_nocase;
    ilist<tdccentry> dcclist;

    int script(char *name, char *format, ...);
    void ial_prefix(char *);
    void ial_add(char *, char *);
    void perror(char *);
    void perror(char *message, int number);
    void createchannel(char *);
    void createquery(char *);
    tserver(char *address, int theport, char *password);
    void server(char *address, int theport, char *password);
    ~tserver();
    void usedata();

    tserver() {}

    // Network Handling
    void handle(int mask);
    void handle_connect(void);
    int getflags();
    int getsockfd();

    // Network Functions
    int senddata(char *);
    int do_connect(void);
    int disconnect(int);

    // Dynamic nick management
    const char *getmynick(void) {
      return mynick;
    }

    void setmynick(const char *n) {
      free(mynick);
      mynick = mystrdup(n);
    }

};

#endif
