#include <string.h>
#include <strings.h>
#include <ctype.h>
#include <stdlib.h>
#include <stdio.h>

#ifdef DMALLOC
#include <dmalloc.h>
#endif

#include "config.h"
#include "support.h"
#include "messages.h"

char *strnum(int num) {
  static char thenum[100];
  sprintf(thenum,"%d",num);
  return thenum;
}

char *strmem(char *orig, int increment) {
  void *temp;
  if(orig) {
    if(!(temp=(char *)malloc(strlen(orig)+increment+1))) {
      fprintf(stderr,M_OUT_OF_MEMORY);
      exit(1);
    }
    strcpy((char *)temp,orig);
  } else {
    if(!(temp=(char *)malloc(increment+1))) {
      bzero(temp,increment);
      fprintf(stderr,M_OUT_OF_MEMORY);
      exit(1);
    }
  }
  return (char *)temp;
}

extern int ischannel(char *string) {
  if((string[0]=='#')||(string[0]=='&')||(string[0]=='+')) return 1;
  return 0;
}

extern char *chop(char *string) {
  string[strlen(string)-1]=0;
  return string;
}

#ifndef HAVE_HTONS
unsigned short htons(unsigned short n) {
  return (n%256)*256+n/256;
}
#endif

#ifndef HAVE_STRCASECMP
int strcasecmp(char *s, char *t) {
  int i;
  for(i=0;tolower(s[i])==tolower(t[i]);i++) if (s[i]==0) return 0;
  return (tolower(s[i])-tolower(t[i]));
}
#endif

#ifndef HAVE_STRNCASECMP
int strncasecmp(char *s, char *t, int n) {
  int i;
  if(!n) return 0;
  for(i=0;tolower(s[i])==tolower(t[i]);i++)
    if ((s[i]==0)||(i==n-1)) return 0;
  return (tolower(s[i])-tolower(t[i]));
}
#endif

/*
extern void getarg(char *string, char *arg) {
  if(strstr(string," ")) {
    strncpy(arg,string,strstr(string," ")-string);
    strcpy(string,strstr(string," ")+1);
    while(string[0]==' ') strcpy(string,string+1);
  } else {
    strcpy(arg,string);
    string[0]=0;
  }
}
*/

extern void parse(char *string, char **prefix, char **command, char **params, int *numparam) {
  char *position;
  *numparam=0;
  if(string[0]==':') {
    *prefix=string+1;
    if((position=strstr(string," "))) {
      *position=0;
      string=position+1;
    } else {
      return;
    }
  }
  if(*string!=0) {
    while(*string==' ') string++;
    if(string[0]==':') {
      *command=string+1;
      return;
    } else {
      *command=string;
      if((position=strstr(string," "))) {
	*position=0;
	string=position+1;
      } else {
	return;
      }
    }
  }
  while(*string!=0) {
    while(*string==' ') string++;
    if(string[0]==':') {
      params[(*numparam)++]=string+1;
      return;
    } else {
      params[(*numparam)++]=string;
      if((position=strstr(string," "))) {
	*position=0;
	string=position+1;
      } else {
	return;
      }
    }
  }
}
