#include <string.h>

#ifdef DMALLOC
#include <dmalloc.h>
#endif

#include "channel.h"
#include "tcltk.h"
#include "messages.h"

void tchan::setmode(char mode, int modetype) {
  if((mode>='a')&&(mode<='z')) modes[mode-97]=modetype;
  if((mode>='A')&&(mode<='Z')) modes[mode-65+26]=modetype;
}

int tchan::getmode(char mode) {
  if((mode>='a')&&(mode<='z')) return modes[mode-97];
  if((mode>='A')&&(mode<='Z')) return modes[mode-65+26];
  return 0;
}

void tchan::clearmodes(void) {
  for(int n=0;n<52;n++) {
    modes[n]=0;
  }
  keyword[0]=0;
  limit=0;
}

int tchan::clearnicklist() {
  nicklist.clear();
  TT_EvalF(TT_ARGS,"%s.nicks delete 0 end",pathname);
  return 0;
}

int tchan::addnicks(char *nicks) {
  tnick *nickp;
  char *position;
  position=strtok(nicks," ");
  while(position) {
    if(!(nickp=new tnick(position))) {
      fprintf(stderr,M_OUT_OF_MEMORY);
      exit(1);
    }
    nicklist.insert_ascending(*nickp);
    delete nickp;
    position=strtok(NULL," ");
  }
  return 0;
}

int tchan::deop(char *nickname) {
  tnick nick(nickname);
  tnick *nickp;
  tnick *newnickp;
  int n;
  if((nickp=nicklist.find(nick))) {
    if(nickp->oped) {
      newnickp=new tnick(*nickp);
      newnickp->oped=0;
      if(newnickp->voiced) {
        newnickp->entry[0]='+';
      } else {
        strcpy(newnickp->entry,newnickp->entry+1);
      }
      n=nicklist.deleteitem(nick);
      TT_EvalF(TT_ARGS,"%s.nicks delete %d",pathname,n);
      n=nicklist.insert_ascending(*newnickp);
      TT_EvalF(TT_ARGS,"%s.nicks insert %d %q",pathname,n,newnickp->entry);
      delete newnickp;
    }
  }
  return 0;
}

int tchan::op(char *nickname) {
  tnick nick(nickname);
  tnick *nickp;
  tnick *newnickp;
  int n;
  if((nickp=nicklist.find(nick))) {
    if(!nickp->oped) {
      newnickp=new tnick(*nickp);
      newnickp->oped=1;
      if(newnickp->voiced) {
        newnickp->entry[0]='@';
      } else {
	sprintf(newnickp->entry,"@%s",newnickp->name);
      }
      n=nicklist.deleteitem(nick);
      TT_EvalF(TT_ARGS,"%s.nicks delete %d",pathname,n);
      n=nicklist.insert_ascending(*newnickp);
      TT_EvalF(TT_ARGS,"%s.nicks insert %d %q",pathname,n,newnickp->entry);
      delete newnickp;
    }
  }
  return 0;
}

int tchan::devoice(char *nickname) {
  tnick nick(nickname);
  tnick *nickp;
  tnick *newnickp;
  int n;
  if((nickp=nicklist.find(nick))) {
    if(nickp->voiced) {
      nickp->voiced=0;
      if(!nickp->oped) {
	newnickp=new tnick(*nickp);
	strcpy(newnickp->entry,newnickp->entry+1);
	n=nicklist.deleteitem(nick);
	TT_EvalF(TT_ARGS,"%s.nicks delete %d",pathname,n);
	n=nicklist.insert_ascending(*newnickp);
	TT_EvalF(TT_ARGS,"%s.nicks insert %d %q",pathname,n,newnickp->entry);
	delete newnickp;
      }
    }
  }
  return 0;
}

int tchan::voice(char *nickname) {
  tnick nick(nickname);
  tnick *nickp;
  tnick *newnickp;
  int n;
  if((nickp=nicklist.find(nick))) {
    if(!nickp->voiced) {
      nickp->voiced=1;
      if(!nickp->oped) {
	newnickp=new tnick(*nickp);
	sprintf(newnickp->entry,"+%s",newnickp->name);
	n=nicklist.deleteitem(nick);
	TT_EvalF(TT_ARGS,"%s.nicks delete %d",pathname,n);
	n=nicklist.insert_ascending(*newnickp);
	TT_EvalF(TT_ARGS,"%s.nicks insert %d %q",pathname,n,newnickp->entry);
	delete newnickp;
      }
    }
  }
  return 0;
}

int tchan::addnick(char *nickname) {
  tnick nick(nickname);
  int n;
  n=nicklist.insert_ascending(nick);
  TT_EvalF(TT_ARGS,"%s.nicks insert %d %q",pathname,n,nickname);
  return 0;
}

int tchan::changenick(char *nickname, char *newnickname) {
  tnick nick(nickname);
  tnick newnick;
  tnick *nickp;
  int n;
  nickp=nicklist.find(nick);
  newnick.oped=nickp->oped;
  newnick.voiced=nickp->voiced;
  newnick.time=nickp->time;
  newnick.global=nickp->global;
  strcpy(newnick.name,newnickname);
  if(newnick.oped||newnick.voiced) {
    sprintf(newnick.entry,"%c%s",nickp->entry[0],newnickname);
  } else {
    strcpy(newnick.entry,newnickname);
  }
  n=nicklist.deleteitem(nick);
  TT_EvalF(TT_ARGS,"%s.nicks delete %d",pathname,n);
  n=nicklist.insert_ascending(newnick);
  TT_EvalF(TT_ARGS,"%s.nicks insert %d %q",pathname,n,newnick.entry);
  return 0;
}

int tchan::delnick(char *nickname) {
  int n;
  tnick nick(nickname);
  n=nicklist.deleteitem(nick);
  TT_EvalF(TT_ARGS,"%s.nicks delete %d",pathname,n);
  return 0;
}

int tchan::updatenicklist() {
  tnick *nickp;
  TT_EvalF(TT_ARGS,"%s.nicks delete 0 end",pathname);
  nicklist.init_trav();
  while((nickp=nicklist.trav())) {
    TT_EvalF(TT_ARGS,"%s.nicks insert end %q",pathname,nickp->entry);
  }
  return 0;
}

int tchan::operator==(tchan &chan) {
  return((strcasecmp(name,chan.name)==0)||(strcasecmp(pathname,chan.pathname)==0));
}

int tchan::operator>=(tchan &chan) {
  return(strcasecmp(name,chan.name)>=0);
}

tchan::tchan(char *something) {
  int n;
  ison=0;
  numops=0;
  numvoice=0;
  numother=0;
  limit=0;
  topic=0;
  keyword[0]=0;
  for(n=0;n<52;n++) {
    modes[n]=0;
  }
  strcpy(name,something);
}

tchan::tchan() {
  int n;
  ison=0;
  numops=0;
  numvoice=0;
  numother=0;
  limit=0;
  keyword[0]=0;
  topic=0;
  for(n=0;n<52;n++) {
    modes[n]=0;
  }
}

tchan::~tchan() {
  if(topic) free(topic);
}
