#include "basewidget.h"
#include "config.h"
#include <QTextEdit>
#include <QLineEdit>
#include <QProcess>
#include <QTime>
#include <QTimer>
#include <QCheckBox>

/**
 * If you write a command in Terminal's command line, DynamicHelp shows help of commands.
 */
class Dynamic_help :public BaseWidget
{
	Q_OBJECT
	public:
	Dynamic_help(QWidget *parent=0);
	~Dynamic_help();
	/** Sets QLineEdit from keyboard signals are listen.
	 */
	void setLineEdit(QLineEdit *lineedit);
	private:
	QTextEdit *textEdit;
	QCheckBox *stop_help;
	QProcess *octave;
	QTime time;
	QTimer timer;
	QString input_text;
	public slots:
	/**
	* Shows help when of text.
	 * @param text Text from QLineEdit.
	*/
	void textChanged ( const QString & text );
	/** Reads and shows Octave output.
	 */
	void readyReadStandardOutput ();
	/** Updates shown help when QLineEdit changes happend.
	 */
	void update();
};

