#ifndef lint
static char yysccsid[] = "@(#)yaccpar	1.9 (Berkeley) 02/21/93";
#endif
#define YYBYACC 1
#define YYMAJOR 1
#define YYMINOR 9
#define yyclearin (yychar=(-1))
#define yyerrok (yyerrflag=0)
#define YYRECOVERING (yyerrflag!=0)
#define YYPREFIX "yy"
#line 55 "moc.y"
#define MOC_YACC_CODE
void yyerror( const char *msg );

#include "qasciidict.h"
#include "qdatetime.h"
#include "qdict.h"
#include "qfile.h"
#include "qptrlist.h"
#include "qregexp.h"
#include "qstrlist.h"
#ifdef MOC_MWERKS_PLUGIN
# ifdef Q_OS_MACX
#  undef OLD_DEBUG
#  ifdef DEBUG
#   define OLD_DEBUG DEBUG
#   undef DEBUG
#  endif
#  define DEBUG 0
#  ifndef __IMAGECAPTURE__
#   define __IMAGECAPTURE__
#  endif
#  include <Carbon/Carbon.h>
# endif
# include "mwerks_mac.h"
#endif 

#include <ctype.h>
#include <limits.h>
#include <qplatformdefs.h>
#include <stdio.h>
#include <stdlib.h>

#if defined CONST
#undef CONST
#endif
#if defined VOID
#undef VOID
#endif

bool isEnumType( const char* type );
int enumIndex( const char* type );

static const char* const utype_map[] =
{
    "bool",
    "int",
    "double",
    "QString",
    "QVariant",
    0
};

bool validUType( QCString ctype )
{
     if ( ctype.left(6) == "const " )
	ctype = ctype.mid( 6, ctype.length() - 6 );
    if ( ctype.right(1) == "&" )
	ctype = ctype.left( ctype.length() - 1 );
    else if ( ctype.right(1) == "*" )
	return TRUE;

    int i = -1;
    while ( utype_map[++i] )
	if ( ctype == utype_map[i] )
	    return TRUE;

    return isEnumType( ctype );
}

QCString referencePlainUType( QCString ctype )
{
     if ( ctype.left(6) == "const " )
	ctype = ctype.mid( 6, ctype.length() - 6 );
     if ( ctype.right(1) == "&" )
	 ctype = ctype.left( ctype.length() - 1 );
     return ctype;
}


QCString uType( QCString ctype )
{
    if ( !validUType( ctype ) )
	return "ptr";
    if ( ctype.left(6) == "const " )
	ctype = ctype.mid( 6, ctype.length() - 6 );
    if ( ctype.right(1) == "&" ) {
	ctype = ctype.left( ctype.length() - 1 );
    } else if ( ctype.right(1) == "*" ) {
	QCString raw = ctype.left( ctype.length() - 1 );
	ctype = "ptr";
	if ( raw == "char" )
	    ctype = "charstar";
	else if ( raw == "QUnknownInterface" )
	    ctype = "iface";
	else if ( raw == "QDispatchInterface" )
	    ctype = "idisp";
    }
    if ( isEnumType( ctype ) )
	ctype = "enum";
    return ctype;
}

bool isInOut( QCString ctype )
{
    if ( ctype.left(6) == "const " )
	return FALSE;
    if ( ctype.right(1) == "&" )
	return TRUE;
    return FALSE;
}

QCString uTypeExtra( QCString ctype )
{
    QCString typeExtra = "0";
    if ( !validUType( ctype ) ) {
	typeExtra.sprintf( "\"%s\"", ctype.data() );
	return typeExtra;
    }
    if ( ctype.left(6) == "const " )
	ctype = ctype.mid( 6, ctype.length() - 6 );
    if ( ctype.right(1) == "&" ) {
	ctype = ctype.left( ctype.length() - 1 );
    } else if ( ctype.right(1) == "*" ) {
	QCString raw = ctype.left( ctype.length() - 1 );
	ctype = "ptr";
	if ( raw == "char" )
	    ;
	else
	    typeExtra.sprintf( "\"%s\"", raw.stripWhiteSpace().data() );

    } else if ( isEnumType( ctype ) ) {
	int idx = enumIndex( ctype );
	if ( idx >= 0 ) {
	    typeExtra.sprintf( "&enum_tbl[%d]", enumIndex( ctype ) );
	} else {
	    typeExtra.sprintf( "parentObject->enumerator(\"%s\", TRUE )", ctype.data() );
	}
	typeExtra =
	    "\n#ifndef QT_NO_PROPERTIES\n\t  " + typeExtra +
	    "\n#else"
	    "\n\t  0"
	    "\n#endif // QT_NO_PROPERTIES\n\t  ";
    }
    return typeExtra;
}

/*
  Attention!
  This table is copied from qvariant.cpp. If you change
  one, change both.
*/
static const int ntypes = 32;
static const char* const type_map[ntypes] =
{
    0,
    "QMap<QString,QVariant>",
    "QValueList<QVariant>",
    "QString",
    "QStringList",
    "QFont",
    "QPixmap",
    "QBrush",
    "QRect",
    "QSize",
    "QColor",
    "QPalette",
    "QColorGroup",
    "QIconSet",
    "QPoint",
    "QImage",
    "int",
    "uint",
    "bool",
    "double",
    "QCString",
    "QPointArray",
    "QRegion",
    "QBitmap",
    "QCursor",
    "QSizePolicy",
    "QDate",
    "QTime",
    "QDateTime",
    "QByteArray",
    "QBitArray",
    "QKeySequence"
};

int qvariant_nameToType( const char* name )
{
    for ( int i = 0; i < ntypes; i++ ) {
	if ( !qstrcmp( type_map[i], name ) )
	    return i;
    }
    return 0;
}

/*
  Returns TRUE if the type is a QVariant types.
*/
bool isVariantType( const char* type )
{
    return qvariant_nameToType( type ) != 0;
}

/*
  Replaces '>>' with '> >' (as in 'QValueList<QValueList<double> >').
  This function must be called to produce valid C++ code. However,
  the string representation still uses '>>'.
*/
void fixRightAngles( QCString *str )
{
    str->replace( QRegExp(">>"), "> >" );
}

static QCString rmWS( const char * );

enum Access { Private, Protected, Public };


class Argument					/* single arg meta data*/
{
public:
    Argument( const char *left, const char *right, const char* argName = 0, bool isDefaultArgument = FALSE )
    {
	leftType = rmWS( left );
	rightType = rmWS( right );
	if ( leftType == "void" && rightType.isEmpty() )
	    leftType = "";

	int len = leftType.length();

	/*
	  Convert 'char const *' into 'const char *'. Start at index 1,
	  not 0, because 'const char *' is already OK.
	*/
	for ( int i = 1; i < len; i++ ) {
	    if ( leftType[i] == 'c' &&
		 strncmp(leftType.data() + i + 1, "onst", 4) == 0 ) {
		leftType.remove( i, 5 );
		if ( leftType[i - 1] == ' ' )
		    leftType.remove( i - 1, 1 );
		leftType.prepend( "const " );
		break;
	    }

	    /*
	      We musn't convert 'char * const *' into 'const char **'
	      and we must beware of 'Bar<const Bla>'.
	    */
	    if ( leftType[i] == '&' || leftType[i] == '*' ||
		 leftType[i] == '<' )
		break;
	}

	name = argName;
	isDefault = isDefaultArgument;
    }

    QCString leftType;
    QCString rightType;
    QCString name;
    bool isDefault;
};

class ArgList : public QPtrList<Argument> {	/* member function arg list*/
public:
    ArgList() { setAutoDelete( TRUE ); }
    ~ArgList() { clear(); }

    /* the clone has one default argument less, the orignal has all default arguments removed */
    ArgList* magicClone() {
	ArgList* l = new ArgList;
	bool firstDefault = FALSE;
	for ( first(); current(); next() ) {
	    bool isDefault = current()->isDefault;
	    if ( !firstDefault && isDefault ) {
		isDefault = FALSE;
		firstDefault = TRUE;
	    }
	    l->append( new Argument( current()->leftType, current()->rightType, current()->name, isDefault ) );
	}
	for ( first(); current(); ) {
	    if ( current()->isDefault )
		remove();
	    else
		next();
	}
	return l;
    }

    bool hasDefaultArguments() {
	for ( Argument* a = first(); a; a = next() ) {
	    if ( a->isDefault )
		return TRUE;
	}
	return FALSE;
    }

};


struct Function					/* member function meta data*/
{
    Access access;
    QCString    qualifier;			/* const or volatile*/
    QCString    name;
    QCString    type;
    QCString    signature;
    int	       lineNo;
    ArgList   *args;
    Function() { args=0;}
   ~Function() { delete args; }
    const char* accessAsString() {
	switch ( access ) {
	case Private: return "Private";
	case Protected: return "Protected";
	default: return "Public";
	}
    }
};

class FuncList : public QPtrList<Function> {	/* list of member functions*/
public:
    FuncList( bool autoDelete = FALSE ) { setAutoDelete( autoDelete ); }

    FuncList find( const char* name )
    {
	FuncList result;
	for ( QPtrListIterator<Function> it(*this); it.current(); ++it ) {
	    if ( it.current()->name == name )
		result.append( it.current() );
	}
	return result;
    }
};

class Enum : public QStrList
{
public:
    QCString name;
    bool set;
};

class EnumList : public QPtrList<Enum> {		/* list of property enums*/
public:
    EnumList() { setAutoDelete(TRUE); }
};


struct Property
{
    Property( int l, const char* t, const char* n, const char* s, const char* g, const char* r,
	      const QCString& st, const QCString& d, const QCString& sc, bool ov )
	: lineNo(l), type(t), name(n), set(s), get(g), reset(r), setfunc(0), getfunc(0),
	  sspec(Unspecified), gspec(Unspecified), stored( st ),
	  designable( d ), scriptable( sc ), override( ov ), oredEnum( -1 )
    {
	/*
	  The Q_PROPERTY construct cannot contain any commas, since
	  commas separate macro arguments. We therefore expect users
	  to type "QMap" instead of "QMap<QString, QVariant>". For
	  coherence, we also expect the same for
	  QValueList<QVariant>, the other template class supported by
	  QVariant.
	*/
	if ( type == "QMap" ) {
	    type = "QMap<QString,QVariant>";
	} else if ( type == "QValueList" ) {
	    type = "QValueList<QVariant>";
	}
    }

    int lineNo;
    QCString type;
    QCString name;
    QCString set;
    QCString get;
    QCString reset;
    QCString stored;
    QCString designable;
    QCString scriptable;
    bool override;

    Function* setfunc;
    Function* getfunc;

    int oredEnum; /* If the enums item may be ored. That means the data type is int.*/
		  /* Allowed values are 1 (True), 0 (False), and -1 (Unset)*/
    QCString enumsettype; /* contains the set function type in case of oredEnum*/
    QCString enumgettype; /* contains the get function type in case of oredEnum*/

    enum Specification  { Unspecified, Class, Reference, Pointer, ConstCharStar };
    Specification sspec;
    Specification gspec;

    bool stdSet() {
	QCString s = "set";
	s += toupper( name[0] );
	s += name.mid( 1 );
	return s == set;
    }

    static const char* specToString( Specification s )
    {
	switch ( s ) {
	case Class:
	    return "Class";
	case Reference:
	    return "Reference";
	case Pointer:
	    return "Pointer";
	case ConstCharStar:
	    return "ConstCharStar";
	default:
	    return "Unspecified";
	}
    }
};

class PropList : public QPtrList<Property> {	/* list of properties*/
public:
    PropList() { setAutoDelete( TRUE ); }
};


struct ClassInfo
{
    ClassInfo( const char* n, const char* v )
	: name(n), value(v)
    {}
    QCString name;
    QCString value;
};

class ClassInfoList : public QPtrList<ClassInfo> {	/* list of class infos*/
public:
    ClassInfoList() { setAutoDelete( TRUE ); }
};

ArgList *addArg( Argument * );			/* add arg to tmpArgList*/

enum Member { SignalMember,
	      SlotMember,
	      PropertyCandidateMember
	    };

void	 addMember( Member );			/* add tmpFunc to current class*/
void     addEnum();				/* add tmpEnum to current class*/

char	*strnew( const char * );		/* returns a new string (copy)*/
char	*stradd( const char *, const char * );	/* add two strings*/
char	*stradd( const char *, const char *,	/* add three strings*/
			       const char * );
char	*straddSpc( const char *, const char * );
char	*straddSpc( const char *, const char *,
			       const char * );
char	*straddSpc( const char *, const char *,
		    const char *, const char * );

extern int yydebug;
bool	   lexDebug	   = FALSE;
int	   lineNo;			/* current line number*/
bool	   errorControl	   = FALSE;	/* controled errors*/
bool	   displayWarnings = TRUE;
bool	   skipClass;			/* don't generate for class*/
bool	   skipFunc;			/* don't generate for func*/
bool	   templateClass;		/* class is a template*/
bool	   templateClassOld;		/* previous class is a template*/

ArgList	  *tmpArgList;			/* current argument list*/
Function  *tmpFunc;			/* current member function*/
Enum      *tmpEnum;			/* current enum*/
Access tmpAccess;			/* current access permission*/
Access subClassPerm;			/* current access permission*/

bool	   Q_OBJECTdetected;		/* TRUE if current class*/
					/*  contains the Q_OBJECT macro*/
bool	   Q_PROPERTYdetected;		/* TRUE if current class*/
					/*  contains at least one Q_PROPERTY,*/
					/*  Q_OVERRIDE, Q_SETS or Q_ENUMS macro*/
bool	   tmpPropOverride;		/* current property override setting*/

int	   tmpYYStart;			/* Used to store the lexers current mode*/
int	   tmpYYStart2;			/* Used to store the lexers current mode*/
					/*  (if tmpYYStart is already used)*/

/* if the format revision changes, you MUST change it in qmetaobject.h too*/
const int formatRevision = 19;		/* moc output format revision*/

/* if the flags change, you HAVE to change it in qmetaobject.h too*/
enum Flags  {
    Invalid		= 0x00000000,
    Readable		= 0x00000001,
    Writable		= 0x00000002,
    EnumOrSet		= 0x00000004,
    StdSet		= 0x00000100,
    Override		= 0x00000200
};

#line 560 "moc.y"
typedef union {
    char	char_val;
    int		int_val;
    double	double_val;
    char       *string;
    Access	access;
    Function   *function;
    ArgList    *arg_list;
    Argument   *arg;
} YYSTYPE;
#line 524 "y.tab.c"
#define CHAR_VAL 257
#define INT_VAL 258
#define DOUBLE_VAL 259
#define STRING 260
#define IDENTIFIER 261
#define FRIEND 262
#define TYPEDEF 263
#define AUTO 264
#define REGISTER 265
#define STATIC 266
#define EXTERN 267
#define INLINE 268
#define VIRTUAL 269
#define CONST 270
#define VOLATILE 271
#define CHAR 272
#define SHORT 273
#define INT 274
#define LONG 275
#define SIGNED 276
#define UNSIGNED 277
#define FLOAT 278
#define DOUBLE 279
#define VOID 280
#define ENUM 281
#define CLASS 282
#define STRUCT 283
#define UNION 284
#define ASM 285
#define PRIVATE 286
#define PROTECTED 287
#define PUBLIC 288
#define OPERATOR 289
#define DBL_COLON 290
#define TRIPLE_DOT 291
#define TEMPLATE 292
#define NAMESPACE 293
#define USING 294
#define MUTABLE 295
#define THROW 296
#define SIGNALS 297
#define SLOTS 298
#define Q_OBJECT 299
#define Q_PROPERTY 300
#define Q_OVERRIDE 301
#define Q_CLASSINFO 302
#define Q_ENUMS 303
#define Q_SETS 304
#define READ 305
#define WRITE 306
#define STORED 307
#define DESIGNABLE 308
#define SCRIPTABLE 309
#define RESET 310
#define YYERRCODE 256
short yylhs[] = {                                        -1,
    0,    0,   37,   37,   37,   37,   37,   39,   39,   45,
   47,   43,   48,   49,   44,   46,   40,   42,   41,   41,
   51,   38,    1,    1,    2,   52,   53,   54,   55,   28,
   28,   28,   28,   28,   27,   29,   29,   30,   30,   56,
   56,   56,   56,   57,   57,   31,   31,   11,   11,   11,
   12,   12,   13,   13,   13,   13,   13,   13,   13,   13,
   13,    3,   58,   58,   14,   14,   15,   15,   16,   16,
   17,   17,   17,   18,   18,   20,   20,   59,   59,   19,
   19,   23,   60,   23,   23,   61,   23,   21,   21,   22,
   62,   22,   63,   22,   22,   22,   32,   32,   64,   32,
   32,   36,   65,   10,   10,   70,   10,   71,   10,   72,
   69,   73,   69,   35,   35,   34,   34,   33,   33,   24,
   24,   25,   25,   26,   26,   68,   68,   68,   75,   74,
   78,   50,   50,   50,   50,   80,   80,   80,   80,   80,
   79,   79,   76,   81,   67,   67,   82,   66,   66,   83,
   84,   84,   86,   85,    4,    4,   77,   77,   87,   87,
   89,   89,   91,   88,   92,   88,   88,   94,   97,   88,
   98,   99,   88,  100,  101,   88,  102,  104,   88,  105,
  107,   88,   90,   90,  109,   90,   90,   96,   96,  110,
  110,  111,   93,   93,  113,  113,  114,  108,  108,  115,
  115,  116,  117,  117,    5,    6,    6,    7,    7,    8,
    8,    8,    8,    8,    8,    8,    8,    8,    8,    9,
    9,    9,  118,  118,  118,  118,  118,  118,  118,  118,
  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,
  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,
  118,  118,  118,  118,  118,  118,  118,  118,  118,  118,
  118,  118,  118,  119,  119,  120,  120,  120,  120,  120,
  120,  120,  120,  120,  120,  120,  120,  112,  112,  112,
  112,  112,  112,  112,  112,  125,  126,  112,  122,  122,
  127,  128,  127,  129,  127,  121,  130,  121,  123,  132,
  132,  131,  131,  124,  124,  133,  133,  133,  134,  135,
  134,  137,   95,  136,  136,  136,  136,  136,  136,  136,
  103,  103,  106,  106,
};
short yylen[] = {                                         2,
    0,    2,    1,    1,    1,    1,    1,    1,    1,    0,
    0,    7,    0,    0,    6,    1,    5,    2,    2,    2,
    0,    3,    1,    1,    4,    0,    0,    0,    0,    1,
    1,    1,    1,    1,    3,    0,    1,    1,    2,    1,
    1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    2,    1,    1,    1,    1,    1,    1,    1,    1,    1,
    1,    4,    0,    1,    2,    2,    1,    2,    3,    1,
    2,    2,    2,    2,    3,    0,    1,    0,    1,    3,
    1,    2,    0,    5,    4,    0,    7,    0,    1,    2,
    0,    4,    0,    5,    1,    3,    1,    2,    0,    5,
    3,    1,    7,    1,    2,    0,    4,    0,    5,    0,
    4,    0,    5,    0,    1,    1,    2,    2,    2,    0,
    1,    1,    2,    1,    1,    1,    1,    3,    0,    3,
    0,    5,    1,    4,    2,    1,    1,    1,    1,    1,
    2,    3,    2,    3,    0,    1,    4,    0,    1,    2,
    1,    3,    0,    5,    0,    1,    0,    1,    2,    1,
    1,    1,    0,    3,    0,    4,    1,    0,    0,    7,
    0,    0,    7,    0,    0,    9,    0,    0,    7,    0,
    0,    7,    2,    3,    0,    3,    1,    0,    1,    2,
    1,    1,    0,    1,    2,    1,    1,    0,    1,    2,
    1,    1,    0,    2,    2,    3,    1,    4,    4,    1,
    3,    2,    3,    2,    1,    3,    2,    3,    2,    1,
    1,    1,    3,    3,    1,    1,    1,    1,    1,    1,
    1,    1,    1,    1,    1,    1,    1,    2,    2,    2,
    2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
    2,    2,    3,    3,    2,    2,    2,    2,    1,    3,
    2,    2,    2,    0,    1,    2,    1,    3,    5,    2,
    3,    4,    3,    2,    6,    4,    5,    3,    4,    6,
    4,    4,    5,    3,    3,    0,    0,    7,    1,    3,
    1,    0,    4,    0,    3,    0,    0,    3,    2,    0,
    1,    5,    4,    0,    1,    0,    1,    3,    1,    0,
    4,    0,    4,    0,    3,    3,    3,    3,    3,    3,
    0,    2,    0,    2,
};
short yydefred[] = {                                      1,
    0,    0,    0,    2,    3,    4,    5,    6,    7,    8,
    9,    0,    0,    0,   19,   20,   18,    0,    0,    0,
    0,    0,    0,    0,    0,    0,   14,   26,  136,   40,
   41,   42,   43,   44,   45,   46,   47,   53,   54,   55,
   56,   57,   58,   59,   60,   61,  137,  138,  139,  140,
  135,    0,   70,   24,    0,   22,   65,   66,  131,    0,
    0,  143,  156,    0,    0,    0,    0,   11,    1,    0,
   26,  142,    0,    0,    0,    0,    0,  220,  221,  222,
    0,  215,  207,    0,  210,    0,   17,    1,    0,    0,
   62,    0,   69,  165,  162,  167,  168,  171,  174,  177,
  180,  161,    0,    0,  160,  163,  134,    0,  217,    0,
  212,    0,    0,  219,  214,    0,   15,   25,    0,    0,
    0,    0,    0,    0,  132,  159,    0,    0,    0,  216,
  211,  206,  218,  213,   12,    0,    0,    0,    0,    0,
    0,  187,    0,    0,  185,  164,  208,  209,    0,   33,
   34,    0,    0,    0,    0,    0,    0,   64,  267,    0,
    0,   52,    0,   49,   48,   38,    0,   31,   30,   32,
    0,  166,  197,    0,  196,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,  183,    0,    0,  106,
  110,    0,    0,    0,  299,   73,    0,    0,    0,  259,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  274,    0,    0,    0,    0,    0,
    0,    0,  266,    0,  116,    0,   51,    0,    0,    0,
    0,    0,   39,  286,  203,  195,    0,    0,  297,  203,
    0,  305,    0,  312,  169,  172,    0,  322,  178,  324,
  181,  184,  202,    0,  201,  186,    0,  191,  192,   27,
   27,  108,  112,    0,    0,    0,  307,  248,  249,    0,
  250,    0,  263,  262,  240,  244,  255,  238,  257,  239,
    0,  258,  241,  242,  243,  245,  256,  246,  247,    0,
    0,  284,    0,  203,  273,  124,  125,  118,    0,  122,
  119,    0,    0,    0,  271,  117,  144,   72,    0,   71,
    0,    0,  268,    0,    0,    0,   81,    0,    0,   27,
    0,  203,    0,  203,    0,    0,    0,    0,    0,    0,
  200,  190,  107,    0,   27,   27,    0,  310,    0,    0,
  253,  254,  260,  223,  224,  203,    0,  123,    0,  272,
  276,    0,  287,  204,    0,    0,   79,   74,   91,    0,
    0,    0,   95,    0,  298,    0,    0,    0,  294,    0,
   97,    0,  289,    0,    0,    0,    0,    0,    0,    0,
  313,  170,  173,  175,  179,  182,  111,  109,    0,    0,
   29,  308,  303,    0,  277,    0,  269,    0,    0,   75,
   80,   27,    0,  102,   83,    0,   93,   90,   35,  292,
    0,   27,   99,   98,  203,    0,    0,    0,    0,    0,
    0,    0,    0,  113,  302,  311,  275,  203,    0,    0,
  149,    0,   96,   28,    0,   27,   27,  101,  295,   27,
    0,  290,  315,  316,  318,  319,  320,  317,  176,    0,
    0,  150,    0,    0,    0,  146,   92,   84,   86,    0,
  293,    0,  153,    0,    0,  129,    0,  126,  103,  127,
   28,   94,  100,   27,  152,    0,    0,    0,   87,    0,
  147,  130,  128,  154,
};
short yydgoto[] = {                                      89,
   53,   54,  158,   62,   63,   81,   82,   83,   84,  159,
  160,  161,  162,  163,  164,   67,  165,  314,  315,  316,
  361,  362,  317,  298,  299,  300,  318,  166,  213,  167,
  168,  370,  225,  302,  303,  371,    4,    5,    6,    7,
    8,    9,   10,   11,   26,   90,   88,   14,   69,   21,
   12,   70,  333,  458,  426,  169,  170,   22,  358,  434,
  471,  402,  436,  440,  240,  430,  455,  469,  192,  260,
  335,  261,  336,  470,  477,   23,  103,   74,   24,   51,
  171,  456,  431,  452,  453,  474,  104,  105,  106,  146,
  127,  119,  172,  120,  180,  256,  326,  121,  327,  122,
  423,  123,  184,  329,  124,  186,  330,  252,  189,  257,
  258,  259,  174,  175,  254,  255,  312,  215,  176,  177,
  241,  372,  178,  243,  311,  398,  373,  437,  412,  320,
  195,  340,  266,  267,  391,  381,  325,
};
short yysindex[] = {                                      0,
  -81, -178,  -61,    0,    0,    0,    0,    0,    0,    0,
    0, -168,   77,   23,    0,    0,    0,  155,  864,   -9,
  195,   65,  138,  229, -229,  183,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  -36,    0,    0,   48,    0,    0,    0,    0,   79,
  328,    0,    0,  320,  122,  329,   48,    0,    0,  331,
    0,    0,  122, 1146,  356,   29,  346,    0,    0,    0,
  358,    0,    0,  262,    0,   48,    0,    0,  -81,  317,
    0,  384,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,  323, 1146,    0,    0,    0,  796,    0, -127,
    0,  328, -127,    0,    0,  374,    0,    0,  443,  468,
  476,  478,  480,  490,    0,    0,   -2,  503,  513,    0,
    0,    0,    0,    0,    0, 1020,  296,  296,  285,  301,
  307,    0,  529,  534,    0,    0,    0,    0,   12,    0,
    0,    0, -100,  338,  467,  339,  128,    0,    0,  146,
 1190,    0,  360,    0,    0,    0, 1054,    0,    0,    0,
   20,    0,    0, 1020,    0,  484,  249,  364,  367,  576,
  578,  585,  301,  594,  307,  602,    0, 1020, 1020,    0,
    0,   10,  519,  389,    0,    0,  590,  242,  383,    0,
  561,  616,  598,  173,  174,  551,  624,  630,  647,  -17,
  655,  656, 1096, 1189,    0,  535, -229,  661,  113,  467,
  198,  198,    0,  270,    0,  -23,    0,  320,  -54,  460,
 1189,  461,    0,    0,    0,    0,  509, 1189,    0,    0,
  -11,    0,  669,    0,    0,    0,  548,    0,    0,    0,
    0,    0,    0, 1020,    0,    0, 1020,    0,    0,    0,
    0,    0,    0,  389,  678,  720,    0,    0,    0,  753,
    0,  767,    0,    0,    0,    0,    0,    0,    0,    0,
  787,    0,    0,    0,    0,    0,    0,    0,    0,  140,
  140,    0,  771,    0,    0,    0,    0,    0,  198,    0,
    0,  140,  -65,  467,    0,    0,    0,    0,  140,    0,
  730,  802,    0,  836,  834,  591,    0,  208, 1075,    0,
  802,    0,   40,    0,  405, 1020, 1020,  844, 1020, 1020,
    0,    0,    0,  793,    0,    0,  720,    0,  389,  781,
    0,    0,    0,    0,    0,    0,  802,    0,  467,    0,
    0,   93,    0,    0,  198,  315,    0,    0,    0,  208,
  -34,  203,    0, 1189,    0,  802,  849,  -28,    0,  303,
    0,   82,    0,  802,  648,  673,  679,  717,  723,  737,
    0,    0,    0,    0,    0,    0,    0,    0,  815,  874,
    0,    0,    0,  802,    0,  467,    0,  966,  942,    0,
    0,    0,  349,    0,    0,  208,    0,    0,    0,    0,
  395,    0,    0,    0,    0,   40,  405,  405,  405,  405,
  405,  405, 1020,    0,    0,    0,    0,    0, -229,  735,
    0,  953,    0,    0,  986,    0,    0,    0,    0,    0,
  802,    0,    0,    0,    0,    0,    0,    0,    0,  802,
 1008,    0, 1012, 1021,  124,    0,    0,    0,    0,  967,
    0,  969,    0, -229, 1189,    0,  807,    0,    0,    0,
    0,    0,    0,    0,    0, 1036,  954, 1019,    0, 1063,
    0,    0,    0,    0,
};
short yyrindex[] = {                                      0,
  284,  987,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  282,  992,    0,    0,    0,    0,    0,  290,    0,
    0,    0,    0,   57,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,  -37,    0,    0,   70,    0,    0,    0,    0,    0,
    0,    0,    0,   53,    0,    0,   64,    0,    0,    0,
    0,    0,    0,  999,    0,   -4,    0,    0,    0,    0,
   71,    0,    0,    0,    0,   95,    0,    0,  -43,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0, 1001,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,  593,    0,    0,    0, 1086,
 1106,    0,    0,    0,    0,    0,    0,    0,  161,    0,
    0,  988,    0,    0, 1105,    0,    0,    0,    0,    0,
  107,    0,    0,    0,    0,    0,  282,    0,    0,    0,
    0,    0,    0,  601,    0,    0,  390, 1089,    0,    0,
    0,    0, 1086,    0, 1106,    0,    0,  863,  910,    0,
    0,  511,  226,    2,    0,    0,  516,  550,  580,    0,
    0,    0,  587,  597,  665, 1005, 1141, 1143, 1346, 1348,
 1351, 1353,    0,    1,    0,    0,    0,    0, 1356, 1105,
  -24,  -24,    0,  177,    0,    0,    0,  213,  108,    0,
  131,    0,    0,    0,    0,    0,    0,  180,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  933,    0,    0,  941,    0,    0,    0,
    0,    0,    0,    2,   37, 1027,    0,    0,    0, 1358,
    0, 1378,    0,    0,    0,    0,    0,    0,    0,    0,
 1380,    0,    0,    0,    0,    0,    0,    0,    0, 1383,
 1383,    0,    0,    0,    0,    0,    0,    0,  -33,    0,
    0,  341,    0, 1105,    0,    0,    0,    0,  177,    0,
    0,  400,    0,    0,   -3, 1112,    0,  -31,  282,    0,
  479,    0,    0,    0, 1113,  910,  910,    0,  910,  910,
    0,    0,    0,    0,    0,    0, 1027,    0, 1030,    0,
    0,    0,    0,    0,    0,    0,  523,    0, 1105,    0,
    0,    0,    0,    0,   17,  896,    0,    0,    0,    0,
   19,  182,    0,    9,    0,  570,  504,    0,    0,  454,
    0,    0,    0,  649,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  693,    0, 1105,    0,    0,   54,    0,
    0,    0,    0,    0,    0,   13,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0, 1113, 1113, 1113, 1113,
 1113, 1113,  910,    0,    0,    0,    0,    0,    0,  278,
    0,    0,    0,    0,   55,    0,    0,    0,    0,    0,
  740,    0,    0,    0,    0,    0,    0,    0,    0,  819,
    0,    0,   99,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,  180,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,
};
short yygindex[] = {                                   1156,
  118,    0, 1147,  929,    0,    0,  440, 1070,  275,  -95,
 -138,    0,  190,  -10,  -25,   44,    0,  719,    0,    0,
  783,  830,  835, -191,    0,  895,    0,   -8,  -59, -154,
 1176,  837,  241, 1043,  416,  843,    0,    0,    0,    0,
    0,    0,    0,    0,    0, 1118,    0,    0,    0,    0,
    0, 1151,  186,  746,    0, 1199, 1206,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,    0,    0,    0,    0,    0,    0,    0,
    0,    0,    0,  762,    0,    0,    0, 1142,    0,    0,
    0,    0,    0,    0, 1109, -209,    0,    0,    0,    0,
    0,    0, 1065,    0,    0, 1088,    0,    0,    0,    0,
 1017,  231,    0, 1101,    0, 1022,  225, -152,    0,    0,
    0,    0,    0,    0,    0,    0,  861,    0,    0,    0,
    0,  965, 1015,  964,    0,  633,    0,
};
#define YYTABLESIZE 1470
short yytable[] = {                                      66,
  214,   20,   23,   61,  121,  224,  121,  121,  121,   88,
  121,  368,   88,  120,  222,  120,  120,  120,  221,  120,
   23,   23,  194,   71,  121,  121,  405,  121,  231,   88,
  301,   64,  323,  120,  120,   85,  120,   77,   37,   23,
   37,   37,   37,  286,   37,  306,   36,  322,   36,   36,
   36,  111,   36,   88,   23,  145,   88,  121,  115,   82,
   65,   37,   82,   55,  223,  214,  120,  295,  108,   36,
  262,   71,  190,   88,  120,  120,  214,  120,  235,  368,
  309,   16,   13,  214,  131,   23,   85,  134,   71,  121,
   23,   37,   23,   23,   23,   85,   23,  369,   85,   36,
  263,   67,  191,   67,   67,   67,  287,   67,   86,  141,
   23,   23,  148,   23,  148,  133,  382,  383,   23,  385,
  386,   67,   67,   18,   67,  416,  306,  141,  141,  205,
  305,  218,   68,   76,   68,   68,   68,   25,   68,  120,
  415,  313,  234,   23,   50,   27,   50,   50,   50,  214,
   50,  351,   68,   68,   67,   68,  232,  151,  233,  151,
  193,  309,   65,  399,   50,   50,  155,   50,   36,   72,
  270,  309,   36,  190,  270,   23,  148,  222,  319,  155,
  364,  221,  468,  222,  467,   68,   67,  221,  270,  270,
   93,  293,  141,  205,  214,  219,  395,   50,   23,   15,
  104,  214,   23,  191,  104,  233,  229,  350,   47,  214,
  277,    2,    3,  449,   28,  233,  279,   68,  104,  104,
   76,  151,   89,  349,   64,   89,  404,  121,   16,   88,
  155,   17,  404,  276,  278,   73,  120,  219,   21,   21,
  222,  214,   89,  427,  221,  222,  466,  360,   21,  221,
   71,   52,   23,   56,   71,  121,  397,  121,  142,   88,
   59,   37,  121,   72,  120,  304,  120,   72,   60,   36,
   23,   23,   37,   37,   37,   37,   37,   37,   37,   37,
   37,   37,   37,   37,   37,   23,   61,   77,  238,   37,
   37,   37,   37,  407,  143,  144,  319,  129,  359,   36,
  367,  270,  269,   88,  409,   68,  239,  222,  232,   82,
  214,  221,  120,   23,   23,   23,   23,   23,   23,   23,
   23,   23,   23,   23,   67,   67,   67,   67,   67,   67,
   67,   67,   67,   67,   67,   23,  145,   73,  145,   75,
  222,   23,   23,   23,  221,   85,   57,   58,  102,  148,
  227,  110,   67,  219,   67,   68,   68,   68,   68,   68,
   68,   68,   68,   68,   68,   68,  173,   50,   50,   50,
   50,   50,   50,   50,   50,   50,   50,   50,  102,   71,
  115,  396,   64,   68,  115,   68,  222,   87,   64,  433,
  221,   36,   91,  413,  151,   50,  107,   50,  115,  115,
  145,  112,  291,  451,  173,  319,  219,  150,  151,   30,
   31,   32,   33,   34,   35,   36,   37,   65,  253,   36,
  217,   23,   23,   23,   23,   23,   23,   23,   23,   23,
   23,   23,  222,  296,  220,  438,  221,  114,  451,  407,
   36,  117,   89,  271,  272,  118,  334,  125,  296,   23,
   23,   36,   36,   36,   36,   36,   36,   36,   36,   36,
   36,   36,   36,   36,  321,  114,  306,  296,  297,   36,
   76,   36,   89,   71,   71,   71,   71,   71,   71,   71,
   71,   71,   71,   71,  253,  413,   72,   72,   72,   72,
   72,   72,   72,   72,   72,   72,   72,  291,  135,  212,
  136,   71,   23,  208,  204,  365,  202,  137,  203,  205,
  200,  206,  291,  207,   72,  138,  109,  139,  347,  140,
  388,  389,   76,  114,  285,  285,  198,  197,  199,  141,
  113,  150,  151,   30,   31,   32,   33,   34,   35,   36,
   37,  102,  306,  147,  182,  102,  366,  102,  374,  130,
  105,   65,  133,  148,  105,  235,  179,  201,  363,  235,
  209,  183,  102,   63,   63,   21,   21,  185,  105,  105,
  394,   64,   64,  235,  235,   21,  150,  151,   30,   31,
   32,   33,   34,   35,   36,   37,  187,  432,   76,  236,
  210,  188,  211,  236,  102,  282,   77,  439,  196,  216,
  363,  115,  408,  278,  278,  400,   76,  236,  236,  237,
  414,  280,  281,   78,   79,   80,  245,   65,  246,  237,
  228,  460,  461,  237,  242,  462,  227,  244,  247,  115,
  227,   78,   79,   80,  249,   65,  231,  237,  237,  441,
  231,  264,  251,  408,  227,  227,  363,  282,  282,  265,
  268,  414,  450,  273,  231,  231,  274,  292,  275,  480,
  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,
  285,  285,  285,  285,  285,  285,  285,  285,  285,  285,
  285,  285,  285,  285,  283,  285,  285,  285,  285,  285,
  284,  285,  285,  285,  279,  279,  285,  285,  285,  285,
  285,  285,  285,  285,  225,  344,  345,  285,  225,  375,
  376,  377,  378,  379,  380,  288,  289,  193,  264,  294,
  308,  310,  225,  225,  352,  194,  264,  324,  150,  151,
   30,   31,   32,   33,   34,   35,   36,   37,  338,  278,
  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
  278,  278,  278,  278,  278,  278,  278,  278,  278,  278,
  278,  278,  278,  339,  278,  278,  278,  278,  278,  219,
  278,  278,  278,  281,  281,  278,  278,  278,  278,  278,
  278,  278,  278,  282,  282,  282,  282,  282,  282,  282,
  282,  282,  282,  282,  282,  282,  282,  282,  282,  282,
  282,  282,  282,  282,  282,  282,  282,  328,  282,  282,
  282,  282,  282,  341,  282,  282,  282,  283,  283,  282,
  282,  282,  282,  282,  282,  282,  282,  342,  343,  346,
  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,
  279,  279,  279,  279,  279,  279,  279,  279,  279,  279,
  279,  279,  279,  279,  353,  279,  279,  279,  279,  279,
  354,  279,  279,  279,  280,  280,  279,  279,  279,  279,
  279,  279,  279,  279,   63,   63,  355,  356,  193,  193,
  193,  357,   63,   63,  384,  387,  194,  194,  194,  193,
  193,  193,  193,  193,  193,  193,  193,  194,  194,  194,
  194,  194,  194,  194,  194,  393,  410,  424,  417,  281,
  281,  281,  281,  281,  281,  281,  281,  281,  281,  281,
  281,  281,  281,  281,  281,  281,  281,  281,  281,  281,
  281,  281,  281,  418,  281,  281,  281,  281,  281,  419,
  281,  281,  281,  288,  288,  281,  281,  281,  281,  281,
  281,  281,  281,  283,  283,  283,  283,  283,  283,  283,
  283,  283,  283,  283,  283,  283,  283,  283,  283,  283,
  283,  283,  283,  283,  283,  283,  283,  420,  283,  283,
  283,  283,  283,  421,  283,  283,  283,  198,  264,  283,
  283,  283,  283,  283,  283,  283,  283,  422,  425,  429,
  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,
  280,  280,  280,  280,  280,  280,  280,  280,  280,  280,
  280,  280,  280,  280,  428,  280,  280,  280,  280,  280,
  454,  280,  280,  280,  188,  264,  280,  280,  280,  280,
  280,  280,  280,  280,  226,  457,  459,  463,  226,  443,
  444,  445,  446,  447,  448,  464,  128,  199,  264,  472,
  465,  473,  226,  226,  478,  189,  264,   38,   39,   40,
   41,   42,   43,   44,   45,   46,  481,  483,  482,  288,
  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,
  288,  288,  288,  288,  288,  288,  288,  288,  288,  288,
  288,  288,  288,  484,  288,  288,  288,  288,  288,   13,
  288,  288,  288,  265,   10,  288,  288,  288,  288,  288,
  288,  288,  288,  157,   29,  158,  321,   30,   31,   32,
   33,   34,   35,   36,   37,   38,   39,   40,   41,   42,
   43,   44,   45,   46,   63,   63,  323,  304,  198,  198,
  198,  300,   78,  314,  301,    1,   36,  307,   19,  198,
  198,  198,  198,  198,  198,  198,  198,   36,   36,   36,
   36,   36,   36,   36,   36,   36,   36,   36,   36,   36,
  228,  132,  229,  476,  228,   36,  229,   36,  435,  403,
  401,   63,   63,  348,   48,  188,  188,  188,  228,  228,
  229,  229,  226,  406,  411,  116,  188,  188,  188,  188,
  188,  188,  188,  188,   63,   63,  479,   49,  199,  199,
  199,   92,   63,   63,   50,  475,  189,  189,  189,  199,
  199,  199,  199,  199,  199,  199,  199,  189,  189,  189,
  189,  189,  189,  189,  189,  126,  181,  248,   45,   45,
   45,   45,   45,   45,   45,   45,   45,   45,   45,   45,
   45,   45,   45,   45,   45,   45,   45,   45,   45,   45,
   45,   45,  250,  332,  236,  331,  442,   45,  337,   45,
  149,  150,  151,   30,   31,   32,   33,   34,  152,   36,
   37,   38,   39,   40,   41,   42,   43,   44,   45,   46,
  153,  390,  392,  154,    0,    0,    0,    0,  155,   65,
    0,   18,  156,  157,   64,  150,  151,   30,   31,   32,
   33,   34,   35,   36,   37,   38,   39,   40,   41,   42,
   43,   44,   45,   46,  230,   64,    0,  154,    0,    0,
    0,    0,    0,   65,    0,   18,   38,   39,   40,   41,
   42,   43,   44,   45,   46,  230,  290,    0,  154,    0,
    0,    0,    0,    0,   65,   36,   18,   38,   39,   40,
   41,   42,   43,   44,   45,   46,   36,   36,   36,   36,
   36,   36,   36,   36,   36,  230,    0,  232,    0,  230,
  233,  232,  234,    0,  233,  104,  234,  251,    0,  104,
    0,  251,    0,  230,  230,  232,  232,    0,  233,  233,
  234,  234,    0,  104,  104,  251,  251,  252,    0,  261,
    0,  252,  114,  261,    0,    0,  114,    0,    0,    0,
    0,   78,   79,   80,    0,  252,  252,  261,  261,    0,
  114,  114,   94,   95,   96,   97,   98,   99,  100,  101,
  150,  151,   30,   31,   32,   33,   34,   35,   36,   37,
    0,   38,   39,   40,   41,   42,   43,   44,   45,   46,
};
short yycheck[] = {                                      25,
  155,   12,   40,   58,   38,  160,   40,   41,   42,   41,
   44,   40,   44,   38,   38,   40,   41,   42,   42,   44,
   58,   59,  123,   60,   58,   59,   61,   61,  167,   61,
  222,  261,   44,   58,   59,   61,   61,   41,   38,   44,
   40,   41,   42,   61,   44,   44,   38,   59,   40,   41,
   42,   77,   44,   41,   59,   58,   44,   91,   84,   41,
  290,   61,   44,   20,  160,  220,   91,  220,   40,   61,
   61,   60,   61,   61,   58,   59,  231,   61,   59,   40,
   44,  125,  261,  238,  110,  123,  112,  113,   60,  123,
   38,   91,   40,   41,   42,   41,   44,   58,   44,   91,
   91,   38,   91,   40,   41,   42,  124,   44,   65,   40,
   58,   59,   59,   61,   61,   59,  326,  327,  123,  329,
  330,   58,   59,  292,   61,   44,  125,   58,   59,   59,
  226,  157,   38,  261,   40,   41,   42,   61,   44,  123,
   59,  237,  123,   91,   38,  123,   40,   41,   42,  304,
   44,  304,   58,   59,   91,   61,  167,   59,  167,   61,
  261,  125,  290,  355,   58,   59,   59,   61,   38,   52,
   40,  231,   42,   61,   44,  123,  123,   38,  238,  123,
  319,   42,   59,   38,   61,   91,  123,   42,   58,   59,
   73,  217,  123,  123,  349,  261,  349,   91,   38,  261,
   40,  356,   42,   91,   44,  214,  163,  303,   19,  364,
   38,  293,  294,  423,   60,  224,   43,  123,   58,   59,
   41,  123,   41,  289,  261,   44,  261,  261,  290,  261,
  123,  293,  261,   61,   61,  290,  261,  261,  282,  283,
   38,  396,   61,  396,   42,   38,  123,   40,  292,   42,
   38,  261,  290,   59,   42,  289,  352,  291,  261,  291,
  123,  261,  296,   38,  289,  289,  291,   42,   40,  261,
   58,   59,  272,  273,  274,  275,  276,  277,  278,  279,
  280,  281,  282,  283,  284,  290,   58,  291,   40,  289,
  290,  291,  292,   91,  297,  298,  356,  108,   91,  291,
  261,   60,   61,  291,  364,  123,   58,   38,  319,  291,
  465,   42,  296,  261,  262,  263,  264,  265,  266,  267,
  268,  269,  270,  271,  261,  262,  263,  264,  265,  266,
  267,  268,  269,  270,  271,  123,   59,  290,   61,  261,
   38,  289,  290,  291,   42,  291,  282,  283,   74,  296,
  161,   77,  289,  261,  291,  261,  262,  263,  264,  265,
  266,  267,  268,  269,  270,  271,  136,  261,  262,  263,
  264,  265,  266,  267,  268,  269,  270,  271,  104,   60,
   40,  289,  261,  289,   44,  291,   38,   59,  261,   41,
   42,  261,   62,   91,  296,  289,   41,  291,   58,   59,
  123,   44,  213,  429,  174,  465,  261,  262,  263,  264,
  265,  266,  267,  268,  269,  270,  271,  290,  188,  289,
  293,  261,  262,  263,  264,  265,  266,  267,  268,  269,
  270,  271,   38,   44,  289,   41,   42,  261,  464,   91,
  261,  125,  261,   61,   62,   62,  261,  125,   59,  289,
  290,  272,  273,  274,  275,  276,  277,  278,  279,  280,
  281,  282,  283,  284,  240,  289,  226,  270,  271,  290,
  291,  292,  291,  261,  262,  263,  264,  265,  266,  267,
  268,  269,  270,  271,  254,   91,  261,  262,  263,  264,
  265,  266,  267,  268,  269,  270,  271,   44,  125,   33,
   58,  289,  290,   37,   38,  320,   40,   40,   42,   43,
   44,   45,   59,   47,  289,   40,   77,   40,  294,   40,
  335,  336,  261,   84,  125,  126,   60,   61,   62,   40,
  269,  262,  263,  264,  265,  266,  267,  268,  269,  270,
  271,   38,  302,   41,  260,   42,  322,   44,  324,  110,
   40,  290,  113,   41,   44,   40,  261,   91,  318,   44,
   94,  261,   59,  282,  283,  282,  283,  261,   58,   59,
  346,  282,  283,   58,   59,  292,  262,  263,  264,  265,
  266,  267,  268,  269,  270,  271,   58,  402,  261,   40,
  124,   58,  126,   44,   91,   45,  269,  412,  261,  261,
  360,  261,  362,  125,  126,  291,  261,   58,   59,  126,
  370,   61,   62,  286,  287,  288,   41,  290,   41,   40,
  261,  436,  437,   44,  261,  440,   40,  261,   44,  289,
   44,  286,  287,  288,   41,  290,   40,   58,   59,  415,
   44,  123,   41,  403,   58,   59,  406,  125,  126,  261,
   61,  411,  428,   93,   58,   59,   41,  123,   61,  474,
  261,  262,  263,  264,  265,  266,  267,  268,  269,  270,
  271,  272,  273,  274,  275,  276,  277,  278,  279,  280,
  281,  282,  283,  284,   61,  286,  287,  288,  289,  290,
   61,  292,  293,  294,  125,  126,  297,  298,  299,  300,
  301,  302,  303,  304,   40,  290,  291,   61,   44,  305,
  306,  307,  308,  309,  310,   61,   61,  125,  126,   59,
  261,  261,   58,   59,  309,  125,  126,   59,  262,  263,
  264,  265,  266,  267,  268,  269,  270,  271,   61,  261,
  262,  263,  264,  265,  266,  267,  268,  269,  270,  271,
  272,  273,  274,  275,  276,  277,  278,  279,  280,  281,
  282,  283,  284,   44,  286,  287,  288,  289,  290,  261,
  292,  293,  294,  125,  126,  297,  298,  299,  300,  301,
  302,  303,  304,  261,  262,  263,  264,  265,  266,  267,
  268,  269,  270,  271,  272,  273,  274,  275,  276,  277,
  278,  279,  280,  281,  282,  283,  284,  260,  286,  287,
  288,  289,  290,   61,  292,  293,  294,  125,  126,  297,
  298,  299,  300,  301,  302,  303,  304,   61,   42,   59,
  261,  262,  263,  264,  265,  266,  267,  268,  269,  270,
  271,  272,  273,  274,  275,  276,  277,  278,  279,  280,
  281,  282,  283,  284,  125,  286,  287,  288,  289,  290,
   59,  292,  293,  294,  125,  126,  297,  298,  299,  300,
  301,  302,  303,  304,  282,  283,   41,   44,  286,  287,
  288,  291,  282,  283,   41,   93,  286,  287,  288,  297,
  298,  299,  300,  301,  302,  303,  304,  297,  298,  299,
  300,  301,  302,  303,  304,  125,   58,   93,  261,  261,
  262,  263,  264,  265,  266,  267,  268,  269,  270,  271,
  272,  273,  274,  275,  276,  277,  278,  279,  280,  281,
  282,  283,  284,  261,  286,  287,  288,  289,  290,  261,
  292,  293,  294,  125,  126,  297,  298,  299,  300,  301,
  302,  303,  304,  261,  262,  263,  264,  265,  266,  267,
  268,  269,  270,  271,  272,  273,  274,  275,  276,  277,
  278,  279,  280,  281,  282,  283,  284,  261,  286,  287,
  288,  289,  290,  261,  292,  293,  294,  125,  126,  297,
  298,  299,  300,  301,  302,  303,  304,  261,  125,   58,
  261,  262,  263,  264,  265,  266,  267,  268,  269,  270,
  271,  272,  273,  274,  275,  276,  277,  278,  279,  280,
  281,  282,  283,  284,   59,  286,  287,  288,  289,  290,
  296,  292,  293,  294,  125,  126,  297,  298,  299,  300,
  301,  302,  303,  304,   40,   93,   61,   40,   44,  417,
  418,  419,  420,  421,  422,   44,  261,  125,  126,   93,
   40,   93,   58,   59,  258,  125,  126,  272,  273,  274,
  275,  276,  277,  278,  279,  280,   41,   59,  125,  261,
  262,  263,  264,  265,  266,  267,  268,  269,  270,  271,
  272,  273,  274,  275,  276,  277,  278,  279,  280,  281,
  282,  283,  284,   41,  286,  287,  288,  289,  290,  123,
  292,  293,  294,  126,  123,  297,  298,  299,  300,  301,
  302,  303,  304,  125,  261,  125,   41,  264,  265,  266,
  267,  268,  269,  270,  271,  272,  273,  274,  275,  276,
  277,  278,  279,  280,  282,  283,   41,   59,  286,  287,
  288,  125,   41,   41,  125,    0,  261,  229,   12,  297,
  298,  299,  300,  301,  302,  303,  304,  272,  273,  274,
  275,  276,  277,  278,  279,  280,  281,  282,  283,  284,
   40,  112,   40,  465,   44,  290,   44,  292,  406,  360,
  356,  282,  283,  299,   19,  286,  287,  288,   58,   59,
   58,   59,  160,  361,  368,   88,  297,  298,  299,  300,
  301,  302,  303,  304,  282,  283,  471,   19,  286,  287,
  288,   71,  282,  283,   19,  464,  286,  287,  288,  297,
  298,  299,  300,  301,  302,  303,  304,  297,  298,  299,
  300,  301,  302,  303,  304,  104,  138,  183,  261,  262,
  263,  264,  265,  266,  267,  268,  269,  270,  271,  272,
  273,  274,  275,  276,  277,  278,  279,  280,  281,  282,
  283,  284,  185,  257,  174,  254,  416,  290,  264,  292,
  261,  262,  263,  264,  265,  266,  267,  268,  269,  270,
  271,  272,  273,  274,  275,  276,  277,  278,  279,  280,
  281,  337,  339,  284,   -1,   -1,   -1,   -1,  289,  290,
   -1,  292,  293,  294,  261,  262,  263,  264,  265,  266,
  267,  268,  269,  270,  271,  272,  273,  274,  275,  276,
  277,  278,  279,  280,  281,  261,   -1,  284,   -1,   -1,
   -1,   -1,   -1,  290,   -1,  292,  272,  273,  274,  275,
  276,  277,  278,  279,  280,  281,  261,   -1,  284,   -1,
   -1,   -1,   -1,   -1,  290,  261,  292,  272,  273,  274,
  275,  276,  277,  278,  279,  280,  272,  273,  274,  275,
  276,  277,  278,  279,  280,   40,   -1,   40,   -1,   44,
   40,   44,   40,   -1,   44,   40,   44,   40,   -1,   44,
   -1,   44,   -1,   58,   59,   58,   59,   -1,   58,   59,
   58,   59,   -1,   58,   59,   58,   59,   40,   -1,   40,
   -1,   44,   40,   44,   -1,   -1,   44,   -1,   -1,   -1,
   -1,  286,  287,  288,   -1,   58,   59,   58,   59,   -1,
   58,   59,  297,  298,  299,  300,  301,  302,  303,  304,
  262,  263,  264,  265,  266,  267,  268,  269,  270,  271,
   -1,  272,  273,  274,  275,  276,  277,  278,  279,  280,
};
#define YYFINAL 1
#ifndef YYDEBUG
#define YYDEBUG 0
#endif
#define YYMAXTOKEN 310
#if YYDEBUG
char *yyname[] = {
"end-of-file",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
"'!'",0,0,0,"'%'","'&'",0,"'('","')'","'*'","'+'","','","'-'",0,"'/'",0,0,0,0,0,
0,0,0,0,0,"':'","';'","'<'","'='","'>'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,"'['",0,"']'","'^'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,"'{'","'|'","'}'","'~'",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,"CHAR_VAL","INT_VAL",
"DOUBLE_VAL","STRING","IDENTIFIER","FRIEND","TYPEDEF","AUTO","REGISTER",
"STATIC","EXTERN","INLINE","VIRTUAL","CONST","VOLATILE","CHAR","SHORT","INT",
"LONG","SIGNED","UNSIGNED","FLOAT","DOUBLE","VOID","ENUM","CLASS","STRUCT",
"UNION","ASM","PRIVATE","PROTECTED","PUBLIC","OPERATOR","DBL_COLON",
"TRIPLE_DOT","TEMPLATE","NAMESPACE","USING","MUTABLE","THROW","SIGNALS","SLOTS",
"Q_OBJECT","Q_PROPERTY","Q_OVERRIDE","Q_CLASSINFO","Q_ENUMS","Q_SETS","READ",
"WRITE","STORED","DESIGNABLE","SCRIPTABLE","RESET",
};
char *yyrule[] = {
"$accept : declaration_seq",
"declaration_seq :",
"declaration_seq : declaration_seq declaration",
"declaration : class_def",
"declaration : namespace_def",
"declaration : namespace_alias_def",
"declaration : using_declaration",
"declaration : using_directive",
"namespace_def : named_namespace_def",
"namespace_def : unnamed_namespace_def",
"$$1 :",
"$$2 :",
"named_namespace_def : NAMESPACE IDENTIFIER $$1 '{' $$2 namespace_body '}'",
"$$3 :",
"$$4 :",
"unnamed_namespace_def : NAMESPACE $$3 '{' $$4 namespace_body '}'",
"namespace_body : declaration_seq",
"namespace_alias_def : NAMESPACE IDENTIFIER '=' complete_class_name ';'",
"using_directive : USING NAMESPACE",
"using_declaration : USING IDENTIFIER",
"using_declaration : USING DBL_COLON",
"$$5 :",
"class_def : $$5 class_specifier ';'",
"class_name : IDENTIFIER",
"class_name : template_class_name",
"template_class_name : IDENTIFIER '<' template_args '>'",
"template_args :",
"const_expression :",
"def_argument :",
"enumerator_expression :",
"decl_specifier : storage_class_specifier",
"decl_specifier : type_specifier",
"decl_specifier : fct_specifier",
"decl_specifier : FRIEND",
"decl_specifier : TYPEDEF",
"decl_specifiers : decl_specs_opt type_name decl_specs_opt",
"decl_specs_opt :",
"decl_specs_opt : decl_specs",
"decl_specs : decl_specifier",
"decl_specs : decl_specs decl_specifier",
"storage_class_specifier : AUTO",
"storage_class_specifier : REGISTER",
"storage_class_specifier : STATIC",
"storage_class_specifier : EXTERN",
"fct_specifier : INLINE",
"fct_specifier : VIRTUAL",
"type_specifier : CONST",
"type_specifier : VOLATILE",
"type_name : elaborated_type_specifier",
"type_name : complete_class_name",
"type_name : simple_type_names",
"simple_type_names : simple_type_names simple_type_name",
"simple_type_names : simple_type_name",
"simple_type_name : CHAR",
"simple_type_name : SHORT",
"simple_type_name : INT",
"simple_type_name : LONG",
"simple_type_name : SIGNED",
"simple_type_name : UNSIGNED",
"simple_type_name : FLOAT",
"simple_type_name : DOUBLE",
"simple_type_name : VOID",
"template_spec : TEMPLATE '<' template_args '>'",
"opt_template_spec :",
"opt_template_spec : template_spec",
"class_key : opt_template_spec CLASS",
"class_key : opt_template_spec STRUCT",
"complete_class_name : qualified_class_name",
"complete_class_name : DBL_COLON qualified_class_name",
"qualified_class_name : qualified_class_name DBL_COLON class_name",
"qualified_class_name : class_name",
"elaborated_type_specifier : class_key IDENTIFIER",
"elaborated_type_specifier : ENUM IDENTIFIER",
"elaborated_type_specifier : UNION IDENTIFIER",
"argument_declaration_list : arg_declaration_list_opt triple_dot_opt",
"argument_declaration_list : arg_declaration_list ',' TRIPLE_DOT",
"arg_declaration_list_opt :",
"arg_declaration_list_opt : arg_declaration_list",
"triple_dot_opt :",
"triple_dot_opt : TRIPLE_DOT",
"arg_declaration_list : arg_declaration_list ',' argument_declaration",
"arg_declaration_list : argument_declaration",
"argument_declaration : decl_specifiers abstract_decl_opt",
"$$6 :",
"argument_declaration : decl_specifiers abstract_decl_opt '=' $$6 def_argument",
"argument_declaration : decl_specifiers abstract_decl_opt dname abstract_decl_opt",
"$$7 :",
"argument_declaration : decl_specifiers abstract_decl_opt dname abstract_decl_opt '=' $$7 def_argument",
"abstract_decl_opt :",
"abstract_decl_opt : abstract_decl",
"abstract_decl : abstract_decl ptr_operator",
"$$8 :",
"abstract_decl : '[' $$8 const_expression ']'",
"$$9 :",
"abstract_decl : abstract_decl '[' $$9 const_expression ']'",
"abstract_decl : ptr_operator",
"abstract_decl : '(' abstract_decl ')'",
"declarator : dname",
"declarator : declarator ptr_operator",
"$$10 :",
"declarator : declarator '[' $$10 const_expression ']'",
"declarator : '(' declarator ')'",
"dname : IDENTIFIER",
"fct_decl : '(' argument_declaration_list ')' cv_qualifier_list_opt ctor_initializer_opt exception_spec_opt fct_body_or_semicolon",
"fct_name : IDENTIFIER",
"fct_name : IDENTIFIER array_decls",
"$$11 :",
"fct_name : IDENTIFIER '=' $$11 const_expression",
"$$12 :",
"fct_name : IDENTIFIER array_decls '=' $$12 const_expression",
"$$13 :",
"array_decls : '[' $$13 const_expression ']'",
"$$14 :",
"array_decls : array_decls '[' $$14 const_expression ']'",
"ptr_operators_opt :",
"ptr_operators_opt : ptr_operators",
"ptr_operators : ptr_operator",
"ptr_operators : ptr_operators ptr_operator",
"ptr_operator : '*' cv_qualifier_list_opt",
"ptr_operator : '&' cv_qualifier_list_opt",
"cv_qualifier_list_opt :",
"cv_qualifier_list_opt : cv_qualifier_list",
"cv_qualifier_list : cv_qualifier",
"cv_qualifier_list : cv_qualifier_list cv_qualifier",
"cv_qualifier : CONST",
"cv_qualifier : VOLATILE",
"fct_body_or_semicolon : ';'",
"fct_body_or_semicolon : fct_body",
"fct_body_or_semicolon : '=' INT_VAL ';'",
"$$15 :",
"fct_body : '{' $$15 '}'",
"$$16 :",
"class_specifier : full_class_head '{' $$16 opt_obj_member_list '}'",
"class_specifier : class_head",
"class_specifier : class_head '(' IDENTIFIER ')'",
"class_specifier : template_spec whatever",
"whatever : IDENTIFIER",
"whatever : simple_type_name",
"whatever : type_specifier",
"whatever : storage_class_specifier",
"whatever : fct_specifier",
"class_head : class_key qualified_class_name",
"class_head : class_key IDENTIFIER class_name",
"full_class_head : class_head opt_base_spec",
"nested_class_head : class_key qualified_class_name opt_base_spec",
"exception_spec_opt :",
"exception_spec_opt : exception_spec",
"exception_spec : THROW '(' argument_declaration_list ')'",
"ctor_initializer_opt :",
"ctor_initializer_opt : ctor_initializer",
"ctor_initializer : ':' mem_initializer_list",
"mem_initializer_list : mem_initializer",
"mem_initializer_list : mem_initializer ',' mem_initializer_list",
"$$17 :",
"mem_initializer : complete_class_name '(' $$17 const_expression ')'",
"opt_base_spec :",
"opt_base_spec : base_spec",
"opt_obj_member_list :",
"opt_obj_member_list : obj_member_list",
"obj_member_list : obj_member_list obj_member_area",
"obj_member_list : obj_member_area",
"qt_access_specifier : access_specifier",
"qt_access_specifier : SLOTS",
"$$18 :",
"obj_member_area : qt_access_specifier $$18 slot_area",
"$$19 :",
"obj_member_area : SIGNALS $$19 ':' opt_signal_declarations",
"obj_member_area : Q_OBJECT",
"$$20 :",
"$$21 :",
"obj_member_area : Q_PROPERTY $$20 '(' property ')' $$21 opt_property_candidates",
"$$22 :",
"$$23 :",
"obj_member_area : Q_OVERRIDE $$22 '(' property ')' $$23 opt_property_candidates",
"$$24 :",
"$$25 :",
"obj_member_area : Q_CLASSINFO $$24 '(' STRING ',' STRING ')' $$25 opt_property_candidates",
"$$26 :",
"$$27 :",
"obj_member_area : Q_ENUMS $$26 '(' qt_enums ')' $$27 opt_property_candidates",
"$$28 :",
"$$29 :",
"obj_member_area : Q_SETS $$28 '(' qt_sets ')' $$29 opt_property_candidates",
"slot_area : SIGNALS ':'",
"slot_area : SLOTS ':' opt_slot_declarations",
"$$30 :",
"slot_area : ':' $$30 opt_property_candidates",
"slot_area : IDENTIFIER",
"opt_property_candidates :",
"opt_property_candidates : property_candidate_declarations",
"property_candidate_declarations : property_candidate_declarations property_candidate_declaration",
"property_candidate_declarations : property_candidate_declaration",
"property_candidate_declaration : signal_or_slot",
"opt_signal_declarations :",
"opt_signal_declarations : signal_declarations",
"signal_declarations : signal_declarations signal_declaration",
"signal_declarations : signal_declaration",
"signal_declaration : signal_or_slot",
"opt_slot_declarations :",
"opt_slot_declarations : slot_declarations",
"slot_declarations : slot_declarations slot_declaration",
"slot_declarations : slot_declaration",
"slot_declaration : signal_or_slot",
"opt_semicolons :",
"opt_semicolons : opt_semicolons ';'",
"base_spec : ':' base_list",
"base_list : base_list ',' base_specifier",
"base_list : base_specifier",
"qt_macro_name : IDENTIFIER '(' IDENTIFIER ')'",
"qt_macro_name : IDENTIFIER '(' simple_type_name ')'",
"base_specifier : complete_class_name",
"base_specifier : VIRTUAL access_specifier complete_class_name",
"base_specifier : VIRTUAL complete_class_name",
"base_specifier : access_specifier VIRTUAL complete_class_name",
"base_specifier : access_specifier complete_class_name",
"base_specifier : qt_macro_name",
"base_specifier : VIRTUAL access_specifier qt_macro_name",
"base_specifier : VIRTUAL qt_macro_name",
"base_specifier : access_specifier VIRTUAL qt_macro_name",
"base_specifier : access_specifier qt_macro_name",
"access_specifier : PRIVATE",
"access_specifier : PROTECTED",
"access_specifier : PUBLIC",
"operator_name : decl_specs_opt IDENTIFIER ptr_operators_opt",
"operator_name : decl_specs_opt simple_type_name ptr_operators_opt",
"operator_name : '+'",
"operator_name : '-'",
"operator_name : '*'",
"operator_name : '/'",
"operator_name : '%'",
"operator_name : '^'",
"operator_name : '&'",
"operator_name : '|'",
"operator_name : '~'",
"operator_name : '!'",
"operator_name : '='",
"operator_name : '<'",
"operator_name : '>'",
"operator_name : '+' '='",
"operator_name : '-' '='",
"operator_name : '*' '='",
"operator_name : '/' '='",
"operator_name : '%' '='",
"operator_name : '^' '='",
"operator_name : '&' '='",
"operator_name : '|' '='",
"operator_name : '~' '='",
"operator_name : '!' '='",
"operator_name : '=' '='",
"operator_name : '<' '='",
"operator_name : '>' '='",
"operator_name : '<' '<'",
"operator_name : '>' '>'",
"operator_name : '<' '<' '='",
"operator_name : '>' '>' '='",
"operator_name : '&' '&'",
"operator_name : '|' '|'",
"operator_name : '+' '+'",
"operator_name : '-' '-'",
"operator_name : ','",
"operator_name : '-' '>' '*'",
"operator_name : '-' '>'",
"operator_name : '(' ')'",
"operator_name : '[' ']'",
"opt_virtual :",
"opt_virtual : VIRTUAL",
"type_and_name : type_name fct_name",
"type_and_name : fct_name",
"type_and_name : opt_virtual '~' fct_name",
"type_and_name : decl_specs type_name decl_specs_opt ptr_operators_opt fct_name",
"type_and_name : decl_specs type_name",
"type_and_name : type_name ptr_operators fct_name",
"type_and_name : type_name decl_specs ptr_operators_opt fct_name",
"type_and_name : type_name OPERATOR operator_name",
"type_and_name : OPERATOR operator_name",
"type_and_name : decl_specs type_name decl_specs_opt ptr_operators_opt OPERATOR operator_name",
"type_and_name : type_name ptr_operators OPERATOR operator_name",
"type_and_name : type_name decl_specs ptr_operators_opt OPERATOR operator_name",
"signal_or_slot : type_and_name fct_decl opt_semicolons",
"signal_or_slot : type_and_name opt_bitfield ';' opt_semicolons",
"signal_or_slot : type_and_name opt_bitfield ',' member_declarator_list ';' opt_semicolons",
"signal_or_slot : enum_specifier opt_identifier ';' opt_semicolons",
"signal_or_slot : USING complete_class_name ';' opt_semicolons",
"signal_or_slot : USING NAMESPACE complete_class_name ';' opt_semicolons",
"signal_or_slot : NAMESPACE IDENTIFIER '{'",
"signal_or_slot : nested_class_head ';' opt_semicolons",
"$$31 :",
"$$32 :",
"signal_or_slot : nested_class_head '{' $$31 '}' $$32 ';' opt_semicolons",
"member_declarator_list : member_declarator",
"member_declarator_list : member_declarator_list ',' member_declarator",
"member_declarator : declarator",
"$$33 :",
"member_declarator : IDENTIFIER ':' $$33 const_expression",
"$$34 :",
"member_declarator : ':' $$34 const_expression",
"opt_bitfield :",
"$$35 :",
"opt_bitfield : ':' $$35 const_expression",
"enum_specifier : ENUM enum_tail",
"opt_komma :",
"opt_komma : ','",
"enum_tail : IDENTIFIER '{' enum_list opt_komma '}'",
"enum_tail : '{' enum_list opt_komma '}'",
"opt_identifier :",
"opt_identifier : IDENTIFIER",
"enum_list :",
"enum_list : enumerator",
"enum_list : enum_list ',' enumerator",
"enumerator : IDENTIFIER",
"$$36 :",
"enumerator : IDENTIFIER '=' $$36 enumerator_expression",
"$$37 :",
"property : IDENTIFIER IDENTIFIER $$37 prop_statements",
"prop_statements :",
"prop_statements : READ IDENTIFIER prop_statements",
"prop_statements : WRITE IDENTIFIER prop_statements",
"prop_statements : RESET IDENTIFIER prop_statements",
"prop_statements : STORED IDENTIFIER prop_statements",
"prop_statements : DESIGNABLE IDENTIFIER prop_statements",
"prop_statements : SCRIPTABLE IDENTIFIER prop_statements",
"qt_enums :",
"qt_enums : IDENTIFIER qt_enums",
"qt_sets :",
"qt_sets : IDENTIFIER qt_sets",
};
#endif
#ifdef YYSTACKSIZE
#undef YYMAXDEPTH
#define YYMAXDEPTH YYSTACKSIZE
#else
#ifdef YYMAXDEPTH
#define YYSTACKSIZE YYMAXDEPTH
#else
#define YYSTACKSIZE 500
#define YYMAXDEPTH 500
#endif
#endif
int yydebug;
int yynerrs;
int yyerrflag;
int yychar;
short *yyssp;
YYSTYPE *yyvsp;
YYSTYPE yyval;
YYSTYPE yylval;
short yyss[YYSTACKSIZE];
YYSTYPE yyvs[YYSTACKSIZE];
#define yystacksize YYSTACKSIZE
#line 1462 "moc.y"

#if defined(Q_OS_WIN32)
#include <io.h>
#undef isatty
extern "C" int hack_isatty( int )
{
    return 0;
}
#define isatty hack_isatty
#else
#include <unistd.h>
#endif

#include "moc_lex.cpp"

void	  init();				// initialize
void      cleanup();
void	  initClass();				// prepare for new class
void	  generateClass();			// generate C++ code for class
void	  initExpression();			// prepare for new expression
QCString  combinePath( const char *, const char * );

class parser_reg {
 public:
    parser_reg();
    ~parser_reg();

    // some temporary values
    QCString   tmpExpression;			// Used to store the characters the lexer
						// is currently skipping (see addExpressionChar and friends)
    QCString  fileName;				// file name
    QCString  outputFile;				// output file name
    QCString  includeFile;				// name of #include file
    QCString  includePath;				// #include file path
    QCString  qtPath;				// #include qt file path
    int           gen_count; //number of classes generated
    bool	  noInclude;		// no #include <filename>
    bool	  generatedCode;		// no code generated
    bool	  mocError;			// moc parsing error occurred
    bool       hasVariantIncluded;	//whether or not qvariant.h was included yet
    QCString  className;				// name of parsed class
    QCString  superClassName;			// name of first super class
    QStrList  multipleSuperClasses;			// other superclasses
    FuncList  signals;				// signal interface
    FuncList  slots;				// slots interface
    FuncList  propfuncs;				// all possible property access functions
    FuncList  funcs;			// all parsed functions, including signals
    EnumList  enums;				// enums used in properties
    PropList  props;				// list of all properties
    ClassInfoList	infos;				// list of all class infos

// Used to store the values in the Q_PROPERTY macro
    QCString propWrite;				// set function
    QCString propRead;				// get function
    QCString propReset;				// reset function
    QCString propStored;				//
    QCString propDesignable;				// "true", "false" or function or empty if not specified
    QCString propScriptable;				// "true", "false" or function or empty if not specified
    bool propOverride;				// Wether OVERRIDE was detected

    QStrList qtEnums;				// Used to store the contents of Q_ENUMS
    QStrList qtSets;				// Used to store the contents of Q_SETS

};
FILE  *out;					// output file
static parser_reg *g = NULL;

parser_reg::parser_reg() : funcs(TRUE)
{
    gen_count = 0;
    noInclude     = FALSE;		// no #include <filename>
    generatedCode = FALSE;		// no code generated
    mocError = FALSE;			// moc parsing error occurred
    hasVariantIncluded = FALSE;
}


parser_reg::~parser_reg()
{
    slots.clear();
    signals.clear();
    propfuncs.clear();
    funcs.clear();
    infos.clear();
    props.clear();
    infos.clear();
}

int yyparse();

void replace( char *s, char c1, char c2 );

#ifndef MOC_MWERKS_PLUGIN
int main( int argc, char **argv )
{
    init();

    bool autoInclude = TRUE;
    const char *error	     = 0;
    g->qtPath = "";
    for ( int n=1; n<argc && error==0; n++ ) {
	QCString arg = argv[n];
	if ( arg[0] == '-' ) {			// option
	    QCString opt = &arg[1];
	    if ( opt[0] == 'o' ) {		// output redirection
		if ( opt[1] == '\0' ) {
		    if ( !(n < argc-1) ) {
			error = "Missing output-file name";
			break;
		    }
		    g->outputFile = argv[++n];
		} else
		    g->outputFile = &opt[1];
	    } else if ( opt == "i" ) {		// no #include statement
		g->noInclude   = TRUE;
		autoInclude = FALSE;
	    } else if ( opt[0] == 'f' ) {	// produce #include statement
		g->noInclude   = FALSE;
		autoInclude = FALSE;
		if ( opt[1] ) {			// -fsomething.h
		    g->includeFile = &opt[1];
		}
	    } else if ( opt[0] == 'p' ) {	// include file path
		if ( opt[1] == '\0' ) {
		    if ( !(n < argc-1) ) {
			error = "Missing path name for the -p option.";
			break;
		    }
		    g->includePath = argv[++n];
		} else {
		    g->includePath = &opt[1];
		}
	    } else if ( opt[0] == 'q' ) {	// qt include file path
		if ( opt[1] == '\0' ) {
		    if ( !(n < argc-1) ) {
			error = "Missing path name for the -q option.";
			break;
		    }
		    g->qtPath = argv[++n];
		} else {
		    g->qtPath = &opt[1];
		}
		replace(g->qtPath.data(),'\\','/');
		if ( g->qtPath.right(1) != "/" )
		    g->qtPath += '/';
	    } else if ( opt == "v" ) {		// version number
		fprintf( stderr, "Qt Meta Object Compiler version %d"
				 " (Qt %s)\n", formatRevision,
				 QT_VERSION_STR );
		cleanup();
		return 1;
	    } else if ( opt == "k" ) {		// don't stop on errors
		errorControl = TRUE;
	    } else if ( opt == "nw" ) {		// don't display warnings
		displayWarnings = FALSE;
	    } else if ( opt == "ldbg" ) {	// lex debug output
		lexDebug = TRUE;
	    } else if ( opt == "ydbg" ) {	// yacc debug output
		yydebug = TRUE;
	    } else {
		error = "Invalid argument";
	    }
	} else {
	    if ( !g->fileName.isNull() )		// can handle only one file
		error = "Too many input files specified";
	    else
		g->fileName = arg.copy();
	}
    }

    if ( autoInclude ) {
	int ppos = g->fileName.findRev('.');
	if ( ppos != -1 && tolower( g->fileName[ppos + 1] ) == 'h' )
	    g->noInclude = FALSE;
	else
	    g->noInclude = TRUE;
    }
    if ( !g->fileName.isEmpty() && !g->outputFile.isEmpty() &&
	 g->includeFile.isEmpty() && g->includePath.isEmpty() ) {
	g->includeFile = combinePath(g->fileName,g->outputFile);
    }
    if ( g->includeFile.isEmpty() )
	g->includeFile = g->fileName.copy();
    if ( !g->includePath.isEmpty() ) {
	if ( g->includePath.right(1) != "/" )
	    g->includePath += '/';
	g->includeFile = g->includePath + g->includeFile;
    }
    if ( g->fileName.isNull() && !error ) {
	g->fileName = "standard input";
	yyin	 = stdin;
    } else if ( argc < 2 || error ) {		// incomplete/wrong args
	fprintf( stderr, "Qt meta object compiler\n" );
	if ( error )
	    fprintf( stderr, "moc: %s\n", error );
	fprintf( stderr, "Usage:  moc [options] <header-file>\n"
		 "\t-o file  Write output to file rather than stdout\n"
		 "\t-i       Do not generate an #include statement\n"
		 "\t-f[file] Force #include, optional file name\n"
		 "\t-p path  Path prefix for included file\n"
		 "\t-k       Do not stop on errors\n"
		 "\t-nw      Do not display warnings\n"
		 "\t-v       Display version of moc\n" );
	cleanup();
	return 1;
    } else {
	yyin = fopen( (const char *)g->fileName, "r" );
	if ( !yyin ) {
	    fprintf( stderr, "moc: %s: No such file\n", (const char*)g->fileName);
	    cleanup();
	    return 1;
	}
    }
    if ( !g->outputFile.isEmpty() ) {		// output file specified
	out = fopen( (const char *)g->outputFile, "w" );	// create output file
	if ( !out ) {
	    fprintf( stderr, "moc: Cannot create %s\n",
		     (const char*)g->outputFile );
	    cleanup();
	    return 1;
	}
    } else {					// use stdout
	out = stdout;
    }
    yyparse();
    fclose( yyin );
    if ( !g->outputFile.isNull() )
	fclose( out );

    if ( !g->generatedCode && displayWarnings && !g->mocError ) {
	fprintf( stderr, "%s:%d: Warning: %s\n", g->fileName.data(), 0,
		 "No relevant classes found. No output generated." );
    }

    int ret = g->mocError ? 1 : 0;
    cleanup();
    return ret;
}
#else
bool qt_is_gui_used = FALSE;
#include <ctype.h>
#include <stdio.h>
#include <string.h>
#ifdef Q_OS_MAC9
# include <Files.h>
# include <Strings.h>
# include <Errors.h>
# include "Aliases.h"
#endif
#include "CWPluginErrors.h"
#include <CWPlugins.h>
#include "DropInCompilerLinker.h"
#include <stat.h>

const unsigned char *p_str(const char *, int =-1);

CWPluginContext g_ctx;

moc_status do_moc( CWPluginContext ctx, const QCString &fin, const QCString &fout, CWFileSpec *dspec, bool i)
{
    init();

    g_ctx = ctx;
    g->noInclude = i;
    g->fileName = fin;
    g->outputFile = fout;

    if ( !g->fileName.isEmpty() && !g->outputFile.isEmpty() &&
	 g->includeFile.isEmpty() && g->includePath.isEmpty() ) {
	g->includeFile = combinePath(g->fileName,g->outputFile);
    }
    if ( g->includeFile.isEmpty() )
	g->includeFile = g->fileName.copy();
    if ( !g->includePath.isEmpty() ) {
	if ( g->includePath.right(1) != "/" )
	    g->includePath += '/';
	g->includeFile = g->includePath + g->includeFile;
    }

    CWFileInfo fi;
    memset(&fi, 0, sizeof(fi));
	fi.fullsearch = true;
	fi.dependencyType = cwNormalDependency;
	fi.isdependentoffile = kCurrentCompiledFile;
    if(CWFindAndLoadFile( ctx, fin.data(), &fi) != cwNoErr) {
	cleanup();
	return moc_no_source;
    }

    if(dspec) {
	memcpy(dspec, &fi.filespec, sizeof(fi.filespec));
	const unsigned char *f = p_str(fout.data());
	memcpy(dspec->name, f, f[0]+1);
    }
    buf_size_total = fi.filedatalength;
    buf_buffer = fi.filedata;

    QCString path("");
    AliasHandle alias;
    Str63 str;
    AliasInfoType x = 1;
    char tmp[sizeof(Str63)+2];
    if(NewAlias( NULL, &fi.filespec, &alias) != noErr) {
	cleanup();
	return moc_general_error;
    }
    for(;;) {
	 GetAliasInfo(alias, x++, str);
	 if(!str[0])
	    break;
	 strncpy((char *)tmp, (const char *)str+1, str[0]);
	 tmp[str[0]] = '\0';
	 path.prepend(":");
	 path.prepend((char *)tmp);
    }
    path.prepend("MacOS 9:"); //FIXME

    QString inpath = path + fin, outpath = path + fout;
    struct stat istat, ostat;
    if(stat(inpath, &istat) == -1) {
	cleanup();
	return moc_no_source;
    }
    if(stat(outpath, &ostat) == 0 && istat.st_mtime < ostat.st_mtime) {
	cleanup();
	return moc_not_time;
    }

    unlink(outpath.data());
    out = fopen(outpath.data(), "w+");
    if(!out) {
	cleanup();
	return moc_general_error;
    }

    yyparse();
    if(out != stdout)
      fclose(out);

   if(g->mocError || !g->generatedCode) {
	unlink(outpath.data());
	moc_status ret = !g->generatedCode ? moc_no_qobject : moc_parse_error;
	cleanup();
	return ret;
    }

    cleanup();
    return moc_success;
}
#endif
void replace( char *s, char c1, char c2 )
{
    if ( !s )
	return;
    while ( *s ) {
	if ( *s == c1 )
	    *s = c2;
	s++;
    }
}

/*
  This function looks at two file names and returns the name of the
  infile, with a path relative to outfile. Examples:
    /tmp/abc	/tmp/bcd	->	abc
    xyz/a/bc	xyz/b/ac	->	../a/bc
    /tmp/abc	xyz/klm		-)	/tmp/abc
 */

// Code stolen from QDir::isRelativePath
bool isRelativePath( const QString &path )
{
  int len = path.length();
  if ( len == 0 )
    return TRUE;

  int i = 0;
#ifdef WIN32
  if ( path[0].isLetter() && path[1] == ':' )		// drive, e.g. a:
    i = 2;
#endif
  return path[i] != '/' && path[i] != '\\';
}

// Code stolen from QDir::cleanDirPath
QString cleanDirPath( const QCString &filePath )
{
  QString name = filePath;
  QString newPath;

  if ( name.isEmpty() )
    return name;

  // already done before calling this function
  // slashify( name );

  bool addedSeparator;
  if ( isRelativePath(name) ) {
    addedSeparator = TRUE;
    name.insert( 0, '/' );
  } else {
    addedSeparator = FALSE;
  }

  int ePos, pos, upLevel;

  pos = ePos = name.length();
  upLevel = 0;
  int len;

  while ( pos && (pos = name.findRev('/',--pos)) != -1 ) {
    len = ePos - pos - 1;
    if ( len == 2 && name.at(pos + 1) == '.'
      && name.at(pos + 2) == '.' ) {
      upLevel++;
    } else {
      if ( len != 0 && (len != 1 || name.at(pos + 1) != '.') ) {
	if ( !upLevel )
	  newPath = QString::fromLatin1("/")
	  + name.mid(pos + 1, len) + newPath;
	else
	  upLevel--;
      }
    }
    ePos = pos;
  }
  if ( addedSeparator ) {
    while ( upLevel-- )
      newPath.insert( 0, QString::fromLatin1("/..") );
    if ( !newPath.isEmpty() )
      newPath.remove( 0, 1 );
    else
      newPath = QString::fromLatin1(".");
  } else {
    if ( newPath.isEmpty() )
      newPath = QString::fromLatin1("/");
#if defined(Q_FS_FAT) || defined(Q_OS_OS2EMX)
    if ( name[0] == '/' ) {
      if ( name[1] == '/' )		// "\\machine\x\ ..."
	newPath.insert( 0, '/' );
    } else {
      newPath = name.left(2) + newPath;
    }
#endif
  }
  return newPath;
}

#ifndef PATH_MAX
#define PATH_MAX _MAX_PATH
#endif

QCString combinePath( const char *infile, const char *outfile )
{
    QCString a = infile;  replace(a.data(),'\\','/');
    QCString b = outfile; replace(b.data(),'\\','/');
    a = a.stripWhiteSpace();
    b = b.stripWhiteSpace();
    QString aDir( cleanDirPath( a ) );
    a = aDir;
    QString bDir( cleanDirPath( b ) );
    b = bDir;
    int i = 0;
    int ncommondirs = 0;
    while ( a[i] && a[i] == b[i] ) {
	if ( a[i] == '/' && i > 0 )
	    ncommondirs++;
	i++;
    }
    if ( ncommondirs > 0 ) {			// common base directory
	while ( i>=0 ) {
	    if ( a[i] == '/' && b[i] == '/' )
		break;
	    --i;
	}
	++i;
	a = &a[i];
	b = &b[i];
    } else {
	if ( (a[0] == '/') || (isalpha(a[0]) && a[1] == ':') )
	    return a;
	b = &b[i];
    }

    if(b.left(3) == "../") {
	QCString cdir;
	char currentName[PATH_MAX];
	if ( QT_GETCWD(currentName,PATH_MAX) != 0 ) {
	    cdir = QString::fromLatin1(currentName);
	    replace(cdir.data(),'\\','/');
	    if(isRelativePath(cdir))
		fprintf(stderr, "Got relative path from CWD, help!?");
	}
	while(b.left(3) == "../") {
	    int l = cdir.findRev('/');
	    a.prepend(cdir.right(cdir.length() - l - 1) + '/');
	    cdir = cdir.left(l);
	    b = b.right(b.length() - 3);
	}
    }
    QCString r;
    i = b.contains('/');
    while ( i-- > 0 )
	r += "../";
    r += a;
    return r;
}


#define getenv hack_getenv			// workaround for byacc
char *getenv()		     { return 0; }
char *getenv( const char * ) { return 0; }

void init()					// initialize
{
    BEGIN OUTSIDE;
    if(g)
	delete g;
    g = new parser_reg;
    lineNo	 = 1;
    skipClass	 = FALSE;
    skipFunc	 = FALSE;
    tmpArgList	 = new ArgList;
    tmpFunc	 = new Function;
    tmpEnum	 = new Enum;

#ifdef MOC_MWERKS_PLUGIN
    buf_buffer = NULL;
    buf_index = 0;
    buf_size_total = 0;
#endif
}

void cleanup()
{
    delete g;
    g = NULL;

#ifdef MOC_MWERKS_PLUGIN
    if(buf_buffer && g_ctx)
	CWReleaseFileText(g_ctx, buf_buffer);
#endif
}

void initClass()				 // prepare for new class
{
    tmpAccess      = Private;
    subClassPerm       = Private;
    Q_OBJECTdetected   = FALSE;
    Q_PROPERTYdetected = FALSE;
    skipClass	       = FALSE;
    templateClass      = FALSE;
    g->slots.clear();
    g->signals.clear();
    g->propfuncs.clear();
    g->enums.clear();
    g->funcs.clear();
    g->props.clear();
    g->infos.clear();
    g->qtSets.clear();
    g->qtEnums.clear();
    g->multipleSuperClasses.clear();
}

struct NamespaceInfo
{
    QCString name;
    int pLevelOnEntering; // Parenthesis level on entering the namespace
    QDict<char> definedClasses; // Classes defined in the namespace
};

QPtrList<NamespaceInfo> namespaces;

void enterNameSpace( const char *name = 0 )	 // prepare for new class
{
    static bool first = TRUE;
    if ( first ) {
	namespaces.setAutoDelete( TRUE );
	first = FALSE;
    }

    NamespaceInfo *tmp = new NamespaceInfo;
    if ( name )
	tmp->name = name;
    tmp->pLevelOnEntering = namespacePLevel;
    namespaces.append( tmp );
}

void leaveNameSpace()				 // prepare for new class
{
    NamespaceInfo *tmp = namespaces.last();
    namespacePLevel = tmp->pLevelOnEntering;
    namespaces.remove();
}

QCString nameQualifier()
{
    QPtrListIterator<NamespaceInfo> iter( namespaces );
    NamespaceInfo *tmp;
    QCString qualifier = "";
    for( ; (tmp = iter.current()) ; ++iter ) {
	if ( !tmp->name.isNull() ) {  // If not unnamed namespace
	    qualifier += tmp->name;
	    qualifier += "::";
	}
    }
    return qualifier;
}

int openNameSpaceForMetaObject( FILE *out )
{
    int levels = 0;
    QPtrListIterator<NamespaceInfo> iter( namespaces );
    NamespaceInfo *tmp;
    QCString indent = "";
    for( ; (tmp = iter.current()) ; ++iter ) {
	if ( !tmp->name.isNull() ) {  // If not unnamed namespace
	    fprintf( out, "%snamespace %s {\n", (const char *)indent,
		     (const char *) tmp->name );
	    indent += "    ";
	    levels++;
	}
    }
    QCString nm = g->className;
    int pos;
    while( (pos = nm.find( "::" )) != -1 ) {
	QCString spaceName = nm.left( pos );
	nm = nm.right( nm.length() - pos - 2 );
	if ( !spaceName.isEmpty() ) {
	    fprintf( out, "%snamespace %s {\n", (const char *)indent,
		     (const char *) spaceName );
	    indent += "    ";
	    levels++;
	}
    }
    return levels;
}

void closeNameSpaceForMetaObject( FILE *out, int levels )
{
    int i;
    for( i = 0 ; i < levels ; i++ )
	    fprintf( out, "}" );
    if ( levels )
	fprintf( out, "\n" );

}

void selectOutsideClassState()
{
    if ( namespaces.count() == 0 )
	BEGIN OUTSIDE;
    else
	BEGIN IN_NAMESPACE;
}

void registerClassInNamespace()
{
    if ( namespaces.count() == 0 )
	return;
    namespaces.last()->definedClasses.insert((const char *)g->className,(char*)1);
}

//
// Remove white space from SIGNAL and SLOT names.
// This function has been copied from qobject.cpp.
//

inline bool isIdentChar( char x )
{						// Avoid bug in isalnum
    return x == '_' || (x >= '0' && x <= '9') ||
	 (x >= 'a' && x <= 'z') || (x >= 'A' && x <= 'Z');
}

inline bool isSpace( char x )
{
#if defined(Q_CC_BOR)
  /*
    Borland C++ 4.5 has a weird isspace() bug.
    isspace() usually works, but not here.
    This implementation is sufficient for our internal use: rmWS()
  */
    return (uchar) x <= 32;
#else
    return isspace( (uchar) x );
#endif
}

static QCString rmWS( const char *src )
{
    QCString result( qstrlen(src)+1 );
    char *d = result.data();
    char *s = (char *)src;
    char last = 0;
    while( *s && isSpace(*s) )			// skip leading space
	s++;
    while ( *s ) {
	while ( *s && !isSpace(*s) )
	    last = *d++ = *s++;
	while ( *s && isSpace(*s) )
	    s++;
	if ( *s && isIdentChar(*s) && isIdentChar(last) )
	    last = *d++ = ' ';
    }
    result.truncate( (int)(d - result.data()) );
    return result;
}


void initExpression()
{
    g->tmpExpression = "";
}

void addExpressionString( const char *s )
{
    g->tmpExpression += s;
}

void addExpressionChar( const char c )
{
    g->tmpExpression += c;
}

void yyerror( const char *msg )			// print yacc error message
{
    g->mocError = TRUE;
#ifndef MOC_MWERKS_PLUGIN
    fprintf( stderr, "%s:%d: Error: %s\n", g->fileName.data(), lineNo, msg );
#else
    char	msg2[200];
    sprintf(msg2, "%s:%d Error: %s", g->fileName.data(), lineNo, msg);
    CWReportMessage(g_ctx, NULL, msg2, NULL, messagetypeError, 0);
#endif
}

void moc_err( const char *s )
{
    yyerror( s );
    if ( errorControl ) {
	exit( -1 );
    }
}

void moc_err( const char *s1, const char *s2 )
{
    static char tmp[1024];
    sprintf( tmp, s1, s2 );
    yyerror( tmp );
    if ( errorControl ) {
	exit( -1 );
    }
}

void moc_warn( const char *msg )
{
    if ( displayWarnings )
	fprintf( stderr, "%s:%d: Warning: %s\n", g->fileName.data(), lineNo, msg);
}

void moc_warn( char *s1, char *s2 )
{
    static char tmp[1024];
    sprintf( tmp, s1, s2 );
    if ( displayWarnings )
	fprintf( stderr, "%s:%d: Warning: %s\n", g->fileName.data(), lineNo, tmp);
}

static bool suppress_func_warn = FALSE;
void func_warn( const char *msg )
{
    if ( !suppress_func_warn )
	moc_warn( msg );
    skipFunc = TRUE;
}

void operatorError()
{
    if ( !suppress_func_warn )
	moc_warn("Operator functions cannot be signals or slots.");
    skipFunc = TRUE;
}

#ifndef yywrap
int yywrap()					// more files?
{
    return 1;					// end of file
}
#endif

char *stradd( const char *s1, const char *s2 )	// adds two strings
{
    char *n = new char[qstrlen(s1)+qstrlen(s2)+1];
    qstrcpy( n, s1 );
    strcat( n, s2 );
    return n;
}

char *stradd( const char *s1, const char *s2, const char *s3 )// adds 3 strings
{
    char *n = new char[qstrlen(s1)+qstrlen(s2)+qstrlen(s3)+1];
    qstrcpy( n, s1 );
    strcat( n, s2 );
    strcat( n, s3 );
    return n;
}

char *stradd( const char *s1, const char *s2,
	      const char *s3, const char *s4 )// adds 4 strings
{
    char *n = new char[qstrlen(s1)+qstrlen(s2)+qstrlen(s3)+qstrlen(s4)+1];
    qstrcpy( n, s1 );
    strcat( n, s2 );
    strcat( n, s3 );
    strcat( n, s4 );
    return n;
}


char *straddSpc( const char *s1, const char *s2 )
{
    char *n = new char[qstrlen(s1)+qstrlen(s2)+2];
    qstrcpy( n, s1 );
    strcat( n, " " );
    strcat( n, s2 );
    return n;
}

char *straddSpc( const char *s1, const char *s2, const char *s3 )
{
    char *n = new char[qstrlen(s1)+qstrlen(s2)+qstrlen(s3)+3];
    qstrcpy( n, s1 );
    strcat( n, " " );
    strcat( n, s2 );
    strcat( n, " " );
    strcat( n, s3 );
    return n;
}

char *straddSpc( const char *s1, const char *s2,
	      const char *s3, const char *s4 )
{
    char *n = new char[qstrlen(s1)+qstrlen(s2)+qstrlen(s3)+qstrlen(s4)+4];
    qstrcpy( n, s1 );
    strcat( n, " " );
    strcat( n, s2 );
    strcat( n, " " );
    strcat( n, s3 );
    strcat( n, " " );
    strcat( n, s4 );
    return n;
}

// Generate C++ code for building member function table


/*
  We call B::qt_invoke() rather than A::B::qt_invoke() to
  work around a bug in MSVC 6. The bug occurs if the
  super-class is in a namespace and the sub-class isn't.

  Exception: If the superclass has the same name as the subclass, we
  want non-MSVC users to have a working generated files.
*/
QCString purestSuperClassName()
{
    QCString sc = g->superClassName;
    QCString c = g->className;
    int pos = sc.findRev( "::" );
    if ( pos != -1 ) {
	sc = sc.right( sc.length() - pos - 2 );
	pos = c.findRev( "::" );
	if ( pos != -1 )
	    c = c.right( c.length() - pos - 2 );
	if ( sc == c )
	    sc = g->superClassName;
    }
    return sc;
}

QCString qualifiedClassName()
{
    return nameQualifier() + g->className;
}

const int Slot_Num = 1;
const int Signal_Num = 2;
const int Prop_Num = 3;

void generateFuncs( FuncList *list, const char *functype, int num )
{
    Function *f;
    for ( f=list->first(); f; f=list->next() ) {
	bool hasReturnValue = f->type != "void" && (validUType( f->type ) || isVariantType( f->type) );

	if ( hasReturnValue || !f->args->isEmpty() ) {
	    fprintf( out, "    static const QUParameter param_%s_%d[] = {\n", functype, list->at() );
	    if ( hasReturnValue ) {
		if ( validUType( f->type ) )
		    fprintf( out, "\t{ 0, &static_QUType_%s, %s, QUParameter::Out }", uType(f->type).data(), uTypeExtra(f->type).data() );
		else
		    fprintf( out, "\t{ 0, &static_QUType_QVariant, %s, QUParameter::Out }", uTypeExtra(f->type).data() );
		if ( !f->args->isEmpty() )
		    fprintf( out, ",\n" );
	    }
	    Argument* a = f->args->first();
	    while ( a ) {
		QCString type = a->leftType + ' ' + a->rightType;
		type = type.simplifyWhiteSpace();
		if( a->name.isEmpty() )
		    fprintf( out, "\t{ 0, &static_QUType_%s, %s, QUParameter::%s }",
			     uType( type ).data(), uTypeExtra( type ).data(),
			     isInOut( type ) ? "InOut" : "In" );
		else
		    fprintf( out, "\t{ \"%s\", &static_QUType_%s, %s, QUParameter::%s }",
			     a->name.data(), uType( type ).data(), uTypeExtra( type ).data(),
			     isInOut( type ) ? "InOut" : "In" );
		a = f->args->next();
		if ( a )
		    fprintf( out, ",\n" );
	    }
	    fprintf( out, "\n    };\n");
	}

	fprintf( out, "    static const QUMethod %s_%d = {", functype, list->at() );
	int n = f->args->count();
	if ( hasReturnValue )
	    n++;
	fprintf( out, "\"%s\", %d,", f->name.data(), n );
	if ( n )
	    fprintf( out, " param_%s_%d };\n", functype, list->at() );
	else
	    fprintf( out, " 0 };\n" );

	QCString typstr = "";
	int count = 0;
	Argument *a = f->args->first();
	while ( a ) {
	    if ( !a->leftType.isEmpty() || ! a->rightType.isEmpty() ) {
		if ( count++ )
		    typstr += ",";
		typstr += a->leftType;
		typstr += a->rightType;
	    }
	    a = f->args->next();
	}
	f->signature = f->name;
	f->signature += "(";
	f->signature += typstr;
	f->signature += ")";
    }
    if ( list->count() ) {
	fprintf(out,"    static const QMetaData %s_tbl[] = {\n", functype );
	f = list->first();
	while ( f ) {
	    fprintf( out, "\t{ \"%s\",", f->signature.data() );
	    fprintf( out, " &%s_%d,", functype, list->at() );
	    fprintf( out, " QMetaData::%s }", f->accessAsString() );
	    f = list->next();
	    if ( f )
		fprintf( out, ",\n");
	}
	fprintf( out, "\n    };\n" );
    }
}


int enumIndex( const char* type )
{
    int index = 0;
    for( QPtrListIterator<Enum> lit( g->enums ); lit.current(); ++lit ) {
	if ( lit.current()->name == type )
	    return index;
	index++;
    }
    return -1;
}

bool isEnumType( const char* type )
{
    return enumIndex( type ) >= 0 ||  ( g->qtEnums.contains( type ) || g->qtSets.contains( type ) );
}

bool isPropertyType( const char* type )
{
    if ( isVariantType( type ) )
	return TRUE;

    return isEnumType( type );
}

int generateEnums()
{
    if ( g->enums.count() == 0 )
	return 0;

    fprintf( out, "#ifndef QT_NO_PROPERTIES\n" );
    int i = 0;
    for ( QPtrListIterator<Enum> it( g->enums ); it.current(); ++it, ++i ) {
	fprintf( out, "    static const QMetaEnum::Item enum_%i[] = {\n", i );
	int k = 0;
	for( QStrListIterator eit( *it.current() ); eit.current(); ++eit, ++k ) {
	    if ( k )
		fprintf( out, ",\n" );
	    fprintf( out, "\t{ \"%s\",  (int) %s::%s }", eit.current(), (const char*) g->className, eit.current() );
	}
	fprintf( out, "\n    };\n" );
    }
    fprintf( out, "    static const QMetaEnum enum_tbl[] = {\n" );
    i = 0;
    for ( QPtrListIterator<Enum> it2( g->enums ); it2.current(); ++it2, ++i ) {
	if ( i )
	    fprintf( out, ",\n" );
	fprintf( out, "\t{ \"%s\", %u, enum_%i, %s }",
		 (const char*)it2.current()->name,
		 it2.current()->count(),
		 i,
		 it2.current()->set ? "TRUE" : "FALSE" );
    }
    fprintf( out, "\n    };\n" );
    fprintf( out, "#endif // QT_NO_PROPERTIES\n" );

    return g->enums.count();
}

int generateProps()
{
    //
    // Resolve and verify property access functions
    //
    for( QPtrListIterator<Property> it( g->props ); it.current(); ) {
	Property* p = it.current();
	++it;

	// verify get function
	if ( !p->get.isEmpty() ) {
	    FuncList candidates = g->propfuncs.find( p->get );
	    for ( Function* f = candidates.first(); f; f = candidates.next() ) {
		if ( f->qualifier != "const" ) // get functions must be const
		    continue;
		if ( f->args && !f->args->isEmpty() ) // and must not take any arguments
		    continue;
		QCString tmp = f->type;
		Property::Specification spec = Property::Unspecified;
		if ( p->type == "QCString" && (tmp == "const char*" || tmp == "const char *" ) ) {
		    tmp = "QCString";
		    spec = Property::ConstCharStar;
		} else if ( tmp.right(1) == "&" ) {
		    tmp = tmp.left( tmp.length() - 1 );
		    spec = Property::Reference;
		} else if ( tmp.right(1) == "*" ) {
		    tmp = tmp.left( tmp.length() - 1 );
		    spec = Property::Pointer;
		} else {
		    spec = Property::Class;
		}
		if ( tmp.left(6) == "const " )
		    tmp = tmp.mid( 6, tmp.length() - 6 );
		tmp = tmp.simplifyWhiteSpace();
		if ( p->type == tmp ) {
		    // If it is an enum then it may not be a set
		    bool ok = TRUE;
		    for( QPtrListIterator<Enum> lit( g->enums ); lit.current(); ++lit )
			if ( lit.current()->name == p->type && lit.current()->set )
			    ok = FALSE;
		    if ( !ok ) continue;
		    p->gspec = spec;
		    p->getfunc = f;
		    p->oredEnum = 0;
		    break;
		}
		else if ( !isVariantType( p->type ) ) {
		    if ( tmp == "int" || tmp == "uint" || tmp == "unsigned int" ) {
			// Test whether the enum is really a set (unfortunately we don't know enums of super classes)
			bool ok = TRUE;
			for( QPtrListIterator<Enum> lit( g->enums ); lit.current(); ++lit )
			    if ( lit.current()->name == p->type && !lit.current()->set )
				ok = FALSE;
			if ( !ok ) continue;
			p->gspec = spec;
			p->getfunc = f;
			p->oredEnum = 1;
			p->enumgettype = tmp;
		    }
		}
	    }
	    if ( p->getfunc == 0 ) {
		if ( displayWarnings ) {

		    // Is the type a set, that means, mentioned in Q_SETS?
		    bool set = FALSE;
		    for( QPtrListIterator<Enum> lit( g->enums ); lit.current(); ++lit )
			if ( lit.current()->name == p->type && lit.current()->set )
			    set = TRUE;

		    fprintf( stderr, "%s:%d: Warning: Property '%s' not available.\n",
			     g->fileName.data(), p->lineNo, (const char*) p->name );
		    fprintf( stderr, "   Have been looking for public get functions \n");
		    if ( !set ) {
			fprintf( stderr,
			     "      %s %s() const\n"
			     "      %s& %s() const\n"
			     "      const %s& %s() const\n"
			     "      %s* %s() const\n",
			     (const char*) p->type, (const char*) p->get,
			     (const char*) p->type, (const char*) p->get,
			     (const char*) p->type, (const char*) p->get,
			     (const char*) p->type, (const char*) p->get );
		    }
		    if ( set || !isPropertyType( p->type ) ) {
			fprintf( stderr,
			     "      int %s() const\n"
			     "      uint %s() const\n"
			     "      unsigned int %s() const\n",
			     (const char*) p->get,
			     (const char*) p->get,
			     (const char*) p->get );
		    }
		    if ( p->type == "QCString" )
			fprintf( stderr, "      const char* %s() const\n",
				 (const char*)p->get );

		    if ( candidates.isEmpty() ) {
			fprintf( stderr, "   but found nothing.\n");
		    } else {
			fprintf( stderr, "   but only found the missmatching candidate(s)\n");
			for ( Function* f = candidates.first(); f; f = candidates.next() ) {
			    QCString typstr = "";
			    Argument *a = f->args->first();
			    int count = 0;
			    while ( a ) {
				if ( !a->leftType.isEmpty() || ! a->rightType.isEmpty() ) {
				    if ( count++ )
					typstr += ",";
				    typstr += a->leftType;
				    typstr += a->rightType;
				}
				a = f->args->next();
			    }
			    fprintf( stderr, "      %s:%d: %s %s(%s) %s\n", g->fileName.data(), f->lineNo,
				     (const char*) f->type,(const char*) f->name, (const char*) typstr,
				     f->qualifier.isNull()?"":(const char*) f->qualifier );
			}
		    }
		}
	    }
	}

	// verify set function
	if ( !p->set.isEmpty() ) {
	    FuncList candidates = g->propfuncs.find( p->set );
	    for ( Function* f = candidates.first(); f; f = candidates.next() ) {
		if ( !f->args || f->args->isEmpty() )
		    continue;
		QCString tmp = f->args->first()->leftType;
		tmp = tmp.simplifyWhiteSpace();
		Property::Specification spec = Property::Unspecified;
		if ( tmp.right(1) == "&" ) {
		    tmp = tmp.left( tmp.length() - 1 );
		    spec = Property::Reference;
		}
		else {
		    spec = Property::Class;
		}
		if ( p->type == "QCString" && (tmp == "const char*" || tmp == "const char *" ) ) {
		    tmp = "QCString";
		    spec = Property::ConstCharStar;
		}
		if ( tmp.left(6) == "const " )
		    tmp = tmp.mid( 6, tmp.length() - 6 );
		tmp = tmp.simplifyWhiteSpace();

		if ( p->type == tmp && f->args->count() == 1 ) {
		    // If it is an enum then it may not be a set
		    if ( p->oredEnum == 1 )
			continue;
		    bool ok = TRUE;
		    for( QPtrListIterator<Enum> lit( g->enums ); lit.current(); ++lit )
			if ( lit.current()->name == p->type && lit.current()->set )
			    ok = FALSE;
		    if ( !ok ) continue;
		    p->sspec = spec;
		    p->setfunc = f;
		    p->oredEnum = 0;
		    break;
		} else if ( !isVariantType( p->type ) && f->args->count() == 1 ) {
		    if ( tmp == "int" || tmp == "uint" || tmp == "unsigned int" ) {
			if ( p->oredEnum == 0 )
			    continue;
			// Test wether the enum is really a set (unfortunately we don't know enums of super classes)
			bool ok = TRUE;
			for( QPtrListIterator<Enum> lit( g->enums ); lit.current(); ++lit )
			    if ( lit.current()->name == p->type && !lit.current()->set )
				ok = FALSE;
			if ( !ok ) continue;
			p->sspec = spec;
			p->setfunc = f;
			p->oredEnum = 1;
			p->enumsettype = tmp;
		    }
		}
	    }
	    if ( p->setfunc == 0 ) {
		if ( displayWarnings ) {

		    // Is the type a set, that means, mentioned in Q_SETS ?
		    bool set = FALSE;
		    for( QPtrListIterator<Enum> lit( g->enums ); lit.current(); ++lit )
			if ( lit.current()->name == p->type && lit.current()->set )
			    set = TRUE;

		    fprintf( stderr, "%s:%d: Warning: Property '%s' not writable.\n",
			     g->fileName.data(), p->lineNo, (const char*) p->name );
		    fprintf( stderr, "   Have been looking for public set functions \n");
		    if ( !set && p->oredEnum != 1 ) {
			fprintf( stderr,
			     "      void %s( %s )\n"
			     "      void %s( %s& )\n"
			     "      void %s( const %s& )\n",
			     (const char*) p->set, (const char*) p->type,
			     (const char*) p->set, (const char*) p->type,
			     (const char*) p->set, (const char*) p->type );
		    }
		    if ( set || ( !isPropertyType( p->type ) && p->oredEnum != 0 ) ) {
			fprintf( stderr,
			     "      void %s( int )\n"
			     "      void %s( uint )\n"
			     "      void %s( unsigned int )\n",
			     (const char*) p->set,
			     (const char*) p->set,
			     (const char*) p->set );
		    }

		    if ( p->type == "QCString" )
			fprintf( stderr, "      void %s( const char* ) const\n",
				 (const char*) p->set );

		    if ( !candidates.isEmpty() ) {
			fprintf( stderr, "   but only found the missmatching candidate(s)\n");
			for ( Function* f = candidates.first(); f; f = candidates.next() ) {
			    QCString typstr = "";
			    Argument *a = f->args->first();
			    int count = 0;
			    while ( a ) {
				if ( !a->leftType.isEmpty() || ! a->rightType.isEmpty() ) {
				    if ( count++ )
					typstr += ",";
				    typstr += a->leftType;
				    typstr += a->rightType;
				}
				a = f->args->next();
			    }
			    fprintf( stderr, "      %s:%d: %s %s(%s)\n", g->fileName.data(), f->lineNo,
				     (const char*) f->type,(const char*) f->name, (const char*) typstr );
			}
		    }
		}
	    }
	}
    }


    if ( displayWarnings && !Q_OBJECTdetected )
	moc_err("The declaration of the class \"%s\" contains properties"
		" but no Q_OBJECT macro.", g->className.data());

    //
    // Create meta data
    //
    if ( g->props.count() )   {
	fprintf( out, "#ifndef QT_NO_PROPERTIES\n" );
	
/*	
	fprintf( out, "    int id = parentObject->propertyOffset() + parentObject->numProperties();\n");

	
	fprintf( out, "    static QMetaProperty props_tbl[%d]; ", g->props.count() );
	fprintf( out, "QMetaProperty *p; int e = 0;\n" );
	for( QPtrListIterator<Property> it( g->props ); it.current(); ++it ) {

	    fprintf( out, "    (p=&props_tbl[e++])->t = \"%s\"; ", it.current()->type.data() );
	    fprintf( out, "p->n = \"%s\"; ", it.current()->name.data() );
	    fprintf( out, "p->id = id++;\n" );

	    QCString flags;
	    if ( !isVariantType( it.current()->type ) ) {
		flags += "QMetaProperty::EnumOrSet|";
		int enumpos = -1;
		int k = 0;
		for( QPtrListIterator<Enum> eit( g->enums ); eit.current(); ++eit, ++k ) {
		    if ( eit.current()->name == it.current()->type )
			enumpos = k;
		}

		// Is it an enum of this class ?
		if ( enumpos != -1 )
		    fprintf( out, "    p->enumData = &enum_tbl[%i];\n", enumpos );
		else
		    fprintf( out, "    p->enumData = parentObject->enumerator( \"%s\", TRUE );\n", it.current()->type.data() );
	    }

	    if ( it.current()->getfunc )
		flags += "QMetaProperty::Readable|";
	    if ( it.current()->setfunc )
		flags += "QMetaProperty::Writable|";
	    if ( it.current()->stdSet() )
		flags += "QMetaProperty::StdSet|";

	    if ( !flags.isEmpty() ) {
		if ( flags[ (int) flags.length() - 1] == '|' )
		    flags.remove( flags.length()-1, 1);
		fprintf( out, "    p->setFlags(%s);\n", flags.data() );
	    }

	    if ( it.current()->override ) {
		fprintf( out, "    p->p = parentObject->property( parentObject->findProperty( \"%s\", TRUE ), TRUE );\n", it.current()->name.data() );
		flags = "";
		if ( !it.current()->getfunc )
		    flags += "QMetaProperty::Readable|";
		if ( !it.current()->setfunc )
		    flags += "QMetaProperty::Writable|QMetaProperty::StdSet|";
		if ( flags[ (int) flags.length() - 1] == '|' )
		    flags.remove( flags.length()-1, 1);
		if (!flags.isEmpty() ) {
		    if ( flags[ (int) flags.length() - 1] == '|' )
			flags.remove( flags.length()-1, 1);
		    fprintf( out, "    p->copyFlags(%s);\n", flags.data() );
		}
	    }
	}
	
*/

	fprintf( out, "    static const QMetaProperty props_tbl[%d] = {\n ", g->props.count() );
	for( QPtrListIterator<Property> it( g->props ); it.current(); ++it ) {

	    fprintf( out, "\t{ \"%s\",\"%s\", ", it.current()->type.data(), it.current()->name.data() );
	    int flags = Invalid;
	    if ( !isVariantType( it.current()->type ) )
		flags |= EnumOrSet;
	    if ( it.current()->getfunc )
		flags |= Readable;
	    if ( it.current()->setfunc ) {
		flags |= Writable;
		if ( it.current()->stdSet() )
		    flags |= StdSet;
	    }
	    if ( it.current()->override )
		flags |= Override;

	    fprintf( out, "%d, ", flags );
	    fprintf( out, "&%s::metaObj, ", (const char*) qualifiedClassName() );
	    if ( !isVariantType( it.current()->type ) ) {
		int enumpos = -1;
		int k = 0;
		for( QPtrListIterator<Enum> eit( g->enums ); eit.current(); ++eit, ++k ) {
		    if ( eit.current()->name == it.current()->type )
			enumpos = k;
		}

		// Is it an enum of this class ?
		if ( enumpos != -1 )
		    fprintf( out, "&enum_tbl[%i], ", enumpos );
		else
		    fprintf( out, "0, ");
	    } else {
		fprintf( out, "0, ");
	    }
	    fprintf( out, "-1 }" );
	    if ( !it.atLast() )
		fprintf( out, ",\n" );
	    else
		fprintf( out, "\n" );
	}
	fprintf( out, "    };\n" );
	fprintf( out, "#endif // QT_NO_PROPERTIES\n" );
    }

    return g->props.count();
}



int generateClassInfos()
{
    if ( g->infos.isEmpty() )
	return 0;

    if ( displayWarnings && !Q_OBJECTdetected )
	moc_err("The declaration of the class \"%s\" contains class infos"
		" but no Q_OBJECT macro.", g->className.data());

    fprintf( out, "    static const QClassInfo classinfo_tbl[] = {\n" );
    int i = 0;
    for( QPtrListIterator<ClassInfo> it( g->infos ); it.current(); ++it, ++i ) {
	if ( i )
	    fprintf( out, ",\n" );
	fprintf( out, "\t{ \"%s\", \"%s\" }", it.current()->name.data(),it.current()->value.data() );
    }
    fprintf( out, "\n    };\n" );
    return i;
}


void generateClass()		      // generate C++ source code for a class
{
    const char *hdr1 = "/****************************************************************************\n"
		 "** %s meta object code from reading C++ file '%s'\n**\n";
    const char *hdr2 = "** Created: %s\n"
		 "**      by: The Qt MOC ($Id:  qt/moc_yacc.cpp   3.0.2   edited Feb 18 13:45 $)\n**\n";
    const char *hdr3 = "** WARNING! All changes made in this file will be lost!\n";
    const char *hdr4 = "*****************************************************************************/\n\n";
    int   i;

    if ( skipClass )				// don't generate for class
	return;

    if ( !Q_OBJECTdetected ) {
	if ( g->signals.count() == 0 && g->slots.count() == 0 && g->props.count() == 0 && g->infos.count() == 0 )
	    return;
	if ( displayWarnings && (g->signals.count() + g->slots.count()) != 0 )
	    moc_err("The declaration of the class \"%s\" contains signals "
		    "or slots\n\t but no Q_OBJECT macro.", g->className.data());
    } else {
	if ( g->superClassName.isEmpty() )
	    moc_err("The declaration of the class \"%s\" contains the\n"
		    "\tQ_OBJECT macro but does not inherit from any class!\n"
		    "\tInherit from QObject or one of its descendants"
		    " or remove Q_OBJECT.", g->className.data() );
    }
    if ( templateClass ) {			// don't generate for class
	moc_err( "Sorry, Qt does not support templates that contain\n"
		 "\tsignals, slots or Q_OBJECT." );
	return;
    }
    g->generatedCode = TRUE;
    g->gen_count++;

    if ( g->gen_count == 1 ) {			// first class to be generated
	QDateTime dt = QDateTime::currentDateTime();
	QCString dstr = dt.toString().ascii();
	QCString fn = g->fileName;
	i = g->fileName.length()-1;
	while ( i>0 && g->fileName[i-1] != '/' && g->fileName[i-1] != '\\' )
	    i--;				// skip path
	if ( i >= 0 )
	    fn = &g->fileName[i];
	fprintf( out, hdr1, (const char*)qualifiedClassName(),(const char*)fn);
	fprintf( out, hdr2, (const char*)dstr );
	fprintf( out, hdr3 );
	fprintf( out, hdr4 );
	if ( !g->noInclude ) {
	    /*
	      The header file might be a Qt header file with QT_NO_COMPAT
	      macros around signals, slots or properties. Without the #undef,
	      we cannot compile Qt itself with QT_NO_COMPAT.

	      Header files of libraries build around Qt can also use
	      QT_NO_COMPAT, so this #undef might be beneficial to users of Qt,
	      and not only to developers of Qt.
	    */
	    fprintf( out, "#undef QT_NO_COMPAT\n" );
	    fprintf( out, "#include \"%s\"\n", (const char*)g->includeFile );
	}
	fprintf( out, "#include <%sqmetaobject.h>\n", (const char*)g->qtPath );
	fprintf( out, "#include <%sqapplication.h>\n\n", (const char*)g->qtPath );
	fprintf( out, "#include <%sprivate/qucomextra_p.h>\n", (const char*)g->qtPath );
	fprintf( out, "#if !defined(Q_MOC_OUTPUT_REVISION) || (Q_MOC_OUTPUT_REVISION != %d)\n", formatRevision );
	fprintf( out, "#error \"This file was generated using the moc from %s."
		 " It\"\n#error \"cannot be used with the include files from"
		 " this version of Qt.\"\n#error \"(The moc has changed too"
		 " much.)\"\n", QT_VERSION_STR );
	fprintf( out, "#endif\n\n" );
    } else {
	fprintf( out, "\n\n" );
    }

    if ( !g->hasVariantIncluded ) {
	bool needToIncludeVariant = !g->props.isEmpty();
	for ( Function* f =g->slots.first(); f && !needToIncludeVariant; f=g->slots.next() )
	    needToIncludeVariant = ( f->type != "void" && !validUType( f->type ) && isVariantType( f->type) );

	if ( needToIncludeVariant ) {
	    fprintf( out, "#include <%sqvariant.h>\n", (const char*)g->qtPath );
	    g->hasVariantIncluded = TRUE;
	}
    }

    bool isQObject =  g->className == "QObject" ;


//
// Generate virtual function className()
//
    fprintf( out, "const char *%s::className() const\n{\n    ",
	     (const char*)qualifiedClassName() );
    fprintf( out, "return \"%s\";\n}\n\n", (const char*)qualifiedClassName() );

//
// Generate static metaObj variable
//
    fprintf( out, "QMetaObject *%s::metaObj = 0;\n", (const char*)qualifiedClassName());

//
// Generate static cleanup object variable
//
    QCString cleanup = qualifiedClassName().copy();
    for ( int cnpos = 0; cnpos < cleanup.length(); cnpos++ ) {
	if ( cleanup[cnpos] == ':' )
	    cleanup[cnpos] = '_';
    }

    fprintf( out, "static QMetaObjectCleanUp cleanUp_%s;\n\n", (const char*) cleanup );

//
// Generate tr and trUtf8 member functions
//
    fprintf( out, "#ifndef QT_NO_TRANSLATION\n" );
    fprintf( out, "QString %s::tr( const char *s, const char *c )\n{\n",
	     (const char*)qualifiedClassName() );
    fprintf( out, "    if ( qApp )\n" );
    fprintf( out, "\treturn qApp->translate( \"%s\", s, c,"
		  " QApplication::DefaultCodec );\n",
	     (const char*)qualifiedClassName() );
    fprintf( out, "    else\n" );
    fprintf( out, "\treturn QString::fromLatin1( s );\n");
    fprintf( out, "}\n" );
    fprintf( out, "#ifndef QT_NO_TRANSLATION_UTF8\n" );
    fprintf( out, "QString %s::trUtf8( const char *s, const char *c )\n{\n",
	     (const char*)qualifiedClassName() );
    fprintf( out, "    if ( qApp )\n" );
    fprintf( out, "\treturn qApp->translate( \"%s\", s, c,"
		  " QApplication::UnicodeUTF8 );\n",
	     (const char*)qualifiedClassName() );
    fprintf( out, "    else\n" );
    fprintf( out, "\treturn QString::fromUtf8( s );\n" );
    fprintf( out, "}\n" );
    fprintf( out, "#endif // QT_NO_TRANSLATION_UTF8\n\n" );
    fprintf( out, "#endif // QT_NO_TRANSLATION\n\n" );

//
// Generate staticMetaObject member function
//
    fprintf( out, "QMetaObject* %s::staticMetaObject()\n{\n", (const char*)qualifiedClassName() );
    fprintf( out, "    if ( metaObj )\n\treturn metaObj;\n" );
    if ( isQObject )
	fprintf( out, "    QMetaObject* parentObject = staticQtMetaObject();\n" );
    else if ( !g->superClassName.isEmpty() )
	fprintf( out, "    QMetaObject* parentObject = %s::staticMetaObject();\n", (const char*)g->superClassName );
    else
	fprintf( out, "    QMetaObject* parentObject = 0;\n" );

//
// Build the classinfo array
//
   int n_infos = generateClassInfos();

// Build the enums array
// Enums HAVE to be generated BEFORE the properties and slots
//
    int n_enums = generateEnums();

//
// Build slots array in staticMetaObject()
//
    generateFuncs( &g->slots, "slot", Slot_Num );

//
// Build signals array in staticMetaObject()
//
    generateFuncs( &g->signals, "signal", Signal_Num );

//
// Build property array in staticMetaObject()
//
   int n_props = generateProps();

//
// Finally code to create and return meta object
//
    fprintf( out, "    metaObj = QMetaObject::new_metaobject(\n"
		  "\t\"%s\", parentObject,\n", (const char*)qualifiedClassName() );

    if ( g->slots.count() )
	fprintf( out, "\tslot_tbl, %d,\n", g->slots.count() );
    else
	fprintf( out, "\t0, 0,\n" );

    if ( g->signals.count() )
	fprintf( out, "\tsignal_tbl, %d,\n", g->signals.count() );
    else
	fprintf( out, "\t0, 0,\n" );

    fprintf( out, "#ifndef QT_NO_PROPERTIES\n" );
    if ( n_props )
	fprintf( out, "\tprops_tbl, %d,\n", n_props );
    else
	fprintf( out, "\t0, 0,\n" );
    if ( n_enums )
	fprintf( out, "\tenum_tbl, %d,\n", n_enums );
    else
	fprintf( out, "\t0, 0,\n" );
    fprintf( out, "#endif // QT_NO_PROPERTIES\n" );

    if ( n_infos )
	fprintf( out, "\tclassinfo_tbl, %d );\n", n_infos );
    else
	fprintf( out, "\t0, 0 );\n" );


//
// Setup cleanup handler and return meta object
//
    fprintf( out, "    cleanUp_%s.setMetaObject( metaObj );\n", cleanup.data() );
    fprintf( out, "    return metaObj;\n}\n" );

//
// End of function staticMetaObject()
//

//
// Generate smart cast function
//
    fprintf( out, "\nvoid* %s::qt_cast( const char* clname )\n{\n",
	     (const char*)qualifiedClassName() );
    fprintf( out, "    if ( !qstrcmp( clname, \"%s\" ) ) return (%s*)this;\n",
	     (const char*) qualifiedClassName(), (const char*) qualifiedClassName() );
    if ( !g->multipleSuperClasses.isEmpty() ) {
	for ( const char* cname = g->multipleSuperClasses.first(); cname; cname = g->multipleSuperClasses.next() )
	    fprintf( out, "    if ( !qstrcmp( clname, \"%s\" ) ) return (%s*)this;\n", cname, cname );
    }
    if ( !g->superClassName.isEmpty() && !isQObject )
	fprintf( out, "    return %s::qt_cast( clname );\n",  (const char*)purestSuperClassName() );
    else
	fprintf( out, "    return 0;\n" );
    fprintf( out, "}\n" );

//
// Generate internal signal functions
//
    Function *f;
    f = g->signals.first();			// make internal signal methods
    static bool included_list_headers = FALSE;
    int sigindex = 0;
    while ( f ) {
	QCString argstr;
	char buf[12];
	Argument *a = f->args->first();
	int offset = 0;
	const char *predef_call_func = 0;

	if ( !a ) {
	    predef_call_func = "activate_signal";
	} else if ( f->args->count() == 1 ) {
	    QCString ctype = (a->leftType + ' ' + a->rightType).simplifyWhiteSpace();
	    if ( !isInOut( ctype ) ) {
		QCString utype = uType( ctype );
		if ( utype == "bool" )
		    predef_call_func = "activate_signal_bool";
		else if ( utype == "QString" || utype == "int" || utype == "double"  )
		    predef_call_func = "activate_signal";
	    }
	}

	if ( !predef_call_func && !included_list_headers ) {
	    // yes we need it, because otherwise QT_VERSION may not be defined
	    fprintf( out, "\n#include <%sqobjectdefs.h>\n", (const char*)g->qtPath );
	    fprintf( out, "#include <%sqsignalslotimp.h>\n", (const char*)g->qtPath );
	    included_list_headers = TRUE;
	}

	while ( a ) { // argument list
	    if ( !a->leftType.isEmpty() || !a->rightType.isEmpty() ) {
		argstr += a->leftType;
		argstr += " ";
		sprintf( buf, "t%d", offset++ );
		argstr += buf;
		argstr += a->rightType;
		a = f->args->next();
		if ( a )
		    argstr += ", ";
	    } else {
		a = f->args->next();
	    }
	}

	fixRightAngles( &argstr );

	fprintf( out, "\n// SIGNAL %s\n", (const char*)f->name );
	fprintf( out, "void %s::%s(", (const char*)qualifiedClassName(),
		 (const char*)f->name );

	if ( argstr.isEmpty() )
	    fprintf( out, ")\n{\n" );
	else
	    fprintf( out, " %s )\n{\n", (const char*)argstr );

	if ( predef_call_func ) {
	    fprintf( out, "    %s( staticMetaObject()->signalOffset() + %d", predef_call_func, sigindex );
	    if ( !argstr.isEmpty() )
		fprintf( out, ", t0" );
	    fprintf( out, " );\n}\n" );
	} else {
	    int nargs = f->args->count();
	    fprintf( out, "    if ( signalsBlocked() )\n\treturn;\n" );
	    fprintf( out, "    QConnectionList *clist = receivers( staticMetaObject()->signalOffset() + %d );\n",
		     sigindex );
	    fprintf( out, "    if ( !clist )\n\treturn;\n" );
	    fprintf( out, "    QUObject o[%d];\n", f->args->count() + 1 );
	    if ( !f->args->isEmpty() ) {
		offset = 0;
		Argument* a = f->args->first();
		while ( a ) {
		    QCString type = a->leftType + ' ' + a->rightType;
		    type = type.simplifyWhiteSpace();
		    if ( validUType( type ) ) {
			QCString utype = uType( type );
			fprintf( out, "    static_QUType_%s.set(o+%d,t%d);\n", utype.data(), offset+1, offset );
		    } else {
			fprintf( out, "    static_QUType_ptr.set(o+%d,&t%d);\n", offset+1, offset );
		    }
		    a = f->args->next();
		    offset++;
		}
	    }
	    fprintf( out, "    activate_signal( clist, o );\n" );
	
	    // get return values from inOut parameters
	    if ( !f->args->isEmpty() ) {
		offset = 0;
		Argument* a = f->args->first();
		while ( a ) {
		    QCString type = a->leftType + ' ' + a->rightType;
		    type = type.simplifyWhiteSpace();
		    if ( validUType( type ) && isInOut( type ) ) {
			QCString utype = uType( type );
			fprintf( out, "    t%d = static_QUType_%s.get(o+%d);\n", offset, utype.data(), offset+1 );
		    }
		    a = f->args->next();
		    offset++;
		}
	    }
	    fprintf( out, "}\n" );
	}
	
	f = g->signals.next();
	sigindex++;
    }


//
// Generate internal qt_invoke()  function
//
    fprintf( out, "\nbool %s::qt_invoke( int _id, QUObject* _o )\n{\n", qualifiedClassName().data() );

    if( !g->slots.isEmpty() ) {
	fprintf( out, "    switch ( _id - staticMetaObject()->slotOffset() ) {\n" );
	int slotindex = -1;
	for ( f = g->slots.first(); f; f = g->slots.next() ) {
	    slotindex ++;
	    if ( f->type == "void" && f->args->isEmpty() ) {
		fprintf( out, "    case %d: %s(); break;\n", slotindex, f->name.data() );
		continue;
	    }

	    fprintf( out, "    case %d: ", slotindex );
	    bool hasReturnValue = FALSE;
	    bool hasVariantReturn = FALSE;
	    if ( f->type != "void" )  {
		if (  validUType( f->type )) {
		    hasReturnValue = TRUE;
		    fprintf( out, "static_QUType_%s.set(_o,", uType(f->type).data() );
		} else if ( isVariantType( f->type ) ) {
		    hasReturnValue = hasVariantReturn = TRUE;
		    // do not need special handling for bool since this is handled as utype
		    fprintf( out, "static_QUType_QVariant.set(_o,QVariant(" );
		}
	    }
	    int offset = 0;
	    fprintf( out, "%s(", f->name.data() );
	    Argument* a = f->args->first();
	    while ( a ) {
		QCString type = a->leftType + ' ' + a->rightType;
		type = type.simplifyWhiteSpace();
		fixRightAngles( &type );
		if ( validUType( type ) ) {
		    QCString utype = uType( type );
		    if ( utype == "ptr" || utype == "enum" )
			fprintf( out, "(%s)static_QUType_%s.get(_o+%d)", type.data(), utype.data(), offset+1 );
		    else
			fprintf( out, "static_QUType_%s.get(_o+%d)", utype.data(), offset+1 );
		} else {
		    fprintf( out, "*((%s*)static_QUType_ptr.get(_o+%d))", referencePlainUType( type) .data(), offset+1 );
		}
		a = f->args->next();
		if ( a )
		    fprintf( out, "," );
		offset++;
	    }
	    fprintf( out, ")" );
	    if ( hasReturnValue )
		fprintf( out, ")" );
	    if ( hasVariantReturn )
		fprintf( out, ")" );
	    fprintf( out, "; break;\n" );
	}
	fprintf( out, "    default:\n" );

	if ( !g->superClassName.isEmpty() && !isQObject ) {
	    fprintf( out, "\treturn %s::qt_invoke( _id, _o );\n",
		     (const char *) purestSuperClassName() );
	} else {
	    fprintf( out, "\treturn FALSE;\n" );
	}
	fprintf( out, "    }\n" );
	fprintf( out, "    return TRUE;\n}\n" );
    } else {
	if ( !g->superClassName.isEmpty()  && !isQObject )
	    fprintf( out, "    return %s::qt_invoke(_id,_o);\n}\n",
		     (const char *) purestSuperClassName() );
	else
	    fprintf( out, "    return FALSE;\n}\n" );
    }


//
// Generate internal qt_emit()  function
//
    fprintf( out, "\nbool %s::qt_emit( int _id, QUObject* _o )\n{\n", qualifiedClassName().data() );

    if ( !g->signals.isEmpty() ) {
	fprintf( out, "    switch ( _id - staticMetaObject()->signalOffset() ) {\n" );
	int signalindex = -1;
	for ( f = g->signals.first(); f; f = g->signals.next() ) {
	    signalindex++;
	    if ( f->type == "void" && f->args->isEmpty() ) {
		fprintf( out, "    case %d: %s(); break;\n", signalindex, f->name.data() );
		continue;
	    }

	    fprintf( out, "    case %d: ", signalindex );
	    bool hasReturnValue = FALSE;
	    if ( f->type != "void" && validUType( f->type )) {
		hasReturnValue = TRUE;
		fprintf( out, "static_QUType_%s.set(_o,", uType(f->type).data() );
	    }
	    int offset = 0;
	    fprintf( out, "%s(", f->name.data() );
	    Argument* a = f->args->first();
	    while ( a ) {
		QCString type = a->leftType + ' ' + a->rightType;
		type = type.simplifyWhiteSpace();
		fixRightAngles( &type );
		if ( validUType( type ) ) {
		    QCString utype = uType( type );
		    if ( utype == "ptr" || utype == "enum" )
			fprintf( out, "(%s)static_QUType_%s.get(_o+%d)", type.data(), utype.data(), offset+1 );
		    else
			fprintf( out, "static_QUType_%s.get(_o+%d)", utype.data(), offset+1 );
		} else {
		    fprintf( out, "*((%s*)static_QUType_ptr.get(_o+%d))", referencePlainUType(type).data(), offset+1 );
		}
		a = f->args->next();
		if ( a )
		    fprintf( out, "," );
		offset++;
	    }
	    fprintf( out, ")" );
	    if ( hasReturnValue )
		fprintf( out, ")" );
	    fprintf( out, "; break;\n" );
	}
	fprintf( out, "    default:\n" );
	if ( !g->superClassName.isEmpty()  && !isQObject )
	    fprintf( out, "\treturn %s::qt_emit(_id,_o);\n",
		     (const char *) purestSuperClassName() );
	else
	    fprintf( out, "\treturn FALSE;\n" );
	fprintf( out, "    }\n" );
	fprintf( out, "    return TRUE;\n}\n" );
    } else {
	if ( !g->superClassName.isEmpty()  && !isQObject )
	    fprintf( out, "    return %s::qt_emit(_id,_o);\n}\n",
		     (const char *) purestSuperClassName() );
	else
	    fprintf( out, "    return FALSE;\n}\n" );
    }


    fprintf( out, "#ifndef QT_NO_PROPERTIES\n" );
//
// Generate internal qt_property()  function
//
    fprintf( out, "\nbool %s::qt_property( int _id, int _f, QVariant* _v)\n{\n", qualifiedClassName().data() );

    if ( !g->props.isEmpty() ) {
	fprintf( out, "    switch ( _id - staticMetaObject()->propertyOffset() ) {\n" );
	int propindex = -1;
	bool need_resolve = FALSE;
	
	for( QPtrListIterator<Property> it( g->props ); it.current(); ++it ){
	    propindex ++;
	    fprintf( out, "    case %d: ", propindex );
	    fprintf( out, "switch( _f ) {\n" );
	
	    uint flag_break = 0;
	    uint flag_propagate = 0;
	
	    if ( it.current()->setfunc ) {
		fprintf( out, "\tcase 0: %s(", it.current()->setfunc->name.data() );
		QCString type = it.current()->type.copy(); // detach on purpose
		if ( it.current()->oredEnum )
		    type = it.current()->enumsettype;
		if ( type == "uint" )
		    fprintf( out, "_v->asUInt()" );
		else if ( type == "unsigned int" )
		    fprintf( out, "(uint)_v->asUInt()" );
		else if ( type == "QMap<QString,QVariant>" )
		    fprintf( out, "_v->asMap()" );
		else if ( type == "QValueList<QVariant>" )
		    fprintf( out, "_v->asList()" );
		else if ( isVariantType( type ) ) {
		    if ( type[0] == 'Q' )
			type = type.mid(1);
		    else
			type[0] = toupper( type[0] );
		    fprintf( out, "_v->as%s()", type.data() );
		} else {
		    fprintf( out, "(%s&)_v->asInt()", type.data() );
		}
		fprintf( out, "); break;\n" );

	    } else if ( it.current()->override ) {
		flag_propagate |= 1 << (0+1);
	    }
	    if ( it.current()->getfunc ) {
		if ( it.current()->gspec == Property::Pointer )
		    fprintf( out, "\tcase 1: if ( %s() ) *_v = QVariant( %s*%s()%s ); break;\n",
			     it.current()->getfunc->name.data(),
			     !isVariantType( it.current()->type ) ? "(int)" : "",
			     it.current()->getfunc->name.data(),
			     it.current()->type == "bool" ? ", 0" : "" );
		else
		    fprintf( out, "\tcase 1: *_v = QVariant( %s%s()%s ); break;\n",
			     !isVariantType( it.current()->type ) ? "(int)" : "",
			     it.current()->getfunc->name.data(),
			     it.current()->type == "bool" ? ", 0" : "" );
	    } else if ( it.current()->override ) {
		flag_propagate |= 1<< (1+1);
	    }

	    if ( !it.current()->reset.isEmpty() )
		fprintf( out, "\tcase 2: %s(); break;\n", it.current()->reset.data() );

	    if ( it.current()->designable.isEmpty() )
		flag_propagate |= 1 << (3+1);
	    else if ( it.current()->designable == "true" )
		flag_break |= 1 << (3+1);
	    else if ( it.current()->designable != "false" )
		fprintf( out, "\tcase 3: return %s();\n", it.current()->designable.data() );

	    if ( it.current()->scriptable.isEmpty() )
		flag_propagate |= 1 << (4+1);
	    else if ( it.current()->scriptable == "true" )
		flag_break |= 1 << (4+1);
	    else if ( it.current()->scriptable != "false" )
		fprintf( out, "\tcase 4: return %s();\n", it.current()->scriptable.data() );

	    if ( it.current()->stored.isEmpty() )
		flag_propagate |= 1 << (5+1);
	    else if ( it.current()->stored == "true" )
		flag_break |= 1 << (5+1);
	    else if ( it.current()->stored != "false" )
		fprintf( out, "\tcase 5: return %s();\n", it.current()->stored.data() );
	
	    int i = 0;
	    if ( flag_propagate != 0 ) {
		fprintf( out, "\t" );
		for ( i = 0; i <= 5; i++ ) {
		    if ( flag_propagate & (1 << (i+1) ) )
			fprintf( out, "case %d: ", i );
		}
		if (!g->superClassName.isEmpty() &&  !isQObject ) {
		    fprintf( out, "goto resolve;\n" );
		    need_resolve = TRUE;
		} else {
		    fprintf( out, "    return FALSE;\n" );
		}
	    }
	    if ( flag_break != 0 ) {
		fprintf( out, "\t" );
		for ( i = 0; i <= 5; i++ ) {
		    if ( flag_break & (1 << (i+1) ) )
			fprintf( out, "case %d: ", i );
		}
		fprintf( out, "break;\n");
	    }

	    fprintf( out, "\tdefault: return FALSE;\n    } break;\n" );
	}
	fprintf( out, "    default:\n" );
	if ( !g->superClassName.isEmpty()  && !isQObject )
	    fprintf( out, "\treturn %s::qt_property( _id, _f, _v );\n",
		     (const char *) purestSuperClassName() );
	else
	    fprintf( out, "\treturn FALSE;\n" );
	fprintf( out, "    }\n" );
	fprintf( out, "    return TRUE;\n" );
	
	if ( need_resolve )
	    fprintf( out, "resolve:\n    return %s::qt_property( staticMetaObject()->resolveProperty(_id), _f, _v );\n",
		     (const char *) purestSuperClassName() );
	fprintf( out, "}\n" );
    } else {
	if ( !g->superClassName.isEmpty() &&  !isQObject )
	    fprintf( out, "    return %s::qt_property( _id, _f, _v);\n}\n",
		     (const char *) purestSuperClassName() );
	else
	    fprintf( out, "    return FALSE;\n}\n" );
    }
    fprintf( out, "#endif // QT_NO_PROPERTIES\n" );
}


ArgList *addArg( Argument *a )			// add argument to list
{
    if ( (!a->leftType.isEmpty() || !a->rightType.isEmpty() ) )  //filter out truely void arguments
	tmpArgList->append( a );
    return tmpArgList;
}

void addEnum()
{
    // Avoid duplicates
    for( QPtrListIterator<Enum> lit( g->enums ); lit.current(); ++lit ) {
	if ( lit.current()->name == tmpEnum->name )
	{
	    if ( displayWarnings )
		moc_err( "Enum %s defined twice.", (const char*)tmpEnum->name );
	}
    }

    // Only look at types mentioned  in Q_ENUMS and Q_SETS
    if ( g->qtEnums.contains( tmpEnum->name ) || g->qtSets.contains( tmpEnum->name ) )
    {
	g->enums.append( tmpEnum );
	if ( g->qtSets.contains( tmpEnum->name ) )
	    tmpEnum->set = TRUE;
	else
	    tmpEnum->set = FALSE;
    }
    else
	delete tmpEnum;
    tmpEnum = new Enum;
}

void addMember( Member m )
{
    if ( skipFunc ) {
	tmpFunc->args = tmpArgList; // just to be sure
	delete tmpFunc;
	tmpArgList  = new ArgList;   // ugly but works
	tmpFunc	    = new Function;
	skipFunc    = FALSE;
	return;
    }

    tmpFunc->type = tmpFunc->type.simplifyWhiteSpace();
    tmpFunc->access = tmpAccess;
    tmpFunc->args = tmpArgList;
    tmpFunc->lineNo = lineNo;

    for ( ;; ) {
	g->funcs.append( tmpFunc );

	if ( m == SignalMember ) {
	    g->signals.append( tmpFunc );
	    break;
	} else {
	    if ( m == SlotMember )
		g->slots.append( tmpFunc );
	    // PropertyCandidateMember or SlotMember
	    if ( !tmpFunc->name.isEmpty() && tmpFunc->access == Public )
		g->propfuncs.append( tmpFunc );
	    if ( !tmpFunc->args || !tmpFunc->args->hasDefaultArguments() )
		break;
	    tmpFunc = new Function( *tmpFunc );
	    tmpFunc->args = tmpFunc->args->magicClone();
	}
    }

    skipFunc = FALSE;
    tmpFunc = new Function;
    tmpArgList = new ArgList;
}

void checkPropertyName( const char* ident )
{
    if ( ident[0] == '_' ) {
	moc_err( "Invalid property name '%s'.", ident );
	return;
    }
}
#line 3611 "y.tab.c"
#define YYABORT goto yyabort
#define YYREJECT goto yyabort
#define YYACCEPT goto yyaccept
#define YYERROR goto yyerrlab
int
yyparse()
{
    register int yym, yyn, yystate;
#if YYDEBUG
    register char *yys;
    extern char *getenv();

    if (yys = getenv("YYDEBUG"))
    {
        yyn = *yys;
        if (yyn >= '0' && yyn <= '9')
            yydebug = yyn - '0';
    }
#endif

    yynerrs = 0;
    yyerrflag = 0;
    yychar = (-1);

    yyssp = yyss;
    yyvsp = yyvs;
    *yyssp = yystate = 0;

yyloop:
    if (yyn = yydefred[yystate]) goto yyreduce;
    if (yychar < 0)
    {
        if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, reading %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
    }
    if ((yyn = yysindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: state %d, shifting to state %d\n",
                    YYPREFIX, yystate, yytable[yyn]);
#endif
        if (yyssp >= yyss + yystacksize - 1)
        {
            goto yyoverflow;
        }
        *++yyssp = yystate = yytable[yyn];
        *++yyvsp = yylval;
        yychar = (-1);
        if (yyerrflag > 0)  --yyerrflag;
        goto yyloop;
    }
    if ((yyn = yyrindex[yystate]) && (yyn += yychar) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yychar)
    {
        yyn = yytable[yyn];
        goto yyreduce;
    }
    if (yyerrflag) goto yyinrecovery;
#ifdef lint
    goto yynewerror;
#endif
yynewerror:
    yyerror("syntax error");
#ifdef lint
    goto yyerrlab;
#endif
yyerrlab:
    ++yynerrs;
yyinrecovery:
    if (yyerrflag < 3)
    {
        yyerrflag = 3;
        for (;;)
        {
            if ((yyn = yysindex[*yyssp]) && (yyn += YYERRCODE) >= 0 &&
                    yyn <= YYTABLESIZE && yycheck[yyn] == YYERRCODE)
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: state %d, error recovery shifting\
 to state %d\n", YYPREFIX, *yyssp, yytable[yyn]);
#endif
                if (yyssp >= yyss + yystacksize - 1)
                {
                    goto yyoverflow;
                }
                *++yyssp = yystate = yytable[yyn];
                *++yyvsp = yylval;
                goto yyloop;
            }
            else
            {
#if YYDEBUG
                if (yydebug)
                    printf("%sdebug: error recovery discarding state %d\n",
                            YYPREFIX, *yyssp);
#endif
                if (yyssp <= yyss) goto yyabort;
                --yyssp;
                --yyvsp;
            }
        }
    }
    else
    {
        if (yychar == 0) goto yyabort;
#if YYDEBUG
        if (yydebug)
        {
            yys = 0;
            if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
            if (!yys) yys = "illegal-symbol";
            printf("%sdebug: state %d, error recovery discards token %d (%s)\n",
                    YYPREFIX, yystate, yychar, yys);
        }
#endif
        yychar = (-1);
        goto yyloop;
    }
yyreduce:
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: state %d, reducing by rule %d (%s)\n",
                YYPREFIX, yystate, yyn, yyrule[yyn]);
#endif
    yym = yylen[yyn];
    yyval = yyvsp[1-yym];
    switch (yyn)
    {
case 10:
#line 689 "moc.y"
{ enterNameSpace(yyvsp[0].string); }
break;
case 11:
#line 690 "moc.y"
{ BEGIN IN_NAMESPACE; }
break;
case 12:
#line 692 "moc.y"
{ leaveNameSpace();
					       selectOutsideClassState();
					     }
break;
case 13:
#line 697 "moc.y"
{ enterNameSpace(); }
break;
case 14:
#line 698 "moc.y"
{ BEGIN IN_NAMESPACE; }
break;
case 15:
#line 700 "moc.y"
{ leaveNameSpace();
					       selectOutsideClassState();
					     }
break;
case 17:
#line 709 "moc.y"
{ selectOutsideClassState(); }
break;
case 18:
#line 713 "moc.y"
{ selectOutsideClassState(); }
break;
case 19:
#line 716 "moc.y"
{ selectOutsideClassState(); }
break;
case 20:
#line 717 "moc.y"
{ selectOutsideClassState(); }
break;
case 21:
#line 720 "moc.y"
{ initClass(); }
break;
case 22:
#line 721 "moc.y"
{ generateClass();
						registerClassInNamespace();
						selectOutsideClassState(); }
break;
case 23:
#line 729 "moc.y"
{ yyval.string = yyvsp[0].string; }
break;
case 24:
#line 730 "moc.y"
{ yyval.string = yyvsp[0].string; }
break;
case 25:
#line 734 "moc.y"
{ g->tmpExpression = rmWS( g->tmpExpression );
				     yyval.string = stradd( yyvsp[-3].string, "<",
						  g->tmpExpression, ">" ); }
break;
case 26:
#line 745 "moc.y"
{ initExpression();
						    templLevel = 1;
						    BEGIN IN_TEMPL_ARGS; }
break;
case 27:
#line 758 "moc.y"
{ initExpression();
						    BEGIN IN_EXPR; }
break;
case 28:
#line 767 "moc.y"
{ BEGIN IN_DEF_ARG; }
break;
case 29:
#line 770 "moc.y"
{ initExpression();
						    BEGIN IN_ENUM; }
break;
case 30:
#line 776 "moc.y"
{ yyval.string = ""; }
break;
case 31:
#line 777 "moc.y"
{ yyval.string = yyvsp[0].string; }
break;
case 32:
#line 778 "moc.y"
{ yyval.string = ""; }
break;
case 33:
#line 779 "moc.y"
{ skipFunc = TRUE; yyval.string = ""; }
break;
case 34:
#line 780 "moc.y"
{ skipFunc = TRUE; yyval.string = ""; }
break;
case 35:
#line 784 "moc.y"
{ yyval.string = straddSpc(yyvsp[-2].string,yyvsp[-1].string,yyvsp[0].string); }
break;
case 36:
#line 786 "moc.y"
{ yyval.string = ""; }
break;
case 37:
#line 787 "moc.y"
{ yyval.string = yyvsp[0].string; }
break;
case 38:
#line 790 "moc.y"
{ yyval.string = yyvsp[0].string; }
break;
case 39:
#line 791 "moc.y"
{ yyval.string = straddSpc(yyvsp[-1].string,yyvsp[0].string); }
break;
case 42:
#line 796 "moc.y"
{ skipFunc = TRUE; }
break;
case 46:
#line 804 "moc.y"
{ yyval.string = "const"; }
break;
case 47:
#line 805 "moc.y"
{ yyval.string = "volatile"; }
break;
case 48:
#line 808 "moc.y"
{ yyval.string = yyvsp[0].string; }
break;
case 49:
#line 809 "moc.y"
{ yyval.string = yyvsp[0].string; }
break;
case 50:
#line 810 "moc.y"
{ yyval.string = yyvsp[0].string; }
break;
case 51:
#line 814 "moc.y"
{ yyval.string = straddSpc(yyvsp[-1].string,yyvsp[0].string); }
break;
case 52:
#line 815 "moc.y"
{ yyval.string = yyvsp[0].string; }
break;
case 53:
#line 817 "moc.y"
{ yyval.string = "char"; }
break;
case 54:
#line 818 "moc.y"
{ yyval.string = "short"; }
break;
case 55:
#line 819 "moc.y"
{ yyval.string = "int"; }
break;
case 56:
#line 820 "moc.y"
{ yyval.string = "long"; }
break;
case 57:
#line 821 "moc.y"
{ yyval.string = "signed"; }
break;
case 58:
#line 822 "moc.y"
{ yyval.string = "unsigned"; }
break;
case 59:
#line 823 "moc.y"
{ yyval.string = "float"; }
break;
case 60:
#line 824 "moc.y"
{ yyval.string = "double"; }
break;
case 61:
#line 825 "moc.y"
{ yyval.string = "void"; }
break;
case 62:
#line 829 "moc.y"
{ g->tmpExpression = rmWS( g->tmpExpression );
				     yyval.string = stradd( "template<",
						  g->tmpExpression, ">" ); }
break;
case 64:
#line 835 "moc.y"
{ templateClassOld = templateClass;
						  templateClass = TRUE;
						}
break;
case 65:
#line 841 "moc.y"
{ yyval.string = "class"; }
break;
case 66:
#line 842 "moc.y"
{ yyval.string = "struct"; }
break;
case 67:
#line 845 "moc.y"
{ yyval.string = yyvsp[0].string; }
break;
case 68:
#line 847 "moc.y"
{ yyval.string = stradd( "::", yyvsp[0].string ); }
break;
case 69:
#line 851 "moc.y"
{ yyval.string = stradd( yyvsp[-2].string, "::", yyvsp[0].string );}
break;
case 70:
#line 852 "moc.y"
{ yyval.string = yyvsp[0].string; }
break;
case 71:
#line 856 "moc.y"
{ yyval.string = straddSpc(yyvsp[-1].string,yyvsp[0].string); }
break;
case 72:
#line 857 "moc.y"
{ yyval.string = stradd("enum ",yyvsp[0].string); }
break;
case 73:
#line 858 "moc.y"
{ yyval.string = stradd("union ",yyvsp[0].string); }
break;
case 74:
#line 863 "moc.y"
{ yyval.arg_list = yyvsp[-1].arg_list;}
break;
case 75:
#line 864 "moc.y"
{ yyval.arg_list = yyvsp[-2].arg_list;
				       func_warn("Ellipsis not supported"
						 " in signals and slots.\n"
						 "Ellipsis argument ignored."); }
break;
case 76:
#line 870 "moc.y"
{ yyval.arg_list = tmpArgList; }
break;
case 77:
#line 871 "moc.y"
{ yyval.arg_list = yyvsp[0].arg_list; }
break;
case 79:
#line 875 "moc.y"
{ func_warn("Ellipsis not supported"
						 " in signals and slots.\n"
						 "Ellipsis argument ignored."); }
break;
case 80:
#line 883 "moc.y"
{ yyval.arg_list = addArg(yyvsp[0].arg); }
break;
case 81:
#line 884 "moc.y"
{ yyval.arg_list = addArg(yyvsp[0].arg); }
break;
case 82:
#line 887 "moc.y"
{ yyval.arg = new Argument(straddSpc(yyvsp[-1].string,yyvsp[0].string),""); }
break;
case 83:
#line 889 "moc.y"
{ expLevel = 1; }
break;
case 84:
#line 891 "moc.y"
{ yyval.arg = new Argument(straddSpc(yyvsp[-4].string,yyvsp[-3].string),"", 0, TRUE ); }
break;
case 85:
#line 894 "moc.y"
{ yyval.arg = new Argument(straddSpc(yyvsp[-3].string,yyvsp[-2].string),yyvsp[0].string, yyvsp[-1].string); }
break;
case 86:
#line 897 "moc.y"
{ expLevel = 1; }
break;
case 87:
#line 899 "moc.y"
{ yyval.arg = new Argument(straddSpc(yyvsp[-6].string,yyvsp[-5].string),yyvsp[-3].string, yyvsp[-4].string, TRUE); }
break;
case 88:
#line 903 "moc.y"
{ yyval.string = ""; }
break;
case 89:
#line 904 "moc.y"
{ yyval.string = yyvsp[0].string; }
break;
case 90:
#line 908 "moc.y"
{ yyval.string = straddSpc(yyvsp[-1].string,yyvsp[0].string); }
break;
case 91:
#line 909 "moc.y"
{ expLevel = 1; }
break;
case 92:
#line 911 "moc.y"
{ yyval.string = stradd( "[",
				     g->tmpExpression =
				     g->tmpExpression.stripWhiteSpace(), "]" ); }
break;
case 93:
#line 914 "moc.y"
{ expLevel = 1; }
break;
case 94:
#line 916 "moc.y"
{ yyval.string = stradd( yyvsp[-4].string,"[",
				     g->tmpExpression =
				     g->tmpExpression.stripWhiteSpace(),"]" ); }
break;
case 95:
#line 919 "moc.y"
{ yyval.string = yyvsp[0].string; }
break;
case 96:
#line 920 "moc.y"
{ yyval.string = yyvsp[-1].string; }
break;
case 97:
#line 923 "moc.y"
{ yyval.string = ""; }
break;
case 98:
#line 925 "moc.y"
{ yyval.string = straddSpc(yyvsp[-1].string,yyvsp[0].string);}
break;
case 99:
#line 926 "moc.y"
{ expLevel = 1; }
break;
case 100:
#line 928 "moc.y"
{ yyval.string = stradd( yyvsp[-4].string,"[",
				     g->tmpExpression =
				     g->tmpExpression.stripWhiteSpace(),"]" ); }
break;
case 101:
#line 931 "moc.y"
{ yyval.string = yyvsp[-1].string; }
break;
case 103:
#line 944 "moc.y"
{ tmpFunc->args	     = yyvsp[-5].arg_list;
						  tmpFunc->qualifier = yyvsp[-3].string; }
break;
case 105:
#line 950 "moc.y"
{ func_warn("Variable as signal or slot."); }
break;
case 106:
#line 951 "moc.y"
{ expLevel=0; }
break;
case 107:
#line 953 "moc.y"
{ skipFunc = TRUE; }
break;
case 108:
#line 954 "moc.y"
{ expLevel=0; }
break;
case 109:
#line 956 "moc.y"
{ skipFunc = TRUE; }
break;
case 110:
#line 960 "moc.y"
{ expLevel = 1; }
break;
case 112:
#line 962 "moc.y"
{ expLevel = 1; }
break;
case 114:
#line 967 "moc.y"
{ yyval.string = ""; }
break;
case 115:
#line 968 "moc.y"
{ yyval.string = yyvsp[0].string; }
break;
case 116:
#line 971 "moc.y"
{ yyval.string = yyvsp[0].string; }
break;
case 117:
#line 972 "moc.y"
{ yyval.string = straddSpc(yyvsp[-1].string,yyvsp[0].string);}
break;
case 118:
#line 975 "moc.y"
{ yyval.string = straddSpc("*",yyvsp[0].string);}
break;
case 119:
#line 976 "moc.y"
{ yyval.string = stradd("&",yyvsp[0].string);}
break;
case 120:
#line 983 "moc.y"
{ yyval.string = ""; }
break;
case 121:
#line 984 "moc.y"
{ yyval.string = yyvsp[0].string; }
break;
case 122:
#line 987 "moc.y"
{ yyval.string = yyvsp[0].string; }
break;
case 123:
#line 989 "moc.y"
{ yyval.string = straddSpc(yyvsp[-1].string,yyvsp[0].string); }
break;
case 124:
#line 992 "moc.y"
{ yyval.string = "const"; }
break;
case 125:
#line 993 "moc.y"
{ yyval.string = "volatile"; }
break;
case 129:
#line 1001 "moc.y"
{ BEGIN IN_FCT; fctLevel = 1;}
break;
case 130:
#line 1002 "moc.y"
{ BEGIN QT_DEF; }
break;
case 131:
#line 1009 "moc.y"
{ BEGIN IN_CLASS;
						  classPLevel = 1;
						}
break;
case 132:
#line 1013 "moc.y"
{ BEGIN QT_DEF; }
break;
case 133:
#line 1014 "moc.y"
{ BEGIN QT_DEF;	  /* -- " -- */
						  skipClass = TRUE; }
break;
case 134:
#line 1018 "moc.y"
{ BEGIN QT_DEF; /* catch ';' */
						  skipClass = TRUE; }
break;
case 135:
#line 1020 "moc.y"
{ skipClass = TRUE;
						  BEGIN GIMME_SEMICOLON; }
break;
case 141:
#line 1033 "moc.y"
{ g->className = yyvsp[0].string;
						  if ( g->className == "QObject" )
						     Q_OBJECTdetected = TRUE;
						}
break;
case 142:
#line 1039 "moc.y"
{ g->className = yyvsp[0].string;
						  if ( g->className == "QObject" )
						     Q_OBJECTdetected = TRUE;
						}
break;
case 143:
#line 1046 "moc.y"
{ g->superClassName = yyvsp[0].string; }
break;
case 144:
#line 1051 "moc.y"
{ templateClass = templateClassOld; }
break;
case 153:
#line 1073 "moc.y"
{ expLevel = 1; }
break;
case 155:
#line 1078 "moc.y"
{ yyval.string = 0; }
break;
case 156:
#line 1079 "moc.y"
{ yyval.string = yyvsp[0].string; }
break;
case 161:
#line 1091 "moc.y"
{ tmpAccess = yyvsp[0].access; }
break;
case 162:
#line 1092 "moc.y"
{ moc_err( "Missing access specifier"
						   " before \"slots:\"." ); }
break;
case 163:
#line 1096 "moc.y"
{ BEGIN QT_DEF; }
break;
case 165:
#line 1098 "moc.y"
{ BEGIN QT_DEF; }
break;
case 167:
#line 1100 "moc.y"
{
			      if ( tmpAccess )
				  moc_warn("Q_OBJECT is not in the private"
					   " section of the class.\n"
					   "Q_OBJECT is a macro that resets"
					   " access permission to \"private\".");
			      Q_OBJECTdetected = TRUE;
			  }
break;
case 168:
#line 1108 "moc.y"
{ tmpYYStart = YY_START;
				       tmpPropOverride = FALSE;
				       BEGIN IN_PROPERTY; }
break;
case 169:
#line 1111 "moc.y"
{
						BEGIN tmpYYStart;
					   }
break;
case 171:
#line 1115 "moc.y"
{ tmpYYStart = YY_START;
				       tmpPropOverride = TRUE;
				       BEGIN IN_PROPERTY; }
break;
case 172:
#line 1118 "moc.y"
{
						BEGIN tmpYYStart;
					   }
break;
case 174:
#line 1122 "moc.y"
{ tmpYYStart = YY_START; BEGIN IN_CLASSINFO; }
break;
case 175:
#line 1124 "moc.y"
{
				      g->infos.append( new ClassInfo( yyvsp[-3].string, yyvsp[-1].string ) );
				      BEGIN tmpYYStart;
				  }
break;
case 177:
#line 1129 "moc.y"
{ tmpYYStart = YY_START; BEGIN IN_PROPERTY; }
break;
case 178:
#line 1130 "moc.y"
{
						Q_PROPERTYdetected = TRUE;
						BEGIN tmpYYStart;
					   }
break;
case 180:
#line 1135 "moc.y"
{ tmpYYStart = YY_START; BEGIN IN_PROPERTY; }
break;
case 181:
#line 1136 "moc.y"
{
						Q_PROPERTYdetected = TRUE;
						BEGIN tmpYYStart;
					   }
break;
case 183:
#line 1143 "moc.y"
{ moc_err( "Signals cannot "
						 "have access specifiers" ); }
break;
case 185:
#line 1146 "moc.y"
{ if ( tmpAccess == Public && Q_PROPERTYdetected )
						  BEGIN QT_DEF;
					      else
						  BEGIN IN_CLASS;
					  suppress_func_warn = TRUE;
					}
break;
case 186:
#line 1153 "moc.y"
{
					  suppress_func_warn = FALSE;
					}
break;
case 187:
#line 1156 "moc.y"
{ BEGIN IN_CLASS;
					   if ( classPLevel != 1 )
					       moc_warn( "unexpected access"
							 "specifier" );
					}
break;
case 192:
#line 1171 "moc.y"
{ addMember( PropertyCandidateMember ); }
break;
case 197:
#line 1183 "moc.y"
{ addMember( SignalMember ); }
break;
case 202:
#line 1194 "moc.y"
{ addMember( SlotMember ); }
break;
case 205:
#line 1201 "moc.y"
{ yyval.string=yyvsp[0].string; }
break;
case 206:
#line 1204 "moc.y"
{ g->multipleSuperClasses.append( yyvsp[0].string ); }
break;
case 208:
#line 1209 "moc.y"
{ yyval.string = stradd( yyvsp[-3].string, "(", yyvsp[-1].string, ")" ); }
break;
case 209:
#line 1211 "moc.y"
{ yyval.string = stradd( yyvsp[-3].string, "(", yyvsp[-1].string, ")" ); }
break;
case 210:
#line 1214 "moc.y"
{yyval.string=yyvsp[0].string;}
break;
case 211:
#line 1215 "moc.y"
{yyval.string=yyvsp[0].string;}
break;
case 212:
#line 1216 "moc.y"
{yyval.string=yyvsp[0].string;}
break;
case 213:
#line 1217 "moc.y"
{yyval.string=yyvsp[0].string;}
break;
case 214:
#line 1218 "moc.y"
{yyval.string=yyvsp[0].string;}
break;
case 215:
#line 1219 "moc.y"
{yyval.string=yyvsp[0].string;}
break;
case 216:
#line 1220 "moc.y"
{yyval.string=yyvsp[0].string;}
break;
case 217:
#line 1221 "moc.y"
{yyval.string=yyvsp[0].string;}
break;
case 218:
#line 1222 "moc.y"
{yyval.string=yyvsp[0].string;}
break;
case 219:
#line 1223 "moc.y"
{yyval.string=yyvsp[0].string;}
break;
case 220:
#line 1226 "moc.y"
{ yyval.access=Private; }
break;
case 221:
#line 1227 "moc.y"
{ yyval.access=Protected; }
break;
case 222:
#line 1228 "moc.y"
{ yyval.access=Public; }
break;
case 266:
#line 1280 "moc.y"
{ tmpFunc->type = yyvsp[-1].string;
						  tmpFunc->name = yyvsp[0].string; }
break;
case 267:
#line 1283 "moc.y"
{ tmpFunc->type = "int";
						  tmpFunc->name = yyvsp[0].string;
				  if ( tmpFunc->name == g->className )
				      func_warn( "Constructors cannot be"
						 " signals or slots.");
						}
break;
case 268:
#line 1290 "moc.y"
{ tmpFunc->type = "void";
						  tmpFunc->name = "~";
						  tmpFunc->name += yyvsp[0].string;
				       func_warn( "Destructors cannot be"
						  " signals or slots.");
						}
break;
case 269:
#line 1298 "moc.y"
{
						    char *tmp =
							straddSpc(yyvsp[-4].string,yyvsp[-3].string,yyvsp[-2].string,yyvsp[-1].string);
						    tmpFunc->type = rmWS(tmp);
						    delete tmp;
						    tmpFunc->name = yyvsp[0].string; }
break;
case 270:
#line 1305 "moc.y"
{ skipFunc = TRUE; }
break;
case 271:
#line 1307 "moc.y"
{ tmpFunc->type =
						      straddSpc(yyvsp[-2].string,yyvsp[-1].string);
						  tmpFunc->name = yyvsp[0].string; }
break;
case 272:
#line 1312 "moc.y"
{ tmpFunc->type =
						      straddSpc(yyvsp[-3].string,yyvsp[-2].string,yyvsp[-1].string);
						  tmpFunc->name = yyvsp[0].string; }
break;
case 273:
#line 1316 "moc.y"
{ operatorError();    }
break;
case 274:
#line 1318 "moc.y"
{ operatorError();    }
break;
case 275:
#line 1321 "moc.y"
{ operatorError();    }
break;
case 276:
#line 1323 "moc.y"
{ operatorError();    }
break;
case 277:
#line 1326 "moc.y"
{ operatorError();    }
break;
case 279:
#line 1332 "moc.y"
{ func_warn("Unexpected variable declaration."); }
break;
case 280:
#line 1335 "moc.y"
{ func_warn("Unexpected variable declaration."); }
break;
case 281:
#line 1337 "moc.y"
{ func_warn("Unexpected enum declaration."); }
break;
case 282:
#line 1339 "moc.y"
{ func_warn("Unexpected using declaration."); }
break;
case 283:
#line 1341 "moc.y"
{ func_warn("Unexpected using declaration."); }
break;
case 284:
#line 1343 "moc.y"
{ classPLevel++;
				  moc_err("Unexpected namespace declaration."); }
break;
case 285:
#line 1346 "moc.y"
{ func_warn("Unexpected class declaration.");}
break;
case 286:
#line 1348 "moc.y"
{ func_warn("Unexpected class declaration.");
				  BEGIN IN_FCT; fctLevel=1;
				}
break;
case 287:
#line 1351 "moc.y"
{ BEGIN QT_DEF; }
break;
case 292:
#line 1361 "moc.y"
{ expLevel = 0; }
break;
case 294:
#line 1363 "moc.y"
{ expLevel = 0; }
break;
case 297:
#line 1368 "moc.y"
{ expLevel = 0; }
break;
case 302:
#line 1383 "moc.y"
{ BEGIN QT_DEF;
				  if ( tmpAccess == Public) {
				      tmpEnum->name = yyvsp[-4].string;
				      addEnum();
				  }
				}
break;
case 303:
#line 1390 "moc.y"
{ tmpEnum->clear();}
break;
case 309:
#line 1402 "moc.y"
{ if ( tmpAccess == Public) tmpEnum->append( yyvsp[0].string ); }
break;
case 310:
#line 1403 "moc.y"
{ expLevel=0; }
break;
case 311:
#line 1404 "moc.y"
{  if ( tmpAccess == Public) tmpEnum->append( yyvsp[-3].string );  }
break;
case 312:
#line 1408 "moc.y"
{
				     g->propWrite = "";
				     g->propRead = "";
				     g->propOverride = tmpPropOverride;
				     g->propReset = "";
				     if ( g->propOverride ) {
					 g->propStored = "";
					 g->propDesignable = "";
					 g->propScriptable = "";
				     } else {
					 g->propStored = "true";
					 g->propDesignable = "true";
					 g->propScriptable = "true";
				     }
				}
break;
case 313:
#line 1424 "moc.y"
{
				    if ( g->propRead.isEmpty() && !g->propOverride )
					moc_err( "A property must at least feature a read method." );
				    checkPropertyName( yyvsp[-2].string );
				    Q_PROPERTYdetected = TRUE;
				    /* Avoid duplicates*/
				    for( QPtrListIterator<Property> lit( g->props ); lit.current(); ++lit ) {
					if ( lit.current()->name == yyvsp[-2].string ) {
					    if ( displayWarnings )
						moc_err( "Property '%s' defined twice.",
							 (const char*)lit.current()->name );
					}
				    }
				    g->props.append( new Property( lineNo, yyvsp[-3].string, yyvsp[-2].string,
								g->propWrite, g->propRead, g->propReset,
								   g->propStored, g->propDesignable,
								   g->propScriptable, g->propOverride ) );
				}
break;
case 315:
#line 1445 "moc.y"
{ g->propRead = yyvsp[-1].string; }
break;
case 316:
#line 1446 "moc.y"
{ g->propWrite = yyvsp[-1].string; }
break;
case 317:
#line 1447 "moc.y"
{ g->propReset = yyvsp[-1].string; }
break;
case 318:
#line 1448 "moc.y"
{ g->propStored = yyvsp[-1].string; }
break;
case 319:
#line 1449 "moc.y"
{ g->propDesignable = yyvsp[-1].string; }
break;
case 320:
#line 1450 "moc.y"
{ g->propScriptable = yyvsp[-1].string; }
break;
case 321:
#line 1453 "moc.y"
{ }
break;
case 322:
#line 1454 "moc.y"
{ g->qtEnums.append( yyvsp[-1].string ); }
break;
case 323:
#line 1457 "moc.y"
{ }
break;
case 324:
#line 1458 "moc.y"
{ g->qtSets.append( yyvsp[-1].string ); }
break;
#line 4679 "y.tab.c"
    }
    yyssp -= yym;
    yystate = *yyssp;
    yyvsp -= yym;
    yym = yylhs[yyn];
    if (yystate == 0 && yym == 0)
    {
#if YYDEBUG
        if (yydebug)
            printf("%sdebug: after reduction, shifting from state 0 to\
 state %d\n", YYPREFIX, YYFINAL);
#endif
        yystate = YYFINAL;
        *++yyssp = YYFINAL;
        *++yyvsp = yyval;
        if (yychar < 0)
        {
            if ((yychar = yylex()) < 0) yychar = 0;
#if YYDEBUG
            if (yydebug)
            {
                yys = 0;
                if (yychar <= YYMAXTOKEN) yys = yyname[yychar];
                if (!yys) yys = "illegal-symbol";
                printf("%sdebug: state %d, reading %d (%s)\n",
                        YYPREFIX, YYFINAL, yychar, yys);
            }
#endif
        }
        if (yychar == 0) goto yyaccept;
        goto yyloop;
    }
    if ((yyn = yygindex[yym]) && (yyn += yystate) >= 0 &&
            yyn <= YYTABLESIZE && yycheck[yyn] == yystate)
        yystate = yytable[yyn];
    else
        yystate = yydgoto[yym];
#if YYDEBUG
    if (yydebug)
        printf("%sdebug: after reduction, shifting from state %d \
to state %d\n", YYPREFIX, *yyssp, yystate);
#endif
    if (yyssp >= yyss + yystacksize - 1)
    {
        goto yyoverflow;
    }
    *++yyssp = yystate;
    *++yyvsp = yyval;
    goto yyloop;
yyoverflow:
    yyerror("yacc stack overflow");
yyabort:
    return (1);
yyaccept:
    return (0);
}
