/* xwindow.h */

#include "wborder.h"
#include "rubber.h"

#ifndef XWINDOW_H
#define XWINDOW_H

class xwindow : public QWidget
{
	Q_OBJECT

	QWidget *dt;                // root window
	WId clientid;               // client window
	int icx, icy, icw, ich;     // normal geometry in maximize state
	int scx, scy, scw, sch;     // normal geometry in screenmode
	char maxstate;              // maximized state 1=toolbar,2=screen
	QPoint mousepos;            // mouse position at button press
	rubber *mrb;                // move/resize rubberband
	bool actpal;                // set to active colors
	bool urgpal;                // set to urgent colors
	QTimer *focustimer;         // autofocus timer
	int borderh;                // diff between parent and client height
	int uborderh;               // upper border height;
	bool prot_delete;           // client has delete WM protocol
	bool prot_takefocus;        // client has take focus WM protocol
	int pos_x, pos_y;                       // XWMNormalHints 
	int base_w, base_h, inc_w, inc_h;       // XWMNormalHints
	int max_w, max_h, min_w, min_h;         // XWMNormalHints
	int wingrav;                            // XWMNormalhints
	long wmnflags;                          // XWMNormalHints
	uint init_w, init_h;        // window initial size
	bool withdrawnstate;
	bool unmapped;              // unmap called
	bool inputfield;            // WMHints
	bool map_iconic;            // WMHints
	bool urgent;                // WMHints
	Colormap cmap;              // colormap
	Window *cmapwins;           // array of subwindows with colormaps
	int ncmaps;                 // number of entries in cmaps
	bool shaped;                // nonrectangular window
	QString wmname;             // WM_NAME property or res_name
	QString icname;             // WM_ICON property or wmname
	QString res_name;           // ClassHint
	QString res_class;          // ClassHint
	QString clientmachine;      // WM_CLIENT_MACHINE
	QString clientfqdn;         // WM_CLIENT_MACHINE
	QString command;            // WM_COMMAND invoke line
	QString clientname;         // res_class or WM_COMMAND basename
	bool sstate;                // screen mode
	QWidget *winfo;             // window info for mid mouse button
	Window transfor;            // TransientForHint or None
	QPixmap wicon;              // icon
	QPixmap wtitle;             // window title
	int pflags;                 // Flags from Property command
	wframe *midmove;            // upper border mid frame for move
	uborder *ubdr;              // upper window border
	lborder *lbdr;              // lower window border
	QVBoxLayout *layout;

	void getsize(int *, int *);            // adjust for possible size
	void send_wmprotocol(long, long);      // send WM_PROTOCOL to child window
	bool query_shape(void);                // nonrectangular window
	void create_wborder(void);             // create window border
	void set_clientstate(int);             // WM_STATE
	void get_servericon(Pixmap, Pixmap);   // set wicon to server icon pixmap
	void getwmprotocols(void);             // get wm protocols

public slots:
	void state(bool);           // map/unmap window
	void wdestroy(void);        // destroy client
	void focus_mouse(void);     // map/raise and set mouse into window
	void map(void);             // map/raise with check for map_iconic 
	void map_normal(void);      // map/raise without check for map_iconic
	void raise(void);           // raise only
	void show_info(void);       // show info on mid mouse button
	void release_info(void);    // release info
	void unmap(void);
	void iconify(void);

	// window frame connects
	
	void t_maximize(void);      // toggle maximize to toolbar
	void s_maximize(void);      // toggle maximize to screen size
	void press_move(QMouseEvent *);           // start move on mouse button
	void release_move(QMouseEvent *);         // set new window position on mouse button release
	void press_leftresize(QMouseEvent *);     // start resize left
	void release_leftresize(QMouseEvent *);   // set new window size on mouse button release
	void press_rightresize(QMouseEvent *);    // start resize right
	void release_rightresize(QMouseEvent *);  // set new window size on mouse button release
	void press_midresize(QMouseEvent *);
	void release_midresize(QMouseEvent *);
	void move_move(QMouseEvent *);            // mouse move for move
	void move_leftresize(QMouseEvent *);      // mouse move for left resize
	void move_rightresize(QMouseEvent *);
	void move_midresize(QMouseEvent *);

public:
	xwindow(Window w, QWidget *parent=0);
	void get_wmname(void);          // get WM_NAME, set caption and create border pixmap
	void get_wmnormalhints(void);   // get WMNormalHints
	void get_wmhints(void);         // get WMHints
	void get_classhint(void);       // WMClassHint
	WId client_id(void)             { return(clientid); }
	int get_pflags(void)            { return(pflags); }
	QString getmachine(void)        { return(clientmachine); }
	void setinactive(void);         // set inactive colors
	void setactive(void);           // set active colors
	void seturgent(void);           // set urgent colors 
	void withdraw(void);            // transition to withdrawn state
	bool iswithdrawn(void)          { return(withdrawnstate); }
	bool isunmapped(void)           { return(unmapped); }
	void reshape(void);             // reshape window
	void startautofocus(void);      // start autofocus
	void stopautofocus(void);       // stop autofocus timer
	void resize_client(int, int, int, int);   // resize with child window
	void resize_request(int, int, int, int);  // client resize request
	void unscreen(void);            // unset screenmode
	bool isstate(void)              { return(sstate); }
	void setchildfocus(long);       // set focus to child window
	void setcmapfocus(void);        // set colormap focus
	void setcmap(Colormap cm)       { cmap = cm; }
	void get_colormaps(void);       // get subwindow colormaps
	QString get_clientname(void)    { return(clientname); }
	void set_pflags(int);           // change pflags
	int get_clienty(void)           { return(y()+uborderh); }
	WId gettransfor(void)           { return(transfor); }
	int getcheight(void)            { return(height()-borderh); } 
	QString ccaption(void)          { return(wmname); }
	QString icaption(void)          { return(icname); }
	QPixmap *icon(void)             { return(&wicon); }
	~xwindow(void);
};
#endif
