/* qapp.h */

#ifndef QAPP_H
#define QAPP_H

#include "toolbar.h"
#include "pager.h"
#include "winlist.h"
#include "menu.h"
#include "procbar.h"
#include "apbar.h"
#include "rubber.h"
#include "xwindow.h"

class qapp : public QApplication
{
protected:
	virtual bool x11EventFilter(XEvent *);

public:
	// Toolbar items
	static Toolbar *tb;     // toolbar
	static pager   *pg;     // pager
	static winlist *wl;     // winlist
	static menu    *mn;     // menu
	static procbar *pb;     // procbar
	static apbar   *ap;     // dclock

	static QPixmap *leftwinpix;           // window button pixmap
	static QPixmap *rightwinpix;          // window button pixmap
	static QList <xwindow> clients;       // client list 
	static QIntDict <xwindow> cwindows;   // child window lookup table
	static QIntDict <xwindow> pwindows;   // parent window lookup table
	static int next_x;                    // autoplacement counter
	static int next_y;                    // autoplacement counter
	static int adesk;                     // current desktop
	static Atom wm_protocols;             // WM_PROTOCOLS
	static Atom wm_delete;                // WM_DELETE property
	static Atom wm_change_state;          // message from client
	static Atom wm_state;                 // message to client 
	static Atom wm_take_focus;            // WM_TAKE_FOCUS property
	static Atom wm_colormaps;             // WM_COLORMAP_WINDOWS property
	static bool smode;                    // screen mode
	static QPalette *ipal;                // window inactive palette
	static QPalette *upal;                // window urgent palette
	static bool mrb;                      // move/resize active
	static xwindow *focusclient;          // currently active client
	static QMap <QString, int> cprops;    // Property flags
	static QMap <QString, int> apclients; // Toolbar clients, position number
	static bool sighup;                   // SIGHUP received
	static int servershapes;              // server supports nonrectangular windows

	enum clflags { WindowListSkip = 0x01, Sticky = 0x02, SmallFrame = 0x04, NoResize = 0x08 };
	
	qapp(int &argc, char **argv);
	void setinactive(xwindow *);
	void stopautofocus(void);
	static void run_client(Window);
	static void install_colormap(Colormap);
	static void read_cprops(void);
	static QString get_cfile(char *);
	void send_configurenotify(xwindow *);
};
#endif
