/* pager.h */

#ifndef PAGER_H
#define PAGER_H

#include "xwindow.h"
#include "defaults.h"

class pager : public QFrame
{
	int vdesks;         // number of virtual desks
	int dwidth;         // desktop width
	int dheight;        // desktop height
	int vw;             // virtual desk width
	int vh;             // virtual desk height
	QPixmap backpix;    // background drawable

	void draw_window(QPainter *painter, QRect &crect);

protected:
	virtual void drawContents(QPainter *);
	virtual void mousePressEvent(QMouseEvent *);

public:
	pager(QWidget *parent, const char *name);
	void draw_pager(void);  // redraw pager
	void change_desk(int desk);     // change active desktop and redraw
	void add(xwindow *);            // add window
};
#endif
