/* main.cpp */

#include "defs.h"
#include "conf.h"
#include "keyboard.h"
#include "qapp.h"
#include "defaults.h"

bool wm_init=TRUE;

void build_toolbar(void)  // create the toolbar
{
	qapp::tb = new Toolbar(0, "Toolbar");
	qapp::tb->setGeometry(0, (defaults::toolbar_top)?(0):(QApplication::desktop()->height()-defaults::tb_height),
	QApplication::desktop()->width(), defaults::tb_height);
	qapp::tb->addspacing(4);

	// pager
	qapp::pg = new pager(qapp::tb, "pager");
	qapp::tb->add(qapp::pg);
	qapp::tb->addspacing(3);

	// winlist
	if(defaults::show_winlist)
	{
		qapp::wl = new winlist(qapp::tb, "winlist");
		qapp::tb->add(qapp::wl);
	}
	else
		qapp::wl = new winlist(0, "winlist");
		

	// menu
	if(defaults::show_menu)
	{
		qapp::mn = new menu(qapp::tb, "menu");
		qapp::tb->add(qapp::mn);
	}	
	else
		qapp::mn = new menu(0, "menu");
		
	qapp::mn->readmenu();

	if(defaults::show_menu || defaults::show_winlist)
		qapp::tb->addsep();

	// procbar
	qapp::pb = new procbar(qapp::tb, "procbar");
	qapp::pb->setFixedHeight(defaults::tc_height);
	qapp::tb->add(qapp::pb);

	qapp::ap = new apbar(qapp::tb, "apbar");
	qapp::tb->add(qapp::ap);

	qapp::tb->addspacing(4);
	qapp::tb->show();
}

void getrunprocs(void)  // get already running clients
{
	Window w,w1,w2,*wins;
	uint nwins,cwin;
	XWindowAttributes attr;

	if(XQueryTree(qt_xdisplay(), qt_xrootwin(), &w1, &w2, &wins, &nwins) == 0 || ! nwins)
		return;

	for(cwin=0; cwin < nwins; cwin++)
	{
		w = wins[cwin];
		
		if(w == qapp::tb->winId())
			continue;

		XGetWindowAttributes(qt_xdisplay(), w, &attr);

		if(attr.map_state == IsViewable)
			qapp::run_client(w);
	}
	XSync(qt_xdisplay(), FALSE);
}

void sig_hup(int)
{
	qapp::sighup = TRUE;
}

void sig_term(int)  // terminate
{
	qapp::pb->remove_all();
	qapp::clients.clear();
	XSync(qt_xdisplay(), FALSE);

	exit(0);
}

void startprg(void)  // start programs from init stack
{
	pid_t pid;
	QString prg;
	while(! defaults::initexec.isEmpty())
	{
		prg = *defaults::initexec.pop();
		
		if((pid = fork()) == 0)
		{
			execl("/bin/sh", "sh", "-c", (const char *)prg, NULL);
			perror("Exec");
			exit(1);
		}
		
		if(pid == -1)
			perror("fork");
	}
}

void make_bpixmaps(void)   // create scaled window button pixmaps
{
	int wh = defaults::windowbuttonsize-4;
	QImage limg(qapp::get_cfile("button_left.xpm"));
	QImage rimg(qapp::get_cfile("button_right.xpm"));
	
	if(qapp::leftwinpix == NULL)
		qapp::leftwinpix = new QPixmap();

	if(qapp::rightwinpix == NULL)
		qapp::rightwinpix = new QPixmap();
	
	if(! limg.isNull())
		qapp::leftwinpix->convertFromImage(limg.smoothScale(wh, wh));
	
	if(! rimg.isNull())
		qapp::rightwinpix->convertFromImage(rimg.smoothScale(wh, wh));
}

int xerrors(Display *d, XErrorEvent *event)
{
	char	msg[100];
	char	req[100];
	char	nmb[100];

	if(wm_init == TRUE && event->error_code == BadAccess)
	{
		cerr << "Another WM is already running\n";
		exit(1);
	}

#ifndef DEBUGMSG
	if(event->error_code == BadWindow || event->error_code == BadMatch)
		return 0;
#endif

	XGetErrorText(d, event->error_code, msg, sizeof(msg));
	sprintf(nmb, "%d", event->request_code);
	XGetErrorDatabaseText(d, "XRequest", nmb, nmb, req, sizeof(req));

	cerr << "WM: " << req << " on resource " << event->resourceid 
	<< " failed: " << msg << '\n';
		
	return 0;
}

int main(int argc, char **argv)
{
	if(argc > 1 && strcmp(argv[1], "--version") == 0)
	{
		cerr << DVERSION;
		return(0);
	}
	
	qapp a(argc, argv);
	
	qapp::clients.setAutoDelete(TRUE);
	defaults::read_config();
	build_toolbar();
	qapp::read_cprops();
	make_bpixmaps();
	a.setMainWidget(qapp::tb);
	
	XSetErrorHandler(xerrors);

	XIconSize *isize;
	if((isize = XAllocIconSize()) != NULL)
	{
		isize->min_width = isize->min_height = 2;
		isize->max_width = isize->max_height = 200;
		isize->width_inc = isize->height_inc = 1;

		XSetIconSizes(qt_xdisplay(), qt_xrootwin(), isize, 1);
		XFree(isize);
	}	

	if(defaults::root_pix.isNull()) 
		a.desktop()->setBackgroundColor(defaults::root_bg);
	else
		a.desktop()->setBackgroundPixmap(QPixmap(defaults::root_pix));

	qapp::upal = new QPalette(defaults::urgent_bg, defaults::urgent_bg);
	qapp::ipal = new QPalette(defaults::inactive_bg, defaults::inactive_bg);

	XSelectInput(qt_xdisplay(), qt_xrootwin(), SubstructureRedirectMask);
	XSync(qt_xdisplay(), FALSE);
	getrunprocs();

	XSelectInput(qt_xdisplay(), qt_xrootwin(),
	SubstructureNotifyMask|SubstructureRedirectMask| 
	ButtonPressMask|
	PropertyChangeMask|
	KeyPressMask|
	ColormapChangeMask|
	EnterWindowMask);

	XSync(qt_xdisplay(), FALSE);

	struct sigaction act;
	
	act.sa_handler = sig_hup;
	act.sa_flags = SA_RESTART;
	sigaction(SIGHUP, &act, NULL);

	act.sa_handler = sig_term;
	sigaction(SIGTERM, &act, NULL);

	keyboard::init();
	wm_init = FALSE;
	startprg();
	
	return(a.exec());
}
