/* keyboard.cpp */

#include "keyboard.h"
#include "qapp.h"

void keyboard::init(void)
{
	XGrabKey(qt_xdisplay(), XKeysymToKeycode (qt_xdisplay(), PREV_WINDOW), PREV_WINDOW_MOD, qt_xrootwin(), True, GrabModeAsync, GrabModeAsync);
	XGrabKey(qt_xdisplay(), XKeysymToKeycode (qt_xdisplay(), NEXT_WINDOW), NEXT_WINDOW_MOD, qt_xrootwin(), True, GrabModeAsync, GrabModeAsync);
 	XGrabKey(qt_xdisplay(), XKeysymToKeycode (qt_xdisplay(), HIDDEN_WINDOW), HIDDEN_WINDOW_MOD, qt_xrootwin(), True, GrabModeAsync, GrabModeAsync);
	XGrabKey(qt_xdisplay(), XKeysymToKeycode (qt_xdisplay(), TOGGLE_SCREENMODE), TOGGLE_SCREENMODE_MOD, qt_xrootwin(), True, GrabModeAsync, GrabModeAsync);
	XGrabKey(qt_xdisplay(), XKeysymToKeycode (qt_xdisplay(), PREV_DESK), PREV_DESK_MOD, qt_xrootwin(), True, GrabModeAsync, GrabModeAsync);
	XGrabKey(qt_xdisplay(), XKeysymToKeycode (qt_xdisplay(), NEXT_DESK), NEXT_DESK_MOD, qt_xrootwin(), True, GrabModeAsync, GrabModeAsync);
	XGrabKey(qt_xdisplay(), XKeysymToKeycode (qt_xdisplay(), WIN_POPUP), WIN_POPUP_MOD, qt_xrootwin(), True, GrabModeAsync, GrabModeAsync);
	XGrabKey(qt_xdisplay(), XKeysymToKeycode (qt_xdisplay(), MENU_POPUP), MENU_POPUP_MOD, qt_xrootwin(), True, GrabModeAsync, GrabModeAsync);
}

bool keyboard::keypress(XKeyEvent *kev)
{
	int sym = (int)XLookupKeysym(kev, 0);
      
	if(sym == PREV_WINDOW && kev->state == PREV_WINDOW_MOD) {
	    prev_win();
	    goto succ_exit;
	} 

	if(sym == NEXT_WINDOW && kev->state == NEXT_WINDOW_MOD) {
	    next_win();
	    goto succ_exit;
	}

	if(sym == HIDDEN_WINDOW && kev->state == HIDDEN_WINDOW_MOD) {
	    qapp::wl->hidden_win();
	    goto succ_exit;
	}

	if(sym == TOGGLE_SCREENMODE && kev->state == TOGGLE_SCREENMODE_MOD) {
	    tscreen();
	    goto succ_exit;
	}

	if(sym == PREV_DESK && kev->state == PREV_DESK_MOD) {
	    pdesk();
	    goto succ_exit;
	}

	if(sym == NEXT_DESK && kev->state == NEXT_DESK_MOD) {
	    ndesk();
	    goto succ_exit;
	}

	if(sym == WIN_POPUP && kev->state == WIN_POPUP_MOD) {
	    qapp::wl->start_popup();
	    goto succ_exit;
	}

	if(sym == MENU_POPUP && kev->state == MENU_POPUP_MOD) {	  
	    qapp::mn->start_popup();
	    goto succ_exit;
	}

	return false;

succ_exit:
	return true;

}

void keyboard::prev_win(void)
{
	xwindow *client,*cur;
	int dwidth = QApplication::desktop()->width();

	if(qapp::focusclient == NULL)
		return;
		
	qapp::clients.find(qapp::focusclient);

	if((client = qapp::clients.current()) == NULL)
		client = qapp::clients.last();

	while(1)
	{
		if((cur = qapp::clients.prev()) == NULL)
			cur = qapp::clients.last();

		if(cur == NULL || cur == client)
			break;

		if(cur->isVisible() && ! (cur->get_pflags() & (qapp::Sticky|qapp::SmallFrame|qapp::NoResize)) &&
		   cur->x()+cur->width()/2 > 0 && cur->x()+cur->width()/2 < dwidth)
		{
			cur->focus_mouse();
			return;
		}
	}
}

void keyboard::next_win(void)
{
	xwindow *client,*cur;
	int dwidth = QApplication::desktop()->width();

	if(qapp::focusclient == NULL)
		return;

	qapp::clients.find(qapp::focusclient);

	if((client = qapp::clients.current()) == NULL)
		client = qapp::clients.first();

	while(1)
	{
		if((cur = qapp::clients.next()) == NULL)
			cur = qapp::clients.first();

		if(cur == NULL || cur == client)
			break;

		if(cur->isVisible() && ! (cur->get_pflags() & (qapp::Sticky|qapp::SmallFrame|qapp::NoResize)) &&
		   cur->x()+cur->width()/2 > 0 && cur->x()+cur->width()/2 < dwidth)
		{
			cur->focus_mouse();
			return;
		}
	}
}

void keyboard::tscreen(void)
{
	xwindow *client,*cur;
	
	if(qapp::smode)
	{
		qapp::smode = FALSE;

		for(client = qapp::clients.first(); client != NULL; client = qapp::clients.next())
			client->unscreen();
	}
	else
	{
		int dwidth = QApplication::desktop()->width();

		if(qapp::focusclient == NULL)
			return;

		qapp::clients.find(qapp::focusclient);

		if((client = qapp::clients.current()) == NULL)
			client = qapp::clients.first();

		cur = client;
		
		do
		{
			if(cur->isVisible() && ! (cur->get_pflags() & (qapp::Sticky|qapp::SmallFrame|qapp::NoResize)) &&
			   cur->x()+cur->width()/2 > 0 && cur->x()+cur->width()/2 < dwidth)
			{
				qapp::smode = TRUE;
				cur->focus_mouse();
				return;
			}
			if((cur = qapp::clients.next()) == NULL)
				cur = qapp::clients.first();
		}
		while(cur != NULL && cur != client);
	}
}

void keyboard::pdesk(void)
{
	if(qapp::smode)
		return;
		
	int desk = qapp::adesk;

	if(--desk < 0)
		desk = defaults::vdesks-1;

	qapp::pg->change_desk(desk);
}

void keyboard::ndesk(void)
{
	if(qapp::smode)
		return;

	int desk = qapp::adesk;

	if(++desk >= defaults::vdesks)
		desk = 0;

	qapp::pg->change_desk(desk);
}
