/************************** * * * * * * * * * * * * ***************************
    Copyright (c) 2000 Ryan Bobko
                       ryan@ostrich-emulators.cx

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
*************************** * * * * * * * * * * * * **************************/
 
#ifndef _QHACCRECWIZ_H
#define _QHACCRECWIZ_H

#include "transaction.h"

#include <qcolor.h>
#include <qlineedit.h>
#include <qdatetime.h>

class Prefs;
class QLabel;
class Account;
class QHaccRecView;
class QHaccLineEdit;
class QHaccDateEdit;
class QHaccAccountManager;

class QHaccRecWin : public QWidget {
  Q_OBJECT
 public:
  QHaccRecWin( Account * =0, QWidget * =0, const char * =0 );
  ~QHaccRecWin();
  void accountOpened( Account * );

 private:
  QHaccRecView * tView;
  QHaccDateEdit * enddate;
  QHaccLineEdit * obal, * ebal;
  QLabel * lblDiff;
  Account * acct;
  const Prefs * prefs;
  float unsum, origUnsum;
  bool firstRun;

  protected slots:
    void hide();
  void changeDate();
  void changeSums( QHaccVector, float, float );
  void refresh();
  void accept();
  void cancel();
};

#endif
