/************************** * * * * * * * * * * * * ***************************
    Copyright (c) 2000 Ryan Bobko
                       ryan@ostrich-emulators.cx

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * ***************************/
#ifndef _QHACCLINEEDITS_H
#define _QHACCLINEEDITS_H

#include <globals.h>

#include <qlabel.h>
#include <qstrlist.h>
#include <qdatetime.h>
#include <qlineedit.h>

class Prefs;

class QHaccLineEdit : public QLineEdit{
  Q_OBJECT
    public:
  QHaccLineEdit( QWidget *, const char * =0 );
  QHaccLineEdit( const QString&, QWidget *, const char * =0 );
  virtual ~QHaccLineEdit();

 protected:
  virtual void focusInEvent( QFocusEvent * );
  virtual void focusOutEvent( QFocusEvent * );
  
 signals:
  void lostFocus();
  
};


class QHaccChoiceEdit : public QHaccLineEdit{
  Q_OBJECT
    public:
  QHaccChoiceEdit( QWidget *, bool =true, const char * =0 );
  QHaccChoiceEdit( const QString&, QWidget *, bool =true, const char * =0 );
  virtual ~QHaccChoiceEdit();
  
  void insertItem( const QString& );
  void insertItems( QStrList );
  void remove( QString );
  void clear();

 protected:
  void keyPressEvent( QKeyEvent * );

 private:
  int index;
  QStrList strings;
  bool allowInserts;

 signals:
  void activated ( int index ) ;
  void activated ( const QString & );
};


class QHaccDateEdit : public QHaccLineEdit{
  Q_OBJECT
    public:
  QHaccDateEdit( QWidget *, const char * =0 );
  QHaccDateEdit( QDate, QWidget *, const char * =0 );
  virtual ~QHaccDateEdit();

  QDate getDate() const;
  void setDate( QDate );
  bool event( QEvent * );

 protected:
  virtual void focusInEvent( QFocusEvent * );
  virtual void focusOutEvent( QFocusEvent * );

 private:
  int currPos, pos;
  QDate day;
  static Prefs * prefs;

  private slots:
    void changeDateFormat( DateFormat );

 signals:
  void dateChanged( QDate );

};
    
#endif
