/************************** * * * * * * * * * * * * ***************************
    Copyright (c) 2000 Ryan Bobko
                       ryan@ostrich-emulators.cx

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * ***************************/

#include "prefs.h"
#include "qhacclineedits.h"

#include <qevent.h>

#include <iostream.h>

/* * * * * * * * * * * * * */
/* * * *  LINEEDIT * * * * */
/* * * * * * * * * * * * * */

enum DATE { MONTH, DAY, YEAR };

//needed to make this because I need a focusout event
QHaccLineEdit::QHaccLineEdit( QWidget * p, const char * n ) : QLineEdit(p,n){}
QHaccLineEdit::QHaccLineEdit( const QString& c, QWidget * p, const char * n )
  : QLineEdit( c, p, n ){}
QHaccLineEdit::~QHaccLineEdit(){}
void QHaccLineEdit::focusInEvent( QFocusEvent * ){
  selectAll();
  setCursorPosition( 0 );
}
void QHaccLineEdit::focusOutEvent( QFocusEvent * ){
  deselect();
  emit lostFocus();
}

  
/* * * * * * * * * * * * * */
/* * * * CHOICEEDIT  * * * */
/* * * * * * * * * * * * * */

//similar to a dropbox, but without the drop part
QHaccChoiceEdit::QHaccChoiceEdit( QWidget * w, bool allow, const char * n )
  : QHaccLineEdit( w, n ){
  allowInserts=allow;
  index=0;
}

QHaccChoiceEdit::QHaccChoiceEdit( const QString& s, QWidget * w, bool allow,
				  const char * n ) : QHaccLineEdit( s, w, n ) {
  allowInserts=allow;
  index=0;
  strings.append( s );
}
QHaccChoiceEdit::~QHaccChoiceEdit(){}

void QHaccChoiceEdit::insertItem( const QString& newOne ){
  if ( !strings.contains( newOne ) ) strings.inSort( newOne );
}
void QHaccChoiceEdit::insertItems( QStrList newOnes ){
  for ( unsigned int i=0; i<newOnes.count(); i++ )
    if ( !strings.contains( newOnes.at( i ) ) )
      strings.inSort( newOnes.at( i ) );
}

void QHaccChoiceEdit::remove( QString s ){ strings.remove( s ); }

void QHaccChoiceEdit::clear(){
  for ( unsigned int i=0; i<strings.count(); i++ ){
    strings.remove( strings.at( i ) );
  }
}

void QHaccChoiceEdit::keyPressEvent( QKeyEvent * qke ){
  /* CAN YOU SAY HACK? */
  switch ( qke->key() ){
  case Key_Up:
    if ( !strings.isEmpty() ){
      index=++index%strings.count();
      setText( strings.at( index ) );
      selectAll();
      setCursorPosition( 0 );
    }
    break;
  case Key_Down:
    if ( !strings.isEmpty() ){
      index=(--index+strings.count() )%strings.count();
      setText( strings.at( index ) );
      selectAll();
      setCursorPosition( 0 );      
    }
    break;
  case Key_Shift:
  case Key_Escape:
    qke->ignore();
    break;
  case Key_Return:
    QHaccLineEdit::keyPressEvent( qke );
    break;
  case Key_Backspace:
  case Key_Delete:
    if ( allowInserts ){
      QString change=text();
      if ( ( int ) change.length() == cursorPosition() ) 
	setText( change.left( cursorPosition() -1 ) );
      else setText( change.left( cursorPosition() ) );
    }      
    break;
  case Key_Right:
    setCursorPosition( cursorPosition()+1 );
    setSelection( cursorPosition(), text().length() );
    break;
  case Key_Left:
    setCursorPosition( cursorPosition()-1 );
    setSelection( cursorPosition(), text().length() );
    break;    
  default:
    QString change;
    
    if ( allowInserts ){
      QHaccLineEdit::keyPressEvent( qke );
      change=text();
    }
    else change=text().left( cursorPosition() ).append( qke->text() );
    
    for ( unsigned int i=0; i<strings.count(); i++ ){
      QString s=strings.at( i );

      if ( change==s.left( change.length() ) ){
	setText( s );
	index=i;
	setSelection( change.length(), text().length() );
	setCursorPosition( change.length() );
	break;
	
      }
    }
  }
}

/* * * * * * * * * * * * * */
/* * * * * DATEEDIT  * * * */
/* * * * * * * * * * * * * */

//a text box that is specially designed to store dates
QHaccDateEdit::QHaccDateEdit( QWidget * p, const char * n ) 
  : QHaccLineEdit( p, n ){

  if ( !prefs ) prefs=Prefs::getInstance();

  connect( prefs, SIGNAL( changedDateFormat( DateFormat ) ),
	   SLOT( changeDateFormat( DateFormat ) ) );
  
  setDate( QDate::currentDate() );
  currPos=0;
}

QHaccDateEdit::QHaccDateEdit( QDate d, QWidget * p,
			      const char * n ) : QHaccLineEdit( p, n ){

  if ( !prefs ) prefs=Prefs::getInstance();

  connect( prefs, SIGNAL( changedDateFormat( DateFormat ) ),
	   SLOT( changeDateFormat( DateFormat ) ) );
  
  setDate( d );
  currPos=0;
}

Prefs * QHaccDateEdit::prefs=0;

QHaccDateEdit::~QHaccDateEdit(){}

void QHaccDateEdit::changeDateFormat( DateFormat ){
  setText( prefs->getDateString( day ) );  
}

void QHaccDateEdit::setDate( QDate d ){
  QDate before=day;
  if( d.isValid() ) day=d;
  else day=QDate::currentDate();
  setText( prefs->getDateString( day ) );
  if ( before!=day ) emit dateChanged( day );
}

void QHaccDateEdit::focusOutEvent( QFocusEvent * ){
  deselect();
  setDate( prefs->getDateFromString( text() ) );
}

void QHaccDateEdit::focusInEvent( QFocusEvent * ){
  //FIX ME: make cursor control respond better to mouse clicks and such

  if ( prefs->getDateFormat()==AMERICAN ) currPos=MONTH;
  else currPos=DAY;
  setCursorPosition( 0 );
  pos=text().find( prefs->getDateSeparator() );
  setSelection( 0, pos );
}

bool QHaccDateEdit::event( QEvent * qe ){
  QString separator=prefs->getDateSeparator();

  if ( qe->type()==QEvent::KeyPress ){
    QKeyEvent * k=( QKeyEvent * )qe;
    if ( k->key()==Key_Tab ){
      if ( currPos==YEAR ) return QWidget::event( qe );
      else {
	int p=text().find( separator, pos );
	setSelection( ++pos, p );
	pos=text().find( separator, pos );
	if ( prefs->getDateFormat()==AMERICAN ) currPos++;
	else{
	  if ( currPos==MONTH ) currPos=YEAR;
	  else if ( currPos==DAY ) currPos=MONTH;
	}
	return true;
      }
    }
    else if ( k->key()==Key_Up ){
      if ( currPos==MONTH )
	setDate( QDate( day.year(), ( ( day.month() )%12 )+1, day.day() ) );
      if ( currPos==DAY )
	setDate( QDate( day.year(), day.month(),
			day.day()%day.daysInMonth()+1 ) );
      if ( currPos==YEAR )
	setDate( QDate( day.year()+1, day.month(), day.day() ) );
      
      setCursorPosition( pos );
      return true;
    }
    else if ( k->key()==Key_Down ){
      int temp=0;
      if ( currPos==MONTH ){
	if ( day.month()==1 ) temp=12;
	else temp=day.month()-1;
	setDate( QDate( day.year(), temp, day.day() ) );
      }
      if ( currPos==DAY ){
	if ( day.day()==1 ) temp=day.daysInMonth();
	else temp=day.day()-1;
	setDate( QDate( day.year(), day.month(), temp ) );
      }
      if ( currPos==YEAR )
	setDate( QDate( day.year()-1, day.month(), day.day() ) );
   
      setCursorPosition( pos );
      return true;
    }
    else return QWidget::event( qe );
  }
  else return QWidget::event( qe );
}

QDate QHaccDateEdit::getDate() const { return day; }

