/************************** * * * * * * * * * * * * ***************************
    Copyright (c) 2000 Ryan Bobko
                       ryan@ostrich-emulators.cx

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * ***************************/

#ifndef _QHACCGRAPHER_H
#define _QHACCGRAPHER_H

#include "globals.h"
#include "qhaccvector.h"


#include <qframe.h>
#include <qstring.h>
#include <qdialog.h>
#include <qdatetime.h>

class Prefs;
class QColor;
class Account;
class QPainter;
class QTextView;
class QComboBox;
class QHaccDateEdit;
class QHaccAccountManager;

// first, a base class for the grapher and reporter
class QHaccGraphFrame : public QFrame{
  Q_OBJECT
    public:
  QHaccGraphFrame( QWidget * =0, const char * =0 );
  virtual ~QHaccGraphFrame();

  void graphit( QString, Account **, unsigned int, QDate, QDate, GraphType );

 protected:
  QString title;
  
  virtual void prepareData( Account **, unsigned int, QDate,
			    QDate, GraphType ) =0;

 public slots:
    virtual void changeColor( QColor );
};


/****************/
/**   GRAPHER  **/
/****************/

class Grapher : public QHaccGraphFrame{
  Q_OBJECT
    public:
  Grapher( QWidget * =0, const char * =0 );
  ~Grapher();

  void prepareData( Account **, unsigned int, QDate, QDate, GraphType );

 protected:
  void drawContents( QPainter * );
  void drawColors( QPainter *, int );
  
 private:
  int partitions, zero;
  QString * headings;
  float * points;
  float * sums;
  QColor * colors;
  GraphType type;
  Prefs * prefs;

  int getHeight() const;
};

/****************/
/**  REPORTER  **/
/****************/

class Reporter : public QHaccGraphFrame{
  Q_OBJECT
    public:
  Reporter( QWidget * =0, const char * =0 );
  ~Reporter();

  static QString makeReport( const QString&, QHaccVector& );
  void prepareData( Account **, unsigned int, QDate, QDate, GraphType );

 protected:
  QTextView * display;

  QHaccVector transactions;
};


/********************/
/**   GRAPHTOPPER  **/
/********************/

class GraphTopper : public QFrame{
  Q_OBJECT
    public:
  GraphTopper( Grapher *, QWidget * =0, const char * =0 );
  GraphTopper( Reporter *, QWidget * =0, const char * =0 );
  ~GraphTopper();
  
 private:
  void init( QHaccGraphFrame * );
  QHaccDateEdit * start, * end;
  QHaccGraphFrame * slave;
  QComboBox * typer, * combo;
  QHaccAccountManager * manager;
  bool graph;

  public slots:
    void changeColor( QColor );
  void changeEntry( int );
  void repaint();
  void accountOpened( const Account * );
};

/*********************/
/**   QHACCGRAPHER  **/
/*********************/

class QHaccGrapher : public QDialog {
  Q_OBJECT
    public:
  enum GType { GRAPH, REPORT };

  QHaccGrapher( GType, QWidget * =0, const char * =0 );
  ~QHaccGrapher();
  
 private:
  GraphTopper * gt;

 public slots:
    void close();
 void accountOpened( const Account * );
};

#endif
