/************************** * * * * * * * * * * * * ***************************
    Copyright (c) 2000 Ryan Bobko
                       ryan@ostrich-emulators.cx

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
*************************** * * * * * * * * * * * * **************************/

#ifndef _QHACC_DIALOGS_H
#define _QHACC_DIALOGS_H

#include "accounts.h"
#include "transaction.h"
#include "qhacclineedits.h"

#include <qcolor.h>
#include <qdialog.h>
#include <qstrlist.h>
#include <qdatetime.h>
#include <qtabdialog.h>

class Prefs;
class QLabel;
class QString;
class QCheckBox;
class QLineEdit;
class QCheckBox;
class QComboBox;
class QPushButton;
class QButtonGroup;
class QRadioButton;
class QHaccDateEdit;
class QHaccChoiceEdit;

/********************************************/
/********* AccountEdit1 definitions *********/
/********************************************/

class QAccountDlg1 : public QWidget{
  Q_OBJECT
    public:
  QAccountDlg1( const Account *, QWidget * =0, const char * =0 );
  ~QAccountDlg1();
  bool getTaxable() const;
  bool isIncome() const;
  float getBal() const;
  QString getName() const;
  QString getNumber() const;
  AccountType getType() const;
  QString getParent() const;
  QString getDefaultTransType() const;

 private:
  int * ids;
  static const int aCHECKING, aSAVINGS, aCREDIT, aASSET, aLIABILITY, aEQUITY, aEXPENSE, aREVENUE, ARRAYSIZE;
  const static char * names[];
  QLineEdit * openBal, * name, * number;
  QHaccChoiceEdit * parent;
  QButtonGroup * typeBox;
  QCheckBox * taxed;
  QComboBox * dttype;

  public slots:
    void checkTypes();
};

/********************************************/
/********* AccountEdit2 definitions *********/
/********************************************/

class QAccountDlg2 : public QWidget{
  Q_OBJECT
    public:
  QAccountDlg2( const Account *, QWidget * =0, const char * =0 );
  ~QAccountDlg2();
  QString * getInstInfo() const;

 private:
  QLineEdit * institution;
  QLineEdit * instaddr1;
  QLineEdit * instaddr2;
  QLineEdit * instcity;
  QLineEdit * inststate;
  QLineEdit * instzip;
  QLineEdit * instcontact;
  QLineEdit * instphone;
  QLineEdit * instfax;
  QLineEdit * instemail;
};

/*********************************************/
/********* AccountEditer definitions *********/
/*********************************************/

class QAccountDlg : public QTabDialog{
  Q_OBJECT
    public:

  QAccountDlg( Account *, QWidget * =0, bool =false,
	       const char * =0 );
  ~QAccountDlg();
  Account * getAccount() const;

 protected:
  void accept();
  void close();

 private:
  Account * account;
  QAccountDlg1 * tab1;
  QAccountDlg2 * tab2;
};

/********************************************/
/******** TransactionDlg definitions ********/
/********************************************/
class QTransDlg : public QDialog {
  Q_OBJECT
    public:

  QTransDlg( Transaction *, bool, const QRect& =QRect(), QWidget * =0,
	     const char * =0, bool =true );
  QTransDlg( Account *, bool, const QRect& =QRect(), QWidget * =0,
	     const char * =0, bool =true );
  ~QTransDlg();

 protected:
  void init( Transaction *, QRect, bool );
  QHaccChoiceEdit ** accounts, * num, * payee, * account;
  QHaccLineEdit ** sums, * memo, * sum;
  QHaccDateEdit * date;
  QPushButton * more;
  Account ** splitAccounts;

  float tsum;
  QString tnum, tpayee, taccount, tmemo;
  Account * owner;
  QDate tdate;
  bool doubleEntry;
  Transaction * mytrans;
  int numSplits;

 private:
  const Prefs * prefs;
  
  public slots:
    void addAnotherSplit();
    void accept();
  void changedSums();
  void matchAccounts();
};


/********************************************/
/*********** PrefsDlg definitions ***********/
/********************************************/

class QHaccPrefsDlg : public QDialog{
  Q_OBJECT
    public:
  QHaccPrefsDlg ( QWidget * =0, const char * =0 );
  ~QHaccPrefsDlg();

  protected slots:
    void accept();
  void close();
  void mColor();
  void aColor();
  void cFont();
  void dEntry();

 private:
  QPushButton * mbtn, * abtn, * fbtn;
  QLineEdit * symbol, * sep, * transTypes;
  QButtonGroup * liner, * dater, * grapher;
  QRadioButton * pie;
  QComboBox * decs;
  QFont fonter;
};


#endif
