/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 2000 Ryan Bobko
                       ryan@ostrich-emulators.cx

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#ifndef _QHACCACCOUNTMANAGER_H
#define _QHACCACCOUNTMANAGER_H

#include "globals.h"

#include <qlist.h>
#include <qobject.h>
#include <qstring.h>
#include <qstrlist.h>

class Account;

class QHaccAccountManager : public QObject{
  Q_OBJECT
    private:
  QHaccAccountManager();
  static QHaccAccountManager * instance;

 public:
  static QHaccAccountManager * getInstance();
  ~QHaccAccountManager();
  QStrList getNames() const;
  QStrList getFullNames() const;
  int count() const;
  Account * getByID( unsigned int ) const;
  Account * get( int ) const;
  Account * get( QString ) const;
  Account * getByFullName( QString ) const;
  QList<Account> getAccounts( AccountType ) const;
  int index( const Account * ) const;
  void add( Account * );
  void remove( Account * );
  void load( Account **, int );
  void setAutoDelete( bool );
  bool isEmpty() const;
  
 private:
  Account ** accounts;
  int numAccounts;

  public slots:
    void resort();

  signals:
  void addedAccount( Account * );
  void removedAccount ( Account * );
};

#endif
