/************************* * * * * * * * * * * * * ***************************
    Copyright (c) 2000 Ryan F Bobko
                       ryan@ostrich-emulators.cx

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
************************** * * * * * * * * * * * * **************************/

#ifndef _QHACC_H
#define _QHACC_H

#include "config.h"
#include "accounts.h"
#include "qhaccview.h"
#include "qhaccrecwin.h"
#include "transaction.h"
#include "qhaccacctman.h"

#include <qstrlist.h>
#include <qapplication.h>

class QLabel;
class Account;
class QCheckBox;
class QComboBox;
class QHaccView;
class QPopupMenu;
class QHaccAccountChooser;

/************************************/
/******** QHacc definitions *********/
/************************************/


class QHacc : public QWidget{
  Q_OBJECT
    public:
  QHacc( const char *, QWidget * =0, const char * =0 );
  ~QHacc();

  enum LType { RESTORE, BALANCES, CRON, ARCHIVE, REPORT };
  static void unmanned( LType, const char *, const char * =0 );

 protected:
  Account * currAcct;
  QHaccView * view;
  QHaccAccountChooser * chooser;

  void load( const char * );
  void initGUI( int );
  Account * getAcct() const;

 private:
  QLabel * balance, * transCount;
  QPopupMenu * prefMenu;
  const char * env;
  static void cron( const char *, const char * );

  public slots:
    void updateBalance( float );
  void accountOpened( Account * );
  void changeSymbol( QString );
  void changeFont( QFont );
  void saveAndQuit();
  void changePrefs();
  void aboutQt();
  void report();
  void chart();
  void about();
  void save();
};

#endif
