/************************** * * * * * * * * * * * * ***************************
    Copyright (c) 2000 Ryan Bobko
                       ryan@ostrich-emulators.cx

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.     
*************************** * * * * * * * * * * * * **************************/

#include "prefs.h"


#include <iostream.h>

Prefs * Prefs::getInstance(){
  if ( !instance ) instance=new Prefs();
  return instance;
}

Prefs * Prefs::instance=0;

Prefs::Prefs(){ resetPrefs(); }

int Prefs::getLines() const { return lines; }
QColor Prefs::getMainColor() const { return mainColor; }
QColor Prefs::getAltColor() const { return altColor; }
QFont Prefs::getFont() const { return font; }
QString Prefs::getSymbol() const { return symbol; }
DateFormat Prefs::getDateFormat() const { return dateFormat; }
QString Prefs::getDateSeparator() const { return separator; }

QDate Prefs::getDateFromString( const QString& dstring ){
  if ( !instance ) instance=new Prefs();

  int start=0,end=0;
  QString sep=instance->getDateSeparator();
  end=dstring.find( sep );
  int m=dstring.left( end ).toInt();
  start=end+1;
  end=dstring.find( sep, start );  
  int d=dstring.mid( start, end-start ).toInt();
  end=dstring.find( sep, start );
  start=end+1;
  int y=dstring.mid( start, end-start ).toInt();

  if ( instance->getDateFormat()==EUROPEAN ){
    //switch day and month for european formats
    int t=m;
    m=d;
    d=t;
  }

  return ( QDate::isValid( y, m, d ) ?
	   QDate( y, m, d ) : QDate::currentDate() );
}

QString Prefs::getDateString( QDate d ) const {
  QString returner;
  QString format="%02d"+separator+"%02d"+separator+"%04d";
  if ( dateFormat==AMERICAN )
    return returner.sprintf( format, d.month(), d.day(), d.year() );
  else
    return returner.sprintf( format, d.day(), d.month(), d.year() );
}

void Prefs::toggleLines() { setLines( (lines==1 ? 2 : 1 ) ); }
void Prefs::setLines( int i ){
  lines=i;
  emit changedLines( lines );
}
void Prefs::setMainColor( QColor c ){
  if ( c.isValid() ){
    mainColor=c;
    emit changedMainColor( c );
  }
}
void Prefs::setAltColor( QColor c ){
  if ( c.isValid() ){
    altColor=c;
    emit changedAltColor( c );
  }
}

void Prefs::setSymbol( QString c ) {
  symbol=c;
  emit changedSymbol( c );
}

void Prefs::resetPrefs(){
  setAltColor( QColor( 173, 216, 230 ) );
  setMainColor ( QColor( 255, 255, 255 ) );
  setLines ( 1 );
  setSymbol( "$" );
  setFont( QFont( "SansSerif" ) );
  setDateSeparator( "/" );
  setDateFormat( AMERICAN );
  setDecoration( SOME );
  setGraphType( BAR );
  if ( transTypes.isEmpty() ) {
    transTypes.append( "ATM" );
    transTypes.append( "DEP" );
    transTypes.append( "WD" );
  }
}

void Prefs::setFont( QFont f ){
  font=f;
  emit changedFont( f );
}

void Prefs::setDateSeparator( QString s ){ separator=s; }
void Prefs::setDateFormat( DateFormat d ){
  dateFormat=d;
  emit changedDateFormat( d );
}

void Prefs::setTransTypes( QStrList strs ){ transTypes=strs; }
QStrList Prefs::getTransTypes() const { return transTypes; }
Decoration Prefs::getDecoration() const { return decs; }
GraphType Prefs::getGraphType() const { return gtype; }
void Prefs::setGraphType( GraphType g ){ gtype=g; }
void Prefs::setDecoration( Decoration d ){
  if ( decs!=d ){
    decs=d;
    emit changedDecoration( decs );
  }
}
