#! /bin/sh
##################################################
## This script will convert the transaction save #
## files from version 0.2 to version 0.2.5       #
##################################################

ACCTS=$(grep "ACCTFILES=" config|cut -d'=' -f2-)
TMP=/tmp/tmper
lookup=/tmp/lkp
ACCTARR=
typeset -i count=0

# version 0.2.1 and above require accounts to have a unique identifier
for f in ${ACCTS}; do
    count=${count}+1
    echo "ACCTID=${count}" >>${f}.info

    cat ${f}.trans|grep -v "NUMTRANS="| awk -F'|' '{print $1, $3}'|
    while read tid pid; do
	echo "!"${tid}"!" ${count} >> ${lookup}
    done
done

for f in ${ACCTS}; do
    echo "NUMTRANS="$(head -1 ${f}.trans|cut -d'=' -f2) > ${TMP}
    cat ${f}.trans|grep -v "NUMTRANS="| awk -F'|' '{print $1, $3,$5"||"$7"||"$9"||"$11"||"$13"||"$15}'|
    while read tid pid line; do
	if [ x"${pid}" == "x0" ]; then
	    echo -n "${tid}||0||" >> ${TMP}
	else
	    typeset -i acct=$(grep "!${pid}!" ${lookup}|cut -d' ' -f2)
	    echo -n "${tid}||1||${pid}||${acct}||" >> ${TMP}
	fi
	echo ${line} >> ${TMP}
    done

    mv ${TMP} ${f}.trans
done
rm -f ${TMP} ${lookup}