#! /bin/sh
##################################################
## This script will convert the transaction save #
## files from version 0.2.1 to version 0.2.5     #
##################################################

ACCTS=$(grep "ACCTFILES=" config|cut -d'=' -f2-)
TMP=/tmp/tmper
typeset -i highcount=0
zerofile=

# accounts used to be numbered from 0, but now, they have
# to be numbered from 1. This loop finds the account that 
# is ID 0, and changes it to an unused number
for f in ${ACCTS}; do
    typeset -i temp=$(grep "ACCTID=" ${f}.info|cut -d'=' -f2)
    
    if [ ${temp} -gt ${highcount} ]; then
	highcount=${temp}
    fi

    if [ x"${temp}" == "x0" ]; then
	zerofile=${f}
    fi
done

# this is the actual conversion
highcount=${highcount}+1
grep -v "ACCTID=" ${zerofile}.info > ${TMP}
echo "ACCTID=${highcount}" >> ${TMP}
mv ${TMP} ${zerofile}.info


# now, let's fix all the transactions
for f in ${ACCTS}; do
    awk -v high=${highcount} -F'|' '{if (NF<2) {print} \
	    else{ if($5==0) {printf "%d||1||%d||%d",$1,$3,high} \
	    else if($5!=-1) {printf "%d||1||%d||%d", $1,$3,$5} \
	    else {printf "%d||0",$1} \
	print "||"$7"||"$9"||"$11"||"$13"||"$15"||"$17}}' ${f}.trans > ${TMP}
    mv ${TMP} ${f}.trans
done
rm -f ${TMP}