/*************************************************************************************************
 * Exception container of Depot
 *                                                      Copyright (C) 2000-2005 Mikio Hirabayashi
 * This file is part of QDBM, Quick Database Manager.
 * QDBM is free software; you can redistribute it and/or modify it under the terms of the GNU
 * Lesser General Public License as published by the Free Software Foundation; either version
 * 2.1 of the License or any later version.  QDBM is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 * You should have received a copy of the GNU Lesser General Public License along with QDBM; if
 * not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307 USA.
 *************************************************************************************************/


package qdbm;



/**
 * Exception container of Depot.
 */
public class DepotException extends DBMException {
  //----------------------------------------------------------------
  // instance fields
  //----------------------------------------------------------------
  /** error code */
  public final int ecode;
  //----------------------------------------------------------------
  // public or protected methods
  //----------------------------------------------------------------
  /**
   * Set the error code with `Depot.EMISC'.
   */
  public DepotException(){
    this(Depot.EMISC);
  }
  /**
   * Set the error code.
   * @param ecode an error code.
   */
  public DepotException(int ecode){
    super(Depot.errmsg(ecode));
    this.ecode = ecode;
  }
}



/* END OF FILE */
