/***************************************************************************
                          rintro.cpp  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/


/****************************************************************************
** rintro.cpp 1998/10/04 A. Mustun RibbonSoft
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#include <qapplication.h>
#include <qfont.h>
#include <qlabel.h>
#include <qpainter.h>
#include <qpixmap.h>

#include "rcolor.h"
#include "rintro.h"
#include "rprgdef.h"

#ifdef DEF_QCAD
#include "xpm/qcadintro.xpm"
#endif

#ifdef DEF_CAM_EXPERT
#include "xpm/camexpintro.xpm"
#endif

// Constructor:
//
RIntro::RIntro(const QString& _version, 
               QWidget* _parent, 
               const char* _name)
  :QWidget(_parent, _name, WStyle_NoBorder)
{
  setFixedSize(222, 149);  // 256 158

  if(parentWidget()) {
    move((parentWidget()->width()-width())/2,
         (parentWidget()->height()-height())/2);
  }

  sVersion =_version;

}



// Destructor:
//
RIntro::~RIntro()
{

}



// Paint:
//
void 
RIntro::paintEvent(QPaintEvent* _ev)
{
  QWidget::paintEvent(_ev);

  QPainter paint;        // painter
  
  paint.begin(this);
  paint.drawPixmap(0, 0, QPixmap(DEF_INTRO));
  
  paint.setFont(QFont("helvetica", 10));
  paint.setPen(rBlack);
  paint.drawText(0, 0, width(), height()-2,
                 AlignLeft|AlignBottom,
                 DEF_INTERNET);
                 
  paint.drawText(0, 0, width(), height()-2,
                 AlignRight|AlignBottom,
                 sVersion);
  paint.end();

}




// EOF

