/*
	Copyright (c) 2003, Nullcube Pty Ltd
	All rights reserved.

	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions are met:

	*   Redistributions of source code must retain the above copyright notice, this
		list of conditions and the following disclaimer.
	*   Redistributions in binary form must reproduce the above copyright notice,
		this list of conditions and the following disclaimer in the documentation
		and/or other materials provided with the distribution.
	*   Neither the name of Nullcube nor the names of its contributors may be used to
		endorse or promote products derived from this software without specific prior
		written permission.

	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
	ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
	WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
	DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
	ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
	LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
	ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
	(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
	SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <sys/param.h>
#include <sys/socket.h>
#include <sys/mbuf.h>
#include <net/if.h>
#include <net/pfvar.h>
#include <net/if_pflog.h>
#include <Python.h>

static PyMethodDef PfMethods[] = {
    {NULL, NULL, 0, NULL}        /* Sentinel */
};

void init_sysvar(void){
    PyObject *module;
    module = Py_InitModule4("_sysvar", PfMethods, NULL, NULL, PYTHON_API_VERSION);

    /* From <sys/socket.h> */
    PyModule_AddIntConstant(module, "AF_UNSPEC",    (long) AF_UNSPEC);      /* unspecified */
    PyModule_AddIntConstant(module, "AF_LOCAL",     (long) AF_LOCAL);       /* local to host (pipes, portals) */
    PyModule_AddIntConstant(module, "AF_INET",      (long) AF_INET);        
    PyModule_AddIntConstant(module, "AF_APPLETALK", (long) AF_APPLETALK);   /* Apple Talk */
    PyModule_AddIntConstant(module, "AF_ROUTE",     (long) AF_ROUTE);       /* Internal Routing Protocol */
    PyModule_AddIntConstant(module, "AF_LINK",      (long) AF_LINK);        /* Link layer interface */
    PyModule_AddIntConstant(module, "AF_INET6",     (long) AF_INET6);       
    PyModule_AddIntConstant(module, "AF_ENCAP",     (long) AF_ENCAP);       

    /* From <net/if.h> */
    PyModule_AddIntConstant(module, "IFNAMSIZ",                 (long) IFNAMSIZ);       
    PyModule_AddIntConstant(module, "PF_RULESET_NAME_SIZE",     (long) PFLOG_RULESET_NAME_SIZE);       

    /* From <net/pfvar.h> */
    /* Reasons */
    PyModule_AddIntConstant(module, "PFRES_MATCH",  (long) PFRES_MATCH);       
    PyModule_AddIntConstant(module, "PFRES_BADOFF", (long) PFRES_BADOFF);       
    PyModule_AddIntConstant(module, "PFRES_FRAG",   (long) PFRES_FRAG);       
    PyModule_AddIntConstant(module, "PFRES_SHORT",  (long) PFRES_SHORT);       
    PyModule_AddIntConstant(module, "PFRES_NORM",   (long) PFRES_NORM);       
    PyModule_AddIntConstant(module, "PFRES_MEMORY", (long) PFRES_MEMORY);       

    /* Actions */
    PyModule_AddIntConstant(module, "PFACT_PASS",               (long) PF_PASS);       
    PyModule_AddIntConstant(module, "PFACT_DROP",               (long) PF_DROP);       
    PyModule_AddIntConstant(module, "PFACT_SCRUB",              (long) PF_SCRUB);       
    PyModule_AddIntConstant(module, "PFACT_NAT",                (long) PF_NAT);       
    PyModule_AddIntConstant(module, "PFACT_NONAT",              (long) PF_NONAT);       
    PyModule_AddIntConstant(module, "PFACT_BINAT",              (long) PF_BINAT);       
    PyModule_AddIntConstant(module, "PFACT_NOBINAT",            (long) PF_NOBINAT);       
    PyModule_AddIntConstant(module, "PFACT_RDR",                (long) PF_RDR);       
    PyModule_AddIntConstant(module, "PFACT_NORDR",              (long) PF_NORDR);       
    PyModule_AddIntConstant(module, "PFACT_SYNPROXY_DROP",      (long) PF_SYNPROXY_DROP);       

    /* Directions */
    PyModule_AddIntConstant(module, "PFDIR_INOUT",              (long) PF_INOUT);       
    PyModule_AddIntConstant(module, "PFDIR_IN",                 (long) PF_IN);       
    PyModule_AddIntConstant(module, "PFDIR_OUT",                (long) PF_OUT);       

    /* enc interface packet format flags */
    PyModule_AddIntConstant(module, "ENC_CONF",                 (long) M_CONF);       
    PyModule_AddIntConstant(module, "ENC_AUTH",                 (long) M_AUTH);       
    PyModule_AddIntConstant(module, "ENC_AUTH_AH",              (long) M_AUTH_AH);       
}
