#ifndef __FTPWHO_UPDATE_H__
#define __FTPWHO_UPDATE_H__ 1

#ifdef FTPWHO

#define SCOREBOARD_PATH "/var/run/pure-ftpd"
#define SCOREBOARD_PREFIX "client-"

typedef enum {
    FTPWHO_STATE_FREE = 0,                    /* must be first (0) */
        FTPWHO_STATE_IDLE, FTPWHO_STATE_DOWNLOAD, FTPWHO_STATE_UPLOAD
} FTPWhoEntryState;

typedef struct FTPWhoEntry_ {
    FTPWhoEntryState state;        
    pid_t pid;
    struct sockaddr_storage addr;
    struct sockaddr_storage local_addr;    
    time_t date;
    time_t xfer_date;
    char account[9];
    char filename[43];
    volatile off_t restartat;
    volatile off_t download_total_size;
    volatile off_t download_current_size;
} FTPWhoEntry;

int ftpwho_initwho(void);
void ftpwho_exit(const int ret);
void ftpwho_lock(void);
void ftpwho_unlock(void);
#ifndef NO_STANDALONE
void ftpwho_unlinksbfile(const pid_t pid);
#endif
    
#endif

#endif
