##############################################################################
# 
# Zope Public License (ZPL) Version 1.0
# -------------------------------------
# 
# Copyright (c) Digital Creations.  All rights reserved.
# 
# This license has been certified as Open Source(tm).
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are
# met:
# 
# 1. Redistributions in source code must retain the above copyright
#    notice, this list of conditions, and the following disclaimer.
# 
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions, and the following disclaimer in
#    the documentation and/or other materials provided with the
#    distribution.
# 
# 3. Digital Creations requests that attribution be given to Zope
#    in any manner possible. Zope includes a "Powered by Zope"
#    button that is installed by default. While it is not a license
#    violation to remove this button, it is requested that the
#    attribution remain. A significant investment has been put
#    into Zope, and this effort will continue if the Zope community
#    continues to grow. This is one way to assure that growth.
# 
# 4. All advertising materials and documentation mentioning
#    features derived from or use of this software must display
#    the following acknowledgement:
# 
#      "This product includes software developed by Digital Creations
#      for use in the Z Object Publishing Environment
#      (http://www.zope.org/)."
# 
#    In the event that the product being advertised includes an
#    intact Zope distribution (with copyright and license included)
#    then this clause is waived.
# 
# 5. Names associated with Zope or Digital Creations must not be used to
#    endorse or promote products derived from this software without
#    prior written permission from Digital Creations.
# 
# 6. Modified redistributions of any form whatsoever must retain
#    the following acknowledgment:
# 
#      "This product includes software developed by Digital Creations
#      for use in the Z Object Publishing Environment
#      (http://www.zope.org/)."
# 
#    Intact (re-)distributions of any official Zope release do not
#    require an external acknowledgement.
# 
# 7. Modifications are encouraged but must be packaged separately as
#    patches to official Zope releases.  Distributions that do not
#    clearly separate the patches from the original work must be clearly
#    labeled as unofficial distributions.  Modifications which do not
#    carry the name Zope may be packaged in any form, as long as they
#    conform to all of the clauses above.
# 
# 
# Disclaimer
# 
#   THIS SOFTWARE IS PROVIDED BY DIGITAL CREATIONS ``AS IS'' AND ANY
#   EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
#   PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL DIGITAL CREATIONS OR ITS
#   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
#   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
#   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
#   USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
#   ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
#   OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
#   OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
#   SUCH DAMAGE.
# 
# 
# This software consists of contributions made by Digital Creations and
# many individuals on behalf of Digital Creations.  Specific
# attributions are listed in the accompanying credits file.
# 
##############################################################################

'''$Id: db.py,v 1.25.2.3 2001/09/03 11:09:57 fog Exp $'''
__version__='$Revision: 1.25.2.3 $'[11:-2]

from Shared.DC.ZRDB.TM import TM
from Shared.DC.ZRDB import dbi_db

import string, sys
from string import strip, split, find
from time import time
from types import ListType
import site

import psycopg
from psycopg import NUMBER, STRING, INTEGER, FLOAT, DATETIME
from psycopg import BOOLEAN, ROWID, LONGINTEGER

failures = 0
calls = 0
last_call_time = time()

class DB(TM,dbi_db.DB):

    _p_oid = _p_changed = _registered = None

    Database_Connection = psycopg.connect

    def __init__(self, connection):
        self.connection = connection
        try:
            self.db = self.Database_Connection(self.connection)
        except psycopg.Error:
            raise sys.exc_type, sys.exc_value, sys.exc_traceback
	self.cursor = self.db.cursor()
        
    def _begin(self):
	#we want to begin the transaction when the TM start its work
	self.db.rollback()
	
    def _finish(self, *ignored):
        try:
            self.db.commit()
        except psycopg.Error:
            raise sys.exc_type, sys.exc_value, sys.exc_traceback
            
    def _abort(self, *ignored):
        if self.db is None:
            return
        else:
            try:
                self.db.rollback()
            except psycopg.Error:
                pass

    def tables(self, rdb=0, _care=('TABLE', 'VIEW')):
        c = self.db.cursor()
        c.execute('SELECT t.tablename AS NAME, '
                  '\'TABLE\' AS TYPE FROM pg_tables t '
                  'UNION SELECT v.viewname AS NAME, '
                  '\'VIEW\' AS TYPE FROM pg_views v ')
        r = []
        a = r.append
        for name, typ in c.fetchall():
            if typ in _care:
                a({'TABLE_NAME': name, 'TABLE_TYPE': typ})
        c.close()
        return r

    def columns(self, table_name):
        c = self.db.cursor()
        try:
            r = c.execute('select * from %s limit 1', table_name)
        except:
            return ()
        desc = c.description
        r = []
        a = r.append
        for name, type, width, ds, p, scale, null_ok in desc:
            if type == NUMBER:
                if type == INTEGER:
                    type = INTEGER
                elif type == FLOAT:
                    type = FLOAT
                else: type = NUMBER
            elif type == BOOLEAN:
                type = BOOLEAN
            elif type == ROWID:
                type = ROWID
            elif type == DATETIME:
                type = DATETIME
            else:
                type = STRING
            a({ 'Name': name,
                'Type': type.name,
                'Precision': 0,
                'Scale': 0,
                'Nullable': 0})
        return r

    def query(self, query_string, max_rows=9999999):
        global failures, calls, last_call_time
        calls = calls+1
        desc = None
        result = ()
        self._register()
        c = self.cursor
        nselects = 0
        try:
            for qs in filter(None, map(strip, split(query_string, '\0'))):
                r = c.execute(qs)
                if c.description is not None:
                    nselects = nselects + 1
                    if c.description != desc and nselects > 1:
                        raise 'Query Error', (
                            'Multiple select schema are not allowed')
                    if type(result) is not ListType:
                        result = list(result)
                    if max_rows:
                        result = c.fetchmany(max_rows)
                    desc = c.description
            failures = 0
        except psycopg.OperationalError, err:
            try:
                del c
                self.db = self.Database_Connection(self.connection)
                self.cursor = self.db.cursor()
            except:
                raise sys.exc_type, sys.exc_value, sys.exc_traceback
            failures = 0
            return self.query(query_string, max_rows)
        except psycopg.InterfaceError, err:
            if self.db is not None:
                del c
                self.db = self.Database_Connection(self.connection)
                self.cursor = self.db.cursor()
                return self.query(query_string, max_rows)
            else:
                raise sys.exc_type, sys.exc_value, sys.exc_traceback
        except psycopg.Error, err:
            failures = failures + 1
            if (failures > 1000):
                #try to open a new connection if this one had more
                #than 1000 errors
                failures = 0
                try:
                    del c
                    self.db = self.Database_Connection(self.connection)
                    self.cursor = self.db.cursor()
                except:
                    raise sys.exc_type, sys.exc_value, sys.exc_traceback
                return self.query(query_string, max_rows)
            else:
                raise sys.exc_type, sys.exc_value, sys.exc_traceback

        if not result:
            return (),()

        items = []
        for name, typ, width, ds, p, scale, null_ok in desc:
            if typ == NUMBER:
                if typ == INTEGER or typ == LONGINTEGER: typs = 'i'
                else: typs = 'n'
            elif typ == BOOLEAN:
                typs = 'n'
            elif typ == ROWID:
                typs = 'i'
            elif typ == DATETIME:
                typs = 'd'
            else:
                typs = 's'
            items.append({
                'name': name,
                'type': typs,
                'width': width,
                'null': null_ok,
                })

        return items, result

    def close(self):
        """Close the connection."""
        self.cursor.close()
        self.db.close()
        self.db = None
        self.cursor = None
        
