/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#define __MAIN_C

#include <gtk/gtk.h>
#include <signal.h>
#include <string.h>
#include <stdlib.h>
#include "global.h"
#include "pidlist.h"
#include "interface.h"
#include "support.h"


/*pour compiler ffmpeg: sur mon Athlon-XP2000+
apres extraction des sources:
CFLAGS="-O3 -march=athlon-xp -mfpmath=sse,387 -msse -mmmx -m3dnow -pipe -fforce-addr 
-fomit-frame-pointer -funroll-loops -frerun-cse-after-loop -frerun-loop-opt -falign-functions=4 
-maccumulate-outgoing-args -fprefetch-loop-arrays"
./configure --prefix=/usr/share/pspvc -disable-shared-pp --disable-shared --enable-static --enable-mmx 
--disable-altivec --disable-debug --enable-mp3lame --enable-a52 --disable-a52bin --enable-audio-oss 
--enable-v4l --disable-dv1394 --disable-dc1394 --enable-pthreads --enable-xvid --enable-ogg --enable-vorbis 
--disable-dts --disable-network --enable-zlib --enable-ffplay --enable-faad --enable-faac --disable-faadbin 
--enable-gpl --enable-pp --disable-opts
make
make install
*/
		

int newstdout;

gboolean idlefunc(void)
{
	pidlist *tmp;
	struct convparam *shm_param;
	int shmid,i;
	gboolean childkilled=FALSE,conversion_running=FALSE;
	gchar *txt;
	if(pl_count>0)
	{
		tmp=pl_first;
		while(tmp)
		{
			shmid=shmget((int)tmp->pid,sizeof(struct convparam),0600);
			if(shmid>0)
			{
				shm_param=shmat(shmid,NULL,SHM_RND);
				childkilled=shm_param->killme;
				if(!shm_param->finished)
				{
					if(shm_param->running)
					{  
						GtkWidget *pass_bar,*button,*timeE,*timeR,*Fps;
						gdouble pourcentage;
						gdouble eta=0,rt=0,fps=0;;
						time_t current_time;
						guint hh,mm,ss;
						conversion_running=TRUE;
						pass_bar=lookup_widget(GTK_WIDGET(tmp->convertwindow), "currentbar");
//						total_bar=lookup_widget(GTK_WIDGET(tmp->convertwindow), "totalbar");
						timeE=lookup_widget(GTK_WIDGET(tmp->convertwindow), "ET");
						timeR=lookup_widget(GTK_WIDGET(tmp->convertwindow), "RT");
						Fps=lookup_widget(GTK_WIDGET(tmp->convertwindow), "FPS");
						if(shm_param->badinputformat==1)
						{
							GtkWidget* msg_dialog;
							msg_dialog=gtk_message_dialog_new(GTK_WINDOW(tmp->convertwindow),GTK_DIALOG_MODAL,GTK_MESSAGE_ERROR,GTK_BUTTONS_CLOSE,_("Unknown input format !!!"));		
							gtk_dialog_run (GTK_DIALOG (msg_dialog));
							gtk_widget_destroy (msg_dialog);
							shm_param->badinputformat=2;
						}
						if(shm_param->DrawButtonText)
						{
							button=lookup_widget(GTK_WIDGET(tmp->convertwindow), "button");
							txt=g_strdup_printf("%s",_("Cancel"));
							gtk_button_set_label (GTK_BUTTON(button),txt);
							g_free(txt);
							shm_param->DrawButtonText=FALSE;
						}
/*						if(shm_param->DrawPassText)
						{
							if(shm_param->pass_current<=shm_param->pass)
								txt=g_strdup_printf("%s",_("Converting"),shm_param->pass_current);
							else
								txt=g_strdup_printf("%s",_("Thumbnail"));
							gtk_progress_bar_set_text(GTK_PROGRESS_BAR(pass_bar),txt);
							g_free(txt);
							shm_param->DrawPassText=FALSE;
						}*/
						pourcentage=(gdouble)(shm_param->fps_reached[shm_param->pass_current-1])/(gdouble)(shm_param->fps_target);
						if(pourcentage>1.0)
							pourcentage=1.0;
						gtk_progress_bar_update(GTK_PROGRESS_BAR(pass_bar),pourcentage);
/*						pourcentage=(gdouble)(shm_param->fps_reached[0]+shm_param->fps_reached[1])/(gdouble)(shm_param->fps_target*shm_param->pass);
						if(pourcentage>1.0)
							pourcentage=1.0;
//				gtk_progress_bar_update(GTK_PROGRESS_BAR(total_bar),pourcentage);*/
						if(shm_param->pass_current<=shm_param->pass)
						{
							current_time=time(NULL);
							eta=difftime(current_time,shm_param->starttime);
							if(eta!=0)
								fps=(shm_param->fps_reached[0]+shm_param->fps_reached[1])/eta;
							else
								fps=0;
							if(fps!=0)
								rt=((double)(shm_param->fps_target*shm_param->pass)/fps)-eta;
							else
								rt=0;
							hh=mm=0;
							ss=(guint)eta;
							while(ss>59)
							{
								ss-=60;
								mm++;
								if(mm==60)
								{
									hh++;
									mm=0;
								}
							}
							txt=g_strdup_printf("E:%02dh%02dm%02ds",hh,mm,ss);
							gtk_label_set_text(GTK_LABEL(timeE),txt);
							g_free(txt);
							if(rt>0.0)
							{
								hh=mm=0;
								ss=(guint)rt;
								while(ss>59)
								{
									ss-=60;
									mm++;
									if(mm==60)
									{
										hh++;
										mm=0;
									}
								}
								txt=g_strdup_printf("R:%02dh%02dm%02ds",hh,mm,ss);
								gtk_label_set_text(GTK_LABEL(timeR),txt);
								g_free(txt);
							}
							txt=g_strdup_printf("fps:%.2f",fps);
							gtk_label_set_text(GTK_LABEL(Fps),txt);
							g_free(txt);
						}
					}
					else
					{
						if(shm_param->DrawButtonText)
						{
							GtkWidget *button;
							button=lookup_widget(GTK_WIDGET(tmp->convertwindow), "button");
							txt=g_strdup_printf("%s",_("Start"));
							gtk_button_set_label (GTK_BUTTON(button),txt);
							g_free(txt);
							shm_param->DrawButtonText=FALSE;
						}
					}
				}
				else
				{
					shm_param->running=FALSE;
					if(shm_param->DrawButtonText)
					{
						GtkWidget *pass_bar,*button,*bt_thm,*framelabel,*framespin,*thm;
						pass_bar=lookup_widget(GTK_WIDGET(tmp->convertwindow), "currentbar");
						//total_bar=lookup_widget(GTK_WIDGET(tmp->convertwindow), "totalbar");
						button=lookup_widget(GTK_WIDGET(tmp->convertwindow), "button");
						bt_thm=lookup_widget(GTK_WIDGET(tmp->convertwindow), "btThm");
						framelabel=lookup_widget(GTK_WIDGET(tmp->convertwindow), "second");
						framespin=lookup_widget(GTK_WIDGET(tmp->convertwindow), "spinsecond");
						thm=lookup_widget(GTK_WIDGET(tmp->convertwindow), "thm");
						txt=g_strdup_printf("%s",_("Close"));
						gtk_progress_bar_update(GTK_PROGRESS_BAR(pass_bar),1.0);
						//gtk_progress_bar_update(GTK_PROGRESS_BAR(total_bar),1.0);
						gtk_button_set_label (GTK_BUTTON(button),txt);
						g_free(txt);
						if(shm_param->codec==0)
							txt=g_strdup_printf("%s/MAQ%05d.THM",shm_param->currentpath,shm_param->pspnum);
						else
							txt=g_strdup_printf("%s/M4V%05d.THM",shm_param->currentpath,shm_param->pspnum);
						gtk_image_set_from_file(GTK_IMAGE(thm),txt);
						g_free(txt);
						gtk_widget_set(GTK_WIDGET(bt_thm),"visible",TRUE,NULL);
						gtk_widget_set(GTK_WIDGET(framelabel),"visible",TRUE,NULL);
						gtk_widget_set(GTK_WIDGET(framespin),"visible",TRUE,NULL);
						gtk_spin_button_set_range(GTK_SPIN_BUTTON(framespin),1.0,shm_param->duration);
						gtk_spin_button_set_value(GTK_SPIN_BUTTON(framespin),(gdouble)shm_param->thm_second);
						shm_param->DrawButtonText=FALSE;
					}
				}
				if(childkilled)
				{
					shm_param->running=FALSE;
					for(i=0;i<2;i++)
						if(shm_param->ffmpeg_conv_tokill[i])
							kill(shm_param->ffmpeg_conv_tokill[i],9);
					for(i=0;i<shm_param->thm_conv_cpt;i++)
						if(shm_param->ffmpeg_thm_tokill[i])
							kill(shm_param->ffmpeg_thm_tokill[i],9);
					kill(tmp->pid,9);
					gtk_widget_destroy(tmp->convertwindow);
					pl_remove(tmp->pid);
				}
				shmdt(shm_param);
				if(childkilled)
				{
					shmctl(shmid,IPC_RMID,NULL);
					tmp=NULL;
				}
				else
					tmp=tmp->next;
			}
		}
		if((!conversion_running)&&(pl_first))
		{
			pidlist *tmp;
			gboolean bcont=TRUE;
			tmp=pl_first;
			while(bcont)
			{
				if(tmp)
				{
					shmid=shmget((int)tmp->pid,sizeof(struct convparam),0600);
					shm_param=shmat(shmid,NULL,SHM_RND);
					if(!shm_param->finished)
					{
						shm_param->DrawButtonText=TRUE;
						shm_param->running=TRUE;
						bcont=FALSE;
					}
					tmp=tmp->next;
					shmdt(shm_param);
				}
				else
					bcont=FALSE;
			}
		}

	}
	while(gtk_events_pending())
		gtk_main_iteration();
	gdk_flush();			
	usleep(200);
	return TRUE;
}


int
main (int argc, char *argv[])
{
  GtkWidget *windowapp;
  gchar token[1024],oldtoken[1024];
  gint cpt=0;
  nb_threads=0;
	printf("http://pspvc.sourceforge.net\n");
	pspvc_log("---------BEGIN\n",1);
#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif

  gtk_set_locale ();
  gtk_init (&argc, &argv);
  add_pixmap_directory (PACKAGE_DATA_DIR  "/pixmaps");

  while(cpt<argc)
  {
  	strcpy(token,argv[cpt++]);
	if(!strcmp(oldtoken,"--threads"))
		nb_threads=atoi(token);
  	strcpy(oldtoken,token);

  }
  if(!nb_threads)
  	nb_threads=1;
  /*
   * The following code was added by Glade to create one of each component
   * (except popup menus), just so that you see something after building
   * the project. Delete any components that you don't want shown initially.
   */
  pl_init();
  options.codec=0;
  options.aspect=3;
  options.volume=100;
  options.vb=384;
 options.ab=64;
  newstdout=dup((long)stdout);
  g_idle_add((GSourceFunc)idlefunc,NULL);
  windowapp = create_mainwindow ();
  gtk_window_set_title (GTK_WINDOW (windowapp), _("PSP Video Converter (v"VERSION")"));
  gtk_widget_show (windowapp);

  gtk_main ();
  return 0;
}

void pspvc_log(char *tolog,int NewFile)
{
	if(DEBUG)
	{
		FILE *logout;
		if(NewFile)
			logout=fopen("pspvc.log","w");
		else		
			logout=fopen("pspvc.log","a");
		fprintf(logout,"%s",tolog);
		fclose(logout);
	}
}

#undef __MAIN_C
