#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "global.h"
#include "pidlist.h"
#include "callbacks.h"
#include "interface.h"
#include "support.h"


void launchffmpeg_video(struct convparam *param,gint pass,gint fatherpid);
void launchffmpeg_thumbnail(struct convparam *param,gint fatherpid);
void setoutputprefix(gint codec,GtkWidget* widget);

void
on_browse_button_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *dialog;

	dialog = gtk_file_chooser_dialog_new ("Open File",
				      NULL,
				      GTK_FILE_CHOOSER_ACTION_OPEN,
				      GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
				      GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
				      NULL);

	if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT)
  	{
		GtkWidget *filename,*title;
		gchar **list,**list2;
		gint i,idx=0;
		gboolean bCont;
		filename=lookup_widget(GTK_WIDGET(button), "filename_entry");
		title=lookup_widget(GTK_WIDGET(button), "title_entry");
		sprintf(options.filename,"%s",gtk_file_chooser_get_preview_filename (GTK_FILE_CHOOSER (dialog)));
		sprintf(options.title,"%s",gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog)));
		sprintf(options.currentpath,"%s",gtk_file_chooser_get_current_folder(GTK_FILE_CHOOSER (dialog)));
		list=g_strsplit (options.title,"/",50);
		bCont=TRUE;
		i=0;
		while(bCont)
		{
			if(list[i])
			{
				idx=i;
			}
			else 
				bCont=FALSE;
			i++;
		}
		list2=g_strsplit (list[idx],".",50);
		if(list2[0])
    		if (strlen(list2[0]) <= 127)
        		sprintf(options.title,"%s",list2[0]);
    		else
        		strncpy(options.title,list2[0],127);
		else
    		sprintf(options.title,"<Title>");
		g_strfreev(list2);
		g_strfreev(list);
		gtk_entry_set_text(GTK_ENTRY(filename),options.filename);
		gtk_entry_set_text(GTK_ENTRY(title),options.title);
  	}
	gtk_widget_destroy (dialog);	
}




void setoutputprefix(gint codec,GtkWidget* widget)
{
	GtkWidget *prefilename_wdg;
	prefilename_wdg=lookup_widget(widget, "prefilename");
	if(codec==0)
		gtk_label_set_text(GTK_LABEL(prefilename_wdg),"MAQ");
	else
		gtk_label_set_text(GTK_LABEL(prefilename_wdg),"M4V");
}


void
on_startcancel_button_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
	pidlist *tmp;
	struct convparam *shm_param;
	GtkWidget *button_wdg;
	gboolean Found=FALSE;
	int shmid;
	if(pl_count>0)
	{
		tmp=pl_first;
		while((tmp)&&(!Found))
		{
			if(tmp->convertwindow)
			{
				button_wdg=lookup_widget(GTK_WIDGET(tmp->convertwindow), "button");
				if(GTK_WIDGET(button)==button_wdg)
				{
					Found=TRUE;
					shmid=shmget((int)tmp->pid,sizeof(struct convparam),0600);
					if(shmid>0)
					{
						shm_param=shmat(shmid,NULL,SHM_RND);
						if((shm_param->running)||(shm_param->finished))
						{
							shm_param->running=FALSE;
							shm_param->killme=TRUE; 
						}
						else
						{
							shm_param->DrawButtonText=TRUE;
							shm_param->running=TRUE;
						}
						shmdt(shm_param);
					}
				}
			}
			tmp=tmp->next;
		}
	}
}


void
on_convert_button_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *filename_wdg,*title_wdg,*pspnum_wdg,*mainwindow_wdg,*volume_wdg;
	gint giErr=0;
	struct convparam *param;
	filename_wdg=lookup_widget(GTK_WIDGET(button), "filename_entry");
	title_wdg=lookup_widget(GTK_WIDGET(button), "title_entry");
	pspnum_wdg=lookup_widget(GTK_WIDGET(button), "pspnum_spinbutton");
	volume_wdg=lookup_widget(GTK_WIDGET(button), "volume_spinbutton");
	mainwindow_wdg=lookup_widget(GTK_WIDGET(button), "mainwindow");
	param=g_new(struct convparam,1);
// VIDEO CODEC
	param->codec=options.codec;
// VB
	param->vb = options.vb;
// AB
	param->ab =	options.ab;
// PASS		
	param->pass = 1;//gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(pass_wdg));
// VOLUME
	param->volume = (gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(volume_wdg))*256)/100;
// ASPECT
	param->aspect=options.aspect;
// PSPNUM
	param->pspnum = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(pspnum_wdg));
// TITLE
	sprintf(param->title,"%s",gtk_entry_get_text(GTK_ENTRY(title_wdg)));
	if(!g_strcasecmp(param->title,""))
	{
		sprintf(param->title,"%05d",param->pspnum);
	}
// FILENAME
	strcpy(param->currentpath,options.currentpath);
	param->filename[0]=0;
	sprintf(param->filename,"%s",gtk_entry_get_text(GTK_ENTRY(filename_wdg)));
	if(!g_strcasecmp(param->filename,""))
		giErr=-1; // filename empty
	else
	{
		FILE *ptr;
		pidlist *tmp;
		struct convparam *tmpparam;
		gint tmpshm;
		// test if file exists
		ptr=fopen(param->filename,"r");
		if(!ptr)
			giErr=-2; // source file not exists
		else
			fclose(ptr);
		// todo: else test if target file is not in queue
		tmp=pl_first;
		while(tmp)
		{
			tmpshm=shmget((int)tmp->pid,sizeof(struct convparam),0600);
			if(tmpshm>0)
			{
				tmpparam=shmat(tmpshm,NULL,SHM_RND);
				if((tmpparam->pspnum==param->pspnum)&&(tmpparam->codec==param->codec))
				{	
					giErr=-3;
					tmp=NULL;
				}
				shmdt(tmpparam);
				if(tmp)
					tmp=tmp->next;
			}
		}
		// todo: else test if target file exists and ask if overwrite it
		
	}
	if(giErr)
	{
		GtkWidget* msg_dialog;
		switch(giErr)
		{
			case -1:
				msg_dialog=gtk_message_dialog_new(GTK_WINDOW(mainwindow_wdg),GTK_DIALOG_MODAL,GTK_MESSAGE_ERROR,GTK_BUTTONS_CLOSE,_("filename empty"));		
				break;
			case -2:
				msg_dialog=gtk_message_dialog_new(GTK_WINDOW(mainwindow_wdg),GTK_DIALOG_MODAL,GTK_MESSAGE_ERROR,GTK_BUTTONS_CLOSE,_("source file not exists"));		
				break;
			case -3:
				msg_dialog=gtk_message_dialog_new(GTK_WINDOW(mainwindow_wdg),GTK_DIALOG_MODAL,GTK_MESSAGE_ERROR,GTK_BUTTONS_CLOSE,_("target file is already in queue"));		
				break;
			default:
				msg_dialog=gtk_message_dialog_new(GTK_WINDOW(mainwindow_wdg),GTK_DIALOG_MODAL,GTK_MESSAGE_ERROR,GTK_BUTTONS_CLOSE,"???");		
				break;
		}
		gtk_dialog_run (GTK_DIALOG (msg_dialog));
		gtk_widget_destroy (msg_dialog);
		g_free(param);
	}
	else
	{
		int childpid;
		childpid=fork();
		if(childpid>0)
		{ // father
			int shmid;
			shmid=shmget((int)childpid,sizeof(struct convparam),IPC_CREAT | 0600);
			if(shmid>0)
			{
				struct convparam *shm_param;
			    GtkWidget *wnd=NULL,*filename_conv,*pspname_conv,*pass_bar_conv;

				shm_param=shmat(shmid, NULL, 0);
				if(shm_param>0)
				{
					strcpy(shm_param->filename,param->filename);
					strcpy(shm_param->title,param->title);
					strcpy(shm_param->currentpath,param->currentpath);
					shm_param->aspect=param->aspect;
					shm_param->pass=param->pass;
					shm_param->vb=param->vb;
					shm_param->ab=param->ab;
					shm_param->pspnum=param->pspnum;
					shm_param->volume=param->volume;
					shm_param->codec=param->codec;
					shm_param->fps_target=1;
					shm_param->fps_reached[0]=0;
					shm_param->fps_reached[1]=0;
					shm_param->pass_current=1;
					shm_param->ffmpeg_conv_tokill[0]=0;
					shm_param->ffmpeg_conv_tokill[1]=0;
					memset(shm_param->ffmpeg_thm_tokill,0,sizeof(shm_param->ffmpeg_thm_tokill));
					shm_param->thm_second=5;
					shm_param->thm_conv_cpt=0;
					shm_param->DrawButtonText=TRUE;
					shm_param->DrawPassText=TRUE;
					shm_param->running=FALSE;
					shm_param->killme=FALSE;
					shm_param->finished=FALSE;
					shm_param->starttime=time(NULL);
					shm_param->badinputformat=0;
					wnd=create_convertwindow();
					gtk_window_set_title(GTK_WINDOW(wnd),param->title);
					filename_conv=lookup_widget(GTK_WIDGET(wnd), "filename");
					pspname_conv=lookup_widget(GTK_WIDGET(wnd), "pspname");
					pass_bar_conv=lookup_widget(GTK_WIDGET(wnd), "currentbar");
					gtk_label_set_text(GTK_LABEL(filename_conv),g_strdup(param->filename));
					if(shm_param->codec==0)
						gtk_label_set_text(GTK_LABEL(pspname_conv),g_strdup_printf("%s/MAQ%05d.MP4",param->currentpath,param->pspnum));
					else
						gtk_label_set_text(GTK_LABEL(pspname_conv),g_strdup_printf("%s/M4V%05d.MP4",param->currentpath,param->pspnum));
					//gtk_progress_bar_set_text(GTK_PROGRESS_BAR(pass_bar_conv),_("Pass 1"));

					gtk_widget_show (wnd);
					pl_add(childpid,wnd);
					shmdt(shm_param);
					g_free(param);
				}
				else
					printf("Error (%d) in shmat\n",errno);
			}
			else
				printf("Error (%d) in shmget\n",errno);
		}
		else
			if(childpid==0)
			{ // child 
				pid_t mypid;
				struct convparam *shm_param;
				gint shmid;
				mypid=getpid();
				shmid=shmget((int)mypid,sizeof(struct convparam),0600);
				while(shmid<0)
				{
					sleep(1);
					shmid=shmget((int)mypid,sizeof(struct convparam),0600);
				}
				shm_param=shmat(shmid,NULL,SHM_RND);
				while(!shm_param->running)
					usleep(100);
				shm_param->starttime=time(NULL);
				for(shm_param->pass_current=1;shm_param->pass_current<=shm_param->pass;shm_param->pass_current++)
				{
					if(!shm_param->badinputformat)
					{
						shm_param->DrawPassText=TRUE;
						launchffmpeg_video(shm_param,shm_param->pass_current,mypid);
						shm_param->fps_reached[shm_param->pass_current-1]=shm_param->fps_target;
					}
					else
					{
						pspvc_log("\nBad Format Deceted !!!!\n",0);
					}
				}
				if(shm_param->pass>1)
				{
				//if multipass so delete logfile (<shm_param->filename>.log)
					gchar *tmptxt;
					tmptxt=g_strdup_printf("%s-%d-0.log",shm_param->filename,mypid);
					remove(tmptxt);
					g_free(tmptxt);
				}
				while(!shm_param->killme)
				{
					if(shm_param->badinputformat)
					{
						shm_param->killme=TRUE;
						shm_param->finished=TRUE;
					}
					if(!shm_param->finished)
					{
						shm_param->DrawPassText=TRUE;
						launchffmpeg_thumbnail(shm_param,mypid);
						shm_param->finished=TRUE;
						shm_param->DrawButtonText=TRUE;
					}
					usleep(500);
				}
				shmdt(shm_param);
				while(1)
					sleep(1);
			}
				
	}
}
					


void launchffmpeg_video(struct convparam *param,gint pass,gint fatherpid)
{
	
	pid_t pid;
	int fd[2];
	pipe(fd);
	pid=fork();
	if(pid==0)
	{ // fils
		int shmid;
		close(fd[0]);
		dup2(fd[1],1);
		dup2(fd[1],2);
		shmid=shmget((int)fatherpid,sizeof(struct convparam),0600);
		if(shmid>0)
		{
			struct convparam *cparam;
			gint argc,ret,i;
			gchar *args[100],logtxt[4096];;
			cparam=shmat(shmid,NULL,SHM_RND);
			argc=0;
			

//	needed stuff for H.264'
//  -acodec aac -vcodec h264 width*height<=76800 width%16=0? height%16=0? -ar 48000 -coder 1 -r 30000/1001  -f psp 
			
			args[argc++]=g_strdup(PACKAGE_DATA_DIR"/pspvc/bin/ffmpeg");
			if(nb_threads>1)
			{
				args[argc++]=g_strdup("-threads");
 				args[argc++]=g_strdup_printf("%d",nb_threads);
			}
			args[argc++]=g_strdup("-y");
 			args[argc++]=g_strdup("-i");
 			args[argc++]=g_strdup_printf("%s",cparam->filename);
			args[argc++]=g_strdup("-acodec");
			args[argc++]=g_strdup("aac");
			args[argc++]=g_strdup("-ab");
			args[argc++]=g_strdup_printf("%dkb",cparam->ab);
			args[argc++]=g_strdup("-vol");
			args[argc++]=g_strdup_printf("%d",cparam->volume);
			args[argc++]=g_strdup("-vcodec");
			if(cparam->codec==0)
				args[argc++]=g_strdup("h264");
			else
				args[argc++]=g_strdup("mpeg4");
			args[argc++]=g_strdup("-b");
			args[argc++]=g_strdup_printf("%dkb",cparam->vb);
			args[argc++]=g_strdup("-ar");
			if(cparam->codec==0)
				args[argc++]=g_strdup("48000");
			else
				args[argc++]=g_strdup("24000");
			args[argc++]=g_strdup("-mbd");
			args[argc++]=g_strdup("2");
			if(cparam->codec==0)
			{ 
				args[argc++]=g_strdup("-coder");
				args[argc++]=g_strdup("1");
			}
			else
			{ 
				args[argc++]=g_strdup("-flags");
				args[argc++]=g_strdup("+4mv+trell");
				args[argc++]=g_strdup("-aic");
				args[argc++]=g_strdup("2");
			}	
			args[argc++]=g_strdup("-cmp");
			args[argc++]=g_strdup("2");
			args[argc++]=g_strdup("-subcmp");
			args[argc++]=g_strdup("2");
			args[argc++]=g_strdup("-s");
			if(cparam->aspect==1)
				args[argc++]=g_strdup("320x240");
			else if(cparam->aspect==2)
				args[argc++]=g_strdup("368x208");
			else 
				args[argc++]=g_strdup("480x272");			
			args[argc++]=g_strdup("-r");
			args[argc++]=g_strdup("30000/1001");
			args[argc++]=g_strdup("-title");
			args[argc++]=g_strdup_printf("%s",cparam->title);
			args[argc++]=g_strdup("-f");
			args[argc++]=g_strdup("psp");
			if(cparam->codec==0)
			{  
				args[argc++]=g_strdup("-flags");
				args[argc++]=g_strdup("loop");
				args[argc++]=g_strdup("-trellis");
				args[argc++]=g_strdup("2");
				args[argc++]=g_strdup("-partitions");
				args[argc++]=g_strdup("parti4x4+parti8x8+partp4x4+partp8x8+partb8x8");
			}
			if(cparam->pass>1)					
			{
				args[argc++]=g_strdup("-pass");
				args[argc++]=g_strdup_printf("%d",pass);
				args[argc++]=g_strdup("-passlogfile");
				args[argc++]=g_strdup_printf("%s-%d",cparam->filename,fatherpid);
			}
			if(((pass==2)&&(cparam->pass==2))||(cparam->pass==1))
			{
				if(cparam->codec==0)
					args[argc++]=g_strdup_printf("%s/MAQ%05d.MP4",cparam->currentpath,cparam->pspnum);
				else
					args[argc++]=g_strdup_printf("%s/M4V%05d.MP4",cparam->currentpath,cparam->pspnum);
			}
			else
				args[argc++]=g_strdup("/dev/null");
			args[argc++]=NULL;			
////////////////////////////////////////////////////////////////////////////////			
			sprintf(logtxt,"-COMMAND:\n");
			pspvc_log(logtxt,0);
			logtxt[0]=0;
			for(i=0;i<argc;i++)
				sprintf(logtxt,"%s %s",logtxt,args[i]);
			pspvc_log(logtxt,0);
			pspvc_log("\n",0);
			while(!cparam->ffmpeg_conv_tokill[pass])
				sleep(1);
			shmdt(cparam);
 			ret=execvp(*args,args);
			if(ret==-1)
				printf("Error=%d\n",errno);
		}
		else
		{
			printf("[launchffmpeg_video] shmid not OK\n");
		}
	}
	if(pid>0)
	{ // Pere
		gint h,m,s,ds,eof=0;
		gchar *cfps;
		gchar token[4096],oldtoken[4096];
		param->ffmpeg_conv_tokill[pass]=pid;
		close(fd[1]);
		dup2(fd[0],0);
		while((strcmp(token,"Duration:"))&&(eof!= EOF))
		{
			eof=scanf("%s",token);
			pspvc_log(token,0);
			if((!strcmp(token,"format"))&&(!strcmp(oldtoken,"Unknown")))
			{
				param->badinputformat=1;
				pspvc_log("bad format detected\n",0);
			}
			sprintf(oldtoken,"%s",token);
		}
		scanf("%02d:%02d:%02d.%d",&h,&m,&s,&ds);
		param->duration=(double)h*3600.0+(double)m*60.0+(double)s+(double)ds/10.0;
		param->fps_target=(int)(param->duration*29.97003);
		while((eof!= EOF)&&(!param->killme))
		{
			eof=scanf("%s",token);
			pspvc_log(token,0);
			pspvc_log(" ",0);
			if(strstr(token,"frame=")!=NULL)
			{
				if(!strcmp("frame=",token))
					eof=scanf("%d",&(param->fps_reached[param->pass_current-1]));
				else
				{
					cfps=strchr(token,'=')+1;
					param->fps_reached[param->pass_current-1]=atoi(cfps);
				}
			}
		}
	}
}

void launchffmpeg_thumbnail(struct convparam *param,gint fatherpid)
{
	
	pid_t pid;
	int fd[2];
	pipe(fd);
	pid=fork();
	if(pid==0)
	{ // fils
		int shmid,i;
		close(fd[0]);
		dup2(fd[1],1);
		dup2(fd[1],2);
		shmid=shmget((int)fatherpid,sizeof(struct convparam),0600);
		if(shmid>0)
		{
			struct convparam *cparam;
			gint argc,ret;
			gchar *args[100],logtxt[4096];
			cparam=shmat(shmid,NULL,SHM_RND);
//				command=g_strdup_printf("ffmpeg -y -i \"%s\" -title \"%s\" -f singlejpeg -ss 5 -vframes 1 -s %s -padtop %d -padbottom %d -an M4V%05d.THM 2>&1"
				 //,shm_param->filename,shm_param->title,thmsize,cf,cf,shm_param->pspnum);
			argc=0;
			args[argc++]=g_strdup(PACKAGE_DATA_DIR"/pspvc/bin/ffmpeg");
			printf("[launchffmpeg] program=%s\n",args[0]);
			args[argc++]=g_strdup("-y");
 			args[argc++]=g_strdup("-i");
 			args[argc++]=g_strdup_printf("%s",cparam->filename);
			args[argc++]=g_strdup("-f");
			args[argc++]=g_strdup("image2");
			args[argc++]=g_strdup("-ss");
			args[argc++]=g_strdup_printf("%d",cparam->thm_second);
			args[argc++]=g_strdup("-vframes");
			args[argc++]=g_strdup("1");
			args[argc++]=g_strdup("-s");
			args[argc++]=g_strdup("160x120");
			args[argc++]=g_strdup("-an");
			if(cparam->codec==0)
				args[argc++]=g_strdup_printf("%s/MAQ%05d.THM",cparam->currentpath,cparam->pspnum);
			else
				args[argc++]=g_strdup_printf("%s/M4V%05d.THM",cparam->currentpath,cparam->pspnum);
			args[argc++]=NULL;
			sprintf(logtxt,"-COMMAND:\n");
			pspvc_log(logtxt,0);
			logtxt[0]=0;
			for(i=0;i<argc;i++)
				sprintf(logtxt,"%s %s",logtxt,args[i]);
			pspvc_log(logtxt,0);
			pspvc_log("\n",0);
			while(!cparam->ffmpeg_thm_tokill[cparam->thm_conv_cpt])
				sleep(1);
			cparam->thm_conv_cpt++;
			shmdt(cparam);
 			ret=execvp(*args,args);
			if(ret==-1)
				printf("Error=%d\n",errno);
			for(i=0;i<argc;i++)
				printf("%s ",args[i]);
			printf("\n");
		}
		else
		{
			printf("[launchffmpeg_thumbnail] shmid not OK\n");
		}
	}
	if(pid>0)
	{ // Pere
		gint eof=0;
		gchar cPoub1[4096];
		param->ffmpeg_thm_tokill[param->thm_conv_cpt]=pid;
		close(fd[1]);
		dup2(fd[0],0);
		while(eof!= EOF)
		{
			eof=scanf("%s",cPoub1);
			pspvc_log(cPoub1,0);
		}
	}
}


void
on_mainwindow_destroy                  (GtkObject       *object,
                                        gpointer         user_data)
{
}

gboolean
on_convertwindow_delete_event          (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{

  return TRUE;
}

gboolean
on_mainwindow_delete_event             (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	gboolean ret=FALSE;
	if(pl_count)
	{
		GtkWidget* msg_dialog;
		msg_dialog=gtk_message_dialog_new(GTK_WINDOW(widget),GTK_DIALOG_MODAL,GTK_MESSAGE_ERROR,GTK_BUTTONS_CLOSE,_("Queue not empty"));		
		gtk_dialog_run (GTK_DIALOG (msg_dialog));
		gtk_widget_destroy (msg_dialog);
		ret=TRUE;
	}
	else
		gtk_main_quit();

  return ret;
}

void
on_btThm_clicked                       (GtkButton       *button,
                                        gpointer         user_data)
{
	pidlist *tmp;
	struct convparam *shm_param;
	GtkWidget *button_wdg;
	GtkWidget *secondspin,*secondlabel;
	secondlabel=lookup_widget(GTK_WIDGET(button), "second");
	secondspin=lookup_widget(GTK_WIDGET(button), "spinsecond");
	gtk_widget_set(GTK_WIDGET(button),"visible",FALSE,NULL);
	gtk_widget_set(GTK_WIDGET(secondlabel),"visible",FALSE,NULL);
	gtk_widget_set(GTK_WIDGET(secondspin),"visible",FALSE,NULL);
	gboolean Found=FALSE;
	int shmid;
	if(pl_count>0)
	{
		tmp=pl_first;
		while((tmp)&&(!Found))
		{
			if(tmp->convertwindow)
			{
				button_wdg=lookup_widget(GTK_WIDGET(tmp->convertwindow), "btThm");
				if(GTK_WIDGET(button)==button_wdg)
				{
					Found=TRUE;
					shmid=shmget((int)tmp->pid,sizeof(struct convparam),0600);
					if(shmid>0)
					{
						shm_param=shmat(shmid,NULL,SHM_RND);
						if(shm_param->thm_conv_cpt<512)
						{
							shm_param->thm_second=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(secondspin));
							shm_param->finished=FALSE;
							shm_param->running=TRUE;
						}
						shmdt(shm_param);
					}
				}
			}
			tmp=tmp->next;
		}
	}
}

void
on_about_button_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *wnd=NULL;
	wnd=create_aboutwindow();
	gtk_widget_show (wnd);	
}


void
on_closebutton_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *wnd=NULL;
	wnd=lookup_widget(GTK_WIDGET(button), "aboutwindow");
	gtk_widget_destroy(wnd);
}

void
on_profile1_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	options.codec=0;
	options.aspect=3;
	options.vb=384;
	options.ab=64;
	setoutputprefix(options.codec,GTK_WIDGET(menuitem));
}


void
on_profile2_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	options.codec=0;
	options.aspect=3;
	options.vb=512;
	options.ab=128;
	setoutputprefix(options.codec,GTK_WIDGET(menuitem));
}


void
on_profile3_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	options.codec=0;
	options.aspect=2;
	options.vb=384;
	options.ab=64;
	setoutputprefix(options.codec,GTK_WIDGET(menuitem));
}


void
on_profile4_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	options.codec=0;
	options.aspect=2;
	options.vb=512;
	options.ab=128;
	setoutputprefix(options.codec,GTK_WIDGET(menuitem));
}


void
on_profile5_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	options.codec=0;
	options.aspect=1;
	options.vb=384;
	options.ab=64;
	setoutputprefix(options.codec,GTK_WIDGET(menuitem));
}


void
on_profile6_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	options.codec=0;
	options.aspect=1;
	options.vb=512;
	options.ab=128;
	setoutputprefix(options.codec,GTK_WIDGET(menuitem));
}


void
on_profile7_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	options.codec=1;
	options.aspect=2;
	options.vb=384;
	options.ab=64;
	setoutputprefix(options.codec,GTK_WIDGET(menuitem));
}


void
on_profile8_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	options.codec=1;
	options.aspect=2;
	options.vb=512;
	options.ab=128;
	setoutputprefix(options.codec,GTK_WIDGET(menuitem));
}


void
on_profile9_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	options.codec=1;
	options.aspect=1;
	options.vb=384;
	options.ab=64;
	setoutputprefix(options.codec,GTK_WIDGET(menuitem));
}


void
on_profile10_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	options.codec=1;
	options.aspect=1;
	options.vb=512;
	options.ab=128;
	setoutputprefix(options.codec,GTK_WIDGET(menuitem));
}
