
#include <cctype>
#include <cstring>
#include <cstdlib>

#include "mutable_container.h"

#include "itemize.hh"

struct PspellItemizeItem {
  char   action;
  const char * name;
  PspellItemizeItem() : action('\0'), name(0) {}
};

class PspellItemizeTokenizer {
private:
  char * list;
  char * i;
public:
  PspellItemizeTokenizer(const char * l);
  ~PspellItemizeTokenizer();
private:
  PspellItemizeTokenizer(const PspellItemizeTokenizer & other) ;
  PspellItemizeTokenizer & operator=(const PspellItemizeTokenizer & other);
public:
  PspellItemizeItem next();
};

PspellItemizeTokenizer::PspellItemizeTokenizer(const char * l) 
{
  size_t size = strlen(l) + 1;
  list = new char[size];
  i = list;
  strncpy(list, l, size);
}

PspellItemizeTokenizer::~PspellItemizeTokenizer() 
{
  delete[] list;
}


PspellItemizeItem PspellItemizeTokenizer::next() 
{
  PspellItemizeItem li;
  while (*i != '\0' && (isspace(*i) || *i == ',')) ++i;
  if (*i == '\0') return li;
  li.action = *i;
  if (*i == '+' || *i == '-') {
    ++i;
  } else if (*i == '!') {
    li.name = "";
    ++i;
    return li;
  } else {
    li.action = '+';
  }
  while (*i != '\0' && *i != ',' && isspace(*i)) ++i;
  if (*i == '\0' || *i == ',') return next();
  li.name = i;
  while (*i != '\0' && *i != ',') ++i;
  while (isspace(*(i-1))) --i;
  if (*i != '\0') {
    *i = '\0';
    ++i;
    }
  return li;
}


void itemize(const char * s, PspellMutableContainer & d) {
  PspellItemizeTokenizer els(s);
  PspellItemizeItem li;
  while (li = els.next(), li.name != 0) {
    switch (li.action) {
    case '+':
      d.add(li.name);
      break;
    case '-':
      d.remove(li.name);
      break;
    case '!':
	d.clear();
	break;
    default:
      abort();
    }
  }
}
